/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.Type;
import com.ibm.xylem.interpreter.AbstractDataObject;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.InterpreterUtilities;
import com.ibm.xylem.interpreter.StreamUtilities;
import com.ibm.xylem.interpreter.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListStream
implements IAppendableStream,
IConvertible {
    protected List m_list;

    public ListStream() {
        this.m_list = new ArrayList();
    }

    public ListStream(List list) {
        this.m_list = list;
    }

    public ListStream(Object object) {
        this.m_list = new ArrayList();
        this.m_list.add(object);
    }

    public Iterator iterator() {
        return this.m_list.iterator();
    }

    public void append(Object object) {
        if (object instanceof ListStream) {
            this.m_list.addAll(((ListStream)object).m_list);
        } else if (object instanceof IStream) {
            IStream iStream = (IStream)object;
            Iterator iterator = iStream.iterator();
            while (iterator.hasNext()) {
                this.m_list.add(iterator.next());
            }
        } else {
            this.m_list.add(object);
        }
    }

    public String toString() {
        InterpreterUtilities interpreterUtilities = new InterpreterUtilities();
        if (this.m_list.size() > 0 && this.m_list.get(0) instanceof AbstractDataObject) {
            return this.m_list.toString();
        }
        if (this.m_list.size() > 0 && this.m_list.get(0) instanceof Tuple && interpreterUtilities.getDebuggerflag()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Tuple tuple : this.m_list) {
                stringBuffer.append(tuple.toString());
            }
            return stringBuffer.toString();
        }
        if (this.m_list.size() == 0 || this.m_list.get(0) instanceof Character) {
            return new String(this.toCharArray());
        }
        String string = "[";
        Iterator iterator = this.m_list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            string = string + (bl ? "" : ", ") + e.toString();
            bl = false;
        }
        string = string + "]";
        return string;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.m_list.size()];
        Iterator iterator = this.m_list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Character c = (Character)e;
            cArray[n++] = c.charValue();
        }
        return cArray;
    }

    public Object convert(Type type) {
        return JavaClassWrapper.convertListStream(this, type);
    }

    public int size() {
        return this.m_list.size();
    }

    public Object get(int n) {
        return this.m_list.get(n);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)object);
    }
}

