/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ScopedPostOrderOptimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class FindFreeVariables
extends ScopedPostOrderOptimizer {
    private HashSet m_freeVars = new HashSet();
    private LinkedList m_freeVarsStack = new LinkedList();

    protected FindFreeVariables() {
    }

    public static Set findFreeVariables(Instruction instruction) {
        FindFreeVariables findFreeVariables = new FindFreeVariables();
        findFreeVariables.optimize(instruction);
        return findFreeVariables.getFreeVars();
    }

    public static Set findFreeBindings(Instruction instruction, BindingEnvironment bindingEnvironment) {
        FindFreeVariables findFreeVariables = new FindFreeVariables();
        findFreeVariables.optimize(instruction);
        HashSet<IBinding> hashSet = new HashSet<IBinding>();
        for (Object e : findFreeVariables.getFreeVars()) {
            IBinding iBinding = bindingEnvironment.getVariableBinding(e);
            if (iBinding == null) {
                throw new XylemError("ERR_SYSTEM", "unbound variable " + e);
            }
            hashSet.add(iBinding);
        }
        return hashSet;
    }

    public HashSet getFreeVars() {
        return this.m_freeVars;
    }

    protected void endOptimize(Instruction instruction) {
        if (this.m_freeVarsStack.size() != 0) {
            throw new XylemError("ERR_SYSTEM", "!!!" + this.m_freeVarsStack.size());
        }
    }

    protected void beginOptimize(Instruction instruction) {
        this.m_freeVars.clear();
        this.m_freeVarsStack.clear();
    }

    protected void preOrderStep(Instruction instruction, Instruction instruction2, int n) {
        if (instruction2 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(n)) {
            this.m_freeVarsStack.add(this.m_freeVars);
            this.m_freeVars = new HashSet();
        }
    }

    protected void addVars(Instruction instruction, Instruction instruction2, int n) {
        if (instruction instanceof IdentifierInstruction) {
            this.m_freeVars.add(((IdentifierInstruction)instruction).getVariable());
        }
    }

    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        this.addVars(instruction, instruction2, n);
        this.removeVars(instruction, instruction2, n);
        return instruction;
    }

    protected void removeVars(Instruction instruction, Instruction instruction2, int n) {
        if (instruction2 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(n)) {
            IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(n);
            if (iBindingArray == null) {
                throw new XylemError("ERR_SYSTEM", "!" + n + " " + instruction);
            }
            this.m_freeVars.removeAll(Arrays.asList(Binding.getNames(iBindingArray)));
            HashSet hashSet = (HashSet)this.m_freeVarsStack.removeLast();
            hashSet.addAll(this.m_freeVars);
            this.m_freeVars = hashSet;
        }
    }
}

