/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.PostOrderOptimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.ReducedForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LambdaOptimizer
extends PostOrderOptimizer {
    protected HashMap m_cache = new HashMap();
    protected boolean m_doLoopInvariantOptimization = true;

    public void disableLoopInvariantOptimization() {
        this.m_doLoopInvariantOptimization = false;
    }

    protected Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof LambdaInstruction) {
            Instruction instruction2;
            Object object;
            LambdaInstruction lambdaInstruction = (LambdaInstruction)instruction;
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            Instruction instruction3 = lambdaInstruction;
            if (this.m_doLoopInvariantOptimization) {
                object = lambdaInstruction.getBody();
                instruction2 = object;
                boolean bl = true;
                ArrayList<LetInstruction> arrayList = new ArrayList<LetInstruction>();
                ArrayList<LetInstruction> arrayList2 = new ArrayList<LetInstruction>();
                while (object instanceof LetInstruction) {
                    LetInstruction letInstruction = (LetInstruction)object;
                    if (letInstruction.getValue().isStatic(bindingEnvironment)) {
                        arrayList.add(letInstruction);
                        arrayList2.add(letInstruction);
                        bl = false;
                    } else {
                        Set set = NavigationUtilities.resolveFreeBindingsForReducedExpression(letInstruction.getValue(), instruction2, bindingEnvironment);
                        List list = lambdaInstruction.getBindings();
                        int n = list.size();
                        list.removeAll(set);
                        if (list.size() == n) {
                            arrayList2.add(letInstruction);
                        } else {
                            arrayList.add(letInstruction);
                        }
                    }
                    object = letInstruction.getBody();
                }
                lambdaInstruction.setBody(OptimizerUtilities.reconstructLets((Instruction)object, arrayList, false));
                if (!bl) {
                    lambdaInstruction = (LambdaInstruction)lambdaInstruction.cloneWithoutTypeInformation();
                }
                instruction3 = OptimizerUtilities.reconstructLets(lambdaInstruction, arrayList2, !bl);
                if (!bl) {
                    instruction3 = ReducedForm.reduceFragment(instruction3);
                    instruction3.typeCheckReduced(typeEnvironment, bindingEnvironment, new LinkedList());
                }
            }
            object = new ArrayList();
            instruction2 = (LambdaInstruction)OptimizerUtilities.skipLets(instruction3, (List)object);
            Instruction instruction4 = LambdaOptimizer.generateFunctionCallBody(((LambdaInstruction)instruction2).getChildInstruction(0), ((LambdaInstruction)instruction2).getBindings(), this.getCurrentFunction(), this.m_cache);
            ((LambdaInstruction)instruction2).setBody(instruction4);
            instruction4.typeCheckReduced(typeEnvironment, bindingEnvironment, new LinkedList());
            if (this.m_doLoopInvariantOptimization && instruction3 instanceof LetInstruction) {
                return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction3, null);
            }
            return instruction3;
        }
        return super.optimizeStep(instruction);
    }

    public static Instruction generateFunctionCallBody(Instruction instruction, List list, Function function, Map map) {
        Object object;
        Object object22;
        if (instruction instanceof FunctionCallInstruction) {
            return instruction;
        }
        BindingEnvironment bindingEnvironment = function.getBindingEnvironment();
        Instruction instruction2 = instruction.generateCanonicalForm(bindingEnvironment);
        String string = instruction2.toString();
        String string2 = "";
        Set set = instruction.accumulateFreeBindingsInOrder(bindingEnvironment);
        s_logger.debug("In generateFunCallBody");
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object22 = (IBinding)iterator.next();
            if (set.contains(object22)) {
                string = string + "_" + n;
            }
            ++n;
        }
        for (Object object22 : set) {
            object = object22.getBindingType();
            if (object == null) {
                object = object22.getLet().getValue().getType(function.getTypeEnvironment(), bindingEnvironment);
            }
            string = string + "_" + object.toString();
        }
        if (!map.containsKey(string)) {
            object22 = function.getTypeEnvironment();
            string2 = OptimizerUtilities.generateIntermediateIdentifier("repeatedFunction");
            object = new Binding[set.size()];
            int n2 = 0;
            for (IBinding iBinding : set) {
                Type type = iBinding.getBindingType();
                if (type == null) {
                    type = iBinding.getLet().getValue().getType(function.getTypeEnvironment(), bindingEnvironment);
                }
                object[n2] = new Binding(iBinding.getName(), type);
                ++n2;
            }
            Function function2 = function.cloneFunctionForFixup(null, false, false, false);
            function2.setBody(instruction.cloneWithNewNames());
            function2.m_parameters = object;
            function2.setName(string2);
            ((TypeEnvironment)object22).getModule().addFunction(function2);
            map.put(string, string2);
            s_logger.debug("Cache Add");
        } else {
            string2 = (String)map.get(string);
            s_logger.debug("Cache hit! on " + string2 + " in " + function.getName());
        }
        object22 = new LinkedList<IdentifierInstruction>();
        object = set.iterator();
        while (object.hasNext()) {
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(((IBinding)object.next()).getName());
            ((LinkedList)object22).add(identifierInstruction);
        }
        return new FunctionCallInstruction(string2, (List)object22);
    }
}

