/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.BindingDependencyInfo;
import com.ibm.xylem.DataDependencyDrivenOptimizer;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public class LetChainClusterizer
extends DataDependencyDrivenOptimizer {
    HashMap m_toConsolidate = new HashMap();
    HashMap m_triples = new HashMap();
    private final int MIN_CHAIN = 5;

    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        if (instruction instanceof LetInstruction) {
            Object object;
            boolean bl;
            Instruction instruction3;
            int n2 = this.getBindingUseCount((IBinding)((Object)instruction));
            if (n2 > 1) {
                return instruction;
            }
            if (n2 == 0) {
                throw new XylemError("ERR_SYSTEM", "dead let or untypechecked code?");
            }
            BindingDependencyInfo bindingDependencyInfo = (BindingDependencyInfo)this.getBindingDependencyInfo((IBinding)((Object)instruction)).next();
            if (!this.shouldConsolidate(bindingDependencyInfo)) {
                return instruction;
            }
            LinkedList linkedList = (LinkedList)this.m_toConsolidate.get(bindingDependencyInfo.m_parent);
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.m_toConsolidate.put(bindingDependencyInfo.m_parent, linkedList);
            }
            Object[] objectArray = new Object[]{instruction, instruction2, new Integer(n)};
            this.m_triples.put(instruction, objectArray);
            linkedList.add(objectArray);
            Instruction instruction4 = ((LetInstruction)instruction).getValue();
            linkedList = (LinkedList)this.m_toConsolidate.get(instruction4);
            if (linkedList == null) {
                return instruction;
            }
            if (linkedList.size() < 5) {
                instruction3 = instruction;
                bl = false;
            } else {
                instruction3 = instruction4;
                bl = true;
            }
            while (!linkedList.isEmpty()) {
                object = (Object[])linkedList.removeLast();
                LetInstruction letInstruction = (LetInstruction)object[0];
                Instruction instruction5 = (Instruction)object[1];
                int n3 = (Integer)object[2];
                if (letInstruction == instruction2) {
                    instruction2 = instruction5;
                    n = n3;
                }
                this.setChild(instruction5, letInstruction.getBody(), n3);
                this.setChild(letInstruction, instruction3, 1);
                instruction3 = letInstruction;
            }
            if (bl) {
                object = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction3, null);
                this.setChild((Instruction)object, instruction3, 1);
                this.setChild(instruction, (Instruction)object, 0);
            } else {
                this.setChild(instruction2, instruction3, n);
            }
            this.m_toConsolidate.remove(instruction4);
            return instruction;
        }
        return instruction;
    }

    private void setChild(Instruction instruction, Instruction instruction2, int n) {
        if (instruction != null) {
            instruction.setChildInstruction(n, instruction2);
        } else {
            this.getCurrentFunction().setBody(instruction);
        }
        Object[] objectArray = (Object[])this.m_triples.get(instruction2);
        if (objectArray != null) {
            objectArray[1] = instruction;
            objectArray[2] = new Integer(n);
        }
    }

    private boolean shouldConsolidate(BindingDependencyInfo bindingDependencyInfo) {
        return bindingDependencyInfo.m_parent instanceof StreamInstruction;
    }
}

