/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.utils.XylemError;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class ReducedForm {
    private static boolean s_enabled = false;
    static Logger s_logger = Logger.getInstance(ReducedForm.class);

    public static void reduceModule(Module module) {
        for (Function function : module.getFunctions()) {
            Instruction instruction = function.getBody();
            try {
                ReducedForm.reduceFunction(function);
                function.typeCheckReduced(module, new LinkedList());
            }
            catch (Exception exception) {
                function.setComment(function.getComment() + "\n" + exception);
                s_logger.error("converted code did not reduce. See output in function.xylem", exception);
                Program.dumpXylemFunctions(new Function[]{function}, new File("."), "function");
                throw new Error("died");
            }
        }
    }

    public static void reduceFunction(Function function) {
        new Form().optimizeFunction(function);
        new Form2().optimizeFunction(function);
        new Variables().optimizeFunction(function);
    }

    public static Instruction reduceFragment(Instruction instruction) {
        instruction = new Form().optimize(instruction);
        instruction = new Form2().optimize(instruction);
        instruction = new Variables().optimizeFragment(instruction);
        return instruction;
    }

    public static class Check
    extends Optimizer {
        private Instruction m_fragment;
        private HashSet m_names = new HashSet();

        public static void check(Module module) {
            if (!s_enabled) {
                return;
            }
            Check check = new Check();
            for (Function function : module.getFunctions()) {
                check.optimizeFunction(function);
            }
        }

        public static void check(Function function) {
            if (!s_enabled) {
                return;
            }
            new Check().optimizeFunction(function);
        }

        public static void check(Instruction instruction) {
            if (!s_enabled) {
                return;
            }
            new Check().optimize(instruction);
        }

        protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
            if (instruction == null) {
                throw new XylemError("ERR_SYSTEM", "null instruction!");
            }
            if (instruction instanceof LetInstruction) {
                if (((LetInstruction)instruction).getValue() instanceof LetInstruction) {
                    throw new XylemError("ERR_SYSTEM", "let value cannot be let in '" + instruction + "'");
                }
                if (!this.m_names.add(((LetInstruction)instruction).getVariable())) {
                    throw new XylemError("ERR_SYSTEM", "let variable '" + ((LetInstruction)instruction).getVariable() + "'" + " reused in " + this.getCurrentFunction());
                }
            } else {
                boolean bl = instruction instanceof ISpecialForm;
                int n2 = instruction.getChildInstructionCount();
                for (int i = 0; i < n2; ++i) {
                    Instruction instruction3;
                    if (bl && ((ISpecialForm)((Object)instruction)).isChildInstructionBody(i) || (instruction3 = instruction.getChildInstruction(i)) instanceof IdentifierInstruction || instruction3 instanceof LiteralInstruction) continue;
                    throw new XylemError("ERR_SYSTEM", "child " + i + " not reduced: " + instruction3 + "\n in: " + instruction);
                }
                if (instruction instanceof ChooseInstruction) {
                    ChooseInstruction chooseInstruction = (ChooseInstruction)instruction;
                    if (chooseInstruction.m_cases.length > 1) {
                        throw new XylemError("ERR_SYSTEM", "ChooseInstruction not reduced (too many cases):\n" + instruction);
                    }
                } else if (this.getCurrentFunction() != null && instruction instanceof IdentifierInstruction && ((IdentifierInstruction)instruction).getBinding(this.getCurrentFunction().getBindingEnvironment()) == null) {
                    throw new XylemError("ERR_SYSTEM", "identifier " + instruction + " is not bound");
                }
            }
            return instruction;
        }

        public Instruction optimize(Instruction instruction) {
            this.m_names.clear();
            this.m_fragment = instruction;
            super.optimize(instruction);
            this.m_fragment = null;
            this.m_names.clear();
            return instruction;
        }

        public void optimizeFunction(Function function) {
            if (function.getBindingEnvironment() == null) {
                throw new XylemError("ERR_SYSTEM", "function " + function.getName() + " has no binding environment.");
            }
            this.m_names = new HashSet();
            for (int i = 0; i < function.m_parameters.length; ++i) {
                this.m_names.add(function.m_parameters[i].getName());
            }
            try {
                super.optimizeFunction(function);
            }
            catch (Exception exception) {
                s_logger.error("error encountered in " + function.getName() + " [" + exception + "]\n" + function, exception);
                throw new XylemError("ERR_SYSTEM", "ReducedForm.Check failed");
            }
            this.m_names = null;
        }
    }

    private static class Form
    extends Optimizer {
        private Form() {
        }

        protected Instruction optimizeStep(Instruction instruction) {
            if (instruction instanceof LetInstruction) {
                LetInstruction letInstruction;
                Instruction instruction2 = instruction;
                do {
                    letInstruction = (LetInstruction)instruction;
                    Instruction instruction3 = this.optimize(letInstruction.getValue());
                    letInstruction.setValue(instruction3);
                } while ((instruction = letInstruction.getBody()) instanceof LetInstruction);
                letInstruction.setBody(this.optimize(instruction));
                return null;
            }
            if (instruction instanceof LiteralInstruction) {
                return instruction;
            }
            boolean bl = instruction instanceof ISpecialForm;
            int n = instruction.getChildInstructionCount();
            Instruction instruction4 = instruction;
            for (int i = 0; i < n; ++i) {
                if (bl && ((ISpecialForm)((Object)instruction)).isChildInstructionBody(i)) {
                    instruction.setChildInstruction(i, this.optimize(instruction.getChildInstruction(i)));
                    continue;
                }
                Instruction instruction5 = instruction.getChildInstruction(i);
                if (instruction5 instanceof IdentifierInstruction || instruction5 instanceof LiteralInstruction) continue;
                Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
                instruction.setChildInstruction(i, new IdentifierInstruction(n2));
                Instruction instruction6 = this.optimize(instruction5);
                ArrayList arrayList = new ArrayList();
                Instruction instruction7 = OptimizerUtilities.skipLets(instruction6, arrayList);
                Instruction instruction8 = new LetInstruction(n2, instruction7, instruction4);
                if (arrayList.size() > 0) {
                    LetInstruction letInstruction = (LetInstruction)arrayList.get(arrayList.size() - 1);
                    letInstruction.setBody(instruction8);
                    instruction8 = instruction6;
                }
                instruction4 = instruction8;
            }
            return instruction4.cloneShallow();
        }
    }

    private static class Form2
    extends Optimizer {
        private Form2() {
        }

        protected Instruction optimizeStep(Instruction instruction) {
            if (instruction instanceof LetInstruction) {
                LetInstruction letInstruction;
                LetInstruction letInstruction2 = null;
                do {
                    if ((letInstruction = (LetInstruction)instruction).getValue() instanceof LetInstruction) {
                        LinkedList linkedList = new LinkedList();
                        Instruction instruction2 = OptimizerUtilities.skipLets(letInstruction.getValue(), linkedList);
                        letInstruction.setValue(this.optimize(instruction2));
                        LetInstruction letInstruction3 = (LetInstruction)linkedList.get(linkedList.size() - 1);
                        letInstruction3.setBody(letInstruction);
                        Instruction instruction3 = (Instruction)linkedList.get(0);
                        instruction3 = this.optimize(instruction3);
                        if (letInstruction2 != null) {
                            letInstruction2.setBody(instruction3);
                            return null;
                        }
                        return instruction3;
                    }
                    letInstruction.setValue(this.optimize(letInstruction.getValue()));
                    instruction = letInstruction.getBody();
                    letInstruction2 = letInstruction;
                } while (instruction instanceof LetInstruction);
                letInstruction.setBody(this.optimize(instruction));
                return null;
            }
            if (instruction instanceof ChooseInstruction && ((ChooseInstruction)instruction).m_cases.length > 1) {
                ChooseInstruction chooseInstruction = (ChooseInstruction)instruction;
                ChooseInstruction.Case[] caseArray = chooseInstruction.m_cases;
                Instruction instruction4 = chooseInstruction.getDefaultHandler();
                if (instruction4 != null) {
                    instruction4 = this.optimize(instruction4);
                }
                for (int i = caseArray.length - 1; i >= 0; --i) {
                    instruction4 = new ChooseInstruction(caseArray[i].getTest(), this.optimize(caseArray[i].getHandler()), instruction4);
                }
                return instruction4;
            }
            return instruction;
        }
    }

    private static class Variables
    extends Optimizer {
        private HashMap m_names;
        private static final Object BOUND = "";
        private boolean m_checkUnboundVars = true;

        private Variables() {
        }

        protected Instruction optimizeStep(Instruction instruction) {
            if (instruction instanceof LetInstruction) {
                LetInstruction letInstruction;
                Instruction instruction2 = instruction;
                do {
                    boolean bl;
                    letInstruction = (LetInstruction)instruction;
                    Object object = letInstruction.getVariable();
                    Object v = this.m_names.get(object);
                    if (this.m_names.get(object) == null) {
                        bl = false;
                    } else {
                        bl = true;
                        Integer n = ReductionHelper.generateIntermediateIdentifier2();
                        letInstruction.setVariable(n);
                    }
                    this.m_names.put(letInstruction.getVariable(), BOUND);
                    instruction.setChildInstruction(0, this.optimize(letInstruction.getValue()));
                    if (!bl) continue;
                    this.m_names.put(object, letInstruction.getVariable());
                    letInstruction.setBody(this.optimize(letInstruction.getBody()));
                    this.m_names.put(object, v);
                    return null;
                } while ((instruction = letInstruction.getBody()) instanceof LetInstruction);
                letInstruction.setBody(this.optimize(instruction));
                return null;
            }
            if (instruction instanceof IdentifierInstruction) {
                IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
                Object v = this.m_names.get(identifierInstruction.getVariable());
                if (v == null) {
                    if (this.m_checkUnboundVars) {
                        throw new XylemError("ERR_SYSTEM", "unbound variable:" + identifierInstruction + " in: " + this.getCurrentFunction());
                    }
                    return null;
                }
                if (v == BOUND) {
                    return null;
                }
                return new IdentifierInstruction(v);
            }
            if (instruction instanceof ISpecialForm) {
                for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                    IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction)).getChildInstructionBindings(i);
                    if (iBindingArray != null) {
                        HashMap<Object, Integer> hashMap = null;
                        HashMap<Object, Object> hashMap2 = null;
                        for (int j = 0; j < iBindingArray.length; ++j) {
                            Object object = this.m_names.put(iBindingArray[j].getName(), BOUND);
                            if (object == null) continue;
                            if (hashMap == null) {
                                hashMap = new HashMap<Object, Integer>();
                                hashMap2 = new HashMap<Object, Object>();
                            }
                            Integer n = ReductionHelper.generateIntermediateIdentifier2();
                            hashMap.put(iBindingArray[j].getName(), n);
                            hashMap2.put(iBindingArray[j].getName(), object);
                            iBindingArray[j].setName(n);
                        }
                        if (hashMap != null) {
                            this.m_names.putAll(hashMap);
                            instruction.setChildInstruction(i, this.optimize(instruction.getChildInstruction(i)));
                            this.m_names.putAll(hashMap2);
                            continue;
                        }
                    }
                    instruction.setChildInstruction(i, this.optimize(instruction.getChildInstruction(i)));
                }
                return null;
            }
            return instruction;
        }

        public void optimizeFunction(Function function) {
            this.m_names = new HashMap();
            for (int i = 0; i < function.m_parameters.length; ++i) {
                this.m_names.put(function.m_parameters[i].getName(), BOUND);
            }
            super.optimizeFunction(function);
            this.m_names = null;
        }

        public Instruction optimizeFragment(Instruction instruction) {
            this.m_checkUnboundVars = false;
            this.m_names = new HashMap();
            instruction = this.optimize(instruction);
            this.m_names = null;
            this.m_checkUnboundVars = true;
            return instruction;
        }
    }
}

