/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.DataDependencyDrivenPostOrderOptimizer;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.util.HashSet;
import java.util.LinkedList;

public class ReverseInliningOptimizer
extends DataDependencyDrivenPostOrderOptimizer {
    private int m_limit;
    public Object[] m_necessaryParameters = new Object[0];

    public ReverseInliningOptimizer(int n) {
        this.m_limit = n;
    }

    protected Instruction optimizeStep(Instruction instruction) {
        int n = instruction.accumulateByteCodeSize();
        if (this.m_limit > 0 && n > this.m_limit && this.m_currentFunction.getBody() != instruction) {
            Instruction instruction2 = instruction;
            if (instruction instanceof ChooseInstruction) {
                instruction2 = this.handleChoose((ChooseInstruction)instruction);
            } else if (instruction instanceof LetInstruction) {
                instruction2 = this.handleLet((LetInstruction)instruction);
            } else if (instruction instanceof MatchInstruction) {
                instruction2 = this.handleMatch((MatchInstruction)instruction);
            } else if (instruction instanceof StreamInstruction) {
                instruction2 = this.handleStream((StreamInstruction)instruction);
            }
            if (instruction == instruction2) {
                return instruction;
            }
            int n2 = instruction2.accumulateByteCodeSize();
            if (n2 < n) {
                return this.optimizeStep(this.doTypeCheck(instruction, instruction2, instruction.getBindingEnvironment()));
            }
            return instruction;
        }
        return instruction;
    }

    private boolean isSafeToCut(Instruction instruction) {
        HashSet hashSet = new HashSet();
        instruction.accumulateFreeBindings(hashSet, null);
        for (IBinding iBinding : hashSet) {
            if (iBinding == null) continue;
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            Type type = iBinding.getBindingType().resolveType(typeEnvironment);
            if (type instanceof NamedType) {
                return false;
            }
            if (!(type instanceof StreamType) || iBinding.getLet() == null || this.getBindingUseCount(iBinding) != 1 || iBinding.getLet().isStatic(null)) continue;
            return false;
        }
        return true;
    }

    private Instruction handleMatch(MatchInstruction matchInstruction) {
        Instruction instruction;
        FunctionCallInstruction functionCallInstruction;
        int n;
        if (!this.isSafeToCut(matchInstruction)) {
            return matchInstruction;
        }
        Instruction instruction2 = matchInstruction.getDefault();
        MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
        Instruction instruction3 = matchInstruction.getToMatch();
        LinkedList<MatchInstruction.Match> linkedList = new LinkedList<MatchInstruction.Match>();
        LinkedList<MatchInstruction.Match> linkedList2 = new LinkedList<MatchInstruction.Match>();
        for (n = matchArray.length - 1; n > 1 && n > matchArray.length / 2; --n) {
            linkedList2.addFirst(matchArray[n]);
        }
        while (n >= 0) {
            linkedList.addFirst(matchArray[n]);
            --n;
        }
        MatchInstruction.Match[] matchArray2 = new MatchInstruction.Match[linkedList.size()];
        MatchInstruction.Match[] matchArray3 = new MatchInstruction.Match[linkedList2.size()];
        linkedList.toArray(matchArray2);
        linkedList2.toArray(matchArray3);
        if (linkedList2.size() == 0) {
            if (null == instruction2) {
                return matchInstruction;
            }
            functionCallInstruction = this.buildFunction(matchInstruction, instruction2, "match-default");
        } else {
            instruction = new MatchInstruction(instruction3, matchArray3, instruction2);
            functionCallInstruction = this.buildFunction(matchInstruction, instruction, "match");
        }
        instruction = new MatchInstruction(instruction3, matchArray2, (Instruction)functionCallInstruction).cloneWithoutTypeInformation();
        return instruction;
    }

    private Instruction handleChoose(ChooseInstruction chooseInstruction) {
        Instruction instruction;
        Instruction instruction2;
        int n;
        if (!this.isSafeToCut(chooseInstruction)) {
            return chooseInstruction;
        }
        Instruction instruction3 = chooseInstruction.getDefaultHandler();
        int n2 = 0;
        if (instruction3 != null) {
            n2 += instruction3.accumulateByteCodeSize();
        }
        LinkedList<ChooseInstruction.Case> linkedList = new LinkedList<ChooseInstruction.Case>();
        LinkedList<ChooseInstruction.Case> linkedList2 = new LinkedList<ChooseInstruction.Case>();
        for (n = chooseInstruction.m_cases.length - 1; n >= 1; --n) {
            instruction2 = chooseInstruction.m_cases[n].getHandler();
            instruction = chooseInstruction.m_cases[n].getTest();
            n2 += instruction2.accumulateByteCodeSize();
            if (this.m_limit > 0 && (n2 += instruction.accumulateByteCodeSize()) >= this.m_limit) break;
            linkedList2.addFirst(new ChooseInstruction.Case(instruction, instruction2));
        }
        while (n >= 0) {
            instruction2 = chooseInstruction.m_cases[n].getHandler();
            instruction = chooseInstruction.m_cases[n].getTest();
            linkedList.addFirst(new ChooseInstruction.Case(instruction, instruction2));
            --n;
        }
        if (linkedList2.size() == 0) {
            if (instruction3 == null) {
                throw new XylemError("ERR_SYSTEM", "inconsistency in RIO at " + chooseInstruction);
            }
            instruction2 = this.buildFunction(chooseInstruction, instruction3, "choose-default");
        } else {
            instruction = new ChooseInstruction(linkedList2.toArray(new ChooseInstruction.Case[0]), instruction3);
            instruction2 = this.buildFunction(chooseInstruction, instruction, "choose");
        }
        if (linkedList.size() == 0) {
            s_logger.warn("inconsistency 1 in RIO at " + chooseInstruction);
            return instruction2;
        }
        instruction = new ChooseInstruction(linkedList.toArray(new ChooseInstruction.Case[0]), instruction2);
        return instruction.cloneWithoutTypeInformation();
    }

    private Instruction handleLet(LetInstruction letInstruction) {
        LetInstruction letInstruction2 = (LetInstruction)letInstruction.cloneShallow();
        Instruction instruction = letInstruction.getBody();
        Instruction instruction2 = letInstruction.getValue();
        if (instruction.accumulateByteCodeSize() >= instruction2.accumulateByteCodeSize()) {
            if (!this.isSafeToCut(instruction)) {
                return letInstruction;
            }
            FunctionCallInstruction functionCallInstruction = this.buildFunction(letInstruction, instruction, "let-body");
            letInstruction2.setBody(functionCallInstruction);
        } else {
            if (!this.isSafeToCut(instruction2)) {
                return letInstruction;
            }
            FunctionCallInstruction functionCallInstruction = this.buildFunction(letInstruction, instruction2, "let-value");
            letInstruction2.setValue(functionCallInstruction);
        }
        return letInstruction2.cloneWithoutTypeInformation();
    }

    private Instruction handleStream(StreamInstruction streamInstruction) {
        return this.buildFunction(streamInstruction, streamInstruction, "stream");
    }

    private FunctionCallInstruction buildFunction(Instruction instruction, Instruction instruction2, String string) {
        Instruction[] instructionArray;
        if (instruction2 instanceof FunctionCallInstruction) {
            return (FunctionCallInstruction)instruction2.cloneWithoutTypeInformation();
        }
        HashSet<Instruction[]> hashSet = new HashSet<Instruction[]>();
        instruction2.accumulateFreeBindings(hashSet, null);
        for (int i = 0; i < this.m_necessaryParameters.length; ++i) {
            instructionArray = instruction.getBindingEnvironment().getVariableBinding(this.m_necessaryParameters[i]);
            if (instructionArray == null) continue;
            hashSet.add(instructionArray);
        }
        IBinding[] iBindingArray = Binding.cloneBindings(hashSet.toArray(new IBinding[0]));
        instructionArray = Binding.getIdentifiers(iBindingArray);
        String string2 = this.m_currentFunction != null ? "outlinedFunction" + this.m_currentFunction.getName() : "outlinedFunction";
        String string3 = OptimizerUtilities.generateIntermediateIdentifier(string + "-" + string2);
        Function function = new Function(string3, (Binding[])iBindingArray, instruction2.cloneWithoutTypeInformation());
        if (!this.m_currentFunction.m_resolvedConstraintTypes.isEmpty()) {
            for (Type type : this.m_currentFunction.m_resolvedConstraintTypes.keySet()) {
                function.m_resolvedConstraintTypes.put(type, this.m_currentFunction.m_resolvedConstraintTypes.get(type));
            }
        }
        this.getCurrentModule().addFunction(function);
        FunctionCallInstruction functionCallInstruction = new FunctionCallInstruction(string3, instructionArray);
        return functionCallInstruction;
    }
}

