/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.DataDependencyDrivenOptimizer;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xylem.instructions.StreamElementInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.instructions.TupleMatchInstruction;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.ParallelForEachOptimizer;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashMap;

public class TupleOptimizer
extends Optimizer {
    private HashMap m_tupleUseInfo = new HashMap();
    private int m_reductions = 0;
    private int m_totalCTors = 0;
    private int m_removedCTors = 0;
    private int m_totalMatches = 0;
    private int m_removedMatches = 0;
    private int m_totalPFEIs = 0;
    private int m_reducedPFEIs = 0;

    public void optimize(Module module) {
        try {
            InformationCollector informationCollector = new InformationCollector(module);
            TupleReducer tupleReducer = new TupleReducer();
            TupleRemover tupleRemover = new TupleRemover();
            ParallelForEachOptimizer parallelForEachOptimizer = new ParallelForEachOptimizer();
            do {
                DeadLetEliminatorOptimizer.eliminateDeadLets(module);
                module.optimize(parallelForEachOptimizer);
                this.m_reductions = 0;
                this.m_tupleUseInfo.clear();
                module.optimize(informationCollector);
                module.optimize(tupleReducer);
                module.clearTypeInformation(true);
                module.typeCheck();
                s_logger.info("TupleOptimizer removed " + this.m_reductions + " tuple or tuple-match arguments.");
            } while (this.m_reductions > 0);
            module.optimize(tupleRemover);
            module.clearTypeInformation(true);
            module.typeCheck();
            module.reduce();
            module.typeCheck();
            s_logger.info("TupleOptimizer removed " + this.m_removedCTors + "/" + this.m_totalCTors + " tuple instructions.");
            s_logger.info("TupleOptimizer removed " + this.m_removedMatches + "/" + this.m_totalMatches + " tuple-match instructions.");
            s_logger.info("TupleOptimizer simplified " + this.m_reducedPFEIs + "/" + this.m_totalPFEIs + " parallel-foreach instructions.");
        }
        catch (Throwable throwable) {
            s_logger.error("Error in TupleOptimizer", throwable);
            throw new Error("Error in encountered TupleOptimizer");
        }
    }

    private static String getInstanceKey(Type type) {
        return "tuple" + System.identityHashCode(type);
    }

    private TupleUseInfo registerTuple(TupleType tupleType) {
        TupleUseInfo tupleUseInfo;
        String string = TupleOptimizer.getInstanceKey(tupleType);
        Object v = this.m_tupleUseInfo.get(string);
        if (v == null) {
            tupleUseInfo = new TupleUseInfo(tupleType);
            this.m_tupleUseInfo.put(string, tupleUseInfo);
        } else {
            while (v instanceof String) {
                v = this.m_tupleUseInfo.get(v);
            }
            tupleUseInfo = (TupleUseInfo)v;
        }
        return tupleUseInfo;
    }

    private void registerTuple(TupleType tupleType, TupleUseInfo tupleUseInfo) {
        String string = TupleOptimizer.getInstanceKey(tupleType);
    }

    private TupleUseInfo getInfo(Instruction instruction, TypeEnvironment typeEnvironment) {
        Type type = instruction.getCachedType();
        String string = TupleOptimizer.getInstanceKey(type);
        Object v = this.m_tupleUseInfo.get(string);
        while (v instanceof String) {
            v = this.m_tupleUseInfo.get(v);
        }
        TupleUseInfo tupleUseInfo = (TupleUseInfo)v;
        if (tupleUseInfo == null && type instanceof TupleType) {
            System.err.println("missing entry for tuple " + string + " at " + instruction);
        }
        return tupleUseInfo;
    }

    private class InformationCollector
    extends DataDependencyDrivenOptimizer {
        private Module m_module;
        private HashMap m_tupleCopyMap = new HashMap();

        private InformationCollector(Module module) {
            this.m_module = module;
        }

        public void optimizeFunction(Function function) {
            this.clearTupleCopyMap();
            if (function.getReturnType() instanceof TupleType && this.m_module.getPublicFunction(function.getName()) != null) {
                TupleType tupleType = (TupleType)function.getReturnType();
                TupleOptimizer.this.registerTuple(tupleType).setAllUsed();
            }
            super.optimizeFunction(function);
        }

        protected Instruction optimizeStep(Instruction instruction) {
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            this.clearTupleCopyMap();
            if (instruction instanceof TupleMatchInstruction) {
                TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction;
                Binding[] bindingArray = tupleMatchInstruction.getBindings();
                TupleType tupleType = (TupleType)tupleMatchInstruction.getToMatch().getType(typeEnvironment, bindingEnvironment);
                for (int i = 0; i < bindingArray.length; ++i) {
                    Binding binding = bindingArray[i];
                    if (binding == null) {
                        throw new XylemError("ERR_SYSTEM", "tuple match binding (" + i + ") " + "has null binding (or no dependancy info) " + tupleMatchInstruction);
                    }
                    if (!this.isBindingUsed(bindingArray[i])) continue;
                    TupleOptimizer.this.registerTuple(tupleType).setUsed(i);
                }
            } else {
                Instruction instruction2;
                if (instruction instanceof ProcessStreamInstruction) {
                    instruction2 = (ProcessStreamInstruction)instruction;
                    TupleUseInfo tupleUseInfo = TupleOptimizer.this.registerTuple((TupleType)instruction2.getChildInstruction(2).getType(typeEnvironment, bindingEnvironment));
                    tupleUseInfo.setAllUsed();
                }
                if (instruction.getCachedType() instanceof TupleType) {
                    this.registerTupleInstruction(instruction, typeEnvironment);
                    if (instruction instanceof IdentifierInstruction) {
                        instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction, bindingEnvironment);
                        this.registerTupleInstruction(instruction2, typeEnvironment);
                    }
                }
                for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                    if (!(instruction.getChildInstruction(i).getCachedType() instanceof TupleType)) continue;
                    this.registerTupleInstruction(instruction.getChildInstruction(i), typeEnvironment);
                }
            }
            return instruction;
        }

        private void clearTupleCopyMap() {
            this.m_tupleCopyMap.clear();
        }

        private void registerTupleInstruction(Instruction instruction, TypeEnvironment typeEnvironment) {
            TupleType tupleType = (TupleType)instruction.getCachedType();
            String string = TupleOptimizer.getInstanceKey(tupleType);
            String string2 = this.getTypeKey(instruction, typeEnvironment);
            TupleUseInfo tupleUseInfo = TupleOptimizer.this.registerTuple(tupleType);
            TupleUseInfo tupleUseInfo2 = (TupleUseInfo)this.m_tupleCopyMap.get(string2);
            if (tupleUseInfo2 != null && tupleUseInfo2 != tupleUseInfo) {
                tupleUseInfo2.mergeInfo(tupleUseInfo);
                TupleOptimizer.this.m_tupleUseInfo.put(string, tupleUseInfo2.getName());
            } else {
                this.m_tupleCopyMap.put(string2, tupleUseInfo);
            }
        }

        private String getTypeKey(Instruction instruction, TypeEnvironment typeEnvironment) {
            TupleType tupleType = (TupleType)instruction.getCachedType();
            StringBuffer stringBuffer = new StringBuffer("tuple");
            for (int i = 0; i < tupleType.getChildTypeCount(); ++i) {
                stringBuffer.append("_");
                Type type = tupleType.getChildType(i).resolveType(this.m_currentFunction.getTypeEnvironment());
                if (type instanceof TypeVariable) {
                    throw new Error("!");
                }
                stringBuffer.append(type);
            }
            return stringBuffer.toString();
        }
    }

    private class TupleReducer
    extends Optimizer {
        private TupleReducer() {
        }

        protected Instruction optimizeStep(Instruction instruction) {
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            if (instruction instanceof TupleInstruction) {
                TupleUseInfo tupleUseInfo = TupleOptimizer.this.getInfo(instruction, typeEnvironment);
                if (tupleUseInfo == null || tupleUseInfo.isFullyUsed()) {
                    return instruction;
                }
                TupleInstruction tupleInstruction = (TupleInstruction)instruction;
                ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                for (int i = 0; i < tupleInstruction.getChildInstructionCount(); ++i) {
                    if (!tupleUseInfo.m_used[i]) continue;
                    arrayList.add(tupleInstruction.getChildInstruction(i).cloneWithoutTypeInformation());
                }
                TupleInstruction tupleInstruction2 = new TupleInstruction(arrayList.toArray(new Instruction[0]));
                this.optimizeChildren(tupleInstruction2);
                String string = tupleUseInfo.getName();
                TupleOptimizer.this.m_reductions += tupleInstruction.getChildInstructionCount() - ((Instruction)tupleInstruction2).getChildInstructionCount();
                return tupleInstruction2;
            }
            if (instruction instanceof TupleMatchInstruction) {
                TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction;
                Instruction instruction2 = tupleMatchInstruction.getToMatch();
                TupleUseInfo tupleUseInfo = TupleOptimizer.this.getInfo(instruction2, typeEnvironment);
                if (tupleUseInfo == null || tupleUseInfo.isFullyUsed()) {
                    return instruction;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < tupleMatchInstruction.getVariableNames().length; ++i) {
                    if (!tupleUseInfo.m_used[i]) continue;
                    arrayList.add(tupleMatchInstruction.getVariableNames()[i]);
                }
                TupleMatchInstruction tupleMatchInstruction2 = new TupleMatchInstruction(instruction2.cloneWithoutTypeInformation(), arrayList.toArray(), tupleMatchInstruction.getBody());
                this.optimizeChildren(tupleMatchInstruction2);
                String string = tupleUseInfo.getName();
                TupleOptimizer.this.m_reductions += tupleMatchInstruction.getVariableNames().length - arrayList.size();
                return tupleMatchInstruction2;
            }
            return instruction;
        }
    }

    private class TupleRemover
    extends Optimizer {
        private TupleRemover() {
        }

        protected Instruction optimizeStep(Instruction instruction) {
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            if (instruction instanceof TupleInstruction) {
                TupleOptimizer.this.m_totalCTors++;
                TupleInstruction tupleInstruction = (TupleInstruction)instruction;
                if (tupleInstruction.getChildInstructionCount() == 1) {
                    s_logger.debug("removed " + tupleInstruction);
                    TupleOptimizer.this.m_removedCTors++;
                    Instruction instruction2 = tupleInstruction.getChildInstruction(0);
                    this.optimizeChildren(instruction2);
                    return instruction2;
                }
            } else if (instruction instanceof TupleMatchInstruction) {
                TupleOptimizer.this.m_totalMatches++;
                TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction;
                if (tupleMatchInstruction.getVariableNames().length == 1) {
                    s_logger.debug("removed " + tupleMatchInstruction);
                    TupleOptimizer.this.m_removedMatches++;
                    LetInstruction letInstruction = new LetInstruction(tupleMatchInstruction.getVariableNames()[0], tupleMatchInstruction.getToMatch(), tupleMatchInstruction.getBody());
                    this.optimizeChildren(letInstruction);
                    return letInstruction;
                }
            } else if (instruction instanceof ParallelForEachInstruction) {
                TupleType tupleType;
                TupleOptimizer.this.m_totalPFEIs++;
                ParallelForEachInstruction parallelForEachInstruction = (ParallelForEachInstruction)instruction;
                Type type = parallelForEachInstruction.getCachedType();
                if (type instanceof TupleType && (tupleType = (TupleType)type).getChildTypeCount() == 1) {
                    Instruction instruction3;
                    Instruction instruction4;
                    s_logger.debug("removed " + parallelForEachInstruction);
                    TupleOptimizer.this.m_reducedPFEIs++;
                    Object object = parallelForEachInstruction.getIndexVar();
                    Instruction instruction5 = parallelForEachInstruction.getBody();
                    if (parallelForEachInstruction.getElementVars().length > 1) {
                        if (object == null) {
                            object = OptimizerUtilities.generateIntermediateIdentifier("index");
                        }
                        for (int i = 1; i < parallelForEachInstruction.getElementVars().length; ++i) {
                            instruction4 = new IdentifierInstruction(object);
                            instruction3 = new StreamElementInstruction(parallelForEachInstruction.getSources()[i], instruction4);
                            instruction5 = new LetInstruction(parallelForEachInstruction.getElementVars()[i], instruction3, instruction5);
                        }
                    }
                    Object object2 = parallelForEachInstruction.getElementVars()[0];
                    instruction4 = parallelForEachInstruction.getSources()[0];
                    instruction3 = new ForEachInstruction(instruction4, object2, object, instruction5);
                    this.optimizeChildren(instruction3);
                    return instruction3;
                }
            }
            return instruction;
        }
    }

    private static class TupleUseInfo {
        private TupleType m_type;
        private boolean[] m_used;
        private String m_name;

        private TupleUseInfo(TupleType tupleType) {
            this.m_type = tupleType;
            this.m_used = new boolean[tupleType.getChildTypeCount()];
            this.m_name = TupleOptimizer.getInstanceKey(tupleType);
        }

        private void mergeInfo(TupleUseInfo tupleUseInfo) {
            for (int i = 0; i < tupleUseInfo.m_used.length; ++i) {
                if (!tupleUseInfo.m_used[i]) continue;
                this.setUsed(i);
            }
        }

        private void setUsed(int n) {
            this.m_used[n] = true;
        }

        private void setAllUsed() {
            for (int i = 0; i < this.m_used.length; ++i) {
                this.m_used[i] = true;
            }
        }

        private String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.getName();
        }

        private boolean isFullyUsed() {
            for (int i = 0; i < this.m_used.length; ++i) {
                if (this.m_used[i]) continue;
                return false;
            }
            return true;
        }
    }
}

