/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PostOrderOptimizer;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.CompoundType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.VirtualDataTypeMap;
import com.ibm.xylem.utils.XylemError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VDTMapOptimizer
extends PostOrderOptimizer {
    private VirtualDataTypeMap m_vdtmap = null;
    private Set m_functionsToUpdate = new HashSet();
    List deltas = new ArrayList();
    Map m_map;

    private VDTMapOptimizer() {
    }

    public VDTMapOptimizer(VirtualDataTypeMap virtualDataTypeMap) {
        this.m_vdtmap = virtualDataTypeMap;
    }

    protected Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof MatchInstruction) {
            Object object;
            Object object2;
            Object object3;
            Object[] objectArray;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            MatchInstruction matchInstruction = (MatchInstruction)instruction;
            MatchInstruction.Match match = matchInstruction.getMatches()[0];
            if (!(match instanceof MatchInstruction.DeconstructionMatch)) {
                return instruction;
            }
            Instruction instruction2 = matchInstruction.getToMatch();
            AbstractDataType abstractDataType = ((MatchInstruction.DeconstructionMatch)match).getConstructor().getAbstractDataType();
            if (abstractDataType == null || !this.m_vdtmap.hasVDTMapping(abstractDataType.getName())) {
                return instruction;
            }
            VirtualDataTypeMap.ADTMapping aDTMapping = this.m_vdtmap.getVDTMapping(abstractDataType.getName());
            MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
            MatchInstruction.Match[] matchArray2 = new MatchInstruction.Match[matchArray.length];
            for (int i = 0; i < matchArray.length; ++i) {
                int n;
                LetInstruction letInstruction;
                Object object8;
                if (matchArray[i] instanceof MatchInstruction.DeconstructionMatch) {
                    Instruction[] instructionArray;
                    Instruction instruction3;
                    object7 = (MatchInstruction.DeconstructionMatch)matchArray[i];
                    object6 = ((MatchInstruction.Match)object7).getHandler();
                    object5 = ((MatchInstruction.DeconstructionMatch)object7).getConstructor().getName();
                    object4 = ((MatchInstruction.DeconstructionMatch)object7).getConstructor().getParameterNames();
                    objectArray = ((MatchInstruction.DeconstructionMatch)object7).getBindings();
                    if (!aDTMapping.m_constructors.containsKey(object5)) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " doesn't specify mapping for constructor:" + (String)object5);
                    }
                    object3 = (VirtualDataTypeMap.ConstructorMapping)aDTMapping.m_constructors.get(object5);
                    object2 = new HashMap<Object, IdentifierInstruction>();
                    object = ReductionHelper.generateIntermediateIdentifier2();
                    ((HashMap)object2).put(((VirtualDataTypeMap.ConstructorMapping)object3).m_deconstructVariable.getName(), new IdentifierInstruction(object));
                    Instruction instruction4 = instruction3 = ((VirtualDataTypeMap.ConstructorMapping)object3).m_deconstructCode.assignNewNames((Map)object2);
                    Instruction[] instructionArray2 = null;
                    while (instruction4 instanceof LetInstruction) {
                        instructionArray = (Instruction[])instruction4;
                        instruction4 = instructionArray.getBody();
                        instructionArray2 = instructionArray;
                    }
                    if (!(instruction4 instanceof TupleInstruction)) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap match code should bottom out into a tuple instruction");
                    }
                    instructionArray = ((TupleInstruction)instruction4).getOperands();
                    if (((Object)object4).length != instructionArray.length) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " constructor:" + (String)object5 + " specifies " + ((Object)object4).length + " parameters, but the ADT map requires " + instructionArray.length);
                    }
                    object8 = object6;
                    for (int j = 0; j < instructionArray.length; ++j) {
                        LetInstruction letInstruction2 = new LetInstruction(((Binding)objectArray[j]).getName(), instructionArray[j], (Instruction)object8);
                        object8 = letInstruction2;
                    }
                    if (instructionArray2 != null) {
                        instructionArray2.setBody((Instruction)object8);
                        letInstruction = new LetInstruction(object, instruction2, instruction3);
                    } else {
                        letInstruction = new LetInstruction(object, instruction2, (Instruction)object8);
                    }
                    n = -1;
                    for (int j = 0; j < abstractDataType.m_constructors.length; ++j) {
                        if (!abstractDataType.m_constructors[j].getName().equals(object5)) continue;
                        n = j;
                        break;
                    }
                    if (n == -1) {
                        throw new XylemError("ERR_SYSTEM", "could not find variant " + (String)object5);
                    }
                } else {
                    throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " must be a deconstruction match!");
                }
                object8 = letInstruction;
                matchArray2[i] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(n), ((Instruction)object8).cloneWithNewNames());
            }
            HashMap<Object, Instruction> hashMap = new HashMap<Object, Instruction>();
            hashMap.put(aDTMapping.m_matchVariable.getName(), instruction2);
            object6 = object7 = aDTMapping.m_matchCode.assignNewNames(hashMap);
            object5 = null;
            while (object6 instanceof LetInstruction) {
                object4 = (LetInstruction)object6;
                object6 = ((LetBaseInstruction)object4).getBody();
                object5 = object4;
            }
            if (!(object6 instanceof TupleInstruction)) {
                throw new XylemError("ERR_SYSTEM", "VDTMap match instruction should bottom out into a tuple instruction");
            }
            int n = ((TupleInstruction)object6).getOperandCount();
            objectArray = ((TupleInstruction)object6).getOperands();
            if (n != 1) {
                throw new XylemError("ERR_SYSTEM", "VDTMap toMatch should have a single returned identifier. Buh?");
            }
            if (!(objectArray[0] instanceof IdentifierInstruction)) {
                throw new XylemError("ERR_SYSTEM", "VDTMap toMatch must be an identifier :" + objectArray[0] + ":");
            }
            object3 = (IdentifierInstruction)objectArray[0];
            object2 = new MatchInstruction((Instruction)object3, matchArray2, matchInstruction.getDefault(), matchInstruction.canAssumeComplete());
            ((LetBaseInstruction)object5).setBody((Instruction)object2);
            object = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), (Instruction)object7, null);
            this.m_functionsToUpdate.add(this.m_currentFunction);
            return ((Instruction)object).cloneWithNewNames();
        }
        if (instruction instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction;
            AbstractDataType abstractDataType = constructorInstantiationInstruction.getConstructor().getAbstractDataType();
            if (abstractDataType == null || !this.m_vdtmap.hasVDTMapping(abstractDataType.getName())) {
                return instruction;
            }
            VirtualDataTypeMap.ADTMapping aDTMapping = this.m_vdtmap.getVDTMapping(abstractDataType.getName());
            if (!aDTMapping.m_constructors.containsKey(constructorInstantiationInstruction.getConstructorName())) {
                throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " doesn't specify mapping for constructor:" + constructorInstantiationInstruction.getConstructorName());
            }
            VirtualDataTypeMap.ConstructorMapping constructorMapping = (VirtualDataTypeMap.ConstructorMapping)aDTMapping.m_constructors.get(constructorInstantiationInstruction.getConstructorName());
            Binding[] bindingArray = constructorMapping.m_constructParameters;
            Instruction[] instructionArray = constructorInstantiationInstruction.getOperands();
            if (bindingArray.length != instructionArray.length) {
                throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " constructor:" + constructorInstantiationInstruction.getConstructorName() + " specifies " + bindingArray.length + " parameters, but the ADT map requires " + instructionArray.length);
            }
            Instruction instruction5 = constructorMapping.m_constructCode;
            for (int i = 0; i < bindingArray.length; ++i) {
                LetInstruction letInstruction = new LetInstruction(bindingArray[i].getName(), instructionArray[i], instruction5);
                instruction5 = letInstruction;
            }
            ChooseInstruction chooseInstruction = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction5, null);
            instruction5 = chooseInstruction;
            this.m_functionsToUpdate.add(this.m_currentFunction);
            return instruction5.cloneWithNewNames();
        }
        int n = instruction.getTypeParameterCount();
        for (int i = 0; i < n; ++i) {
            if (instruction.getTypeParameter(i) == null) {
                System.out.println("Instruction " + instruction + " parameter " + i + " (" + instruction.getChildInstruction(i) + ") is null");
                throw new RuntimeException();
            }
            instruction.setTypeParameter(i, this.convertType(instruction.getTypeParameter(i)));
        }
        return instruction;
    }

    public void doUpdate(Module module) {
        Object object;
        Object object22;
        Object object3;
        Iterator iterator = this.m_vdtmap.vdtMappingNames().iterator();
        this.m_map = new HashMap();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            CompoundType compoundType = module.lookupCompoundType((String)object3);
            if (compoundType == null) continue;
            object22 = compoundType.getNamedType();
            this.m_map.put(object22, this.m_vdtmap.getTargetType((String)object3));
        }
        module.optimize(this);
        object3 = module.m_signature;
        if (this.m_functionsToUpdate.isEmpty() && this.deltas.isEmpty()) {
            s_logger.info("Skipping update for module :" + module.getName() + ":");
            return;
        }
        for (Object object22 : this.deltas) {
            if (((Delta)object22).enclosingFunction != null) {
                ((Delta)object22).enclosingFunction.setBody(((Delta)object22).replacement.cloneWithNewNames());
                continue;
            }
            ((Delta)object22).parent.setChildInstruction(((Delta)object22).index, ((Delta)object22).replacement.cloneWithNewNames());
        }
        this.deltas.clear();
        for (Object object22 : this.m_functionsToUpdate) {
            object = ((Function)object22).getParameters();
            Serializable serializable = ((Function)object22).getReturnType();
            iterator = this.m_vdtmap.vdtMappingNames().iterator();
            TypeEnvironment typeEnvironment = ((Function)object22).getTypeEnvironment();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CompoundType compoundType = ((Function)object22).getTypeEnvironment().getModule().lookupCompoundType(string);
                Type type = compoundType.getNamedType().resolveType(typeEnvironment);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Type type2 = ((Binding)object[i]).getBindingType().resolveType(typeEnvironment);
                    if (type2 == null || !type2.refersToType(type, typeEnvironment.getModule())) continue;
                    HashMap<Type, Type> hashMap = new HashMap<Type, Type>();
                    hashMap.put(type, this.m_vdtmap.getTargetType(string));
                    ((Binding)object[i]).setType(((Binding)object[i]).getBindingType().resolveType(typeEnvironment).replaceType(hashMap));
                }
            }
        }
        object22 = this.m_vdtmap.getTypeMap();
        object = new Optimizer((HashMap)object22){
            final /* synthetic */ HashMap val$typeMap;
            {
                this.val$typeMap = hashMap;
            }

            protected Instruction optimizeStep(Instruction instruction) {
                for (int i = 0; i < instruction.getTypeParameterCount(); ++i) {
                    Type type = instruction.getTypeParameter(i).resolveType(this.m_currentFunction.getTypeEnvironment());
                    instruction.setTypeParameter(i, type.replaceType(this.val$typeMap));
                }
                return instruction;
            }
        };
        for (Serializable serializable : module.getFunctions()) {
            ((Optimizer)object).optimizeFunction((Function)serializable);
        }
        this.convertADTs(module);
        this.convertADTs((ITypeStore)object3);
        this.convertFunctionSignatures(module);
        for (Serializable serializable : this.m_functionsToUpdate) {
            if (((ModuleSignature)object3).getFunctionSignature(((Function)serializable).getName()) != null) {
                ((ModuleSignature)object3).addFunctionSignature(new FunctionSignature((Function)serializable));
            }
            ((Function)serializable).clearReducedTypeInformation();
            try {
                ((Function)serializable).typeCheckReduced(module, new LinkedList());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new Error(throwable.getMessage());
            }
        }
        this.m_functionsToUpdate.clear();
    }

    public void optimizeFunction(Function function) {
        Binding[] bindingArray = function.getParameters();
        Type type = function.getReturnType();
        Iterator iterator = this.m_vdtmap.vdtMappingNames().iterator();
        TypeEnvironment typeEnvironment = function.getTypeEnvironment();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CompoundType compoundType = function.getTypeEnvironment().getModule().lookupCompoundType(string);
            Type type2 = compoundType != null ? compoundType.getNamedType() : function.getTypeEnvironment().getModule().lookupTypeAlias(string);
            if (type2 == null) continue;
            type2 = type2.resolveType(typeEnvironment);
            if (type != null && type.resolveType(typeEnvironment).refersToType(type2, typeEnvironment.getModule())) {
                this.m_functionsToUpdate.add(function);
            }
            for (int i = 0; i < bindingArray.length; ++i) {
                Type type3 = bindingArray[i].getBindingType().resolveType(typeEnvironment);
                if (type3 == null || !type3.refersToType(type2, typeEnvironment.getModule())) continue;
                this.m_functionsToUpdate.add(function);
            }
        }
        super.optimizeFunction(function);
    }

    protected void convertADTs(ITypeStore iTypeStore) {
        boolean bl;
        HashSet<AbstractDataType> hashSet = new HashSet<AbstractDataType>();
        do {
            Iterator iterator = iTypeStore.getAbstractDataTypesIterator();
            bl = false;
            while (iterator.hasNext()) {
                AbstractDataType abstractDataType = (AbstractDataType)iterator.next();
                if (hashSet.contains(abstractDataType)) continue;
                for (int i = 0; i < abstractDataType.m_constructors.length; ++i) {
                    AbstractDataType.Constructor constructor = abstractDataType.m_constructors[i];
                    for (int j = 0; j < constructor.m_parameters.length; ++j) {
                        Binding binding = constructor.m_parameters[j];
                        binding.setType(this.convertType(binding.getBindingType()));
                    }
                }
                hashSet.add(abstractDataType);
                bl = true;
            }
        } while (bl);
    }

    protected void convertFunctionSignatures(Module module) {
        Iterator iterator = module.getFunctions().iterator();
        while (iterator.hasNext()) {
            Function function;
            this.m_currentFunction = function = (Function)iterator.next();
            for (int i = 0; i < function.m_parameters.length; ++i) {
                Binding binding = function.m_parameters[i];
                binding.setType(this.convertType(binding.getBindingType()));
            }
            function.setReturnType(this.convertType(function.getReturnType()));
            FunctionSignature functionSignature = module.getFunctionSignature(this.m_currentFunction.getName());
            if (functionSignature != null) {
                functionSignature.setReturnType(function.getReturnType());
            }
            this.m_currentFunction = null;
        }
    }

    public Type convertType(Type type) {
        if (type == null) {
            throw new RuntimeException();
        }
        if (this.getCurrentFunction() != null) {
            type = type.resolveType(this.getCurrentFunction().getTypeEnvironment());
        }
        if (type instanceof NamedType) {
            NamedType namedType = (NamedType)type;
            Type type2 = this.m_map == null ? null : this.m_map.get(namedType);
            if (type2 != null) {
                return type2;
            }
            return namedType;
        }
        int n = type.getChildTypeCount();
        for (int i = 0; i < n; ++i) {
            type.setChildType(i, this.convertType(type.getChildType(i)));
        }
        return type;
    }

    private class Delta {
        Instruction parent;
        int index;
        Instruction replacement;
        TypeEnvironment tenv;
        BindingEnvironment benv;
        Function enclosingFunction;

        public Delta(Instruction instruction, int n, Instruction instruction2, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Function function) {
            this.parent = instruction;
            this.index = n;
            this.replacement = instruction2;
            this.tenv = typeEnvironment;
            this.benv = bindingEnvironment;
            this.enclosingFunction = function;
        }
    }
}

