/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.instructions.AutomatonInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.ConstructorDataType;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutomatonFunctionCallEvaluator
extends PartialEvaluator {
    private static boolean m_skipMatchExtraction = true;

    public static final Object generateIntermediateIdentifier() {
        return ReductionHelper.generateIntermediateIdentifier2();
    }

    private static final LiteralInstruction getLiteralIfPossible(Instruction instruction, LetChainManager letChainManager) {
        if (instruction instanceof IdentifierInstruction) {
            instruction = letChainManager.lookupBinding(instruction);
        }
        if (instruction instanceof LiteralInstruction) {
            return (LiteralInstruction)instruction;
        }
        return null;
    }

    private static final LiteralInstruction[] getLiteralsIfPossible(Instruction instruction, LetChainManager letChainManager) {
        if (instruction instanceof IdentifierInstruction) {
            instruction = letChainManager.lookupBinding(instruction);
        }
        if (!(instruction instanceof StreamInstruction)) {
            return null;
        }
        StreamInstruction streamInstruction = (StreamInstruction)instruction;
        int n = streamInstruction.getChildInstructionCount();
        LiteralInstruction[] literalInstructionArray = new LiteralInstruction[n];
        for (int i = 0; i < n; ++i) {
            Instruction instruction2 = streamInstruction.getChildInstruction(i);
            if (instruction2 instanceof IdentifierInstruction) {
                instruction2 = letChainManager.lookupBinding(instruction2);
            }
            if (!(instruction2 instanceof LiteralInstruction)) {
                return null;
            }
            literalInstructionArray[i] = (LiteralInstruction)instruction2;
        }
        return literalInstructionArray;
    }

    private static Integer getIntegerFromCurrentStates(Set set) {
        Integer n = null;
        n = 1 == set.size() ? (Integer)set.iterator().next() : null;
        return n;
    }

    private static Instruction getIdentityOptimizedInstruction(Instruction instruction, Function function, Integer n, AutomatonInstruction automatonInstruction) {
        if (null != n && 3 == n && -1 != function.getName().indexOf("fix-html-special-attributes-for-td") && function.getName().equals("$afo-augmented$xslt1$fix-html-special-attributes-for-td")) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = new ConstructorInstantiationInstruction(automatonInstruction.getStateComboConstructor(function.getTypeEnvironment()).getName(), new Instruction[]{instruction, LiteralInstruction.integerLiteral(3)});
            return constructorInstantiationInstruction;
        }
        return null;
    }

    private static boolean isUnneeded(Function function, Function function2) {
        if (function.getName().endsWith("$afo-augmented$xslt1$fix-html-special-attributes-for-td") && function2.getName().equals("$afo-augmented$xslt1$fix-html-special-attributes-for-td")) {
            return true;
        }
        if (-1 != function.getName().indexOf("$afo-augmented$xslt1$fix-html-special-attributes-for-td") && -1 != function2.getName().indexOf("$afo-augmented$xslt1$fix-html-special-attributes-for-td")) {
            s_logger.warn("isUnneeded found: " + function.getName() + " <==> " + function2.getName());
        }
        return false;
    }

    private static HashMap getBindingReplacementMap(AutomatonInstruction.Match match, ConstructorInstantiationInstruction constructorInstantiationInstruction, Function function, FunctionCallInstruction functionCallInstruction, LetChainManager letChainManager, LetInstruction letInstruction) {
        HashMap hashMap;
        if (match instanceof AutomatonInstruction.DeconstructionMatch) {
            AutomatonInstruction.DeconstructionMatch deconstructionMatch = (AutomatonInstruction.DeconstructionMatch)match;
            hashMap = PartialInformationCollector.setupDeconstructionBindingReplacement(deconstructionMatch.getUsedParameters(constructorInstantiationInstruction.m_parameters), deconstructionMatch.getBindings(), deconstructionMatch.getHandler(), letChainManager, letInstruction);
        } else {
            hashMap = PartialInformationCollector.setupDeconstructionBindingReplacement(new Instruction[0], new Binding[0], match.getHandler(), letChainManager, letInstruction);
        }
        for (int i = 0; i < function.m_parameters.length; ++i) {
            hashMap.put(function.m_parameters[i].getName(), functionCallInstruction.m_parameters[i]);
        }
        return hashMap;
    }

    private static Function getAugmentedGenericFunction(Function function, Function function2, int n, Integer n2, boolean bl, PartialInformationCollector partialInformationCollector) {
        int n3;
        GenericDerivative genericDerivative = new GenericDerivative(function2.getName(), n2, bl);
        Function function3 = function.lookupDerivative(genericDerivative);
        if (function3 != null) {
            return function3;
        }
        Module module = function.getTypeEnvironment().getModule();
        Object object = AutomatonFunctionCallEvaluator.generateIntermediateIdentifier();
        Instruction instruction = function.getBody();
        instruction = genericDerivative.isRunOnStreamPart() ? AutomatonFunctionCallEvaluator.getStreamPartOut(instruction, partialInformationCollector, true) : instruction.cloneReduced();
        int n4 = function.m_parameters.length + function2.m_parameters.length - 1;
        if (genericDerivative.isInitialStateSpecialized()) {
            --n4;
        }
        Binding[] bindingArray = new Binding[n4];
        int n5 = 0;
        Instruction[] instructionArray = new Instruction[function2.m_parameters.length];
        for (n3 = 0; n3 < function2.m_parameters.length; ++n3) {
            Object object2;
            if (n == n3) {
                object2 = object;
                instructionArray[n3] = new IdentifierInstruction(object2);
                continue;
            }
            if (genericDerivative.isInitialStateSpecialized() && function2.m_parameters.length - 1 == n3) {
                instructionArray[n3] = new LiteralInstruction(IntType.s_intType, n2);
                continue;
            }
            object2 = AutomatonFunctionCallEvaluator.generateIntermediateIdentifier();
            bindingArray[n5++] = new Binding(object2, function2.m_parameters[n3].getBindingType(), function2.m_parameters[n3].getTypeEnvironment());
            instructionArray[n3] = new IdentifierInstruction(object2);
        }
        for (n3 = 0; n3 < function.m_parameters.length; ++n3) {
            bindingArray[n5++] = new Binding(function.m_parameters[n3].getName(), function.m_parameters[n3].getBindingType());
        }
        Instruction instruction2 = AutomatonFunctionCallEvaluator.moveToBottom(instruction, object, new FunctionCallInstruction(function2.getName(), instructionArray));
        function3 = new Function(function.getName() + function2.getName() + (genericDerivative.isInitialStateSpecialized() ? "$" + genericDerivative.m_automatonInitialState.toString() : ""), bindingArray, instruction2);
        if (!function2.getName().equals("$afo-augmented$xslt1$playback-sax-events")) {
            function3.setMemoizeResult(function.getMemoizeResult());
        }
        function3.m_comment = function.getComment();
        function3.setConstraints(function.getConstraints());
        function3.m_resolvedConstraintTypes = new HashMap(function.m_resolvedConstraintTypes);
        module.addFunction(function3);
        function.registerDerivative(genericDerivative, function3);
        return function3;
    }

    private static Instruction[] getParametersForAugmentedGenericFunction(FunctionCallInstruction functionCallInstruction, int n, AutomatonInstruction automatonInstruction, boolean bl, FunctionCallInstruction functionCallInstruction2, Function function) {
        int n2;
        GenericDerivative genericDerivative = (GenericDerivative)function.getDerivationKey();
        Instruction[] instructionArray = new Instruction[function.m_parameters.length];
        int n3 = 0;
        for (n2 = 0; n2 < functionCallInstruction.m_parameters.length; ++n2) {
            if (n == n2 || bl && genericDerivative.isInitialStateSpecialized() && functionCallInstruction.m_parameters.length - 1 == n2) continue;
            instructionArray[n3++] = functionCallInstruction.m_parameters[n2];
        }
        if (!bl && !genericDerivative.isInitialStateSpecialized()) {
            instructionArray[n3++] = automatonInstruction.getInitialState();
        }
        for (n2 = 0; n2 < functionCallInstruction2.m_parameters.length; ++n2) {
            instructionArray[n3++] = functionCallInstruction2.m_parameters[n2];
        }
        return instructionArray;
    }

    private static Instruction getStreamPartOut(Instruction instruction, PartialInformationCollector partialInformationCollector, boolean bl) {
        Type type = partialInformationCollector.resolveType(instruction);
        if (bl) {
            instruction = instruction.cloneWithNewNames();
        }
        if (null == type || !(type instanceof NamedType)) {
            throw new XylemError("ERR_SYSTEM", "Why isn't this type a CDT?: " + type);
        }
        ConstructorDataType constructorDataType = (ConstructorDataType)((NamedType)type).resolveNameToADT(partialInformationCollector.getCurrentTypeEnvironment());
        Object object = AutomatonFunctionCallEvaluator.generateIntermediateIdentifier();
        Instruction instruction2 = AutomatonFunctionCallEvaluator.moveToBottom(instruction, object, new MatchInstruction((Instruction)new IdentifierInstruction(object), constructorDataType.m_constructors[0], 0));
        return instruction2;
    }

    public static Function getStreamOnlyFunction(Function function, LetChainManager letChainManager, PartialInformationCollector partialInformationCollector) {
        StreamOnlyDerivative streamOnlyDerivative = StreamOnlyDerivative.s_streamOnlyDerivative;
        Function function2 = function.lookupDerivative(streamOnlyDerivative);
        if (function2 != null) {
            return function2;
        }
        Module module = function.getTypeEnvironment().getModule();
        if (function.getDerivationKey() == AugmentedDerivative.s_augmentedDerivative) {
            Function function3 = function.getOriginalFunction();
            Function function4 = function3.cloneFunctionForFixup(AugmentedDerivative.s_extraArgDerivative);
            function4.setMemoizeResult(function3.getMemoizeResult());
            Binding[] bindingArray = new Binding[function.m_parameters.length];
            for (int i = 0; i < bindingArray.length; ++i) {
                bindingArray[i] = new Binding(function.m_parameters[i].getName());
            }
            function4.m_parameters = bindingArray;
            module.addFunction(function4);
            return function4;
        }
        Instruction instruction = StreamOnlyHelper.getStreamOnly(function.getBody(), letChainManager, partialInformationCollector);
        function2 = function.cloneFunctionForFixup(streamOnlyDerivative);
        function2.setBody(instruction);
        module.addFunction(function2);
        return function2;
    }

    public static final boolean isAutomatonFunctionAugmented(Function function) {
        return function.getDerivationKey() == AugmentedDerivative.s_augmentedDerivative;
    }

    public static Function getAugmentedAutomatonFunction(Function function) {
        Function function2 = function.lookupDerivative(AugmentedDerivative.s_augmentedDerivative);
        if (function2 != null) {
            return function2;
        }
        Binding[] bindingArray = function.m_parameters;
        Binding[] bindingArray2 = new Binding[bindingArray.length + 1];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray2[i] = new Binding(bindingArray[i].getName(), bindingArray[i].getBindingType());
        }
        Object object = AutomatonFunctionCallEvaluator.generateIntermediateIdentifier();
        bindingArray2[bindingArray.length] = new Binding(object, IntType.s_intType);
        AutomatonInstruction automatonInstruction = (AutomatonInstruction)function.getBody().cloneWithoutTypeInformation();
        automatonInstruction.setWrapResult(true);
        automatonInstruction.setInitialState(new IdentifierInstruction(object));
        function2 = new Function("$afo-augmented$" + function.getName(), bindingArray2, automatonInstruction);
        function2.m_comment = function.getComment();
        function2.setConstraints(function.getConstraints());
        function2.m_resolvedConstraintTypes = function.m_resolvedConstraintTypes;
        function.getTypeEnvironment().getModule().addFunction(function2);
        function.registerDerivative(AugmentedDerivative.s_augmentedDerivative, function2);
        try {
            function2.typeCheckReduced(function.getTypeEnvironment().getModule(), new LinkedList());
        }
        catch (TypeCheckException typeCheckException) {
            throw new XylemError("ERR_SYSTEM", "New augmented automaton function does not type check: " + typeCheckException);
        }
        return function2;
    }

    public static FunctionCallInstruction makeCallToAugmentedAutomatonFromWithinLoop(PartialInformationCollector partialInformationCollector, Instruction instruction, FunctionCallInstruction functionCallInstruction, Function function, int n, boolean bl, Instruction instruction2) {
        Instruction[] instructionArray = new Instruction[functionCallInstruction.m_parameters.length + (bl ? 0 : 1)];
        for (int i = 0; i < functionCallInstruction.m_parameters.length; ++i) {
            instructionArray[i] = n == i ? instruction : functionCallInstruction.m_parameters[i];
        }
        instructionArray[instructionArray.length - 1] = instruction2;
        return new FunctionCallInstruction(function.getName(), instructionArray);
    }

    public static MatchInstruction.DeconstructionMatch makeExtractMatch(ConstructorDataType constructorDataType, int n) {
        Object[] objectArray = new Object[]{ReductionHelper.generateIntermediateIdentifier2(), ReductionHelper.generateIntermediateIdentifier2()};
        return new MatchInstruction.DeconstructionMatch(constructorDataType.m_constructors[0], objectArray, (Instruction)new IdentifierInstruction(objectArray[n]));
    }

    private final MatchInstruction getCombinedMatch(MatchInstruction.LiteralMatch[] literalMatchArray, AutomatonInstruction.DeconstructionMatch[] deconstructionMatchArray, ConstructorInstantiationInstruction constructorInstantiationInstruction, LetChainManager letChainManager, LetInstruction letInstruction, PartialInformationCollector partialInformationCollector, Instruction instruction) {
        MatchInstruction.Match[] matchArray = this.combineMatchesForSameState(literalMatchArray, deconstructionMatchArray, constructorInstantiationInstruction, letChainManager, letInstruction, partialInformationCollector);
        if (0 == matchArray.length) {
            return null;
        }
        MatchInstruction matchInstruction = new MatchInstruction(instruction, matchArray, null);
        return matchInstruction;
    }

    private final MatchInstruction.LiteralMatch[] combineMatchesForSameState(MatchInstruction.LiteralMatch[] literalMatchArray, AutomatonInstruction.DeconstructionMatch[] deconstructionMatchArray, ConstructorInstantiationInstruction constructorInstantiationInstruction, LetChainManager letChainManager, LetInstruction letInstruction, PartialInformationCollector partialInformationCollector) {
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        int n3;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        LiteralInstruction.KnownValue[] knownValueArray = new LiteralInstruction.KnownValue[constructorInstantiationInstruction.m_parameters.length];
        for (n3 = 0; n3 < constructorInstantiationInstruction.m_parameters.length; ++n3) {
            knownValueArray[n3] = AutomatonFunctionCallEvaluator.extractKnownValue(partialInformationCollector, constructorInstantiationInstruction.m_parameters[n3], letChainManager);
        }
        for (n3 = 0; n3 < literalMatchArray.length; ++n3) {
            MatchInstruction.LiteralMatch literalMatch = literalMatchArray[n3];
            object3 = deconstructionMatchArray[n3];
            Object object4 = literalMatch.getLiteral().getValue();
            if (!(object4 instanceof Integer)) {
                throw new XylemError("ERR_SYSTEM", "Can't call combineMatchesForSameState other than with integer literal match clauses.");
            }
            n2 = (Integer)object4;
            n = ((AutomatonInstruction.DeconstructionMatch)object3).compare(knownValueArray);
            boolean bl = false;
            if (0 == n) break;
            if (1 == n) {
                bl = true;
            }
            Object object5 = object4;
            object2 = new MIandAI(literalMatch, (AutomatonInstruction.DeconstructionMatch)object3, bl);
            if (hashMap.containsKey(object5)) {
                object = (List)hashMap.get(object5);
                object.add(object2);
                continue;
            }
            object = new LinkedList();
            object.add(object2);
            hashMap.put(object5, object);
        }
        MatchInstruction.LiteralMatch[] literalMatchArray2 = new MatchInstruction.LiteralMatch[hashMap.size()];
        int n4 = 0;
        object3 = hashMap.keySet().iterator();
        boolean bl = false;
        while (object3.hasNext()) {
            Object e = object3.next();
            n = (Integer)e;
            List list = (List)hashMap.get(e);
            if (list.size() == 0) {
                literalMatchArray2[n4] = null;
                bl = true;
            }
            if (list.size() == 1 && ((MIandAI)list.get((int)0)).m_isSureMatch) {
                literalMatchArray2[n4] = ((MIandAI)list.get((int)0)).m_m;
            } else {
                Object object6;
                Object object7;
                int n5 = 0;
                object2 = list.iterator();
                object = new ChooseInstruction.Case[list.size()];
                while (object2.hasNext()) {
                    object7 = (MIandAI)object2.next();
                    object6 = ((MIandAI)object7).m_m;
                    AutomatonInstruction.DeconstructionMatch deconstructionMatch = ((MIandAI)object7).m_dm;
                    IdentifierInstruction identifierInstruction = deconstructionMatch.getXylemIfMatches(constructorInstantiationInstruction, letChainManager, letInstruction);
                    object[n5] = new ChooseInstruction.Case(identifierInstruction, ((MatchInstruction.Match)object6).getHandler());
                    ++n5;
                }
                object7 = null;
                for (int i = ((ChooseInstruction.Case[])object).length - 1; i >= 0; --i) {
                    object7 = new ChooseInstruction(((ChooseInstruction.Case)object[i]).getTest(), ((ChooseInstruction.Case)object[i]).getHandler(), (Instruction)object7);
                }
                literalMatchArray2[n4] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(n), (Instruction)object7);
                object6 = new MatchInstruction((Instruction)new IdentifierInstruction("toMatch"), new MatchInstruction.Match[]{literalMatchArray2[n4]}, null);
            }
            ++n4;
        }
        if (bl) {
            n2 = 0;
            for (n = 0; n < literalMatchArray2.length; ++n) {
                if (null == literalMatchArray2[n]) continue;
                ++n2;
            }
            MatchInstruction.LiteralMatch[] literalMatchArray3 = literalMatchArray2;
            literalMatchArray2 = new MatchInstruction.LiteralMatch[n2];
            int n6 = 0;
            for (int i = 0; i < literalMatchArray2.length; ++i) {
                if (null == literalMatchArray3[i]) continue;
                literalMatchArray2[n6] = literalMatchArray3[i];
                ++n6;
            }
        }
        return literalMatchArray2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public PartialEvaluationResult extractPartialInformation(Instruction var1_1, PartialInformationCollector var2_2, LetInstruction var3_3, LetChainManager var4_4) {
        block88: {
            block90: {
                block94: {
                    block95: {
                        block93: {
                            block92: {
                                block91: {
                                    block89: {
                                        var5_5 = (FunctionCallInstruction)var1_1;
                                        var6_6 = var4_4.getCurrentFunction().getTypeEnvironment();
                                        var7_7 = var4_4.getCurrentFunction().getBindingEnvironment();
                                        var9_9 = var8_8 = var6_6.getModule().getFunction(var5_5.getFunction());
                                        var10_10 = null;
                                        var11_11 = null;
                                        var12_12 = -1;
                                        if (AutomatonFunctionCallEvaluator.isAutomatonFunctionAugmented(var8_8)) {
                                            var10_10 = var8_8;
                                            var8_8 = var8_8.getOriginalFunction();
                                            var11_11 = (AutomatonInstruction)var8_8.getBody();
                                            var12_12 = 0;
                                        } else if (var8_8.getBody() instanceof AutomatonInstruction && (var11_11 = (AutomatonInstruction)var8_8.getBody()).getSource() instanceof IdentifierInstruction && var11_11.getInitialState() instanceof LiteralInstruction && (var13_13 = (IdentifierInstruction)var11_11.getSource()).getVariable().equals(var8_8.m_parameters[0].getName())) {
                                            var12_12 = 0;
                                            var10_10 = AutomatonFunctionCallEvaluator.getAugmentedAutomatonFunction(var8_8);
                                        }
                                        if (var12_12 == -1) {
                                            return PartialEvaluationResult.s_emptyResult;
                                        }
                                        var13_14 = var9_9 == var10_10;
                                        var14_15 = var13_14 != false || var11_11.getWrapResult() != false;
                                        var15_16 = var13_14 != false ? var5_5.m_parameters[var5_5.getChildInstructionCount() - 1] : var11_11.getInitialState();
                                        var2_2.partiallyEvaluate(var15_16, var4_4);
                                        var16_17 = AutomatonFunctionCallEvaluator.extractIntegerValue(var2_2, var15_16, var4_4);
                                        var17_18 = (ConstructorDataType)((NamedType)var11_11.getStateComboType().resolveType(var6_6)).resolveNameToADT(var6_6);
                                        var18_19 = var5_5.getParameters()[var12_12];
                                        var19_20 = AutomatonFunctionCallEvaluator.getIdentityOptimizedInstruction(var5_5.getParameters()[var12_12], var10_10, var16_17, var11_11);
                                        if (null != var19_20) {
                                            return new PartialEvaluationResult(var19_20);
                                        }
                                        var2_2.partiallyEvaluate((Instruction)var18_19, var4_4);
                                        var18_19 = var4_4.lookupBinding((Instruction)var18_19);
                                        v0 = var20_21 = var18_19 instanceof StreamInstruction != false ? (StreamInstruction)var18_19 : null;
                                        if (var18_19 == null) break block88;
                                        var21_22 = null;
                                        if (var18_19 instanceof StreamInstruction && (var23_24 = AutomatonFunctionCallEvaluator.accumulateStream(var22_23 /* !! */  = (StreamInstruction)var18_19, var2_2, var4_4)).hasNext()) {
                                            var24_26 = (Instruction)var23_24.next();
                                            if (!var23_24.hasNext() && var2_2.resolveType((Instruction)var24_26) instanceof StreamType) {
                                                var18_19 = var24_26;
                                                if ((var18_19 = var4_4.lookupBinding((Instruction)var18_19)) == null) {
                                                    return PartialEvaluationResult.s_emptyResult;
                                                }
                                                var20_21 = var18_19 instanceof StreamInstruction != false ? (StreamInstruction)var18_19 : null;
                                            }
                                        }
                                        var22_23 /* !! */  = var13_14 != false ? var5_5.m_parameters[var5_5.getChildInstructionCount() - 1] : var11_11.getInitialState();
                                        var23_25 = false;
                                        if (var18_19 instanceof MatchInstruction && null != (var25_27 /* !! */  = (var24_26 = (MatchInstruction)var18_19).doSpecialADTExtraction(var6_6, var7_7))) {
                                            var2_2.partiallyEvaluate((Instruction)var25_27 /* !! */ , var4_4);
                                            var25_27 /* !! */  = var4_4.lookupBinding((Instruction)var25_27 /* !! */ );
                                            var18_19 = var25_27 /* !! */ ;
                                            var23_25 = true;
                                        }
                                        if (!(var18_19 instanceof ForEachInstruction)) break block89;
                                        var24_26 = AutomatonFunctionCallEvaluator.generateIntermediateIdentifier();
                                        var25_27 /* !! */  = (ForEachInstruction)var18_19.cloneWithNewNames();
                                        var26_28 = OptimizerUtilities.generateIntermediateIdentifier();
                                        var27_34 = AutomatonFunctionCallEvaluator.makeCallToAugmentedAutomatonFromWithinLoop(var2_2, new IdentifierInstruction(var26_28), var5_5, var10_10, var12_12, var13_14, new IdentifierInstruction(var24_26));
                                        var28_40 = AutomatonFunctionCallEvaluator.moveToBottom(var25_27 /* !! */ .getBody(), var26_28, var27_34);
                                        v1 = var29_45 = var25_27 /* !! */ .overriddenCollectionType() != false ? new AutomatonInstruction(var25_27 /* !! */ .getSource(), var22_23 /* !! */ , new AutomatonInstruction.Match[0], var28_40, var11_11.getStateComboType(), var24_26, var25_27 /* !! */ .getVarName(), null, var14_15, (ICollectionType)var25_27 /* !! */ .getCollectionType()) : new AutomatonInstruction(var25_27 /* !! */ .getSource(), var22_23 /* !! */ , new AutomatonInstruction.Match[0], var28_40, var11_11.getStateComboType(), var24_26, var25_27 /* !! */ .getVarName(), null, var14_15);
                                        if (var25_27 /* !! */ .getIndexVar() != null) {
                                            var29_45.setLoopIndexVar(var25_27 /* !! */ .getIndexVar());
                                        }
                                        var21_22 = var29_45;
                                        if (var23_25) {
                                            var21_22 = null;
                                        }
                                        break block90;
                                    }
                                    if (!(var18_19 instanceof ChooseInstruction)) break block91;
                                    var24_26 = (ChooseInstruction)var18_19;
                                    var25_27 /* !! */  = (ChooseInstruction)var24_26.cloneShallow();
                                    for (var26_29 = 0; var26_29 < var24_26.m_cases.length; ++var26_29) {
                                        var27_35 = (FunctionCallInstruction)var5_5.cloneReduced();
                                        var28_41 = ReductionHelper.generateIntermediateIdentifier2();
                                        var27_35.m_parameters[var12_12] = new IdentifierInstruction(var28_41);
                                        var29_46 = var24_26.m_cases[var26_29].getHandler();
                                        var29_46 = var23_25 != false ? AutomatonFunctionCallEvaluator.getStreamPartOut(var29_46, var2_2, true) : var29_46.cloneWithNewNames();
                                        var25_27 /* !! */ .m_cases[var26_29].setHandler(AutomatonFunctionCallEvaluator.moveToBottom(var29_46, var28_41, var27_35));
                                    }
                                    var26_30 = var24_26.getDefaultHandler();
                                    if (var26_30 != null) {
                                        var27_35 = (FunctionCallInstruction)var5_5.cloneReduced();
                                        var28_41 = ReductionHelper.generateIntermediateIdentifier2();
                                        var27_35.m_parameters[var12_12] = new IdentifierInstruction(var28_41);
                                        var29_46 = var26_30;
                                        var29_46 = var23_25 != false ? AutomatonFunctionCallEvaluator.getStreamPartOut(var29_46, var2_2, true) : var29_46.cloneWithNewNames();
                                        var25_27 /* !! */ .setDefaultHandler(AutomatonFunctionCallEvaluator.moveToBottom(var29_46, var28_41, var27_35));
                                    }
                                    var21_22 = var25_27 /* !! */ ;
                                    if (AutomatonFunctionCallEvaluator.m_skipMatchExtraction && var23_25) {
                                        var21_22 = null;
                                    }
                                    break block90;
                                }
                                if (!(var18_19 instanceof MatchInstruction)) break block92;
                                var24_26 = (MatchInstruction)var18_19;
                                var25_27 /* !! */  = (MatchInstruction)var24_26.cloneWithNewNames();
                                var26_31 = var24_26.getMatches();
                                for (var27_36 = 0; var27_36 < var26_31.length; ++var27_36) {
                                    var28_42 = (FunctionCallInstruction)var5_5.cloneReduced();
                                    var29_47 = ReductionHelper.generateIntermediateIdentifier2();
                                    var28_42.m_parameters[var12_12] = new IdentifierInstruction(var29_47);
                                    var30_49 = var25_27 /* !! */ .getMatches()[var27_36].getHandler();
                                    if (var23_25) {
                                        var30_49 = AutomatonFunctionCallEvaluator.getStreamPartOut(var30_49, var2_2, false);
                                    }
                                    var25_27 /* !! */ .getMatches()[var27_36].setHandler(AutomatonFunctionCallEvaluator.moveToBottom(var30_49, var29_47, var28_42));
                                }
                                var27_37 = var24_26.getDefault();
                                if (var27_37 != null) {
                                    var28_42 = (FunctionCallInstruction)var5_5.cloneReduced();
                                    var29_47 = ReductionHelper.generateIntermediateIdentifier2();
                                    var28_42.m_parameters[var12_12] = new IdentifierInstruction(var29_47);
                                    var30_49 = var25_27 /* !! */ .getDefault();
                                    if (var23_25) {
                                        var30_49 = AutomatonFunctionCallEvaluator.getStreamPartOut(var30_49, var2_2, false);
                                    }
                                    var25_27 /* !! */ .setDefault(AutomatonFunctionCallEvaluator.moveToBottom(var30_49, var29_47, var28_42));
                                }
                                var21_22 = var25_27 /* !! */ ;
                                if (AutomatonFunctionCallEvaluator.m_skipMatchExtraction && var23_25) {
                                    var21_22 = null;
                                }
                                break block90;
                            }
                            if (!(var18_19 instanceof FunctionCallInstruction)) break block93;
                            var24_26 = (FunctionCallInstruction)var18_19;
                            var25_27 /* !! */  = var4_4.getCurrentFunction().getTypeEnvironment().getModule().getFunction(var24_26.getFunction());
                            if (AutomatonFunctionCallEvaluator.isUnneeded((Function)var25_27 /* !! */ , var10_10)) {
                                var21_22 = var24_26.cloneReduced();
                            } else {
                                var26_32 = AutomatonFunctionCallEvaluator.getAugmentedGenericFunction(var25_27 /* !! */ , var10_10, var12_12, var16_17, var23_25, var2_2);
                                var27_38 = AutomatonFunctionCallEvaluator.getParametersForAugmentedGenericFunction(var5_5, var12_12, var11_11, var13_14, (FunctionCallInstruction)var24_26, var26_32);
                                var28_43 = new FunctionCallInstruction(var26_32.getName(), var27_38);
                                var21_22 = var28_43;
                            }
                            if (var8_8 == var9_9 && !var11_11.getWrapResult()) {
                                var21_22 = new MatchInstruction(var4_4.insertBody2((Instruction)var21_22, var3_3), new MatchInstruction.Match[]{AutomatonFunctionCallEvaluator.makeExtractMatch(var17_18, 0)}, null);
                            }
                            if (AutomatonFunctionCallEvaluator.m_skipMatchExtraction && var23_25) {
                                var21_22 = null;
                            }
                            break block90;
                        }
                        if (!(var18_19 instanceof StreamInstruction)) break block90;
                        if (var23_25) {
                            throw new XylemError("ERR_SYSTEM", "Should never reach, should have to extract the stream");
                        }
                        if (var11_11.getDefaultHandler() != null) {
                            return PartialEvaluationResult.s_emptyResult;
                        }
                        var24_26 = var11_11.getKnownStates();
                        var25_27 /* !! */  = new HashSet();
                        var26_33 = PartialEvaluator.extractLiteralValue(var2_2, var22_23 /* !! */ , var4_4);
                        if (var26_33 instanceof Integer) {
                            var25_27 /* !! */ .add(var26_33);
                        }
                        if (var25_27 /* !! */ .isEmpty()) {
                            var25_27 /* !! */ .addAll(var24_26);
                        }
                        var27_39 = new LinkedList<Object[]>();
                        var28_44 = new LinkedList<Instruction>();
                        var29_48 = new LinkedList<Object>();
                        var30_50 = AutomatonFunctionCallEvaluator.accumulateStream(var20_21, var2_2, var4_4);
                        while (var30_50.hasNext()) {
                            var31_51 = (Instruction)var30_50.next();
                            var18_19 = var4_4.lookupBinding((Instruction)var31_51);
                            var32_52 = new HashSet();
                            if (var18_19 instanceof ConstructorInstantiationInstruction) {
                                var33_53 = (ConstructorInstantiationInstruction)var18_19;
                                if (var25_27 /* !! */ .size() == 1) {
                                    var34_61 = (Integer)var25_27 /* !! */ .iterator().next();
                                    var35_68 = false;
                                    block3: for (var36_76 = 0; var36_76 < var11_11.m_matches.length; ++var36_76) {
                                        var37_83 = (Instruction[])var11_11.m_matches[var36_76];
                                        if (var37_83.getCurrentState() != var34_61 || var37_83.getConstructor() != var33_53.getConstructor()) continue;
                                        var38_86 = var37_83.getNextState();
                                        if (!(var38_86 instanceof LiteralInstruction) || !((var39_87 = ((LiteralInstruction)var38_86).getValue()) instanceof Integer)) break;
                                        var40_90 = (Integer)var39_87;
                                        var41_96 = var37_83.getBindingNames();
                                        for (var42_97 = 0; var42_97 < ((AutomatonInstruction.BindingOrLiteral[])var41_96).length; ++var42_97) {
                                            var43_103 = var41_96[var42_97];
                                            if (var43_103.isLiteral()) {
                                                var44_105 = var43_103.getLiteral();
                                                var45_109 /* !! */  = AutomatonFunctionCallEvaluator.getLiteralIfPossible(var33_53.m_parameters[var42_97], var4_4);
                                                if (null == var45_109 /* !! */ ) break block3;
                                                if (!var44_105.equals(var45_109 /* !! */ )) continue block3;
                                                continue;
                                            }
                                            if (!var43_103.isLiteralStream()) continue;
                                            var44_105 = var43_103.getLiteralStream();
                                            var45_109 /* !! */  = AutomatonFunctionCallEvaluator.getLiteralsIfPossible(var33_53.m_parameters[var42_97], var4_4);
                                            if (null == var45_109 /* !! */ ) break block3;
                                            if (!Arrays.equals((Object[])var44_105, var45_109 /* !! */ )) continue block3;
                                        }
                                        var42_98 = var37_83.getHandler();
                                        var43_103 = AutomatonFunctionCallEvaluator.getBindingReplacementMap((AutomatonInstruction.Match)var37_83, var33_53, var8_8, var5_5, var4_4, var3_3);
                                        var44_105 = var42_98.assignNewNames((Map)var43_103);
                                        var28_44.add(var4_4.insertBodyWithoutClone((Instruction)var44_105, var3_3));
                                        var32_52.add(new Integer(var40_90));
                                        var35_68 = true;
                                        break;
                                    }
                                    if (!var35_68) {
                                        if (!var28_44.isEmpty()) {
                                            var27_39.add(new Object[]{var28_44, new Integer(var34_61)});
                                            var28_44 = new LinkedList<E>();
                                        }
                                        var29_48.add(var31_51);
                                        var32_52.addAll(var24_26);
                                    }
                                } else {
                                    var34_62 = var25_27 /* !! */ .iterator();
                                    var29_48.add(var31_51);
                                    while (var34_62.hasNext()) {
                                        var35_69 = (Integer)var34_62.next();
                                        var36_77 = false;
                                        for (var37_84 = 0; var37_84 < var11_11.m_matches.length; ++var37_84) {
                                            var38_86 = (Instruction[])var11_11.m_matches[var37_84];
                                            if (var38_86.getCurrentState() != var35_69 || var38_86.getConstructor() != var33_53.getConstructor()) continue;
                                            var39_87 = var38_86.getNextState();
                                            if (!(var39_87 instanceof LiteralInstruction) || !((var40_91 = ((LiteralInstruction)var39_87).getValue()) instanceof Integer)) break;
                                            var35_69 = (Integer)var40_91;
                                            var36_77 = true;
                                            break;
                                        }
                                        if (!var36_77) continue;
                                        var32_52.add(new Integer(var35_69));
                                    }
                                    if (var32_52.size() == 1 && !var29_48.isEmpty()) {
                                        var27_39.add(new Object[]{var29_48, null});
                                        var29_48 = new LinkedList<E>();
                                    }
                                }
                            } else if (var18_19 instanceof LiteralInstruction) {
                                var33_54 = (LiteralInstruction)var18_19;
                                if (var25_27 /* !! */ .size() == 1) {
                                    var34_61 = (Integer)var25_27 /* !! */ .iterator().next();
                                    var35_70 = false;
                                    for (var36_78 = 0; var36_78 < var11_11.m_matches.length; ++var36_78) {
                                        if (var11_11.m_matches[var36_78] instanceof AutomatonInstruction.LiteralMatch) {
                                            var37_83 = (AutomatonInstruction.LiteralMatch)var11_11.m_matches[var36_78];
                                            if (var37_83.getCurrentState() != var34_61 || !var37_83.getLiteral().equals(var33_54)) continue;
                                            var38_86 = var37_83.getNextState();
                                            if (!(var38_86 instanceof LiteralInstruction) || !((var39_87 = ((LiteralInstruction)var38_86).getValue()) instanceof Integer)) break;
                                            var40_90 = (Integer)var39_87;
                                            var41_96 = var37_83.getHandler();
                                            var42_99 = AutomatonFunctionCallEvaluator.getBindingReplacementMap((AutomatonInstruction.Match)var37_83, null, var8_8, var5_5, var4_4, var3_3);
                                            var43_103 = var41_96.assignNewNames(var42_99);
                                            var28_44.add(var4_4.insertBodyWithoutClone((Instruction)var43_103, var3_3));
                                            var32_52.add(new Integer(var40_90));
                                            var35_70 = true;
                                            break;
                                        }
                                        if (!(var11_11.m_matches[var36_78] instanceof AutomatonInstruction.LiteralWildcardMatch) || (var37_83 = (AutomatonInstruction.LiteralWildcardMatch)var11_11.m_matches[var36_78]).getCurrentState() != var34_61) continue;
                                        var38_86 = var37_83.getNextState();
                                        if (!(var38_86 instanceof LiteralInstruction) || !((var39_87 = ((LiteralInstruction)var38_86).getValue()) instanceof Integer)) break;
                                        var40_90 = (Integer)var39_87;
                                        var41_96 = var37_83.getHandler();
                                        if (var41_96 instanceof StreamInstruction && var41_96.getChildInstructionCount() == 1 && var41_96.getChildInstruction(0) instanceof IdentifierInstruction && ((IdentifierInstruction)var41_96.getChildInstruction(0)).getBinding(var2_2.getCurrentBindingEnvironment()) == var37_83.getBinding()) {
                                            var28_44.add(var33_54);
                                        } else {
                                            var42_100 = var37_83.getHandler();
                                            var43_103 = PartialInformationCollector.setupDeconstructionBindingReplacement(new Instruction[]{var33_54}, new Binding[]{var37_83.getBinding()}, var42_100, var4_4, var3_3);
                                            for (var44_106 = 0; var44_106 < var8_8.m_parameters.length; ++var44_106) {
                                                var43_103.put(var8_8.m_parameters[var44_106].getName(), var5_5.m_parameters[var44_106]);
                                            }
                                            var44_105 = var42_100.assignNewNames((Map)var43_103);
                                            var45_109 /* !! */  = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), (Instruction)var44_105, null);
                                            var44_105.typeCheckReduced(var6_6, var7_7, new LinkedList<E>());
                                            var2_2.partiallyEvaluateBody((Instruction)var44_105, (Instruction)var45_109 /* !! */ , 1, var4_4);
                                            var46_111 = var28_44.size();
                                            if (!this.accumulateNonNewStreamContent((Instruction)var44_105, var7_7, var28_44)) {
                                                while (var28_44.size() > var46_111) {
                                                    var28_44.remove(var46_111);
                                                }
                                                var28_44.add(var4_4.insertBodyWithoutClone((Instruction)var44_105, var3_3));
                                            }
                                        }
                                        var32_52.add(new Integer(var40_90));
                                        var35_70 = true;
                                        break;
                                    }
                                    if (!var35_70) {
                                        if (!var28_44.isEmpty()) {
                                            var27_39.add(new Object[]{var28_44, new Integer(var34_61)});
                                            var28_44 = new LinkedList<E>();
                                        }
                                        var29_48.add(var31_51);
                                        var32_52.addAll(var24_26);
                                    }
                                } else {
                                    var34_63 = var25_27 /* !! */ .iterator();
                                    var29_48.add(var31_51);
                                    while (var34_63.hasNext()) {
                                        var35_71 = (Integer)var34_63.next();
                                        var36_79 = false;
                                        for (var37_85 = 0; var37_85 < var11_11.m_matches.length; ++var37_85) {
                                            if (var11_11.m_matches[var37_85] instanceof AutomatonInstruction.LiteralMatch) {
                                                var38_86 = (AutomatonInstruction.LiteralMatch)var11_11.m_matches[var37_85];
                                                if (var38_86.getCurrentState() != var35_71 || !var38_86.getLiteral().equals(var33_54)) continue;
                                                var39_87 = var38_86.getNextState();
                                                if (!(var39_87 instanceof LiteralInstruction) || !((var40_92 = ((LiteralInstruction)var39_87).getValue()) instanceof Integer)) break;
                                                var35_71 = (Integer)var40_92;
                                                var36_79 = true;
                                                break;
                                            }
                                            if (!(var11_11.m_matches[var37_85] instanceof AutomatonInstruction.LiteralWildcardMatch) || (var38_86 = (AutomatonInstruction.LiteralWildcardMatch)var11_11.m_matches[var37_85]).getCurrentState() != var35_71) continue;
                                            var39_87 = var38_86.getNextState();
                                            if (!(var39_87 instanceof LiteralInstruction) || !((var40_92 = ((LiteralInstruction)var39_87).getValue()) instanceof Integer)) break;
                                            var35_71 = (Integer)var40_92;
                                            var36_79 = true;
                                            break;
                                        }
                                        if (!var36_79) continue;
                                        var32_52.add(new Integer(var35_71));
                                    }
                                    if (var32_52.size() == 1 && !var29_48.isEmpty()) {
                                        var27_39.add(new Object[]{var29_48, null});
                                        var29_48 = new LinkedList<E>();
                                    }
                                }
                            } else {
                                if (!var28_44.isEmpty()) {
                                    var33_55 = (Integer)var25_27 /* !! */ .iterator().next();
                                    var27_39.add(new Object[]{var28_44, new Integer(var33_55)});
                                    var28_44 = new LinkedList<E>();
                                }
                                if (!var29_48.isEmpty()) {
                                    var27_39.add(new Object[]{var29_48, null});
                                    var29_48 = new LinkedList<E>();
                                }
                                if (var18_19 instanceof FunctionCallInstruction) {
                                    var33_56 = (FunctionCallInstruction)var18_19;
                                    var34_64 = var4_4.getCurrentFunction().getTypeEnvironment().getModule().getFunction(var33_56.getFunction());
                                    var19_20 = AutomatonFunctionCallEvaluator.getIdentityOptimizedInstruction(var33_56, var10_10, AutomatonFunctionCallEvaluator.getIntegerFromCurrentStates((Set)var25_27 /* !! */ ), var11_11);
                                    if (null != var19_20) {
                                        var27_39.add(new Object[]{var19_20, null});
                                    } else {
                                        var35_72 = AutomatonFunctionCallEvaluator.getAugmentedGenericFunction(var34_64, var10_10, var12_12, AutomatonFunctionCallEvaluator.getIntegerFromCurrentStates((Set)var25_27 /* !! */ ), false, var2_2);
                                        var36_80 = AutomatonFunctionCallEvaluator.getParametersForAugmentedGenericFunction(var5_5, var12_12, var11_11, var13_14, var33_56, var35_72);
                                        var37_83 = new FunctionCallInstruction(var35_72.getName(), var36_80);
                                        var27_39.add(new Object[]{var37_83, new Boolean(((GenericDerivative)var35_72.getDerivationKey()).isInitialStateSpecialized() == false)});
                                    }
                                } else {
                                    var29_48.add(var31_51);
                                    var27_39.add(new Object[]{var29_48, null});
                                    var29_48 = new LinkedList<E>();
                                }
                                var32_52.addAll(var24_26);
                            }
                            var25_27 /* !! */  = var32_52;
                        }
                        if (!var29_48.isEmpty()) {
                            var27_39.add(new Object[]{var29_48, null});
                            var29_48 = new LinkedList<E>();
                        }
                        if (!var28_44.isEmpty()) {
                            var27_39.add(new Object[]{var28_44, var25_27 /* !! */ .iterator().next()});
                            var28_44 = new LinkedList<E>();
                        }
                        var31_51 = var11_11.getResultElementType(var2_2.getCurrentTypeEnvironment());
                        if (var27_39.size() != 1) break block94;
                        var32_52 = (Object[])var27_39.getFirst();
                        if (var32_52[1] != null) ** GOTO lbl406
                        if (!(var32_52[0] instanceof FunctionCallInstruction)) break block95;
                        var33_57 = (FunctionCallInstruction)var32_52[0];
                        var33_57.m_parameters[var10_10.m_parameters.length - 2] = var22_23 /* !! */ ;
                        var34_65 /* !! */  = var9_9 == var10_10 || var11_11.getWrapResult() != false ? var33_57 : new MatchInstruction((Instruction)var33_57, new MatchInstruction.Match[]{AutomatonFunctionCallEvaluator.makeExtractMatch(var17_18, 0)}, null);
                        var21_22 = var34_65 /* !! */ ;
                        break block90;
                    }
                    var33_58 = (LinkedList)var32_52[0];
                    if (var33_58.size() != 1) ** GOTO lbl405
                    var34_66 = var4_4.lookupBinding((Instruction)var33_58.getFirst());
                    if (var34_66 instanceof ConstructorInstantiationInstruction) {
                        var35_73 = (ConstructorInstantiationInstruction)var34_66;
                        var36_81 = var9_9 == var10_10 || var11_11.getWrapResult() != false;
                        var37_83 = new LinkedList<E>();
                        var38_86 = new ArrayList<E>();
                        for (var39_88 = 0; var39_88 < var11_11.m_matches.length; ++var39_88) {
                            var40_93 = (AutomatonInstruction.DeconstructionMatch)var11_11.m_matches[var39_88];
                            if (!var40_93.getConstructorName().equals(var35_73.getConstructorName()) || !(var40_93.getNextState() instanceof LiteralInstruction)) continue;
                            var41_96 = var40_93.getHandler();
                            var42_101 = PartialInformationCollector.setupDeconstructionBindingReplacement(var40_93.getUsedParameters(var35_73.m_parameters), var40_93.getBindings(), (Instruction)var41_96, var4_4, var3_3);
                            for (var43_104 = 0; var43_104 < var8_8.m_parameters.length; ++var43_104) {
                                var42_101.put(var8_8.m_parameters[var43_104].getName(), var5_5.m_parameters[var43_104]);
                            }
                            var43_103 = var41_96.assignNewNames(var42_101);
                            var44_105 = OptimizerUtilities.generateIntermediateIdentifier();
                            var45_109 /* !! */  = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(var40_93.getCurrentState()), (Instruction)(var36_81 != false ? AutomatonFunctionCallEvaluator.moveToBottom(var4_4.insertBodyWithoutClone((Instruction)var43_103, var3_3), var44_105, new ConstructorInstantiationInstruction(var17_18.m_constructors[0].getName(), new Instruction[]{new IdentifierInstruction(var44_105), var40_93.getNextState()})) : var43_103));
                            var37_83.add(var45_109 /* !! */ );
                            var38_86.add(var40_93);
                        }
                        if (var37_83.isEmpty()) {
                            return PartialEvaluationResult.s_emptyResult;
                        }
                        var39_89 = new MatchInstruction.LiteralMatch[var37_83.size()];
                        var37_83.toArray(var39_89);
                        var40_94 = new AutomatonInstruction.DeconstructionMatch[var38_86.size()];
                        var38_86.toArray(var40_94);
                        var41_96 = this.getCombinedMatch(var39_89, var40_94, var35_73, var4_4, var3_3, var2_2, var22_23 /* !! */ );
                        if (null == var41_96) {
                            return PartialEvaluationResult.s_emptyResult;
                        }
                        var21_22 = var41_96;
                    } else {
                        return PartialEvaluationResult.s_emptyResult;
lbl405:
                        // 1 sources

                        return PartialEvaluationResult.s_emptyResult;
lbl406:
                        // 1 sources

                        var33_59 = new Instruction[((LinkedList)var32_52[0]).size()];
                        ((LinkedList)var32_52[0]).toArray(var33_59);
                        var34_67 /* !! */  = var9_9 == var10_10 || var11_11.getWrapResult() != false ? new ConstructorInstantiationInstruction(var17_18.m_constructors[0].getName(), new Instruction[]{var4_4.insertBody(new StreamInstruction((Type)var31_51, var33_59), var3_3), new LiteralInstruction(IntType.s_intType, var32_52[1])}) : new StreamInstruction((Type)var31_51, var33_59);
                        var21_22 = var34_67 /* !! */ ;
                    }
                    break block90;
                }
                var32_52 = new Instruction[var27_39.size()];
                var33_60 = var27_39.iterator();
                var34_61 = 0;
                while (var33_60.hasNext()) {
                    var35_74 = (Object[])var33_60.next();
                    if (var35_74[0] instanceof LinkedList) {
                        var36_82 = (LinkedList)var35_74[0];
                        if (var35_74[1] == null) {
                            if (var36_82.size() == 1 && (var37_83 = var4_4.lookupBinding((Instruction)var36_82.get(0))) instanceof ConstructorInstantiationInstruction && var11_11.getDefaultHandler() == null) {
                                var38_86 = new ArrayList<E>();
                                var39_87 = new ArrayList<E>();
                                var40_95 = new ArrayList<E>();
                                var41_96 = (ConstructorInstantiationInstruction)var37_83.cloneReduced();
                                var42_102 = var4_4.insertBody2(var22_23 /* !! */ , var3_3);
                                var43_103 = null;
                                var44_108 = true;
                                for (var45_110 = 0; var45_110 < var11_11.m_matches.length; ++var45_110) {
                                    var46_112 = (AutomatonInstruction.DeconstructionMatch[])var11_11.m_matches[var45_110];
                                    if (!var46_112.getConstructorName().equals(var41_96.getConstructorName())) continue;
                                    var47_113 = var46_112.getNextState();
                                    var48_115 = var46_112.getHandler();
                                    var49_116 = AutomatonFunctionCallEvaluator.getBindingReplacementMap((AutomatonInstruction.Match)var46_112, (ConstructorInstantiationInstruction)var41_96, var8_8, var5_5, var4_4, var3_3);
                                    var50_117 = var48_115.assignNewNames((Map)var49_116);
                                    var38_86.add(new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(var46_112.getCurrentState()), var50_117));
                                    var39_87.add(new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(var46_112.getCurrentState()), var47_113));
                                    var40_95.add(var46_112);
                                    if (var44_108) {
                                        if (var47_113 instanceof LiteralInstruction) {
                                            var43_103 = ((LiteralInstruction)var47_113).getValue();
                                        }
                                        var44_108 = false;
                                        continue;
                                    }
                                    if (var43_103 == null) continue;
                                    if (var47_113 instanceof LiteralInstruction) {
                                        if (var43_103.equals(((LiteralInstruction)var47_113).getValue())) continue;
                                        AutomatonFunctionCallEvaluator.s_logger.warn(">> gave up nextState(" + var43_103 + ") nextStateInstruction(" + var47_113 + ")\n");
                                        var43_103 = null;
                                        continue;
                                    }
                                    var43_103 = null;
                                    AutomatonFunctionCallEvaluator.s_logger.warn(">> gave up because not a literal");
                                }
                                var45_109 /* !! */  = new MatchInstruction.LiteralMatch[var38_86.size()];
                                var38_86.toArray(var45_109 /* !! */ );
                                var46_112 = new AutomatonInstruction.DeconstructionMatch[var40_95.size()];
                                var40_95.toArray(var46_112);
                                var47_113 = this.getCombinedMatch((MatchInstruction.LiteralMatch[])var45_109 /* !! */ , var46_112, (ConstructorInstantiationInstruction)var41_96, var4_4, var3_3, var2_2, var42_102);
                                if (null == var47_113) {
                                    return PartialEvaluationResult.s_emptyResult;
                                }
                                var48_114 = true;
                                var49_116 = null;
                                var50_117 = null;
                                var51_118 = null;
                                for (var52_120 = 0; var52_120 < var39_87.size(); ++var52_120) {
                                    var49_116 = (MatchInstruction.LiteralMatch)var39_87.get(var52_120);
                                    if (!(var49_116.getHandler() instanceof LiteralInstruction)) {
                                        var48_114 = false;
                                        break;
                                    }
                                    var50_117 = (LiteralInstruction)var49_116.getHandler();
                                    var51_118 = var49_116.getLiteral();
                                    if (var50_117.getType() == var51_118.getType() && var50_117.getValue().equals(var51_118.getValue())) continue;
                                    var48_114 = false;
                                    break;
                                }
                                var52_119 = null;
                                if (var48_114) {
                                    var52_119 = var42_102;
                                } else {
                                    var53_121 = new MatchInstruction.LiteralMatch[var39_87.size()];
                                    var39_87.toArray(var53_121);
                                    var52_119 = this.getCombinedMatch(var53_121, var46_112, (ConstructorInstantiationInstruction)var41_96, var4_4, var3_3, var2_2, var42_102);
                                }
                                if (null == var52_119) {
                                    return PartialEvaluationResult.s_emptyResult;
                                }
                                var32_52[var34_61++] = var4_4.insertBody2(var47_113, var3_3);
                                var22_23 /* !! */  = var4_4.insertBody2(var43_103 != null ? LiteralInstruction.integerLiteral((Integer)var43_103) : var52_119, var3_3);
                                continue;
                            }
                            var38_86 = new Instruction[var36_82.size()];
                            var36_82.toArray((T[])var38_86);
                            var39_87 = (StreamInstruction)var20_21.cloneReduced();
                            var39_87.setElements((Instruction[])var38_86);
                            var40_95 = AutomatonFunctionCallEvaluator.makeCallToAugmentedAutomatonFromWithinLoop(var2_2, var4_4.insertBodyWithoutClone(var39_87.cloneReduced(), var3_3), var5_5, var10_10, var12_12, var13_14, var22_23 /* !! */ );
                            var41_96 = var4_4.insertBody((Instruction)var40_95, var3_3);
                            var42_102 = new MatchInstruction((Instruction)var41_96, new MatchInstruction.Match[]{AutomatonFunctionCallEvaluator.makeExtractMatch(var17_18, 0)}, null);
                            var32_52[var34_61++] = var4_4.insertBody2(var42_102, var3_3);
                            var22_23 /* !! */  = var4_4.insertBody(new MatchInstruction((Instruction)var41_96, new MatchInstruction.Match[]{AutomatonFunctionCallEvaluator.makeExtractMatch(var17_18, 1)}, null), var3_3);
                            continue;
                        }
                        var37_83 = new Instruction[var36_82.size()];
                        var36_82.toArray((T[])var37_83);
                        var38_86 = new StreamInstruction((Type)var31_51, (Instruction[])var37_83);
                        var32_52[var34_61++] = var4_4.insertBody((Instruction)var38_86, var3_3);
                        var22_23 /* !! */  = LiteralInstruction.integerLiteral((Integer)var35_74[1]);
                        continue;
                    }
                    if (var35_74[0] instanceof FunctionCallInstruction) {
                        var36_82 = (FunctionCallInstruction)var35_74[0];
                        if (((Boolean)var35_74[1]).booleanValue()) {
                            var36_82.m_parameters[var10_10.m_parameters.length - 2] = var22_23 /* !! */ ;
                        }
                        var37_83 = var4_4.insertBody((Instruction)var36_82, var3_3);
                        var38_86 = new MatchInstruction((Instruction)var37_83, new MatchInstruction.Match[]{AutomatonFunctionCallEvaluator.makeExtractMatch(var17_18, 0)}, null);
                        var32_52[var34_61++] = var4_4.insertBody((Instruction)var38_86, var3_3);
                        var22_23 /* !! */  = var4_4.insertBody(new MatchInstruction((Instruction)var37_83, new MatchInstruction.Match[]{AutomatonFunctionCallEvaluator.makeExtractMatch(var17_18, 1)}, null), var3_3);
                        continue;
                    }
                    var36_82 = (ConstructorInstantiationInstruction)var35_74[0];
                    var37_83 = var4_4.insertBody((Instruction)var36_82, var3_3);
                    var32_52[var34_61++] = var4_4.insertBody2(var36_82.getChildInstruction(0), var3_3);
                    var22_23 /* !! */  = var4_4.insertBody2(var36_82.getChildInstruction(1), var3_3);
                }
                var35_75 /* !! */  = var9_9 == var10_10 || var11_11.getWrapResult() != false ? new ConstructorInstantiationInstruction(var17_18.m_constructors[0].getName(), new Instruction[]{var4_4.insertBody(new StreamInstruction((Type)var31_51, (Instruction[])var32_52), var3_3), var22_23 /* !! */ }) : new StreamInstruction((Type)var31_51, (Instruction[])var32_52);
                var21_22 = var35_75 /* !! */ ;
            }
            if (var21_22 != null) {
                return new PartialEvaluationResult((Instruction)var21_22, true);
            }
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    protected boolean accumulateNonNewStreamContentInner(Instruction instruction, BindingEnvironment bindingEnvironment, LinkedList linkedList, HashSet hashSet) {
        if ((instruction = NavigationUtilities.resolveReducedIdentifier(instruction, bindingEnvironment)) instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            int n = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n; ++i) {
                Instruction instruction2 = NavigationUtilities.resolveIdentifierAliases(streamInstruction.getChildInstruction(i), bindingEnvironment);
                if (instruction2 instanceof IdentifierInstruction) {
                    IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
                    if (hashSet.contains(identifierInstruction.getVariable())) {
                        if (this.accumulateNonNewStreamContentInner(identifierInstruction, bindingEnvironment, linkedList, hashSet)) continue;
                        return false;
                    }
                } else if (!(instruction2 instanceof LiteralInstruction)) {
                    return false;
                }
                linkedList.add(instruction2);
            }
            return true;
        }
        return false;
    }

    protected boolean accumulateNonNewStreamContent(Instruction instruction, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        while (instruction instanceof LetInstruction) {
            object = (LetInstruction)instruction;
            hashSet.add(((LetBaseInstruction)object).getVariable());
            instruction = ((LetBaseInstruction)object).getBody();
        }
        if (this.accumulateNonNewStreamContentInner(instruction, bindingEnvironment, linkedList, hashSet)) {
            object = hashSet.iterator();
            while (object.hasNext()) {
                bindingEnvironment.unregisterBinding(object.next());
            }
            return true;
        }
        return false;
    }

    static final class AugmentedDerivative {
        static AugmentedDerivative s_augmentedDerivative = new AugmentedDerivative();
        static AugmentedDerivative s_extraArgDerivative = new AugmentedDerivative();

        private AugmentedDerivative() {
        }
    }

    static final class GenericDerivative {
        String m_automatonFunctionName;
        Integer m_automatonInitialState;
        boolean m_runOnStreamPart;

        GenericDerivative(String string, Integer n, boolean bl) {
            this.m_automatonFunctionName = string;
            this.m_automatonInitialState = n;
            this.m_runOnStreamPart = bl;
        }

        GenericDerivative(String string, Integer n) {
            this.m_automatonFunctionName = string;
            this.m_automatonInitialState = n;
            this.m_runOnStreamPart = false;
        }

        public boolean isInitialStateSpecialized() {
            return null != this.m_automatonInitialState;
        }

        public boolean isRunOnStreamPart() {
            return this.m_runOnStreamPart;
        }

        public String toString() {
            return "(" + this.m_automatonFunctionName.toString() + ", " + this.m_automatonInitialState + (this.m_runOnStreamPart ? "runOnStreamPart" : "runOnWholeFunction") + ")";
        }

        public int hashCode() {
            return this.m_automatonFunctionName.hashCode() + (null == this.m_automatonInitialState ? 0 : this.m_automatonInitialState.hashCode()) + (this.m_runOnStreamPart ? 1000 : 0);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof GenericDerivative)) {
                return false;
            }
            GenericDerivative genericDerivative = (GenericDerivative)object;
            String string = genericDerivative.m_automatonFunctionName;
            Integer n = genericDerivative.m_automatonInitialState;
            boolean bl = genericDerivative.m_runOnStreamPart;
            if (!string.equals(this.m_automatonFunctionName)) {
                return false;
            }
            if (bl != this.m_runOnStreamPart) {
                return false;
            }
            if (null == n && null != this.m_automatonInitialState || null != n && null == this.m_automatonInitialState) {
                return false;
            }
            if (null == n && null == this.m_automatonInitialState) {
                return true;
            }
            return n.intValue() == this.m_automatonInitialState.intValue();
        }
    }

    private static class MIandAI {
        AutomatonInstruction.DeconstructionMatch m_dm;
        MatchInstruction.LiteralMatch m_m;
        boolean m_isSureMatch;

        public MIandAI(MatchInstruction.LiteralMatch literalMatch, AutomatonInstruction.DeconstructionMatch deconstructionMatch, boolean bl) {
            this.m_m = literalMatch;
            this.m_dm = deconstructionMatch;
            this.m_isSureMatch = bl;
        }
    }

    static final class StreamOnlyDerivative {
        static StreamOnlyDerivative s_streamOnlyDerivative = new StreamOnlyDerivative();

        StreamOnlyDerivative() {
        }
    }

    static final class StreamOnlyHelper {
        StreamOnlyHelper() {
        }

        public static final Instruction getStreamOnly(Instruction instruction, LetChainManager letChainManager, PartialInformationCollector partialInformationCollector) {
            Instruction instruction2;
            if (instruction instanceof LetInstruction) {
                LetInstruction letInstruction = (LetInstruction)instruction;
                return new LetInstruction(letInstruction.getVariable(), letInstruction.getValue().cloneWithNewNames(), StreamOnlyHelper.getStreamOnly(letInstruction.getBody(), letChainManager, partialInformationCollector));
            }
            if (instruction instanceof FunctionCallInstruction) {
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                Function function = letChainManager.getCurrentFunction().getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
                if (function.getDerivationKey() == AugmentedDerivative.s_augmentedDerivative) {
                    Function function2 = function.getOriginalFunction();
                    Instruction instruction3 = functionCallInstruction.getChildInstruction(functionCallInstruction.getChildInstructionCount() - 1);
                    instruction3 = letChainManager.lookupBinding(instruction3);
                    Integer n = LiteralInstruction.getInteger(instruction3);
                    Integer n2 = LiteralInstruction.getInteger(((AutomatonInstruction)function2.getBody()).getInitialState());
                    if (null == n || null == n2 || n.intValue() != n2.intValue()) {
                        PartialEvaluator.s_logger.error("ERROR ERROR ERROR oldInitialState=" + instruction3 + " olderInitialState=" + ((AutomatonInstruction)function2.getBody()).getInitialState());
                    }
                    Instruction[] instructionArray = functionCallInstruction.getParameters();
                    Instruction[] instructionArray2 = new Instruction[instructionArray.length - 1];
                    for (int i = 0; i < instructionArray.length - 1; ++i) {
                        instructionArray2[i] = instructionArray[i];
                    }
                    return new FunctionCallInstruction(function2.getName(), instructionArray2);
                }
                if (function.getBody() instanceof AutomatonInstruction) {
                    if (((AutomatonInstruction)function.getBody()).getWrapResult()) {
                        Function function3 = AutomatonFunctionCallEvaluator.getStreamOnlyFunction(function, letChainManager, partialInformationCollector);
                        Instruction[] instructionArray = functionCallInstruction.getParameters();
                        Instruction[] instructionArray3 = new Instruction[instructionArray.length];
                        for (int i = 0; i < instructionArray.length; ++i) {
                            instructionArray3[i] = instructionArray[i];
                        }
                        return new FunctionCallInstruction(function3.getName(), instructionArray3);
                    }
                    return instruction.cloneWithNewNames();
                }
                return instruction.cloneWithNewNames();
            }
            if (instruction instanceof ConstructorInstantiationInstruction) {
                instruction2 = (ConstructorInstantiationInstruction)instruction;
                if (!(partialInformationCollector.resolveType(instruction2) instanceof NamedType)) {
                    throw new XylemError("ERR_SYSTEM", "type is " + partialInformationCollector.resolveType(instruction2));
                }
                ConstructorDataType constructorDataType = (ConstructorDataType)((NamedType)partialInformationCollector.resolveType(instruction2)).resolveNameToADT(partialInformationCollector.getCurrentTypeEnvironment());
                if (1 == constructorDataType.m_constructors.length && 2 == constructorDataType.m_constructors[0].m_parameters.length) {
                    return ((ConstructorInstantiationInstruction)instruction2).m_parameters[0];
                }
            }
            if (instruction instanceof AutomatonInstruction) {
                instruction2 = (AutomatonInstruction)instruction;
                PartialEvaluator.s_logger.warn("AFCE sees a Automaton Instruction, isWrap=" + ((AutomatonInstruction)instruction2).getWrapResult());
            }
            if (instruction instanceof IdentifierInstruction) {
                return instruction;
            }
            throw new XylemError("ERR_SYSTEM", "StreamOnlyHelper found: " + instruction.getClass());
        }
    }
}

