/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.NumericalComparisonInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.optimizers.partialeval.PrimitiveArithmeticEvaluator;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.utils.XylemError;

public class NumericalComparisonEvaluator
extends PrimitiveArithmeticEvaluator {
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        NumericalComparisonInstruction numericalComparisonInstruction = (NumericalComparisonInstruction)instruction;
        partialInformationCollector.partiallyEvaluate(numericalComparisonInstruction.getOperand1(), letChainManager);
        partialInformationCollector.partiallyEvaluate(numericalComparisonInstruction.getOperand2(), letChainManager);
        Object object = PartialEvaluator.extractLiteralValue(partialInformationCollector, numericalComparisonInstruction.getOperand1(), letChainManager);
        Object object2 = PartialEvaluator.extractLiteralValue(partialInformationCollector, numericalComparisonInstruction.getOperand2(), letChainManager);
        Type type = partialInformationCollector.resolveType(numericalComparisonInstruction.getOperand1());
        if (object == null || object2 == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (!(type instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Only numerical types are supported by the numerical operators");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type);
        return new PartialEvaluationResult(new LiteralInstruction(type, iNumericalType.evaluateOperation(object, object2, numericalComparisonInstruction.getOperation())));
    }
}

