/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IdentifierConsolidator;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.optimizers.partialeval.ADTMatchEvaluator;
import com.ibm.xylem.optimizers.partialeval.EvaluatorDiscoveringPartialInformationCollector;
import com.ibm.xylem.optimizers.partialeval.FLD2ForEachEvaluator;
import com.ibm.xylem.optimizers.partialeval.ForEachEvaluator;
import com.ibm.xylem.optimizers.partialeval.FunctionCallEvaluator;
import com.ibm.xylem.optimizers.partialeval.MatchEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartialEvaluationOptimizer
extends Optimizer {
    protected HashMap m_evaluators = new HashMap(499);
    protected HashSet m_functions = new HashSet();
    protected HashSet m_functionsIfStaticArg = new HashSet();
    public HashSet m_entryPoints = new HashSet();
    public IdentifierConsolidator m_ic;

    public PartialEvaluationOptimizer(Set set) {
        this.m_entryPoints.addAll(set);
        this.baseSetup();
    }

    public PartialEvaluationOptimizer() {
        this.m_entryPoints.add("main");
        this.baseSetup();
    }

    protected void baseSetup() {
        this.addEvaluator(ForEachInstruction.class, new ForEachEvaluator());
        this.addEvaluator(ForEachInstruction.class, new FLD2ForEachEvaluator());
        this.addEvaluator(MatchInstruction.class, new ADTMatchEvaluator());
        this.addEvaluator(MatchInstruction.class, new MatchEvaluator());
        this.setupFunctionCallEvaluators();
    }

    public PartialInformationCollector createInitialFuncInfoCollector(Instruction instruction, Map map, Function function) {
        return new EvaluatorDiscoveringPartialInformationCollector(instruction, map, function);
    }

    public Instruction optimize(Instruction instruction) {
        PartialInformationCollector partialInformationCollector = this.createInitialFuncInfoCollector(instruction, this.m_evaluators, this.m_currentFunction);
        partialInformationCollector.m_identifierConsolidator = this.m_ic;
        Instruction instruction2 = partialInformationCollector.doPartialEvaluation().getReplacement();
        if (instruction2 == null) {
            instruction2 = instruction;
        } else {
            instruction2 = instruction2.removeAliases(new HashMap());
            Function function = this.getCurrentFunction();
            instruction2.typeCheckReduced(function.getTypeEnvironment(), function.getBindingEnvironment(), new LinkedList());
        }
        return instruction2;
    }

    protected void addEvaluator(Class clazz, PartialEvaluator partialEvaluator) {
        ArrayList<PartialEvaluator> arrayList = (ArrayList<PartialEvaluator>)this.m_evaluators.get(clazz);
        if (arrayList == null) {
            arrayList = new ArrayList<PartialEvaluator>();
            this.m_evaluators.put(clazz, arrayList);
        }
        arrayList.add(partialEvaluator);
    }

    public void addEvaluator(PartialEvaluator partialEvaluator) {
        Class[] classArray = partialEvaluator.getSupportedInstructionClasses();
        for (int i = 0; i < classArray.length; ++i) {
            this.addEvaluator(classArray[i], partialEvaluator);
        }
    }

    public void optimizeFunction(Function function) {
        if (this.m_entryPoints.contains(function.getName())) {
            PartialInformationCollector partialInformationCollector = this.createInitialFuncInfoCollector(function.getBody(), this.m_evaluators, function);
            partialInformationCollector.m_identifierConsolidator = this.m_ic;
            partialInformationCollector.doPartialEvaluationFromFunction(function);
        }
    }

    protected void setupFunctionCallEvaluators() {
        this.addEvaluator(FunctionCallInstruction.class, new FunctionCallEvaluator(){

            protected boolean allowInlining(FunctionCallInstruction functionCallInstruction, Function function, BindingEnvironment bindingEnvironment) {
                LetInstruction letInstruction;
                Instruction instruction;
                if (PartialEvaluationOptimizer.this.m_functionsIfStaticArg.contains(function.getName())) {
                    return functionCallInstruction.getOperands()[0].isStatic(bindingEnvironment);
                }
                Instruction instruction2 = function.getBody();
                while (instruction2 instanceof LetInstruction && ((instruction = (letInstruction = (LetInstruction)instruction2).getValue()) instanceof LiteralInstruction || instruction instanceof IdentifierInstruction)) {
                    instruction2 = letInstruction.getBody();
                }
                if (instruction2 instanceof FunctionCallInstruction) {
                    FunctionCallInstruction functionCallInstruction2 = (FunctionCallInstruction)instruction2;
                    Function function2 = function.getTypeEnvironment().getModule().getFunction(functionCallInstruction2.getFunction());
                    if (!function.getMemoizeResult() || function2.getMemoizeResult()) {
                        return true;
                    }
                } else if (instruction2 instanceof MatchInstruction) {
                    MatchInstruction matchInstruction = (MatchInstruction)instruction2;
                    if (matchInstruction.getDefault() == null && matchInstruction.getMatches().length == 1) {
                        NotInstruction notInstruction;
                        Instruction instruction3 = matchInstruction.getMatches()[0].getHandler();
                        if (instruction3 instanceof IdentifierInstruction) {
                            return true;
                        }
                        if (instruction3 instanceof NotInstruction && (notInstruction = (NotInstruction)instruction3).getOperand() instanceof IdentifierInstruction) {
                            return true;
                        }
                    }
                } else if (instruction2 instanceof ConstructorInstantiationInstruction) {
                    return true;
                }
                if (function.getInlineHint()) {
                    return true;
                }
                if (function.getBody().isStatic(function.getBindingEnvironment())) {
                    return true;
                }
                return PartialEvaluationOptimizer.this.m_functions.contains(function.getName());
            }
        });
    }
}

