/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;

public final class DoubleType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -3363106463616654709L;
    public static final DoubleType s_doubleType = new DoubleType();
    private static short[] s_branchOpcode = new short[]{0, 0, 0, 0, 0, 158, 155, 156, 157, 154};

    private DoubleType() {
    }

    public Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return BasicType.DOUBLE;
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "double";
    }

    public JavaClassWrapper getJavaType() {
        return new JavaClassWrapper(Double.TYPE);
    }

    public Object evaluateOperation(Object object, Object object2, int n) {
        switch (n) {
            case 0: {
                return new Double((Double)object + (Double)object2);
            }
            case 1: {
                return new Double((Double)object - (Double)object2);
            }
            case 2: {
                return new Double((Double)object * (Double)object2);
            }
            case 3: {
                return new Double((Double)object / (Double)object2);
            }
            case 4: {
                return new Double((Double)object % (Double)object2);
            }
            case 5: {
                return (Double)object > (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return (Double)object >= (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return (Double)object < (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return (Double)object <= (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return ((Double)object).doubleValue() == ((Double)object2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return new Double(-((Double)object).doubleValue());
            }
        }
        throw new UnsupportedOperationException("The " + PrimitiveNumericalType.getOperator(n) + " operator is not supported on double.");
    }

    public void generateCodeForOperation(InstructionListBuilder instructionListBuilder, int n) {
        if (n == 16) {
            instructionListBuilder.append(InstructionConstants.DNEG);
        } else if (n < 5 || n > 9) {
            super.generateCodeForOperation(instructionListBuilder, n);
        } else {
            short s = s_branchOpcode[n];
            switch (s) {
                case 156: 
                case 157: {
                    instructionListBuilder.appendDCmpg();
                    break;
                }
                default: {
                    instructionListBuilder.appendDCmpl();
                }
            }
            SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
            switchBuilder.startTest(s);
            instructionListBuilder.appendConstant(true);
            switchBuilder.endTest();
            switchBuilder.startElse();
            instructionListBuilder.appendConstant(false);
            switchBuilder.endElse();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return s_doubleType;
    }

    public String getDefaultValue() {
        return "0.0";
    }
}

