/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xylem.IObjectFilePersistence;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class JavaClassInformation {
    protected boolean m_isInterface = false;
    protected HashSet m_baseClassNames = new HashSet();
    protected HashMap m_methods = new HashMap();
    protected HashMap m_fields = new HashMap();
    protected HashMap m_staticMethods = new HashMap();
    protected ArrayList m_constructors = new ArrayList();

    public void setInterface(boolean bl) {
        this.m_isInterface = bl;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public Collection getMethods(String string) {
        return (Collection)this.m_methods.get(string);
    }

    public Collection getStaticMethods(String string) {
        return (Collection)this.m_staticMethods.get(string);
    }

    public Field getField(String string) {
        return (Field)this.m_fields.get(string);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        Method method;
        int n;
        int n2;
        this.m_isInterface = readObjectFileHelper.readBoolean();
        int n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_baseClassNames.add(readObjectFileHelper.readString());
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            Method method2 = new Method();
            method2.read(readObjectFileHelper);
            this.addConstructor(method2);
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = readObjectFileHelper.readInt();
            for (n = 0; n < n4; ++n) {
                method = new Method();
                method.read(readObjectFileHelper);
                this.addMethod(method);
            }
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = readObjectFileHelper.readInt();
            for (n = 0; n < n5; ++n) {
                method = new Method();
                method.read(readObjectFileHelper);
                this.addStaticMethod(method);
            }
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            Field field = new Field();
            field.read(readObjectFileHelper);
            this.addField(field);
        }
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        Method method;
        Iterator iterator;
        writeObjectFileHelper.writeBoolean(this.m_isInterface);
        writeObjectFileHelper.writeInt(this.m_baseClassNames.size());
        Iterator<Object> iterator2 = this.m_baseClassNames.iterator();
        while (iterator2.hasNext()) {
            writeObjectFileHelper.writeString((String)iterator2.next());
        }
        writeObjectFileHelper.writeInt(this.m_constructors.size());
        for (Object object : this.m_constructors) {
            ((Method)object).write(writeObjectFileHelper);
        }
        writeObjectFileHelper.writeInt(this.m_methods.size());
        for (Object object : this.m_methods.values()) {
            writeObjectFileHelper.writeInt(((ArrayList)object).size());
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                method = (Method)iterator.next();
                method.write(writeObjectFileHelper);
            }
        }
        writeObjectFileHelper.writeInt(this.m_staticMethods.size());
        for (Object object : this.m_staticMethods.values()) {
            writeObjectFileHelper.writeInt(((ArrayList)object).size());
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                method = (Method)iterator.next();
                method.write(writeObjectFileHelper);
            }
        }
        writeObjectFileHelper.writeInt(this.m_fields.size());
        for (Object object : this.m_fields.values()) {
            ((Field)object).write(writeObjectFileHelper);
        }
    }

    public void addMethod(Method method) {
        ArrayList<Method> arrayList = (ArrayList<Method>)this.m_methods.get(method.getName());
        if (arrayList == null) {
            arrayList = new ArrayList<Method>();
            this.m_methods.put(method.getName(), arrayList);
        }
        arrayList.add(method);
    }

    public void addConstructor(Method method) {
        this.m_constructors.add(method);
    }

    public void addField(Field field) {
        this.m_fields.put(field.getName(), field);
    }

    public void addStaticMethod(Method method) {
        ArrayList<Method> arrayList = (ArrayList<Method>)this.m_staticMethods.get(method.getName());
        if (arrayList == null) {
            arrayList = new ArrayList<Method>();
            this.m_staticMethods.put(method.getName(), arrayList);
        }
        arrayList.add(method);
    }

    public void addBaseClassName(String string) {
        this.m_baseClassNames.add(string);
    }

    public Set getBaseClassNames() {
        return this.m_baseClassNames;
    }

    public static class Field
    implements IObjectFilePersistence {
        protected String m_name;
        protected Type m_returnType;
        protected Object m_constantObject;

        public Field() {
        }

        public Field(String string, Type type, Object object) {
            this.m_name = string;
            this.m_returnType = type;
            this.m_constantObject = object;
        }

        public String getName() {
            return this.m_name;
        }

        public Type getType() {
            return this.m_returnType;
        }

        public boolean isConstant() {
            return null != this.m_constantObject;
        }

        public Integer getIntegerObject() {
            if (this.m_constantObject instanceof Integer) {
                return (Integer)this.m_constantObject;
            }
            return null;
        }

        public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
            writeObjectFileHelper.writeString(this.m_name);
            writeObjectFileHelper.writeType(this.m_returnType);
            writeObjectFileHelper.writeObject(this.m_constantObject);
        }

        public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
            this.m_name = readObjectFileHelper.readString();
            this.m_returnType = readObjectFileHelper.readType();
            this.m_constantObject = readObjectFileHelper.readObject();
        }
    }

    public static class Method
    implements IObjectFilePersistence {
        protected String m_name;
        protected Type[] m_parameterTypes;
        protected Type m_returnType;

        public Method() {
        }

        public Method(String string, Type[] typeArray, Type type) {
            this.m_name = string;
            this.m_parameterTypes = typeArray;
            this.m_returnType = type;
        }

        public String getName() {
            return this.m_name;
        }

        public Type getReturnType() {
            return this.m_returnType;
        }

        public Type[] getParameterTypes() {
            return this.m_parameterTypes;
        }

        public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
            writeObjectFileHelper.writeString(this.m_name);
            writeObjectFileHelper.writeTypes(this.m_parameterTypes);
            writeObjectFileHelper.writeType(this.m_returnType);
        }

        public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
            this.m_name = readObjectFileHelper.readString();
            this.m_parameterTypes = readObjectFileHelper.readTypes();
            this.m_returnType = readObjectFileHelper.readType();
        }
    }
}

