/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.ListStream;
import com.ibm.xylem.interpreter.StringStream;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.utils.XylemError;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class StreamType
extends Type
implements ICollectionType,
Serializable {
    private static final long serialVersionUID = 7675041141206643421L;
    public static final boolean s_inlineResize = false;
    public static final boolean s_enableBCELBuffering = true;
    protected Type m_elementType;
    public static int s_reallocs = 0;

    public StreamType(Type type) {
        if (type instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't create a stream type of a stream type");
        }
        this.m_elementType = type;
    }

    public Type expandTypeAliases(Module module) {
        return this.m_elementType.expandTypeAliases(module).getStreamType();
    }

    public static StreamType makeStreamType(Type type) {
        if (type instanceof StreamType) {
            return (StreamType)type;
        }
        return type.getStreamType();
    }

    public static Type makeAtomicType(Type type) {
        if (type instanceof StreamType) {
            return ((StreamType)type).getElementType();
        }
        return type;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof StreamType && ((StreamType)object).m_elementType.equals(this.m_elementType);
    }

    public Type duplicateType(Map map) {
        Type type = (Type)map.get(this);
        if (type != null) {
            return type;
        }
        return this.m_elementType.duplicateType(map).getStreamType();
    }

    public Type replaceType(Map map) {
        Type type = (Type)map.get(this);
        if (type != null) {
            return type;
        }
        return this.m_elementType.replaceType(map).getStreamType();
    }

    public String toString() {
        return this.m_elementType.toString() + "[]";
    }

    public String getImplementationName(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        return this.m_elementType.getImplementationName(dataFlowCodeGenerationHelper) + dataFlowCodeGenerationHelper.m_arraySuffix;
    }

    public com.ibm.xtq.bcel.generic.Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return new ArrayType(this.m_elementType.getImplementationType(bCELCodeGenerationHelper), 1);
    }

    public JavaClassWrapper getJavaType() {
        JavaClassWrapper javaClassWrapper = this.getElementType().getJavaType();
        return javaClassWrapper.newArrayClass(1);
    }

    public Object createStream(Object object) {
        if (object.getClass().isArray()) {
            ListStream listStream = new ListStream();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                listStream.append(this.m_elementType.createStream(object2));
            }
            return listStream;
        }
        if (object instanceof String) {
            return new StringStream((String)object);
        }
        if ((object = this.m_elementType.createStream(object)) instanceof IStream) {
            return object;
        }
        return new ListStream(object);
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    public Type resolveType(TypeEnvironment typeEnvironment) {
        Type type = this.m_elementType.resolveType(typeEnvironment);
        if (type == null) {
            return null;
        }
        return type.getStreamType();
    }

    public void generateDataFlowLoopEnd(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, String string2, CodeGenerationTracker codeGenerationTracker) {
        dataFlowCodeGenerationHelper.append("}\n");
    }

    public String generateDataFlowLoopStart(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, Instruction instruction, String string, CodeGenerationTracker codeGenerationTracker) {
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        String string3 = codeGenerationTracker.generateConventionally(instruction, dataFlowCodeGenerationHelper);
        dataFlowCodeGenerationHelper.append("for (int " + string2 + " = 0; " + string2 + " < " + StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string3) + "; " + string2 + "++) {\n");
        dataFlowCodeGenerationHelper.appendAssignment(string, this.m_elementType, string3 + "[" + string2 + "]", codeGenerationTracker);
        return string3;
    }

    public ICollectionType.BCELLoopState generateLoopStart(BCELCodeGenerationHelper bCELCodeGenerationHelper, Instruction instruction, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder) {
        LoopState loopState = new LoopState();
        loopState.m_collectionVar = codeGenerationTracker.generateConventionallyIntoRegister(instruction, bCELCodeGenerationHelper, instructionListBuilder);
        loopState.m_indexVar = codeGenerationTracker.allocateRegister();
        instructionListBuilder.appendConstant(0);
        instructionListBuilder.appendIStore(loopState.m_indexVar);
        loopState.m_lenVar = codeGenerationTracker.allocateRegister();
        instructionListBuilder.appendALoad(loopState.m_collectionVar);
        instructionListBuilder.appendArrayLength();
        instructionListBuilder.appendIStore(loopState.m_lenVar);
        loopState.m_loopStart = instructionListBuilder.appendILoad(loopState.m_indexVar);
        instructionListBuilder.appendILoad(loopState.m_lenVar);
        loopState.m_loopBranch = instructionListBuilder.appendIficmpge();
        loopState.m_elementVar = codeGenerationTracker.allocateRegister(this.getElementType().getImplementationType(bCELCodeGenerationHelper));
        instructionListBuilder.appendALoad(loopState.m_collectionVar);
        instructionListBuilder.appendILoad(loopState.m_indexVar);
        instructionListBuilder.appendArrayLoad(this.getElementType());
        instructionListBuilder.appendStore(this.getElementType(), loopState.m_elementVar);
        return loopState;
    }

    public void generateLoopEnd(BCELCodeGenerationHelper bCELCodeGenerationHelper, ICollectionType.BCELLoopState bCELLoopState, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder) {
        LoopState loopState = (LoopState)bCELLoopState;
        instructionListBuilder.appendLocalIncrement(loopState.m_indexVar);
        instructionListBuilder.appendGoto(loopState.m_loopStart);
        loopState.m_loopBranch.setTarget(instructionListBuilder.appendNOP());
    }

    private static String generateBufferCache(StreamType streamType, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        Type type = streamType.getElementType();
        String string = streamType.getImplementationName(dataFlowCodeGenerationHelper);
        String string2 = type.getImplementationName(dataFlowCodeGenerationHelper);
        String string3 = string + "_buffer_cache";
        String string4 = (String)dataFlowCodeGenerationHelper.generationMemosGet(string3);
        if (string4 == null) {
            string4 = dataFlowCodeGenerationHelper.generateNewMemberVariableName("_buffer_cache");
            if (dataFlowCodeGenerationHelper.isTargetCPP()) {
                dataFlowCodeGenerationHelper.appendConstantStatement(string + " " + string4 + "[10];\n");
            } else {
                dataFlowCodeGenerationHelper.appendConstantStatement(string + "[] " + string4 + " = new " + string2 + "[10][];\n");
            }
            dataFlowCodeGenerationHelper.appendConstantStatement("int " + string4 + "_next = 0;\n");
            dataFlowCodeGenerationHelper.appendConstantStatement("int " + string4 + "_created = 0;\n");
            dataFlowCodeGenerationHelper.generationMemosPut(string3, string4);
        }
        return string4;
    }

    public static void generateCreateStream(String string, int n, StreamType streamType, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        Type type = streamType.getElementType();
        DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper2 = dataFlowCodeGenerationHelper;
        String string2 = streamType.getImplementationName(dataFlowCodeGenerationHelper);
        String string3 = type.getImplementationName(dataFlowCodeGenerationHelper);
        String string4 = StreamType.generateBufferCache(streamType, dataFlowCodeGenerationHelper);
        dataFlowCodeGenerationHelper2.append("// Create stream\n");
        dataFlowCodeGenerationHelper2.append(string2);
        dataFlowCodeGenerationHelper2.append(" ");
        dataFlowCodeGenerationHelper2.append(string);
        dataFlowCodeGenerationHelper2.append("_stream;\n");
        dataFlowCodeGenerationHelper2.append(string2 + " " + string + "_original = " + dataFlowCodeGenerationHelper.m_null + ";\n");
        if (!dataFlowCodeGenerationHelper.isTargetCPP()) {
            string4 = dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + string4;
        }
        if (dataFlowCodeGenerationHelper.isTargetCPP()) {
            dataFlowCodeGenerationHelper2.append("if (" + string4 + "_next < sizeof(" + string4 + ")) {\n");
        } else {
            dataFlowCodeGenerationHelper2.append("if (" + string4 + "_next < " + string4 + ".length) {\n");
        }
        dataFlowCodeGenerationHelper2.append("if (" + string4 + "_next == " + string4 + "_created) {\n");
        if (dataFlowCodeGenerationHelper.getSettings().isBufferDiagnostics()) {
            dataFlowCodeGenerationHelper2.append("System.err.println(\">> allocated new cached buffer of type " + string3 + "\");\n");
        }
        dataFlowCodeGenerationHelper2.append(string4 + "[" + string4 + "_created++] = new " + string3 + "[1024];\n");
        dataFlowCodeGenerationHelper2.append("}\n");
        dataFlowCodeGenerationHelper2.append(string + "_stream = " + string4 + "[" + string4 + "_next++];\n");
        dataFlowCodeGenerationHelper2.append(string + "_original = " + string + "_stream;\n");
        dataFlowCodeGenerationHelper2.append("} else {\n");
        if (dataFlowCodeGenerationHelper.getSettings().isBufferDiagnostics()) {
            dataFlowCodeGenerationHelper2.append("System.err.println(\">> out of buffers of type " + string3 + "\");\n");
        }
        dataFlowCodeGenerationHelper2.append(string);
        dataFlowCodeGenerationHelper2.append("_stream = ");
        if (dataFlowCodeGenerationHelper.isTargetJava()) {
            dataFlowCodeGenerationHelper2.append("new ");
            dataFlowCodeGenerationHelper2.append(string3);
            dataFlowCodeGenerationHelper2.append("[");
            dataFlowCodeGenerationHelper2.append(Integer.toString(n));
            dataFlowCodeGenerationHelper2.append("];\n");
        } else {
            dataFlowCodeGenerationHelper2.append("NEW_ARRAY(");
            dataFlowCodeGenerationHelper2.append(string3);
            dataFlowCodeGenerationHelper2.append(", ");
            dataFlowCodeGenerationHelper2.append(Integer.toString(n));
            dataFlowCodeGenerationHelper2.append(");\n");
        }
        dataFlowCodeGenerationHelper2.append("}\n");
        dataFlowCodeGenerationHelper2.append("int " + string + "_size = 0;\n");
    }

    public static int[] generateCreateStream(InstructionListBuilder instructionListBuilder, int n, StreamType streamType, BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker) {
        Object object;
        Type type = streamType.getElementType();
        int[] nArray = new int[3];
        int n2 = nArray[0] = codeGenerationTracker.allocateRegister();
        int n3 = nArray[1] = codeGenerationTracker.allocateRegister();
        int n4 = nArray[2] = codeGenerationTracker.allocateRegister();
        com.ibm.xtq.bcel.generic.Type type2 = type.getImplementationType(bCELCodeGenerationHelper);
        instructionListBuilder.appendNull();
        instructionListBuilder.appendAStore(n4);
        String string = streamType.prettyPrint() + "_buffer_cache";
        String string2 = (String)bCELCodeGenerationHelper.generationMemosGet(string);
        if (string2 == null) {
            string2 = bCELCodeGenerationHelper.generateNewMemberVariableName("_buffer_cache");
            bCELCodeGenerationHelper.allocateThreadLocalVariable(string2, new ArrayType(type2, 2), false);
            bCELCodeGenerationHelper.allocateThreadLocalVariable(string2 + "_next", BasicType.INT, true);
            bCELCodeGenerationHelper.allocateThreadLocalVariable(string2 + "_created", BasicType.INT, false);
            object = bCELCodeGenerationHelper.getConstructorILB();
            bCELCodeGenerationHelper.generateThreadLocalVarStartPut((InstructionListBuilder)object);
            ((InstructionListBuilder)object).appendNewArray(new ArrayType(type2, 1), 10);
            bCELCodeGenerationHelper.generateThreadLocalVarFinishPut((InstructionListBuilder)object, string2);
            bCELCodeGenerationHelper.generationMemosPut(string, string2);
        }
        instructionListBuilder.appendThis();
        object = instructionListBuilder.appendIfnull();
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_next");
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2);
        instructionListBuilder.appendArrayLength();
        BranchInstruction branchInstruction = instructionListBuilder.appendIficmpge();
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_next");
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_created");
        BranchInstruction branchInstruction2 = instructionListBuilder.appendIficmpne();
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2);
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_next");
        bCELCodeGenerationHelper.generateThreadLocalVarStartPut(instructionListBuilder);
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_created");
        instructionListBuilder.appendPlusPlus();
        bCELCodeGenerationHelper.generateThreadLocalVarFinishPut(instructionListBuilder, string2 + "_created");
        instructionListBuilder.appendNewArray(type2, 1024);
        instructionListBuilder.appendAAStore();
        branchInstruction2.setTarget(bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2));
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_next");
        bCELCodeGenerationHelper.generateThreadLocalVarStartPut(instructionListBuilder);
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_next");
        instructionListBuilder.appendPlusPlus();
        bCELCodeGenerationHelper.generateThreadLocalVarFinishPut(instructionListBuilder, string2 + "_next");
        instructionListBuilder.appendAALoad();
        instructionListBuilder.appendAStore(n2);
        instructionListBuilder.appendALoad(n2);
        instructionListBuilder.appendAStore(n4);
        BranchInstruction branchInstruction3 = instructionListBuilder.appendGoto();
        InstructionHandle instructionHandle = instructionListBuilder.appendNewArray(type2, n);
        instructionListBuilder.appendAStore(n2);
        ((BranchInstruction)object).setTarget(instructionHandle);
        branchInstruction.setTarget(instructionHandle);
        branchInstruction3.setTarget(instructionListBuilder.appendNOP());
        instructionListBuilder.appendConstant(0);
        instructionListBuilder.appendIStore(n3);
        return nArray;
    }

    public static String generateStreamParameterList(String string, StreamType streamType, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        Type type = streamType.getElementType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(streamType.getImplementationName(dataFlowCodeGenerationHelper));
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("_stream, ");
        stringBuffer.append("int");
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("_size");
        return stringBuffer.toString();
    }

    public static int generateStreamParameterList(String string, StreamType streamType, BCELCodeGenerationHelper bCELCodeGenerationHelper, ArrayList arrayList, ArrayList arrayList2, CodeGenerationTracker codeGenerationTracker) {
        arrayList2.add(streamType.getImplementationType(bCELCodeGenerationHelper));
        arrayList.add(string + "_stream");
        arrayList2.add(BasicType.INT);
        arrayList.add(string + "_size");
        int n = codeGenerationTracker.allocateRegister();
        codeGenerationTracker.allocateRegister();
        return n;
    }

    public static void generateStreamFunctionSuffix(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType) {
        dataFlowCodeGenerationHelper.allocateThreadLocalVariable("stream_size", "int");
        dataFlowCodeGenerationHelper.append(dataFlowCodeGenerationHelper.generateThreadLocalVarReference("stream_size") + " = " + string + "_size;\n");
    }

    public static void generateStreamFunctionSuffix(BCELCodeGenerationHelper bCELCodeGenerationHelper, int n, StreamType streamType, InstructionListBuilder instructionListBuilder) {
        bCELCodeGenerationHelper.allocateThreadLocalVariable("stream_size", BasicType.INT, false);
        bCELCodeGenerationHelper.generateThreadLocalVarStartPut(instructionListBuilder);
        instructionListBuilder.appendILoad(n + 1);
        bCELCodeGenerationHelper.generateThreadLocalVarFinishPut(instructionListBuilder, "stream_size");
    }

    public static void generateStreamFunctionCallSuffix(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType) {
        dataFlowCodeGenerationHelper.allocateThreadLocalVariable("stream_size", "int");
        dataFlowCodeGenerationHelper.append(string + "_size = " + dataFlowCodeGenerationHelper.generateThreadLocalVarReference("stream_size") + ";\n");
    }

    public static void generateStreamFunctionCallSuffix(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, StreamType streamType, InstructionListBuilder instructionListBuilder) {
        bCELCodeGenerationHelper.allocateThreadLocalVariable("stream_size", BasicType.INT, false);
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, "stream_size");
        instructionListBuilder.appendIStore(nArray[1]);
    }

    public static String generateStreamCallList(String string, StreamType streamType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("_stream, ");
        stringBuffer.append(string);
        stringBuffer.append("_size");
        return stringBuffer.toString();
    }

    public static String generateGetStreamPart(String string, StreamType streamType) {
        return string + "_stream";
    }

    public static String generateLengthExpression(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string) {
        if (dataFlowCodeGenerationHelper.isTargetJava()) {
            return string + ".length";
        }
        return "LENGTH(" + string + ")";
    }

    public static void generateGrowStreamBy1(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType) {
        Type type = streamType.getElementType();
        String string2 = "resize_stream_1_" + type.getImplementationName(dataFlowCodeGenerationHelper);
        String string3 = (String)dataFlowCodeGenerationHelper.generationMemosGet(string2);
        if (string3 == null) {
            string3 = dataFlowCodeGenerationHelper.generateNewMemberVariableName("resize_stream_1");
            dataFlowCodeGenerationHelper.generationMemosPut(string2, string3);
            StringBuffer stringBuffer = new StringBuffer();
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                stringBuffer.append("static public final ");
            }
            stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper) + dataFlowCodeGenerationHelper.m_arraySuffix + " " + string3 + "(" + type.getImplementationName(dataFlowCodeGenerationHelper) + dataFlowCodeGenerationHelper.m_arraySuffix + " " + "_stream, " + "int" + " " + "_size) {\n");
            if (dataFlowCodeGenerationHelper.getSettings().isBufferDiagnostics()) {
                stringBuffer.append("System.err.println(\">> resizing " + type.getImplementationName(dataFlowCodeGenerationHelper) + "\");\n");
            }
            stringBuffer.append(streamType.getImplementationName(dataFlowCodeGenerationHelper));
            stringBuffer.append(" ");
            stringBuffer.append("_stream2 = ");
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                stringBuffer.append("new ");
                stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper));
                stringBuffer.append("[");
                stringBuffer.append("_size * 2];\n");
            } else {
                stringBuffer.append("NEW_ARRAY(");
                stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper));
                stringBuffer.append(", ");
                stringBuffer.append("_size * 2);\n");
            }
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                stringBuffer.append("System.arraycopy(");
                stringBuffer.append("_stream, 0, ");
                stringBuffer.append("_stream2, 0, ");
                stringBuffer.append("_size);\n");
            } else {
                stringBuffer.append("memcpy(");
                stringBuffer.append("_stream2, ");
                stringBuffer.append("_stream, ");
                stringBuffer.append("_size * sizeof(" + type.getImplementationName(dataFlowCodeGenerationHelper) + "));\n");
            }
            stringBuffer.append("return ");
            stringBuffer.append("_stream2;\n");
            stringBuffer.append("}\n");
            dataFlowCodeGenerationHelper.appendConstantStatement(stringBuffer.toString());
        }
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_stream = ");
        dataFlowCodeGenerationHelper.append(dataFlowCodeGenerationHelper.getStaticFieldPrefix() + string3);
        dataFlowCodeGenerationHelper.append("(");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_stream, ");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size);\n");
    }

    public static void fillStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, String string3) {
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName("new_size");
        dataFlowCodeGenerationHelper.append(dataFlowCodeGenerationHelper.m_finalKeyword);
        dataFlowCodeGenerationHelper.append(" int ");
        dataFlowCodeGenerationHelper.append(string4);
        dataFlowCodeGenerationHelper.append(" = ");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size + ");
        dataFlowCodeGenerationHelper.append(string3);
        dataFlowCodeGenerationHelper.append(";\n");
        dataFlowCodeGenerationHelper.append("if (");
        dataFlowCodeGenerationHelper.append(string4);
        dataFlowCodeGenerationHelper.append(" > ");
        dataFlowCodeGenerationHelper.append(StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string + "_stream"));
        dataFlowCodeGenerationHelper.append(") {\n");
        StreamType.generateGrowStream(dataFlowCodeGenerationHelper, string, streamType, string3);
        dataFlowCodeGenerationHelper.append("}\n");
        dataFlowCodeGenerationHelper.append("java.util.Arrays.fill(");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_stream, ");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size, ");
        dataFlowCodeGenerationHelper.append(string4);
        dataFlowCodeGenerationHelper.append(", ");
        dataFlowCodeGenerationHelper.append(string2);
        dataFlowCodeGenerationHelper.append(");\n");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size = ");
        dataFlowCodeGenerationHelper.append(string4);
        dataFlowCodeGenerationHelper.append(";\n");
    }

    public static void generateAddElementToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2) {
        dataFlowCodeGenerationHelper.append("if (");
        dataFlowCodeGenerationHelper.append(StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string + "_stream"));
        dataFlowCodeGenerationHelper.append(" == ");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size) {\n");
        StreamType.generateGrowStreamBy1(dataFlowCodeGenerationHelper, string, streamType);
        dataFlowCodeGenerationHelper.append("}\n");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_stream[");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size++] = ");
        dataFlowCodeGenerationHelper.append(string2);
        dataFlowCodeGenerationHelper.append(";\n");
    }

    public static void generateAddElementToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String[] stringArray, boolean bl) {
        if (stringArray.length == 0) {
            return;
        }
        if (stringArray.length == 1) {
            StreamType.generateAddElementToStream(dataFlowCodeGenerationHelper, string, streamType, stringArray[0]);
        } else {
            if (!bl) {
                dataFlowCodeGenerationHelper.append("if (");
                dataFlowCodeGenerationHelper.append(StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string + "_stream"));
                dataFlowCodeGenerationHelper.append(" < (");
                dataFlowCodeGenerationHelper.append(Integer.toString(stringArray.length));
                dataFlowCodeGenerationHelper.append(" + ");
                dataFlowCodeGenerationHelper.append(string);
                dataFlowCodeGenerationHelper.append("_size)) {\n");
                StreamType.generateGrowStream(dataFlowCodeGenerationHelper, string, streamType, string + "_size + " + stringArray.length);
                dataFlowCodeGenerationHelper.append("}\n");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                dataFlowCodeGenerationHelper.append(string);
                dataFlowCodeGenerationHelper.append("_stream[");
                dataFlowCodeGenerationHelper.append(string);
                dataFlowCodeGenerationHelper.append("_size++] = ");
                dataFlowCodeGenerationHelper.append(stringArray[i]);
                dataFlowCodeGenerationHelper.append(";\n");
            }
        }
    }

    public static void generateGrowIfNeeded(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, int n) {
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendArrayLength();
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendConstant(n);
        instructionListBuilder.appendIAdd();
        BranchInstruction branchInstruction = instructionListBuilder.appendIficmpge();
        instructionListBuilder.appendConstant(n);
        StreamType.generateGrowStream(nArray, bCELCodeGenerationHelper, streamType, instructionListBuilder);
        branchInstruction.setTarget(instructionListBuilder.appendNOP());
    }

    public static void generateStartAddElementToStream(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, CodeGenerationTracker codeGenerationTracker) {
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendLocalPlusPlus(nArray[1]);
    }

    public static void generateFinishAddElementToStream(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, CodeGenerationTracker codeGenerationTracker) {
        instructionListBuilder.appendArrayStore(streamType.getElementType());
    }

    public static void generateAddStreamToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2 + "_stream", string2 + "_size", -1);
    }

    public static void generateAddMultipleElementsToStream(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, CodeGenerationTracker codeGenerationTracker, int n) {
        StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, codeGenerationTracker, n, -1, -1, -1);
    }

    public static void generateAddMultipleElementsToStream(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, CodeGenerationTracker codeGenerationTracker, int n, int n2) {
        StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, codeGenerationTracker, n, -1, -1, n2);
    }

    public static void generateAddMultipleElementsToStream(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, CodeGenerationTracker codeGenerationTracker, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            if (n == -1) {
                instructionListBuilder.appendPop();
            }
            return;
        }
        if (bCELCodeGenerationHelper.getSettings().isOutlineStreamAppend()) {
            com.ibm.xtq.bcel.generic.Type[] typeArray;
            boolean bl = n3 != -1 || n2 != -1 || n4 != -1;
            String string = bl ? "_substr" : "";
            String string2 = "append_stream_" + streamType.prettyPrint() + string;
            String string3 = (String)bCELCodeGenerationHelper.generationMemosGet(string2);
            if (bl) {
                com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[5];
                typeArray2[0] = streamType.getImplementationType(bCELCodeGenerationHelper);
                typeArray2[1] = streamType.getImplementationType(bCELCodeGenerationHelper);
                typeArray2[2] = BasicType.INT;
                typeArray2[3] = BasicType.INT;
                typeArray = typeArray2;
                typeArray2[4] = BasicType.INT;
            } else {
                com.ibm.xtq.bcel.generic.Type[] typeArray3 = new com.ibm.xtq.bcel.generic.Type[3];
                typeArray3[0] = streamType.getImplementationType(bCELCodeGenerationHelper);
                typeArray3[1] = streamType.getImplementationType(bCELCodeGenerationHelper);
                typeArray = typeArray3;
                typeArray3[2] = BasicType.INT;
            }
            com.ibm.xtq.bcel.generic.Type[] typeArray4 = typeArray;
            if (string3 == null) {
                string3 = bCELCodeGenerationHelper.generateNewMemberVariableName("append_stream" + string);
                bCELCodeGenerationHelper.generationMemosPut(string2, string3);
                ClassGenerationHelper classGenerationHelper = bCELCodeGenerationHelper.m_cgh;
                InstructionListBuilder instructionListBuilder2 = new InstructionListBuilder(bCELCodeGenerationHelper, new InstructionList(), classGenerationHelper);
                MethodGen methodGen = new MethodGen(25, streamType.getImplementationType(bCELCodeGenerationHelper), typeArray4, null, string3, instructionListBuilder.getClassGenerationHelper().m_cg.getClassName(), instructionListBuilder2.getInstructionList(), classGenerationHelper.m_cpg);
                BranchInstruction branchInstruction = null;
                if (bl) {
                    instructionListBuilder2.appendILoad(4);
                    instructionListBuilder2.appendConstant(0);
                    branchInstruction = instructionListBuilder2.appendIficmple();
                } else {
                    instructionListBuilder2.appendALoad(0);
                    instructionListBuilder2.appendArrayLength();
                    instructionListBuilder2.appendIStore(4);
                }
                instructionListBuilder2.appendILoad(2);
                instructionListBuilder2.appendILoad(4);
                instructionListBuilder2.appendIAdd();
                instructionListBuilder2.appendALoad(1);
                instructionListBuilder2.appendArrayLength();
                BranchInstruction branchInstruction2 = instructionListBuilder2.appendIficmple();
                instructionListBuilder2.appendILoad(4);
                StreamType.generateGrowStream(new int[]{1, 2}, bCELCodeGenerationHelper, streamType, instructionListBuilder2);
                branchInstruction2.setTarget(instructionListBuilder2.appendALoad(0));
                if (!bl) {
                    instructionListBuilder2.appendConstant(0);
                } else {
                    instructionListBuilder2.appendILoad(3);
                }
                instructionListBuilder2.appendALoad(1);
                instructionListBuilder2.appendILoad(2);
                instructionListBuilder2.appendILoad(4);
                instructionListBuilder2.appendSystemArrayCopy();
                if (bl) {
                    branchInstruction.setTarget(instructionListBuilder2.appendNOP());
                }
                instructionListBuilder2.appendALoad(1);
                instructionListBuilder2.appendAReturn();
                bCELCodeGenerationHelper.addMethodToClass(methodGen, classGenerationHelper);
            }
            if (n != -1) {
                instructionListBuilder.appendALoad(n);
            } else if (n4 == -1 && n3 == -1) {
                n3 = codeGenerationTracker.allocateRegister();
                instructionListBuilder.appendDUP();
                instructionListBuilder.appendArrayLength();
                instructionListBuilder.appendIStore(n3);
            }
            instructionListBuilder.appendALoad(nArray[0]);
            instructionListBuilder.appendILoad(nArray[1]);
            if (bl) {
                if (n2 != -1) {
                    instructionListBuilder.appendILoad(n2);
                } else {
                    instructionListBuilder.appendConstant(0);
                }
                if (n4 != -1) {
                    instructionListBuilder.appendConstant(n4);
                } else if (n3 != -1) {
                    instructionListBuilder.appendILoad(n3);
                } else if (n != -1) {
                    instructionListBuilder.appendALoad(n);
                    instructionListBuilder.appendArrayLength();
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            instructionListBuilder.appendInvokeStatic(bCELCodeGenerationHelper.getClassName(), string3, streamType.getImplementationType(bCELCodeGenerationHelper), typeArray4);
            instructionListBuilder.appendAStore(nArray[0]);
            instructionListBuilder.appendILoad(nArray[1]);
            if (n4 != -1) {
                instructionListBuilder.appendConstant(n4);
            } else if (n3 != -1) {
                instructionListBuilder.appendILoad(n3);
            } else if (n != -1) {
                instructionListBuilder.appendALoad(n);
                instructionListBuilder.appendArrayLength();
            } else {
                throw new UnsupportedOperationException();
            }
            instructionListBuilder.appendIAdd();
            instructionListBuilder.appendIStore(nArray[1]);
        } else {
            if (n == -1) {
                n = codeGenerationTracker.allocateRegister();
                instructionListBuilder.appendAStore(n);
            }
            if (n3 == -1) {
                n3 = codeGenerationTracker.allocateRegister();
                instructionListBuilder.appendALoad(n);
                instructionListBuilder.appendArrayLength();
                instructionListBuilder.appendIStore(n3);
            }
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendConstant(0);
            BranchInstruction branchInstruction = instructionListBuilder.appendIficmple();
            instructionListBuilder.appendILoad(nArray[1]);
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendIAdd();
            instructionListBuilder.appendALoad(nArray[0]);
            instructionListBuilder.appendArrayLength();
            BranchInstruction branchInstruction3 = instructionListBuilder.appendIficmple();
            instructionListBuilder.appendILoad(n3);
            StreamType.generateGrowStream(nArray, bCELCodeGenerationHelper, streamType, instructionListBuilder);
            branchInstruction3.setTarget(instructionListBuilder.appendALoad(n));
            if (n2 == -1) {
                instructionListBuilder.appendConstant(0);
            } else {
                instructionListBuilder.appendILoad(n2);
            }
            instructionListBuilder.appendALoad(nArray[0]);
            instructionListBuilder.appendILoad(nArray[1]);
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendSystemArrayCopy();
            instructionListBuilder.appendILoad(nArray[1]);
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendIAdd();
            instructionListBuilder.appendIStore(nArray[1]);
            branchInstruction.setTarget(instructionListBuilder.appendNOP());
        }
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string2), -1);
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, int n) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string2), n);
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, String string3) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, string3, 0, -1);
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, String string3, int n) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, string3, 0, n);
    }

    public static void generateGrowStream(int[] nArray, BCELCodeGenerationHelper bCELCodeGenerationHelper, StreamType streamType, InstructionListBuilder instructionListBuilder) {
        String string = "resize_stream_" + streamType.prettyPrint();
        String string2 = (String)bCELCodeGenerationHelper.generationMemosGet(string);
        if (string2 == null) {
            string2 = bCELCodeGenerationHelper.generateNewMemberVariableName("resize_stream");
            bCELCodeGenerationHelper.generationMemosPut(string, string2);
            ClassGenerationHelper classGenerationHelper = bCELCodeGenerationHelper.m_cgh;
            InstructionListBuilder instructionListBuilder2 = new InstructionListBuilder(bCELCodeGenerationHelper, new InstructionList(), classGenerationHelper);
            MethodGen methodGen = new MethodGen(25, streamType.getImplementationType(bCELCodeGenerationHelper), new com.ibm.xtq.bcel.generic.Type[]{BasicType.INT, streamType.getImplementationType(bCELCodeGenerationHelper), BasicType.INT}, null, string2, instructionListBuilder.getClassGenerationHelper().m_cg.getClassName(), instructionListBuilder2.getInstructionList(), classGenerationHelper.m_cpg);
            instructionListBuilder2.appendALoad(1);
            instructionListBuilder2.appendConstant(0);
            instructionListBuilder2.appendILoad(0);
            instructionListBuilder2.appendILoad(2);
            instructionListBuilder2.appendConstant(1);
            instructionListBuilder2.appendIShl();
            instructionListBuilder2.appendIAdd();
            instructionListBuilder2.appendNewArray(streamType.getElementType());
            instructionListBuilder2.appendDUP();
            instructionListBuilder2.appendAStore(3);
            instructionListBuilder2.appendConstant(0);
            instructionListBuilder2.appendILoad(2);
            instructionListBuilder2.appendSystemArrayCopy();
            instructionListBuilder2.appendALoad(3);
            instructionListBuilder2.appendAReturn();
            bCELCodeGenerationHelper.addMethodToClass(methodGen, classGenerationHelper);
        }
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendInvokeStatic(bCELCodeGenerationHelper.getClassName(), string2, streamType.getImplementationType(bCELCodeGenerationHelper), new com.ibm.xtq.bcel.generic.Type[]{BasicType.INT, streamType.getImplementationType(bCELCodeGenerationHelper), BasicType.INT});
        instructionListBuilder.appendAStore(nArray[0]);
    }

    public static void generateGrowStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2) {
        Type type = streamType.getElementType();
        String string3 = "resize_stream_" + type.getImplementationName(dataFlowCodeGenerationHelper);
        String string4 = (String)dataFlowCodeGenerationHelper.generationMemosGet(string3);
        if (string4 == null) {
            string4 = dataFlowCodeGenerationHelper.generateNewMemberVariableName("resize_stream");
            dataFlowCodeGenerationHelper.generationMemosPut(string3, string4);
            StringBuffer stringBuffer = new StringBuffer();
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                stringBuffer.append("static public final ");
            }
            stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper) + dataFlowCodeGenerationHelper.m_arraySuffix + " " + string4 + "(int len, " + type.getImplementationName(dataFlowCodeGenerationHelper) + dataFlowCodeGenerationHelper.m_arraySuffix + " " + "_stream, " + "int" + " " + "_size) {\n");
            if (dataFlowCodeGenerationHelper.getSettings().isBufferDiagnostics()) {
                stringBuffer.append("System.err.println(\">> resizing " + type.getImplementationName(dataFlowCodeGenerationHelper) + "\");\n");
            }
            stringBuffer.append(streamType.getImplementationName(dataFlowCodeGenerationHelper));
            stringBuffer.append(" ");
            stringBuffer.append("_stream2 = ");
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                stringBuffer.append("new ");
                stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper));
                stringBuffer.append("[");
                stringBuffer.append("_size * 2 + len];\n");
            } else {
                stringBuffer.append("NEW_ARRAY(");
                stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper));
                stringBuffer.append(", ");
                stringBuffer.append("_size * 2 + len);\n");
            }
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                stringBuffer.append("System.arraycopy(");
                stringBuffer.append("_stream, 0, ");
                stringBuffer.append("_stream2, 0, ");
                stringBuffer.append("_size);\n");
            } else {
                stringBuffer.append("memcpy(");
                stringBuffer.append("_stream2, ");
                stringBuffer.append("_stream, ");
                stringBuffer.append("_size * sizeof(" + type.getImplementationName(dataFlowCodeGenerationHelper) + "));\n");
            }
            stringBuffer.append("return ");
            stringBuffer.append("_stream2;\n");
            stringBuffer.append("}\n");
            dataFlowCodeGenerationHelper.appendConstantStatement(stringBuffer.toString());
        }
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_stream = ");
        dataFlowCodeGenerationHelper.append(dataFlowCodeGenerationHelper.getStaticFieldPrefix() + string4);
        dataFlowCodeGenerationHelper.append("(");
        dataFlowCodeGenerationHelper.append(string2);
        dataFlowCodeGenerationHelper.append(", ");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_stream, ");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size);\n");
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, String string3, int n, int n2) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, string3, Integer.toString(n), n2);
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, String string3, String string4) {
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, string3, string4, -1);
    }

    public static void generateAddMultipleElementsToStream(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, StreamType streamType, String string2, String string3, String string4, int n) {
        if (n == 0) {
            return;
        }
        if (n == -1) {
            String string5 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            dataFlowCodeGenerationHelper.append(dataFlowCodeGenerationHelper.m_finalKeyword);
            dataFlowCodeGenerationHelper.append(" int " + string5 + " = " + string3 + ";\n");
            string3 = string5;
            dataFlowCodeGenerationHelper.append("if (");
            dataFlowCodeGenerationHelper.append(string3);
            dataFlowCodeGenerationHelper.append(" > 0) {\n");
        } else {
            string3 = Integer.toString(n);
        }
        dataFlowCodeGenerationHelper.append("if (");
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size + ");
        dataFlowCodeGenerationHelper.append(string3);
        dataFlowCodeGenerationHelper.append(" > ");
        dataFlowCodeGenerationHelper.append(StreamType.generateLengthExpression(dataFlowCodeGenerationHelper, string + "_stream"));
        dataFlowCodeGenerationHelper.append(") {\n");
        StreamType.generateGrowStream(dataFlowCodeGenerationHelper, string, streamType, string3);
        dataFlowCodeGenerationHelper.append("}\n");
        if (dataFlowCodeGenerationHelper.isTargetJava()) {
            dataFlowCodeGenerationHelper.append("System.arraycopy(");
            dataFlowCodeGenerationHelper.append(string2);
            dataFlowCodeGenerationHelper.append(", ");
            dataFlowCodeGenerationHelper.append(string4);
            dataFlowCodeGenerationHelper.append(", ");
            dataFlowCodeGenerationHelper.append(string);
            dataFlowCodeGenerationHelper.append("_stream, ");
            dataFlowCodeGenerationHelper.append(string);
            dataFlowCodeGenerationHelper.append("_size, ");
            dataFlowCodeGenerationHelper.append(string3);
            dataFlowCodeGenerationHelper.append(");\n");
        } else {
            dataFlowCodeGenerationHelper.append("memcpy(");
            dataFlowCodeGenerationHelper.append(string);
            dataFlowCodeGenerationHelper.append("_stream + ");
            dataFlowCodeGenerationHelper.append(string);
            dataFlowCodeGenerationHelper.append("_size, ");
            dataFlowCodeGenerationHelper.append(string2);
            dataFlowCodeGenerationHelper.append(" + ");
            dataFlowCodeGenerationHelper.append(string4);
            dataFlowCodeGenerationHelper.append(", ");
            dataFlowCodeGenerationHelper.append(string3);
            dataFlowCodeGenerationHelper.append(" * sizeof(" + streamType.getElementType().getImplementationName(dataFlowCodeGenerationHelper) + "));\n");
        }
        dataFlowCodeGenerationHelper.append(string);
        dataFlowCodeGenerationHelper.append("_size += ");
        dataFlowCodeGenerationHelper.append(string3);
        dataFlowCodeGenerationHelper.append(";\n");
        if (n == -1) {
            dataFlowCodeGenerationHelper.append("}\n");
        }
    }

    public static void generateCompactStream(String string, StreamType streamType, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        String string2 = streamType.getImplementationName(dataFlowCodeGenerationHelper);
        Type type = streamType.getElementType();
        DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper2 = dataFlowCodeGenerationHelper;
        dataFlowCodeGenerationHelper2.append("// Compact stream\n");
        dataFlowCodeGenerationHelper2.append(string2);
        dataFlowCodeGenerationHelper2.append(" ");
        dataFlowCodeGenerationHelper2.append(string);
        dataFlowCodeGenerationHelper2.append(";\nif (");
        dataFlowCodeGenerationHelper2.append(StreamType.generateLengthExpression(dataFlowCodeGenerationHelper2, string + "_stream"));
        dataFlowCodeGenerationHelper2.append(" != ");
        dataFlowCodeGenerationHelper2.append(string);
        dataFlowCodeGenerationHelper2.append("_size || (" + string + "_original == " + string + "_stream)) {\n");
        if (dataFlowCodeGenerationHelper2.isTargetJava()) {
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append(" = new ");
            dataFlowCodeGenerationHelper2.append(type.getImplementationName(dataFlowCodeGenerationHelper));
            dataFlowCodeGenerationHelper2.append("[");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append("_size];\n");
            dataFlowCodeGenerationHelper2.append("System.arraycopy(");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append("_stream, 0, ");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append(", 0, ");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append("_size);");
        } else {
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append(" = NEW_ARRAY(");
            dataFlowCodeGenerationHelper2.append(type.getImplementationName(dataFlowCodeGenerationHelper));
            dataFlowCodeGenerationHelper2.append(", ");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append("_size);\n");
            dataFlowCodeGenerationHelper2.append("memcpy(");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append(", ");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append("_stream, ");
            dataFlowCodeGenerationHelper2.append(string);
            dataFlowCodeGenerationHelper2.append("_size * sizeof(" + type.getImplementationName(dataFlowCodeGenerationHelper) + "));");
        }
        dataFlowCodeGenerationHelper2.append("\n} else {\n");
        dataFlowCodeGenerationHelper2.append(string);
        dataFlowCodeGenerationHelper2.append(" = ");
        dataFlowCodeGenerationHelper2.append(string);
        dataFlowCodeGenerationHelper2.append("_stream;\n}\n");
        StreamType.generateReleaseLastBuffer(string, streamType, dataFlowCodeGenerationHelper);
    }

    public static void generateReleaseLastBuffer(String string, StreamType streamType, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        String string2 = StreamType.generateBufferCache(streamType, dataFlowCodeGenerationHelper);
        if (!dataFlowCodeGenerationHelper.isTargetCPP()) {
            string2 = dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + string2;
        }
        dataFlowCodeGenerationHelper.append("if (" + string + "_original != " + dataFlowCodeGenerationHelper.m_null + ") ");
        dataFlowCodeGenerationHelper.append(string2 + "_next--;\n");
    }

    public static void generateCompactStream(int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker) {
        Type type = streamType.getElementType();
        int n = codeGenerationTracker.allocateRegister();
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendArrayLength();
        instructionListBuilder.appendILoad(nArray[1]);
        BranchInstruction branchInstruction = instructionListBuilder.appendIficmpne();
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendALoad(nArray[2]);
        BranchInstruction branchInstruction2 = instructionListBuilder.appendIfacmpne();
        branchInstruction.setTarget(instructionListBuilder.appendILoad(nArray[1]));
        instructionListBuilder.appendNewArray(type);
        instructionListBuilder.appendAStore(n);
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendConstant(0);
        instructionListBuilder.appendALoad(n);
        instructionListBuilder.appendConstant(0);
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendSystemArrayCopy();
        BranchInstruction branchInstruction3 = instructionListBuilder.appendGoto();
        branchInstruction2.setTarget(instructionListBuilder.appendALoad(nArray[0]));
        instructionListBuilder.appendAStore(n);
        branchInstruction3.setTarget(instructionListBuilder.appendALoad(nArray[2]));
        BranchInstruction branchInstruction4 = instructionListBuilder.appendIfnull();
        StreamType.generateReleaseLastBuffer(instructionListBuilder, streamType, bCELCodeGenerationHelper);
        branchInstruction4.setTarget(instructionListBuilder.appendNOP());
        instructionListBuilder.appendALoad(n);
    }

    private static void generateReleaseLastBuffer(InstructionListBuilder instructionListBuilder, StreamType streamType, BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        String string = streamType.prettyPrint() + "_buffer_cache";
        String string2 = (String)bCELCodeGenerationHelper.generationMemosGet(string);
        bCELCodeGenerationHelper.generateThreadLocalVarStartPut(instructionListBuilder);
        bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2 + "_next");
        instructionListBuilder.appendConstant(1);
        instructionListBuilder.appendISub();
        bCELCodeGenerationHelper.generateThreadLocalVarFinishPut(instructionListBuilder, string2 + "_next");
    }

    public boolean isFullySpecified() {
        return this.m_elementType.isFullySpecified();
    }

    public String prettyPrint() {
        return this.m_elementType.prettyPrint() + "[]";
    }

    public int hashCode() {
        return 31 * this.m_elementType.hashCode();
    }

    public int getChildTypeCount() {
        return 1;
    }

    public Type getChildType(int n) {
        return n == 0 ? this.m_elementType : null;
    }

    public void setChildType(int n, Type type) {
        if (n == 0) {
            this.m_elementType = type;
        }
    }

    public StreamType getStreamType() {
        throw new UnsupportedOperationException();
    }

    public Type resolveTypeAsMuchAsPossible(TypeEnvironment typeEnvironment, Set set) {
        return this.m_elementType.resolveTypeAsMuchAsPossible(typeEnvironment, set).getStreamType();
    }

    public String getDefaultValue() {
        return "null";
    }

    static class LoopState
    extends ICollectionType.BCELLoopState {
        InstructionHandle m_loopStart;
        BranchInstruction m_loopBranch;
        int m_lenVar;

        LoopState() {
        }
    }
}

