/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.optimizers.FlattenStreamOptimizer;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.parser.ParserException;
import com.ibm.xylem.parser.ParserSource;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.TupleType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class VirtualDataTypeMap {
    static final Logger s_logger = Logger.getInstance(VirtualDataTypeMap.class);
    private HashMap m_mappings = new HashMap();
    private Collection m_importDirectives = new ArrayList();
    private FlattenStreamOptimizer streamFlattener = new FlattenStreamOptimizer();

    public void addVDTMapping(String string, ADTMapping aDTMapping, boolean bl) {
        s_logger.debug("adding VDTmap from " + string);
        Object v = this.m_mappings.get(string);
        if (v == aDTMapping) {
            return;
        }
        if (v != null && bl) {
            s_logger.error("vdtmap with name " + string + " already exists");
        }
        this.m_mappings.put(string, aDTMapping);
    }

    public void addVDTMapping(String string, ADTMapping aDTMapping) {
        this.addVDTMapping(string, aDTMapping, true);
    }

    public boolean hasVDTMapping(String string) {
        return this.m_mappings.containsKey(string);
    }

    public Set vdtMappingNames() {
        return this.m_mappings.keySet();
    }

    public ADTMapping getVDTMapping(String string) {
        return (ADTMapping)this.m_mappings.get(string);
    }

    public void addVDT(Module module, String string, Type type, LambdaInstruction lambdaInstruction, Map map) throws ParserException {
        if (this.hasVDTMapping(string)) {
            throw new ParserException("map-datatype already supplied for " + string);
        }
        ADTMapping aDTMapping = new ADTMapping();
        this.addVDTMapping(string, aDTMapping);
        aDTMapping.m_targetType = type;
        Binding[] bindingArray = lambdaInstruction.getParameters();
        if (bindingArray.length != 1) {
            throw new ParserException("mapping function should have a single parameter");
        }
        TupleInstruction tupleInstruction = new TupleInstruction(new Instruction[]{lambdaInstruction.getBody()});
        Function function = this.typecheckAndReduceVDTCode(module, tupleInstruction, bindingArray);
        aDTMapping.m_matchVariable = function.getParameters()[0];
        aDTMapping.m_matchCode = function.getBody();
        for (String string2 : map.keySet()) {
            LambdaInstruction[] lambdaInstructionArray = (LambdaInstruction[])map.get(string2);
            if (lambdaInstructionArray.length != 2) {
                throw new ParserException("a variant mapping must have two functions to construct and deconstruct an object");
            }
            ConstructorMapping constructorMapping = new ConstructorMapping();
            function = this.typecheckAndReduceVDTCode(module, lambdaInstructionArray[0].getBody(), lambdaInstructionArray[0].getParameters());
            constructorMapping.m_constructParameters = function.getParameters();
            constructorMapping.m_constructCode = function.getBody();
            Binding[] bindingArray2 = lambdaInstructionArray[1].getParameters();
            if (bindingArray2.length != 1) {
                throw new ParserException("deconstructor function should have a single parameter");
            }
            function = this.typecheckAndReduceVDTCode(module, lambdaInstructionArray[1].getBody(), lambdaInstructionArray[1].getParameters());
            if (!(function.getReturnType() instanceof TupleType)) {
                throw new ParserException("return type must be a tuple :" + function.toString() + ":" + function.getBody());
            }
            constructorMapping.m_deconstructVariable = function.getParameters()[0];
            constructorMapping.m_deconstructCode = function.getBody();
            aDTMapping.m_constructors.put(string2, constructorMapping);
        }
    }

    protected void applyFlattener(Function function, Module module) {
    }

    private Function typecheckAndReduceVDTCode(Module module, Instruction instruction, Binding[] bindingArray) throws ParserException {
        Function function = new Function(OptimizerUtilities.generateIntermediateIdentifier(), bindingArray, instruction);
        this.applyFlattener(function, module);
        try {
            function.typeCheck(module, null, new LinkedList());
        }
        catch (TypeCheckException typeCheckException) {
            System.out.println("======BROKE!======\n" + function);
            typeCheckException.printStackTrace();
            throw new ParserException(typeCheckException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("======BROKE nullpointer!======\n" + function);
            nullPointerException.printStackTrace();
            throw new ParserException(nullPointerException.getMessage());
        }
        function.standardizeTypes(true);
        function.reduce();
        this.streamFlattener.optimizeFunction(function);
        return function;
    }

    public void addImportDirectives(Collection collection) {
        this.m_importDirectives.addAll(collection);
    }

    public Collection getImportDirectives() {
        return this.m_importDirectives;
    }

    public static void main(String[] stringArray) {
        try {
            ParserSource parserSource = new ParserSource(new File(stringArray[0]).toURL());
            Parser parser = new Parser(new SearchPathSourceResolver(new LinkedList()), parserSource, new ModuleSignatureStore(new LinkedList()));
            VirtualDataTypeMap virtualDataTypeMap = parser.parseVDTMap();
            System.out.println(virtualDataTypeMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addAll(VirtualDataTypeMap virtualDataTypeMap) {
        for (Map.Entry entry : virtualDataTypeMap.m_mappings.entrySet()) {
            String string = (String)entry.getKey();
            ADTMapping aDTMapping = (ADTMapping)entry.getValue();
            this.addVDTMapping(string, aDTMapping);
        }
    }

    public Type getTargetType(String string) {
        if (!this.hasVDTMapping(string)) {
            return null;
        }
        return this.getVDTMapping((String)string).m_targetType;
    }

    public HashMap getTypeMap() {
        HashMap<NamedType, Type> hashMap = new HashMap<NamedType, Type>();
        for (String string : this.m_mappings.keySet()) {
            hashMap.put(new NamedType(string), this.getTargetType(string));
        }
        return hashMap;
    }

    public static class ADTMapping {
        public HashMap m_constructors = new HashMap();
        public Instruction m_matchCode;
        public Binding m_matchVariable;
        public Type m_targetType;
    }

    public static class ConstructorMapping {
        public Instruction m_constructCode;
        public Binding[] m_constructParameters;
        public Instruction m_deconstructCode;
        public Binding m_deconstructVariable;
    }
}

