/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.res.CharArrayWrapper;
import org.apache.xml.utils.res.IntArrayWrapper;
import org.apache.xml.utils.res.LongArrayWrapper;
import org.apache.xml.utils.res.StringArrayWrapper;
import org.apache.xml.utils.res.XResourceBundle;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemNumber
extends ElemTemplateElement {
    static final long serialVersionUID = 8118472298274407610L;
    private CharArrayWrapper m_alphaCountTable = null;
    private XPath m_countMatchPattern = null;
    private XPath m_fromMatchPattern = null;
    private int m_level = 1;
    private XPath m_valueExpr = null;
    private AVT m_format_avt = null;
    private AVT m_lang_avt = null;
    private AVT m_lettervalue_avt = null;
    private AVT m_groupingSeparator_avt = null;
    private AVT m_groupingSize_avt = null;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};

    public void setCount(XPath xPath) {
        this.m_countMatchPattern = xPath;
    }

    public XPath getCount() {
        return this.m_countMatchPattern;
    }

    public void setFrom(XPath xPath) {
        this.m_fromMatchPattern = xPath;
    }

    public XPath getFrom() {
        return this.m_fromMatchPattern;
    }

    public void setLevel(int n) {
        this.m_level = n;
    }

    public int getLevel() {
        return this.m_level;
    }

    public void setValue(XPath xPath) {
        this.m_valueExpr = xPath;
    }

    public XPath getValue() {
        return this.m_valueExpr;
    }

    public void setFormat(AVT aVT) {
        this.m_format_avt = aVT;
    }

    public AVT getFormat() {
        return this.m_format_avt;
    }

    public void setLang(AVT aVT) {
        this.m_lang_avt = aVT;
    }

    public AVT getLang() {
        return this.m_lang_avt;
    }

    public void setLetterValue(AVT aVT) {
        this.m_lettervalue_avt = aVT;
    }

    public AVT getLetterValue() {
        return this.m_lettervalue_avt;
    }

    public void setGroupingSeparator(AVT aVT) {
        this.m_groupingSeparator_avt = aVT;
    }

    public AVT getGroupingSeparator() {
        return this.m_groupingSeparator_avt;
    }

    public void setGroupingSize(AVT aVT) {
        this.m_groupingSize_avt = aVT;
    }

    public AVT getGroupingSize() {
        return this.m_groupingSize_avt;
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        StylesheetRoot.ComposeState composeState = stylesheetRoot.getComposeState();
        Vector vector = composeState.getVariableNames();
        if (null != this.m_countMatchPattern) {
            this.m_countMatchPattern.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_format_avt) {
            this.m_format_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_fromMatchPattern) {
            this.m_fromMatchPattern.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_groupingSeparator_avt) {
            this.m_groupingSeparator_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_groupingSize_avt) {
            this.m_groupingSize_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_lang_avt) {
            this.m_lang_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_lettervalue_avt) {
            this.m_lettervalue_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_valueExpr) {
            this.m_valueExpr.fixupVariables(vector, composeState.getGlobalsSize());
        }
    }

    public int getXSLToken() {
        return 35;
    }

    public String getNodeName() {
        return "number";
    }

    public void execute(TransformerImpl transformerImpl) throws TransformerException {
        if (transformerImpl.getDebug()) {
            transformerImpl.getTraceManager().fireTraceEvent(this);
        }
        int n = transformerImpl.getXPathContext().getCurrentNode();
        String string = this.getCountString(transformerImpl, n);
        try {
            transformerImpl.getResultTreeHandler().characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        finally {
            if (transformerImpl.getDebug()) {
                transformerImpl.getTraceManager().fireTraceEndEvent(this);
            }
        }
    }

    public ElemTemplateElement appendChild(ElemTemplateElement elemTemplateElement) {
        this.error("ER_CANNOT_ADD", new Object[]{elemTemplateElement.getNodeName(), this.getNodeName()});
        return null;
    }

    int findAncestor(XPathContext xPathContext, XPath xPath, XPath xPath2, int n, ElemNumber elemNumber) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        while (!(-1 == n || null != xPath && xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY || null != xPath2 && xPath2.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY)) {
            n = dTM.getParent(n);
        }
        return n;
    }

    private int findPrecedingOrAncestorOrSelf(XPathContext xPathContext, XPath xPath, XPath xPath2, int n, ElemNumber elemNumber) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        while (-1 != n) {
            if (null != xPath && xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) {
                n = -1;
                break;
            }
            if (null != xPath2 && xPath2.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) break;
            int n2 = dTM.getPreviousSibling(n);
            if (-1 == n2) {
                n = dTM.getParent(n);
                continue;
            }
            n = dTM.getLastChild(n2);
            if (n != -1) continue;
            n = n2;
        }
        return n;
    }

    XPath getCountMatchPattern(XPathContext xPathContext, int n) throws TransformerException {
        XPath xPath = this.m_countMatchPattern;
        DTM dTM = xPathContext.getDTM(n);
        if (null == xPath) {
            switch (dTM.getNodeType(n)) {
                case 1: {
                    MyPrefixResolver myPrefixResolver = dTM.getNamespaceURI(n) == null ? new MyPrefixResolver(dTM.getNode(n), dTM, n, false) : new MyPrefixResolver(dTM.getNode(n), dTM, n, true);
                    xPath = new XPath(dTM.getNodeName(n), this, myPrefixResolver, 1, xPathContext.getErrorListener());
                    break;
                }
                case 2: {
                    xPath = new XPath("@" + dTM.getNodeName(n), this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 3: 
                case 4: {
                    xPath = new XPath("text()", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 8: {
                    xPath = new XPath("comment()", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 9: {
                    xPath = new XPath("/", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 7: {
                    xPath = new XPath("pi(" + dTM.getNodeName(n) + ")", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                default: {
                    xPath = null;
                }
            }
        }
        return xPath;
    }

    String getCountString(TransformerImpl transformerImpl, int n) throws TransformerException {
        long[] lArray = null;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        CountersTable countersTable = transformerImpl.getCountersTable();
        if (null != this.m_valueExpr) {
            XObject xObject = this.m_valueExpr.execute(xPathContext, n, (PrefixResolver)this);
            double d = Math.floor(xObject.num() + 0.5);
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d < 0.0 && Double.isInfinite(d)) {
                return "-Infinity";
            }
            if (Double.isInfinite(d)) {
                return "Infinity";
            }
            if (d == 0.0) {
                return "0";
            }
            long l = (long)d;
            lArray = new long[]{l};
        } else if (3 == this.m_level) {
            lArray = new long[]{countersTable.countNode(xPathContext, this, n)};
        } else {
            NodeVector nodeVector = this.getMatchingAncestors(xPathContext, n, 1 == this.m_level);
            int n2 = nodeVector.size() - 1;
            if (n2 >= 0) {
                lArray = new long[n2 + 1];
                for (int i = n2; i >= 0; --i) {
                    int n3 = nodeVector.elementAt(i);
                    lArray[n2 - i] = countersTable.countNode(xPathContext, this, n3);
                }
            }
        }
        return null != lArray ? this.formatNumberList(transformerImpl, lArray, n) : "";
    }

    public int getPreviousNode(XPathContext xPathContext, int n) throws TransformerException {
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        DTM dTM = xPathContext.getDTM(n);
        if (3 == this.m_level) {
            XPath xPath2 = this.m_fromMatchPattern;
            while (-1 != n) {
                int n2 = dTM.getPreviousSibling(n);
                if (-1 == n2) {
                    n2 = dTM.getParent(n);
                    if (-1 != n2 && (null != xPath2 && xPath2.getMatchScore(xPathContext, n2) != Double.NEGATIVE_INFINITY || dTM.getNodeType(n2) == 9)) {
                        n = -1;
                        break;
                    }
                } else {
                    int n3 = n2;
                    while (-1 != n3) {
                        n3 = dTM.getLastChild(n2);
                        if (-1 == n3) continue;
                        n2 = n3;
                    }
                }
                if (-1 == (n = n2) || null != xPath && xPath.getMatchScore(xPathContext, n) == Double.NEGATIVE_INFINITY) continue;
                break;
            }
        } else {
            while (-1 != n && (-1 == (n = dTM.getPreviousSibling(n)) || null != xPath && xPath.getMatchScore(xPathContext, n) == Double.NEGATIVE_INFINITY)) {
            }
        }
        return n;
    }

    public int getTargetNode(XPathContext xPathContext, int n) throws TransformerException {
        int n2 = -1;
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        n2 = 3 == this.m_level ? this.findPrecedingOrAncestorOrSelf(xPathContext, this.m_fromMatchPattern, xPath, n, this) : this.findAncestor(xPathContext, this.m_fromMatchPattern, xPath, n, this);
        return n2;
    }

    NodeVector getMatchingAncestors(XPathContext xPathContext, int n, boolean bl) throws TransformerException {
        NodeSetDTM nodeSetDTM = new NodeSetDTM(xPathContext.getDTMManager());
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        DTM dTM = xPathContext.getDTM(n);
        while (-1 != n && (null == this.m_fromMatchPattern || this.m_fromMatchPattern.getMatchScore(xPathContext, n) == Double.NEGATIVE_INFINITY || bl)) {
            if (null == xPath) {
                System.out.println("Programmers error! countMatchPattern should never be null!");
            }
            if (xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) {
                nodeSetDTM.addElement(n);
                if (bl) break;
            }
            n = dTM.getParent(n);
        }
        return nodeSetDTM;
    }

    Locale getLocale(TransformerImpl transformerImpl, int n) throws TransformerException {
        Locale locale = null;
        if (null != this.m_lang_avt) {
            XPathContext xPathContext = transformerImpl.getXPathContext();
            String string = this.m_lang_avt.evaluate(xPathContext, n, this);
            if (null != string && null == (locale = new Locale(string.toUpperCase(), ""))) {
                transformerImpl.getMsgMgr().warn(this, null, xPathContext.getDTM(n).getNode(n), "WG_LOCALE_NOT_FOUND", new Object[]{string});
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private DecimalFormat getNumberFormatter(TransformerImpl transformerImpl, int n) throws TransformerException {
        String string;
        String string2;
        Locale locale = (Locale)this.getLocale(transformerImpl, n).clone();
        DecimalFormat decimalFormat = null;
        String string3 = string2 = null != this.m_groupingSeparator_avt ? this.m_groupingSeparator_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        if (string2 != null && !this.m_groupingSeparator_avt.isSimple() && string2.length() != 1) {
            transformerImpl.getMsgMgr().warn(this, "WG_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{"name", this.m_groupingSeparator_avt.getName()});
        }
        String string4 = string = null != this.m_groupingSize_avt ? this.m_groupingSize_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        if (null != string2 && null != string && string2.length() > 0) {
            try {
                decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                decimalFormat.setGroupingSize(Integer.valueOf(string));
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                decimalFormatSymbols.setGroupingSeparator(string2.charAt(0));
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                decimalFormat.setGroupingUsed(true);
            }
            catch (NumberFormatException numberFormatException) {
                decimalFormat.setGroupingUsed(false);
            }
        }
        return decimalFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String formatNumberList(TransformerImpl transformerImpl, long[] lArray, int n) throws TransformerException {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            String string2;
            String string3;
            int n2 = lArray.length;
            int n3 = 1;
            char c = '1';
            String string4 = null;
            String string5 = null;
            String string6 = ".";
            boolean bl = true;
            String string7 = string3 = null != this.m_format_avt ? this.m_format_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
            if (null == string3) {
                string3 = "1";
            }
            NumberFormatStringTokenizer numberFormatStringTokenizer = new NumberFormatStringTokenizer(string3);
            for (int i = 0; i < n2; ++i) {
                if (numberFormatStringTokenizer.hasMoreTokens()) {
                    string2 = numberFormatStringTokenizer.nextToken();
                    if (Character.isLetterOrDigit(string2.charAt(string2.length() - 1))) {
                        n3 = string2.length();
                        c = string2.charAt(n3 - 1);
                    } else if (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                        string5 = string2;
                        while (numberFormatStringTokenizer.nextIsSep()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string5 = string5 + string2;
                        }
                        if (!bl) {
                            string6 = string5;
                        }
                        string2 = numberFormatStringTokenizer.nextToken();
                        n3 = string2.length();
                        c = string2.charAt(n3 - 1);
                    } else {
                        string4 = string2;
                        while (numberFormatStringTokenizer.hasMoreTokens()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string4 = string4 + string2;
                        }
                    }
                }
                if (null != string5 && bl) {
                    fastStringBuffer.append(string5);
                } else if (null != string6 && !bl) {
                    fastStringBuffer.append(string6);
                }
                this.getFormattedNumber(transformerImpl, n, c, n3, lArray[i], fastStringBuffer);
                bl = false;
            }
            while (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                numberFormatStringTokenizer.nextToken();
            }
            if (string4 != null) {
                fastStringBuffer.append(string4);
            }
            while (numberFormatStringTokenizer.hasMoreTokens()) {
                string2 = numberFormatStringTokenizer.nextToken();
                fastStringBuffer.append(string2);
            }
            string = fastStringBuffer.toString();
        }
        finally {
            StringBufferPool.free(fastStringBuffer);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFormattedNumber(TransformerImpl transformerImpl, int n, char c, int n2, long l, FastStringBuffer fastStringBuffer) throws TransformerException {
        String string = this.m_lettervalue_avt != null ? this.m_lettervalue_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        Object var9_8 = null;
        XResourceBundle xResourceBundle = null;
        switch (c) {
            case 'A': {
                if (null == this.m_alphaCountTable) {
                    xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformerImpl, n));
                    this.m_alphaCountTable = (CharArrayWrapper)xResourceBundle.getObject("alphabet");
                }
                this.int2alphaCount(l, this.m_alphaCountTable, fastStringBuffer);
                break;
            }
            case 'a': {
                if (null == this.m_alphaCountTable) {
                    xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformerImpl, n));
                    this.m_alphaCountTable = (CharArrayWrapper)xResourceBundle.getObject("alphabet");
                }
                FastStringBuffer fastStringBuffer2 = StringBufferPool.get();
                try {
                    this.int2alphaCount(l, this.m_alphaCountTable, fastStringBuffer2);
                    fastStringBuffer.append(fastStringBuffer2.toString().toLowerCase(this.getLocale(transformerImpl, n)));
                    break;
                }
                finally {
                    StringBufferPool.free(fastStringBuffer2);
                }
            }
            case 'I': {
                fastStringBuffer.append(this.long2roman(l, true));
                break;
            }
            case 'i': {
                fastStringBuffer.append(this.long2roman(l, true).toLowerCase(this.getLocale(transformerImpl, n)));
                break;
            }
            case '\u3042': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HA"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u3044': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HI"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a2': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "A"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a4': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "I"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u4e00': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "CN"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u58f9': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "TW"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0e51': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("th", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u05d0': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("he", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u10d0': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ka", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u03b1': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("el", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0430': {
                xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("cy", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (CharArrayWrapper)xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            default: {
                DecimalFormat decimalFormat = this.getNumberFormatter(transformerImpl, n);
                String string2 = decimalFormat == null ? String.valueOf(0) : decimalFormat.format(0L);
                String string3 = decimalFormat == null ? String.valueOf(l) : decimalFormat.format(l);
                int n3 = n2 - string3.length();
                for (int i = 0; i < n3; ++i) {
                    fastStringBuffer.append(string2);
                }
                fastStringBuffer.append(string3);
            }
        }
    }

    String getZeroString() {
        return "0";
    }

    protected String int2singlealphaCount(long l, CharArrayWrapper charArrayWrapper) {
        int n = charArrayWrapper.getLength();
        if (l > (long)n) {
            return this.getZeroString();
        }
        return new Character(charArrayWrapper.getChar((int)l - 1)).toString();
    }

    protected void int2alphaCount(long l, CharArrayWrapper charArrayWrapper, FastStringBuffer fastStringBuffer) {
        int n;
        int n2 = charArrayWrapper.getLength();
        char[] cArray = new char[n2];
        for (n = 0; n < n2 - 1; ++n) {
            cArray[n + 1] = charArrayWrapper.getChar(n);
        }
        cArray[0] = charArrayWrapper.getChar(n);
        char[] cArray2 = new char[100];
        int n3 = cArray2.length - 1;
        int n4 = 1;
        long l2 = 0L;
        while ((n4 = (int)(l + (l2 = n4 == 0 || l2 != 0L && n4 == n2 - 1 ? (long)(n2 - 1) : 0L)) % n2) != 0 || (l /= (long)n2) != 0L) {
            cArray2[n3--] = cArray[n4];
            if (l > 0L) continue;
        }
        fastStringBuffer.append(cArray2, n3 + 1, cArray2.length - n3 - 1);
    }

    protected String tradAlphaCount(long l, XResourceBundle xResourceBundle) {
        int n;
        CharArrayWrapper charArrayWrapper;
        if (l > Long.MAX_VALUE) {
            this.error("ER_NUMBER_TOO_BIG");
            return "#error";
        }
        char[] cArray = null;
        int n2 = 1;
        char[] cArray2 = new char[100];
        int n3 = 0;
        IntArrayWrapper intArrayWrapper = (IntArrayWrapper)xResourceBundle.getObject("numberGroups");
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)xResourceBundle.getObject("tables");
        String string = xResourceBundle.getString("numbering");
        if (string.equals("multiplicative-additive")) {
            String string2 = xResourceBundle.getString("multiplierOrder");
            LongArrayWrapper longArrayWrapper = (LongArrayWrapper)xResourceBundle.getObject("multiplier");
            charArrayWrapper = (CharArrayWrapper)xResourceBundle.getObject("zero");
            for (n = 0; n < longArrayWrapper.getLength() && l < longArrayWrapper.getLong(n); ++n) {
            }
            while (n < longArrayWrapper.getLength()) {
                if (l < longArrayWrapper.getLong(n)) {
                    if (charArrayWrapper.getLength() == 0) {
                        ++n;
                    } else {
                        if (cArray2[n3 - 1] != charArrayWrapper.getChar(0)) {
                            cArray2[n3++] = charArrayWrapper.getChar(0);
                        }
                        ++n;
                    }
                } else if (l >= longArrayWrapper.getLong(n)) {
                    long l2 = l / longArrayWrapper.getLong(n);
                    l %= longArrayWrapper.getLong(n);
                    for (int i = 0; i < intArrayWrapper.getLength(); ++i) {
                        int n4;
                        n2 = 1;
                        if (l2 / (long)intArrayWrapper.getInt(i) <= 0L) {
                            continue;
                        }
                        CharArrayWrapper charArrayWrapper2 = (CharArrayWrapper)xResourceBundle.getObject(stringArrayWrapper.getString(i));
                        cArray = new char[charArrayWrapper2.getLength() + 1];
                        for (n4 = 0; n4 < charArrayWrapper2.getLength(); ++n4) {
                            cArray[n4 + 1] = charArrayWrapper2.getChar(n4);
                        }
                        cArray[0] = charArrayWrapper2.getChar(n4 - 1);
                        n2 = (int)l2 / intArrayWrapper.getInt(i);
                        if (n2 == 0 && l2 == 0L) break;
                        char c = ((CharArrayWrapper)xResourceBundle.getObject("multiplierChar")).getChar(n);
                        if (n2 < cArray.length) {
                            if (string2.equals("precedes")) {
                                cArray2[n3++] = c;
                                cArray2[n3++] = cArray[n2];
                                break;
                            }
                            if (n2 != 1 || n != longArrayWrapper.getLength() - 1) {
                                cArray2[n3++] = cArray[n2];
                            }
                            cArray2[n3++] = c;
                            break;
                        }
                        return "#error";
                    }
                    ++n;
                }
                if (n < longArrayWrapper.getLength()) continue;
            }
        }
        int n5 = 0;
        while (n5 < intArrayWrapper.getLength()) {
            if (l / (long)intArrayWrapper.getInt(n5) <= 0L) {
                ++n5;
                continue;
            }
            charArrayWrapper = (CharArrayWrapper)xResourceBundle.getObject(stringArrayWrapper.getString(n5));
            cArray = new char[charArrayWrapper.getLength() + 1];
            for (n = 0; n < charArrayWrapper.getLength(); ++n) {
                cArray[n + 1] = charArrayWrapper.getChar(n);
            }
            cArray[0] = charArrayWrapper.getChar(n - 1);
            n2 = (int)l / intArrayWrapper.getInt(n5);
            if (n2 == 0 && (l %= (long)intArrayWrapper.getInt(n5)) == 0L) break;
            if (n2 >= cArray.length) {
                return "#error";
            }
            cArray2[n3++] = cArray[n2];
            ++n5;
        }
        return new String(cArray2, 0, n3);
    }

    protected String long2roman(long l, boolean bl) {
        if (l <= 0L) {
            return this.getZeroString();
        }
        String string = "";
        int n = 0;
        if (l <= 3999L) {
            while (true) {
                if (l >= ElemNumber.m_romanConvertTable[n].m_postValue) {
                    string = string + ElemNumber.m_romanConvertTable[n].m_postLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_postValue;
                    continue;
                }
                if (bl && l >= ElemNumber.m_romanConvertTable[n].m_preValue) {
                    string = string + ElemNumber.m_romanConvertTable[n].m_preLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_preValue;
                }
                ++n;
                if (l <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    public void callChildVisitors(XSLTVisitor xSLTVisitor, boolean bl) {
        if (bl) {
            if (null != this.m_countMatchPattern) {
                this.m_countMatchPattern.getExpression().callVisitors(this.m_countMatchPattern, xSLTVisitor);
            }
            if (null != this.m_fromMatchPattern) {
                this.m_fromMatchPattern.getExpression().callVisitors(this.m_fromMatchPattern, xSLTVisitor);
            }
            if (null != this.m_valueExpr) {
                this.m_valueExpr.getExpression().callVisitors(this.m_valueExpr, xSLTVisitor);
            }
            if (null != this.m_format_avt) {
                this.m_format_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_groupingSeparator_avt) {
                this.m_groupingSeparator_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_groupingSize_avt) {
                this.m_groupingSize_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_lang_avt) {
                this.m_lang_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_lettervalue_avt) {
                this.m_lettervalue_avt.callVisitors(xSLTVisitor);
            }
        }
        super.callChildVisitors(xSLTVisitor, bl);
    }

    private class MyPrefixResolver
    implements PrefixResolver {
        DTM dtm;
        int handle;
        boolean handleNullPrefix;

        public MyPrefixResolver(Node node, DTM dTM, int n, boolean bl) {
            this.dtm = dTM;
            this.handle = n;
            this.handleNullPrefix = bl;
        }

        public String getNamespaceForPrefix(String string) {
            return this.dtm.getNamespaceURI(this.handle);
        }

        public String getNamespaceForPrefix(String string, Node node) {
            return this.getNamespaceForPrefix(string);
        }

        public String getBaseIdentifier() {
            return ElemNumber.this.getBaseIdentifier();
        }

        public boolean handlesNullPrefixes() {
            return this.handleNullPrefix;
        }
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String string) {
            this.str = string;
            this.maxPosition = string.length();
        }

        public void reset() {
            this.currentPosition = 0;
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n, this.currentPosition);
        }

        public boolean isLetterOrDigitAhead() {
            for (int i = this.currentPosition; i < this.maxPosition; ++i) {
                if (!Character.isLetterOrDigit(this.str.charAt(i))) continue;
                return true;
            }
            return false;
        }

        public boolean nextIsSep() {
            return !Character.isLetterOrDigit(this.str.charAt(this.currentPosition));
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public int countTokens() {
            int n = 0;
            int n2 = this.currentPosition;
            while (n2 < this.maxPosition) {
                int n3 = n2;
                while (n2 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                if (n3 == n2 && !Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                ++n;
            }
            return n;
        }
    }
}

