/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;

public class ElemUse
extends ElemTemplateElement {
    static final long serialVersionUID = 5830057200289299736L;
    private QName[] m_attributeSetsNames = null;

    public void setUseAttributeSets(Vector vector) {
        int n = vector.size();
        this.m_attributeSetsNames = new QName[n];
        for (int i = 0; i < n; ++i) {
            this.m_attributeSetsNames[i] = (QName)vector.elementAt(i);
        }
    }

    public void setUseAttributeSets(QName[] qNameArray) {
        this.m_attributeSetsNames = qNameArray;
    }

    public QName[] getUseAttributeSets() {
        return this.m_attributeSetsNames;
    }

    public void applyAttrSets(TransformerImpl transformerImpl, StylesheetRoot stylesheetRoot) throws TransformerException {
        this.applyAttrSets(transformerImpl, stylesheetRoot, this.m_attributeSetsNames);
    }

    private void applyAttrSets(TransformerImpl transformerImpl, StylesheetRoot stylesheetRoot, QName[] qNameArray) throws TransformerException {
        if (null != qNameArray) {
            for (QName qName : qNameArray) {
                Vector vector = stylesheetRoot.getAttributeSetComposed(qName);
                if (null != vector) {
                    int n = vector.size();
                    for (int i = n - 1; i >= 0; --i) {
                        ElemAttributeSet elemAttributeSet = (ElemAttributeSet)vector.elementAt(i);
                        elemAttributeSet.execute(transformerImpl);
                    }
                    continue;
                }
                throw new TransformerException(XSLMessages.createMessage("ER_NO_ATTRIB_SET", new Object[]{qName}), this);
            }
        }
    }

    public void execute(TransformerImpl transformerImpl) throws TransformerException {
        if (null != this.m_attributeSetsNames) {
            this.applyAttrSets(transformerImpl, this.getStylesheetRoot(), this.m_attributeSetsNames);
        }
    }
}

