/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;

public class StylesheetComposed
extends Stylesheet {
    static final long serialVersionUID = -3444072247410233923L;
    private int m_importNumber = -1;
    private int m_importCountComposed;
    private int m_endImportCountComposed;
    private transient Vector m_includesComposed;

    public StylesheetComposed(Stylesheet stylesheet) {
        super(stylesheet);
    }

    public boolean isAggregatedType() {
        return true;
    }

    public void recompose(Vector vector) throws TransformerException {
        int n = this.getIncludeCountComposed();
        for (int i = -1; i < n; ++i) {
            int n2;
            Stylesheet stylesheet = this.getIncludeComposed(i);
            int n3 = stylesheet.getOutputCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getOutput(n2));
            }
            n3 = stylesheet.getAttributeSetCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getAttributeSet(n2));
            }
            n3 = stylesheet.getDecimalFormatCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getDecimalFormat(n2));
            }
            n3 = stylesheet.getKeyCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getKey(n2));
            }
            n3 = stylesheet.getNamespaceAliasCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getNamespaceAlias(n2));
            }
            n3 = stylesheet.getTemplateCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getTemplate(n2));
            }
            n3 = stylesheet.getVariableOrParamCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getVariableOrParam(n2));
            }
            n3 = stylesheet.getStripSpaceCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getStripSpace(n2));
            }
            n3 = stylesheet.getPreserveSpaceCount();
            for (n2 = 0; n2 < n3; ++n2) {
                vector.addElement(stylesheet.getPreserveSpace(n2));
            }
        }
    }

    void recomposeImports() {
        this.m_importNumber = this.getStylesheetRoot().getImportNumber(this);
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        int n = stylesheetRoot.getGlobalImportCount();
        this.m_importCountComposed = n - this.m_importNumber - 1;
        int n2 = this.getImportCount();
        if (n2 > 0) {
            this.m_endImportCountComposed += n2;
            while (n2 > 0) {
                this.m_endImportCountComposed += this.getImport(--n2).getEndImportCountComposed();
            }
        }
        n2 = this.getIncludeCountComposed();
        while (n2 > 0) {
            int n3 = this.getIncludeComposed(--n2).getImportCount();
            this.m_endImportCountComposed += n3;
            while (n3 > 0) {
                this.m_endImportCountComposed += this.getIncludeComposed(n2).getImport(--n3).getEndImportCountComposed();
            }
        }
    }

    public StylesheetComposed getImportComposed(int n) throws ArrayIndexOutOfBoundsException {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return stylesheetRoot.getGlobalImport(1 + this.m_importNumber + n);
    }

    public int getImportCountComposed() {
        return this.m_importCountComposed;
    }

    public int getEndImportCountComposed() {
        return this.m_endImportCountComposed;
    }

    void recomposeIncludes(Stylesheet stylesheet) {
        int n = stylesheet.getIncludeCount();
        if (n > 0) {
            if (null == this.m_includesComposed) {
                this.m_includesComposed = new Vector();
            }
            for (int i = 0; i < n; ++i) {
                Stylesheet stylesheet2 = stylesheet.getInclude(i);
                this.m_includesComposed.addElement(stylesheet2);
                this.recomposeIncludes(stylesheet2);
            }
        }
    }

    public Stylesheet getIncludeComposed(int n) throws ArrayIndexOutOfBoundsException {
        if (-1 == n) {
            return this;
        }
        if (null == this.m_includesComposed) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Stylesheet)this.m_includesComposed.elementAt(n);
    }

    public int getIncludeCountComposed() {
        return null != this.m_includesComposed ? this.m_includesComposed.size() : 0;
    }

    public void recomposeTemplates(boolean bl) throws TransformerException {
    }
}

