/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.apache.xerces.util.PrimeNumberSequenceGenerator;
import org.apache.xerces.util.SymbolTable;

public class SoftReferenceSymbolTable
extends SymbolTable {
    protected SREntry[] fBuckets = null;
    private final ReferenceQueue fReferenceQueue;

    public SoftReferenceSymbolTable(int n, float f) {
        super(1, f);
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.fLoadFactor = f;
        this.fTableSize = n;
        this.fBuckets = new SREntry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * f);
        this.fCount = 0;
        this.fReferenceQueue = new ReferenceQueue();
    }

    public SoftReferenceSymbolTable(int n) {
        this(n, 0.75f);
    }

    public SoftReferenceSymbolTable() {
        this(101, 0.75f);
    }

    public String addSymbol(String string) {
        Object object;
        this.clean();
        int n = 0;
        int n2 = this.hash(string) % this.fTableSize;
        SREntry sREntry = this.fBuckets[n2];
        while (sREntry != null) {
            object = (SREntryData)sREntry.get();
            if (object != null) {
                if (((SREntryData)object).symbol.equals(string)) {
                    return ((SREntryData)object).symbol;
                }
                ++n;
            }
            sREntry = sREntry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n2 = this.hash(string) % this.fTableSize;
        } else if (n >= this.fCollisionThreshold) {
            this.rebalance();
            n2 = this.hash(string) % this.fTableSize;
        }
        string = string.intern();
        this.fBuckets[n2] = object = new SREntry(string, this.fBuckets[n2], n2, this.fReferenceQueue);
        ++this.fCount;
        return string;
    }

    public String addSymbol(char[] cArray, int n, int n2) {
        SREntry sREntry;
        Object object;
        this.clean();
        int n3 = 0;
        int n4 = this.hash(cArray, n, n2) % this.fTableSize;
        SREntry sREntry2 = this.fBuckets[n4];
        while (sREntry2 != null) {
            block8: {
                object = (SREntryData)sREntry2.get();
                if (object != null) {
                    if (n2 == ((SREntryData)object).characters.length) {
                        int n5 = 0;
                        while (n5 < n2) {
                            if (cArray[n + n5] != ((SREntryData)object).characters[n5]) {
                                ++n3;
                                break block8;
                            }
                            ++n5;
                        }
                        return ((SREntryData)object).symbol;
                    }
                    ++n3;
                }
            }
            sREntry2 = sREntry2.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n4 = this.hash(cArray, n, n2) % this.fTableSize;
        } else if (n3 >= this.fCollisionThreshold) {
            this.rebalance();
            n4 = this.hash(cArray, n, n2) % this.fTableSize;
        }
        object = new String(cArray, n, n2).intern();
        this.fBuckets[n4] = sREntry = new SREntry((String)object, cArray, n, n2, this.fBuckets[n4], n4, this.fReferenceQueue);
        ++this.fCount;
        return object;
    }

    protected void rehash() {
        this.rehashCommon(this.fBuckets.length * 2 + 1);
    }

    protected void compact() {
        this.rehashCommon((int)((float)this.fCount / this.fLoadFactor) * 2 + 1);
    }

    protected void rebalance() {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[32];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.rehashCommon(this.fBuckets.length);
    }

    private void rehashCommon(int n) {
        int n2 = this.fBuckets.length;
        SREntry[] sREntryArray = this.fBuckets;
        SREntry[] sREntryArray2 = new SREntry[n];
        this.fThreshold = (int)((float)n * this.fLoadFactor);
        this.fBuckets = sREntryArray2;
        this.fTableSize = this.fBuckets.length;
        int n3 = n2;
        while (n3-- > 0) {
            SREntry sREntry = sREntryArray[n3];
            while (sREntry != null) {
                SREntry sREntry2 = sREntry;
                sREntry = sREntry.next;
                SREntryData sREntryData = (SREntryData)sREntry2.get();
                if (sREntryData != null) {
                    int n4 = this.hash(sREntryData.symbol) % n;
                    if (sREntryArray2[n4] != null) {
                        sREntryArray2[n4].prev = sREntry2;
                    }
                    sREntry2.bucket = n4;
                    sREntry2.next = sREntryArray2[n4];
                    sREntryArray2[n4] = sREntry2;
                } else {
                    sREntry2.bucket = -1;
                    sREntry2.next = null;
                    --this.fCount;
                }
                sREntry2.prev = null;
            }
        }
    }

    public boolean containsSymbol(String string) {
        int n = this.hash(string) % this.fTableSize;
        int n2 = string.length();
        SREntry sREntry = this.fBuckets[n];
        while (sREntry != null) {
            block4: {
                SREntryData sREntryData = (SREntryData)sREntry.get();
                if (sREntryData != null && n2 == sREntryData.characters.length) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (string.charAt(n3) == sREntryData.characters[n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            sREntry = sREntry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n, int n2) {
        int n3 = this.hash(cArray, n, n2) % this.fTableSize;
        SREntry sREntry = this.fBuckets[n3];
        while (sREntry != null) {
            block4: {
                SREntryData sREntryData = (SREntryData)sREntry.get();
                if (sREntryData != null && n2 == sREntryData.characters.length) {
                    int n4 = 0;
                    while (n4 < n2) {
                        if (cArray[n + n4] == sREntryData.characters[n4]) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            sREntry = sREntry.next;
        }
        return false;
    }

    private void removeEntry(SREntry sREntry) {
        int n = sREntry.bucket;
        if (n >= 0) {
            if (sREntry.next != null) {
                sREntry.next.prev = sREntry.prev;
            }
            if (sREntry.prev != null) {
                sREntry.prev.next = sREntry.next;
            } else {
                this.fBuckets[n] = sREntry.next;
            }
            --this.fCount;
        }
    }

    private void clean() {
        SREntry sREntry = (SREntry)this.fReferenceQueue.poll();
        if (sREntry != null) {
            do {
                this.removeEntry(sREntry);
            } while ((sREntry = (SREntry)this.fReferenceQueue.poll()) != null);
            if (this.fCount < this.fThreshold >> 2) {
                this.compact();
            }
        }
    }

    protected static final class SREntry
    extends SoftReference {
        public SREntry next;
        public SREntry prev;
        public int bucket;

        public SREntry(String string, SREntry sREntry, int n, ReferenceQueue referenceQueue) {
            super(new SREntryData(string), referenceQueue);
            this.initialize(sREntry, n);
        }

        public SREntry(String string, char[] cArray, int n, int n2, SREntry sREntry, int n3, ReferenceQueue referenceQueue) {
            super(new SREntryData(string, cArray, n, n2), referenceQueue);
            this.initialize(sREntry, n3);
        }

        private void initialize(SREntry sREntry, int n) {
            this.next = sREntry;
            if (sREntry != null) {
                sREntry.prev = this;
            }
            this.prev = null;
            this.bucket = n;
        }
    }

    protected static final class SREntryData {
        public final String symbol;
        public final char[] characters;

        public SREntryData(String string) {
            this.symbol = string;
            this.characters = new char[this.symbol.length()];
            this.symbol.getChars(0, this.characters.length, this.characters, 0);
        }

        public SREntryData(String string, char[] cArray, int n, int n2) {
            this.symbol = string;
            this.characters = new char[n2];
            System.arraycopy(cArray, n, this.characters, 0, n2);
        }
    }
}

