/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseTraversers
extends DTMDefaultBase {
    public DTMDefaultBaseTraversers(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        super(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl);
    }

    public DTMDefaultBaseTraversers(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl, int n2, boolean bl2, boolean bl3) {
        super(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl, n2, bl2, bl3);
    }

    public DTMAxisTraverser getAxisTraverser(int n) {
        DTMAxisTraverser dTMAxisTraverser;
        if (null == this.m_traversers) {
            this.m_traversers = new DTMAxisTraverser[Axis.getNamesLength()];
            dTMAxisTraverser = null;
        } else {
            dTMAxisTraverser = this.m_traversers[n];
            if (dTMAxisTraverser != null) {
                return dTMAxisTraverser;
            }
        }
        switch (n) {
            case 0: {
                dTMAxisTraverser = new AncestorTraverser();
                break;
            }
            case 1: {
                dTMAxisTraverser = new AncestorOrSelfTraverser();
                break;
            }
            case 2: {
                dTMAxisTraverser = new AttributeTraverser();
                break;
            }
            case 3: {
                dTMAxisTraverser = new ChildTraverser();
                break;
            }
            case 4: {
                dTMAxisTraverser = new DescendantTraverser();
                break;
            }
            case 5: {
                dTMAxisTraverser = new DescendantOrSelfTraverser();
                break;
            }
            case 6: {
                dTMAxisTraverser = new FollowingTraverser();
                break;
            }
            case 7: {
                dTMAxisTraverser = new FollowingSiblingTraverser();
                break;
            }
            case 9: {
                dTMAxisTraverser = new NamespaceTraverser();
                break;
            }
            case 8: {
                dTMAxisTraverser = new NamespaceDeclsTraverser();
                break;
            }
            case 10: {
                dTMAxisTraverser = new ParentTraverser();
                break;
            }
            case 11: {
                dTMAxisTraverser = new PrecedingTraverser();
                break;
            }
            case 12: {
                dTMAxisTraverser = new PrecedingSiblingTraverser();
                break;
            }
            case 13: {
                dTMAxisTraverser = new SelfTraverser();
                break;
            }
            case 16: {
                dTMAxisTraverser = new AllFromRootTraverser();
                break;
            }
            case 14: {
                dTMAxisTraverser = new AllFromNodeTraverser();
                break;
            }
            case 15: {
                dTMAxisTraverser = new PrecedingAndAncestorTraverser();
                break;
            }
            case 17: {
                dTMAxisTraverser = new DescendantFromRootTraverser();
                break;
            }
            case 18: {
                dTMAxisTraverser = new DescendantOrSelfFromRootTraverser();
                break;
            }
            case 19: {
                dTMAxisTraverser = new RootTraverser();
                break;
            }
            case 20: {
                return null;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage("ER_UNKNOWN_AXIS_TYPE", new Object[]{Integer.toString(n)}));
            }
        }
        if (null == dTMAxisTraverser) {
            throw new DTMException(XMLMessages.createXMLMessage("ER_AXIS_TRAVERSER_NOT_SUPPORTED", new Object[]{Axis.getNames(n)}));
        }
        this.m_traversers[n] = dTMAxisTraverser;
        return dTMAxisTraverser;
    }

    private class AllFromNodeTraverser
    extends DescendantOrSelfTraverser {
        private AllFromNodeTraverser() {
        }

        public int next(int n, int n2) {
            int n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) + 1;
            DTMDefaultBaseTraversers.this._exptype(n2);
            if (!this.isDescendant(n3, n2)) {
                return -1;
            }
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
        }
    }

    private class AllFromRootTraverser
    extends AllFromNodeTraverser {
        private AllFromRootTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.getDocumentRoot(n);
        }

        public int first(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(DTMDefaultBaseTraversers.this.getDocumentRoot(n)) == n2 ? n : this.next(n, n, n2);
        }

        public int next(int n, int n2) {
            int n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            short s = DTMDefaultBaseTraversers.this._type(n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) + 1);
            if (s == -1) {
                return -1;
            }
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
        }

        public int next(int n, int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) + 1;
            int n5;
            while ((n5 = DTMDefaultBaseTraversers.this._exptype(n2)) != -1) {
                if (n5 == n3) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
                }
                ++n2;
            }
            return -1;
        }
    }

    private class AncestorOrSelfTraverser
    extends AncestorTraverser {
        private AncestorOrSelfTraverser() {
        }

        public int first(int n) {
            return n;
        }

        public int first(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(n) == n2 ? n : this.next(n, n, n2);
        }
    }

    private class AncestorTraverser
    extends DTMAxisTraverser {
        private AncestorTraverser() {
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getParent(n2);
        }

        public int next(int n, int n2, int n3) {
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            while (-1 != (n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            return -1;
        }
    }

    private class AttributeTraverser
    extends DTMAxisTraverser {
        private AttributeTraverser() {
        }

        public int next(int n, int n2) {
            return n == n2 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n) : DTMDefaultBaseTraversers.this.getNextAttribute(n2);
        }

        public int next(int n, int n2, int n3) {
            int n4 = n2 = n == n2 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n) : DTMDefaultBaseTraversers.this.getNextAttribute(n2);
            do {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) != n3) continue;
                return n2;
            } while (-1 != (n2 = DTMDefaultBaseTraversers.this.getNextAttribute(n2)));
            return -1;
        }
    }

    private class ChildTraverser
    extends DTMAxisTraverser {
        private ChildTraverser() {
        }

        protected int getNextIndexed(int n, int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getNamespaceID(n3);
            int n5 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getLocalNameID(n3);
            while (true) {
                int n6;
                if (-2 != (n6 = DTMDefaultBaseTraversers.this.findElementFromIndex(n4, n5, n2))) {
                    int n7 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n6);
                    if (n7 == n) {
                        return n6;
                    }
                    if (n7 < n) {
                        return -1;
                    }
                    do {
                        if ((n7 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n7)) >= n) continue;
                        return -1;
                    } while (n7 > n);
                    n2 = n6 + 1;
                    continue;
                }
                DTMDefaultBaseTraversers.this.nextNode();
                if (DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n) != -2) break;
            }
            return -1;
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.getFirstChild(n);
        }

        public int first(int n, int n2) {
            int n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            int n4 = this.getNextIndexed(n3, DTMDefaultBaseTraversers.this._firstch(n3), n2);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n4);
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getNextSibling(n2);
        }

        public int next(int n, int n2, int n3) {
            n2 = DTMDefaultBaseTraversers.this._nextsib(DTMDefaultBaseTraversers.this.makeNodeIdentity(n2));
            while (-1 != n2) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) == n3) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
                }
                n2 = DTMDefaultBaseTraversers.this._nextsib(n2);
            }
            return -1;
        }
    }

    private class DescendantFromRootTraverser
    extends DescendantTraverser {
        private DescendantFromRootTraverser() {
        }

        protected int getFirstPotential(int n) {
            return DTMDefaultBaseTraversers.this._firstch(0);
        }

        protected int getSubtreeRoot(int n) {
            return 0;
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.makeNodeHandle(DTMDefaultBaseTraversers.this._firstch(0));
        }

        public int first(int n, int n2) {
            if (this.isIndexed(n2)) {
                int n3 = 0;
                int n4 = this.getFirstPotential(n3);
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n3, n4, n2));
            }
            int n5 = DTMDefaultBaseTraversers.this.getDocumentRoot(n);
            return this.next(n5, n5, n2);
        }
    }

    private class DescendantOrSelfFromRootTraverser
    extends DescendantTraverser {
        private DescendantOrSelfFromRootTraverser() {
        }

        protected int getFirstPotential(int n) {
            return n;
        }

        protected int getSubtreeRoot(int n) {
            return DTMDefaultBaseTraversers.this.makeNodeIdentity(DTMDefaultBaseTraversers.this.getDocument());
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.getDocumentRoot(n);
        }

        public int first(int n, int n2) {
            if (this.isIndexed(n2)) {
                int n3 = 0;
                int n4 = this.getFirstPotential(n3);
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n3, n4, n2));
            }
            int n5 = this.first(n);
            return this.next(n5, n5, n2);
        }
    }

    private class DescendantOrSelfTraverser
    extends DescendantTraverser {
        private DescendantOrSelfTraverser() {
        }

        protected int getFirstPotential(int n) {
            return n;
        }

        public int first(int n) {
            return n;
        }
    }

    private class DescendantTraverser
    extends IndexedDTMAxisTraverser {
        private DescendantTraverser() {
        }

        protected int getFirstPotential(int n) {
            return n + 1;
        }

        protected boolean axisHasBeenProcessed(int n) {
            return DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n) != -2;
        }

        protected int getSubtreeRoot(int n) {
            return DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
        }

        protected boolean isDescendant(int n, int n2) {
            return DTMDefaultBaseTraversers.this._parent(n2) >= n;
        }

        protected boolean isAfterAxis(int n, int n2) {
            do {
                if (n2 != n) continue;
                return false;
            } while ((n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2)) >= n);
            return true;
        }

        public int first(int n, int n2) {
            if (this.isIndexed(n2)) {
                int n3 = this.getSubtreeRoot(n);
                int n4 = this.getFirstPotential(n3);
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n3, n4, n2));
            }
            return this.next(n, n, n2);
        }

        public int next(int n, int n2) {
            int n3 = this.getSubtreeRoot(n);
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) + 1;
            while (true) {
                short s = DTMDefaultBaseTraversers.this._type(n2);
                if (!this.isDescendant(n3, n2)) {
                    return -1;
                }
                if (2 != s && 13 != s) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
                }
                ++n2;
            }
        }

        public int next(int n, int n2, int n3) {
            int n4 = this.getSubtreeRoot(n);
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) + 1;
            if (this.isIndexed(n3)) {
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n4, n2, n3));
            }
            while (true) {
                int n5 = DTMDefaultBaseTraversers.this._exptype(n2);
                if (!this.isDescendant(n4, n2)) {
                    return -1;
                }
                if (n5 == n3) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
                }
                ++n2;
            }
        }
    }

    private class FollowingSiblingTraverser
    extends DTMAxisTraverser {
        private FollowingSiblingTraverser() {
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getNextSibling(n2);
        }

        public int next(int n, int n2, int n3) {
            while (-1 != (n2 = DTMDefaultBaseTraversers.this.getNextSibling(n2))) {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) != n3) continue;
                return n2;
            }
            return -1;
        }
    }

    private class FollowingTraverser
    extends DescendantTraverser {
        private FollowingTraverser() {
        }

        public int first(int n) {
            int n2;
            short s = DTMDefaultBaseTraversers.this._type(n = DTMDefaultBaseTraversers.this.makeNodeIdentity(n));
            if ((2 == s || 13 == s) && -1 != (n2 = DTMDefaultBaseTraversers.this._firstch(n = DTMDefaultBaseTraversers.this._parent(n)))) {
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            do {
                if (-1 != (n2 = DTMDefaultBaseTraversers.this._nextsib(n))) continue;
                n = DTMDefaultBaseTraversers.this._parent(n);
            } while (-1 == n2 && -1 != n);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
        }

        public int first(int n, int n2) {
            int n3;
            short s = DTMDefaultBaseTraversers.this.getNodeType(n);
            if ((2 == s || 13 == s) && -1 != (n3 = DTMDefaultBaseTraversers.this.getFirstChild(n = DTMDefaultBaseTraversers.this.getParent(n)))) {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) == n2) {
                    return n3;
                }
                return this.next(n, n3, n2);
            }
            do {
                if (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextSibling(n))) {
                    if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) == n2) {
                        return n3;
                    }
                    return this.next(n, n3, n2);
                }
                n = DTMDefaultBaseTraversers.this.getParent(n);
            } while (-1 == n3 && -1 != n);
            return n3;
        }

        public int next(int n, int n2) {
            short s;
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            do {
                if (-1 != (s = DTMDefaultBaseTraversers.this._type(++n2))) continue;
                return -1;
            } while (2 == s || 13 == s);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
        }

        public int next(int n, int n2, int n3) {
            int n4;
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            do {
                if (-1 != (n4 = DTMDefaultBaseTraversers.this._exptype(++n2))) continue;
                return -1;
            } while (n4 != n3);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
        }
    }

    private abstract class IndexedDTMAxisTraverser
    extends DTMAxisTraverser {
        private IndexedDTMAxisTraverser() {
        }

        protected final boolean isIndexed(int n) {
            return DTMDefaultBaseTraversers.this.m_indexing && 1 == DTMDefaultBaseTraversers.this.m_expandedNameTable.getType(n);
        }

        protected abstract boolean isAfterAxis(int var1, int var2);

        protected abstract boolean axisHasBeenProcessed(int var1);

        protected int getNextIndexed(int n, int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getNamespaceID(n3);
            int n5 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getLocalNameID(n3);
            while (true) {
                int n6;
                if (-2 != (n6 = DTMDefaultBaseTraversers.this.findElementFromIndex(n4, n5, n2))) {
                    if (this.isAfterAxis(n, n6)) {
                        return -1;
                    }
                    return n6;
                }
                if (this.axisHasBeenProcessed(n)) break;
                DTMDefaultBaseTraversers.this.nextNode();
            }
            return -1;
        }
    }

    private class NamespaceDeclsTraverser
    extends DTMAxisTraverser {
        private NamespaceDeclsTraverser() {
        }

        public int next(int n, int n2) {
            return n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, false);
        }

        public int next(int n, int n2, int n3) {
            int n4 = n2 = n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, false);
            do {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) != n3) continue;
                return n2;
            } while (-1 != (n2 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, false)));
            return -1;
        }
    }

    private class NamespaceTraverser
    extends DTMAxisTraverser {
        private NamespaceTraverser() {
        }

        public int next(int n, int n2) {
            return n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, true);
        }

        public int next(int n, int n2, int n3) {
            int n4 = n2 = n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, true);
            do {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) != n3) continue;
                return n2;
            } while (-1 != (n2 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, true)));
            return -1;
        }
    }

    private class ParentTraverser
    extends DTMAxisTraverser {
        private ParentTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.getParent(n);
        }

        public int first(int n, int n2) {
            n = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            while (-1 != (n = DTMDefaultBaseTraversers.this.m_parent.elementAt(n))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n) != n2) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n);
            }
            return -1;
        }

        public int next(int n, int n2) {
            return -1;
        }

        public int next(int n, int n2, int n3) {
            return -1;
        }
    }

    private class PrecedingAndAncestorTraverser
    extends DTMAxisTraverser {
        private PrecedingAndAncestorTraverser() {
        }

        public int next(int n, int n2) {
            int n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            for (n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) - 1; n2 >= 0; --n2) {
                short s = DTMDefaultBaseTraversers.this._type(n2);
                if (2 == s || 13 == s) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            return -1;
        }

        public int next(int n, int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            for (n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) - 1; n2 >= 0; --n2) {
                int n5 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2);
                if (n5 != n3) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            return -1;
        }
    }

    private class PrecedingSiblingTraverser
    extends DTMAxisTraverser {
        private PrecedingSiblingTraverser() {
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getPreviousSibling(n2);
        }

        public int next(int n, int n2, int n3) {
            while (-1 != (n2 = DTMDefaultBaseTraversers.this.getPreviousSibling(n2))) {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) != n3) continue;
                return n2;
            }
            return -1;
        }
    }

    private class PrecedingTraverser
    extends DTMAxisTraverser {
        private PrecedingTraverser() {
        }

        protected boolean isAncestor(int n, int n2) {
            n = DTMDefaultBaseTraversers.this.m_parent.elementAt(n);
            while (-1 != n) {
                if (n == n2) {
                    return true;
                }
                n = DTMDefaultBaseTraversers.this.m_parent.elementAt(n);
            }
            return false;
        }

        public int next(int n, int n2) {
            int n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            for (n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) - 1; n2 >= 0; --n2) {
                short s = DTMDefaultBaseTraversers.this._type(n2);
                if (2 == s || 13 == s || this.isAncestor(n3, n2)) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            return -1;
        }

        public int next(int n, int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n);
            for (n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2) - 1; n2 >= 0; --n2) {
                int n5 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2);
                if (n5 != n3 || this.isAncestor(n4, n2)) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            return -1;
        }
    }

    private class RootTraverser
    extends AllFromRootTraverser {
        private RootTraverser() {
        }

        public int first(int n, int n2) {
            int n3 = DTMDefaultBaseTraversers.this.getDocumentRoot(n);
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) == n2 ? n3 : -1;
        }

        public int next(int n, int n2) {
            return -1;
        }

        public int next(int n, int n2, int n3) {
            return -1;
        }
    }

    private class SelfTraverser
    extends DTMAxisTraverser {
        private SelfTraverser() {
        }

        public int first(int n) {
            return n;
        }

        public int first(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(n) == n2 ? n : -1;
        }

        public int next(int n, int n2) {
            return -1;
        }

        public int next(int n, int n2, int n3) {
            return -1;
        }
    }
}

