/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import org.apache.xml.serializer.Encodings;

public final class EncodingInfo {
    private final char m_highCharInContiguousGroup;
    final String name;
    final String javaName;
    final boolean isStateless;
    InEncoding m_encoding;
    private static final byte[] s_noBytes = new byte[0];

    public boolean isCharInEncoding(char c) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isCharInEncoding(c);
    }

    public boolean isCodePointInEncoding(int n) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isCodePointInEncoding(n);
    }

    public byte[] getEncodedBytesForChar(char c) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytesForChar(c);
    }

    public boolean isSurrogatePairInEncoding(char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isSurrogatePairInEncoding(c, c2);
    }

    public byte[] getEncodedBytesForCodepoint(int n, char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytesForCodepoint(n, c, c2);
    }

    public EncodingInfo(String string, String string2, char c, boolean bl) {
        this.name = string;
        this.javaName = string2;
        this.m_highCharInContiguousGroup = c;
        this.isStateless = bl;
    }

    private static byte[] inEncoding(int n, String string) {
        byte[] byArray;
        try {
            char[] cArray = new char[]{(char)n};
            String string2 = new String(cArray);
            byte[] byArray2 = string2.getBytes(string);
            boolean bl = EncodingInfo.inEncoding(n, byArray2);
            byArray = (byte[])(bl ? byArray2 : null);
        }
        catch (Exception exception) {
            boolean bl = false;
            if (string == null) {
                bl = true;
                byArray = s_noBytes;
            }
            byArray = null;
        }
        return byArray;
    }

    private static byte[] getEncBytes(char c, char c2, String string) {
        try {
            char[] cArray = new char[]{c, c2};
            String string2 = new String(cArray);
            byte[] byArray = string2.getBytes(string);
            boolean bl = EncodingInfo.inEncoding((int)c, byArray);
            if (bl) {
                return byArray;
            }
            return null;
        }
        catch (Exception exception) {
            boolean bl = false;
            return null;
        }
    }

    private static boolean inEncoding(int n, byte[] byArray) {
        boolean bl = byArray == null || byArray.length == 0 ? false : (byArray[0] == 0 ? false : byArray[0] != 63 || n == 63);
        return bl;
    }

    public final char getHighChar() {
        return this.m_highCharInContiguousGroup;
    }

    public final boolean isStatelessEncoding() {
        return this.isStateless;
    }

    static final class EncodingImpl
    implements InEncoding {
        private final EncodingInfo m_encoding;
        private final int m_first;
        private final int m_explFirst;
        private final int m_explLast;
        private final int m_last;
        private EncodingImpl m_before;
        private EncodingImpl m_after;
        private static final int RANGE = 128;
        private final boolean[] m_alreadyKnown = new boolean[128];
        private final byte[][] m_char2Bytes = new byte[128][];

        public boolean isCharInEncoding(char c) {
            byte[] byArray = this.getEncodedBytesForChar(c);
            return byArray != null;
        }

        public boolean isSurrogatePairInEncoding(char c, char c2) {
            int n = Encodings.toCodePoint(c, c2);
            byte[] byArray = this.getEncodedBytesForCodepoint(n, c, c2);
            return byArray != null;
        }

        public final byte[] getEncodedBytes127(int n) {
            return this.m_char2Bytes[n];
        }

        public byte[] getEncodedBytesForChar(char c) {
            byte[] byArray;
            char c2 = c;
            if (c2 < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, c2);
                }
                byArray = this.m_before.getEncodedBytesForChar(c);
            } else if (this.m_explLast < c2) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, c2);
                }
                byArray = this.m_after.getEncodedBytesForChar(c);
            } else {
                int n = c2 - this.m_explFirst;
                if (this.m_alreadyKnown[n]) {
                    byArray = this.m_char2Bytes[n];
                } else {
                    byArray = EncodingInfo.inEncoding(c, this.m_encoding.javaName);
                    this.m_alreadyKnown[n] = true;
                    this.m_char2Bytes[n] = byArray;
                }
            }
            return byArray;
        }

        public byte[] getEncodedBytesForCodepoint(int n, char c, char c2) {
            byte[] byArray;
            if (n < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, n);
                }
                byArray = this.m_before.getEncodedBytesForCodepoint(n, c, c2);
            } else if (this.m_explLast < n) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, n);
                }
                byArray = this.m_after.getEncodedBytesForCodepoint(n, c, c2);
            } else {
                int n2 = n - this.m_explFirst;
                if (this.m_alreadyKnown[n2]) {
                    byArray = this.m_char2Bytes[n2];
                } else {
                    byArray = EncodingInfo.getEncBytes(c, c2, this.m_encoding.javaName);
                    this.m_alreadyKnown[n2] = true;
                    this.m_char2Bytes[n2] = byArray;
                }
            }
            return byArray;
        }

        EncodingImpl(EncodingInfo encodingInfo) {
            this(encodingInfo, 0, Integer.MAX_VALUE, 0);
        }

        private EncodingImpl(EncodingInfo encodingInfo, int n, int n2, int n3) {
            char c;
            this.m_first = n;
            this.m_last = n2;
            this.m_explFirst = n3;
            this.m_explLast = n3 + 127;
            this.m_encoding = encodingInfo;
            String string = encodingInfo.javaName;
            if (string != null && 0 <= this.m_explFirst && this.m_explFirst <= 127 && encodingInfo.isStatelessEncoding()) {
                int n4;
                if ("UTF8".equals(string) || "UTF-16".equals(string) || "ASCII".equals(string) || "US-ASCII".equals(string) || "Unicode".equals(string) || "UNICODE".equals(string) || string.startsWith("ISO8859")) {
                    for (c = '\u0000'; c < '\u007f'; ++c) {
                        n4 = c - this.m_explFirst;
                        if (0 > n4 || n4 >= 128) continue;
                        this.m_alreadyKnown[n4] = true;
                        this.m_char2Bytes[n4] = new byte[]{(byte)c};
                    }
                } else {
                    for (c = '\u0000'; c < '\u007f'; c = (char)((char)(c + 1))) {
                        n4 = c - this.m_explFirst;
                        if (0 > n4 || n4 >= 128) continue;
                        this.m_char2Bytes[n4] = this.getEncodedBytesForChar(c);
                    }
                }
            }
            if (string == null) {
                for (c = '\u0000'; c < this.m_alreadyKnown.length; ++c) {
                    this.m_alreadyKnown[c] = true;
                    this.m_char2Bytes[c] = s_noBytes;
                }
            }
        }

        public boolean isCodePointInEncoding(int n) {
            block4: {
                try {
                    if (Encodings.codePointHasSurrogatePair(n)) {
                        int n2 = Encodings.getLowSurrogate(n);
                        int n3 = Encodings.getHighSurrogate(n);
                        if (n2 != -1 && n3 != -1) {
                            return this.isSurrogatePairInEncoding((char)n3, (char)n2);
                        }
                        break block4;
                    }
                    char c = (char)n;
                    return this.isCharInEncoding(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static interface InEncoding {
        public boolean isCharInEncoding(char var1);

        public boolean isSurrogatePairInEncoding(char var1, char var2);

        public boolean isCodePointInEncoding(int var1);

        public byte[] getEncodedBytesForChar(char var1);

        public byte[] getEncodedBytesForCodepoint(int var1, char var2, char var3);
    }
}

