/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NamespaceMappings {
    private int m_count = 0;
    private HashMap m_namespaces;
    private Stack m_nodeStack;
    private static final String EMPTYSTRING = "";
    private static final String XML_PREFIX = "xml";
    private static final MappingRecord s_MapRecEmpty = new MappingRecord("", "", -1);
    private static final MappingRecord s_MapRecXML = new MappingRecord("xml", "http://www.w3.org/XML/1998/namespace", -1);
    private Stack m_emptyStringStack = new Stack();
    private Stack m_XMLStringStack;
    private boolean m_undeclarationIsEnabled = false;

    public NamespaceMappings() {
        this.m_namespaces = new HashMap();
        this.m_nodeStack = new Stack();
        this.m_XMLStringStack = new Stack();
        this.m_emptyStringStack.push(s_MapRecEmpty);
        this.m_namespaces.put(EMPTYSTRING, this.m_emptyStringStack);
        this.m_XMLStringStack.push(s_MapRecXML);
        this.m_namespaces.put(XML_PREFIX, this.m_XMLStringStack);
    }

    public String lookupNamespace(String string) {
        String string2 = null;
        Stack stack = this.getPrefixStack(string);
        if (stack != null && !stack.isEmpty()) {
            string2 = ((MappingRecord)stack.peek()).m_uri;
        }
        if (string2 == null) {
            string2 = EMPTYSTRING;
        }
        return string2;
    }

    MappingRecord getMappingFromPrefix(String string) {
        Stack stack = (Stack)this.m_namespaces.get(string);
        return stack != null && !stack.isEmpty() ? (MappingRecord)stack.peek() : null;
    }

    public String lookupPrefix(String string) {
        String string2 = null;
        Set set = this.m_namespaces.keySet();
        for (String string3 : set) {
            String string4 = this.lookupNamespace(string3);
            if (string4 == null || !string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    MappingRecord getMappingFromURI(String string) {
        MappingRecord mappingRecord = null;
        Set set = this.m_namespaces.keySet();
        for (String string2 : set) {
            MappingRecord mappingRecord2 = this.getMappingFromPrefix(string2);
            if (mappingRecord2 == null || !mappingRecord2.m_uri.equals(string)) continue;
            mappingRecord = mappingRecord2;
            break;
        }
        return mappingRecord;
    }

    boolean popNamespace(String string) {
        if (string.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack stack = this.getPrefixStack(string);
        if (stack != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    public boolean pushNamespace(String string, String string2, int n) {
        MappingRecord mappingRecord;
        if (string.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack stack = (Stack)this.m_namespaces.get(string);
        if (stack == null) {
            stack = new Stack();
            this.m_namespaces.put(string, stack);
        }
        if (!stack.empty()) {
            mappingRecord = (MappingRecord)stack.peek();
            if (string2.equals(mappingRecord.m_uri) || n == mappingRecord.m_declarationDepth) {
                return false;
            }
        }
        mappingRecord = new MappingRecord(string, string2, n);
        stack.push(mappingRecord);
        this.m_nodeStack.push(mappingRecord);
        return true;
    }

    void popNamespaces(int n, ContentHandler contentHandler) {
        while (true) {
            String string;
            Stack stack;
            MappingRecord mappingRecord;
            if (this.m_nodeStack.isEmpty()) {
                return;
            }
            MappingRecord mappingRecord2 = (MappingRecord)this.m_nodeStack.peek();
            if (n < 1 || mappingRecord2.m_declarationDepth < n) break;
            MappingRecord mappingRecord3 = (MappingRecord)this.m_nodeStack.pop();
            if (mappingRecord3 != (mappingRecord = (MappingRecord)(stack = this.getPrefixStack(string = mappingRecord2.m_prefix)).peek())) continue;
            stack.pop();
            if (contentHandler == null) continue;
            try {
                contentHandler.endPrefixMapping(string);
            }
            catch (SAXException sAXException) {}
        }
    }

    public String generateNextPrefix() {
        return "ns" + this.m_count++;
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceMappings namespaceMappings = new NamespaceMappings();
        namespaceMappings.m_count = this.m_count;
        namespaceMappings.m_emptyStringStack = (Stack)this.m_emptyStringStack.clone();
        namespaceMappings.m_namespaces = (HashMap)this.m_namespaces.clone();
        namespaceMappings.m_nodeStack = (Stack)this.m_nodeStack.clone();
        namespaceMappings.m_undeclarationIsEnabled = this.m_undeclarationIsEnabled;
        namespaceMappings.m_XMLStringStack = (Stack)this.m_XMLStringStack.clone();
        return namespaceMappings;
    }

    final void reset() {
        this.m_count = 0;
        this.m_emptyStringStack.clear();
        this.m_namespaces.clear();
        this.m_nodeStack.clear();
        this.m_undeclarationIsEnabled = false;
        this.m_XMLStringStack.clear();
        this.m_emptyStringStack.push(s_MapRecEmpty);
        this.m_namespaces.put(EMPTYSTRING, this.m_emptyStringStack);
        this.m_XMLStringStack.push(s_MapRecXML);
        this.m_namespaces.put(XML_PREFIX, this.m_XMLStringStack);
        this.m_count = 0;
        this.m_namespaces.clear();
        this.m_nodeStack.clear();
        this.m_emptyStringStack.push(s_MapRecEmpty);
        this.m_namespaces.put(EMPTYSTRING, this.m_emptyStringStack);
        this.m_XMLStringStack.push(s_MapRecXML);
        this.m_namespaces.put(XML_PREFIX, this.m_XMLStringStack);
    }

    private Stack getPrefixStack(String string) {
        Stack stack = (Stack)this.m_namespaces.get(string);
        return stack;
    }

    private Stack createPrefixStack(String string) {
        Stack stack = new Stack();
        this.m_namespaces.put(string, stack);
        return stack;
    }

    public String[] lookupAllPrefixes(String string) {
        String[] stringArray2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Set set = this.m_namespaces.keySet();
        for (String[] stringArray2 : set) {
            String string2 = this.lookupNamespace((String)stringArray2);
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(stringArray2);
        }
        stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    void undeclareAllPrefixMappings(int n) {
        if (this.m_undeclarationIsEnabled) {
            Set set = this.m_namespaces.keySet();
            for (String string : set) {
                Stack stack = this.getPrefixStack(string);
                if (stack.empty()) continue;
                MappingRecord mappingRecord = (MappingRecord)stack.peek();
                if (mappingRecord.m_uri.length() <= 0 || mappingRecord.m_declarationDepth > n) continue;
                this.undeclarePrefixMapping(string, n);
            }
        }
    }

    public void undeclarePrefixMapping(String string, int n) {
        if (this.m_undeclarationIsEnabled) {
            this.pushNamespace(string, EMPTYSTRING, n);
        }
    }

    Enumeration getPrefixMappingsAtDepth(int n) {
        MappingsAtDepth mappingsAtDepth = new MappingsAtDepth(n);
        return mappingsAtDepth;
    }

    void setUndeclaration(boolean bl) {
        this.m_undeclarationIsEnabled = bl;
    }

    static class MappingRecord {
        final String m_prefix;
        final String m_uri;
        final int m_declarationDepth;

        MappingRecord(String string, String string2, int n) {
            this.m_prefix = string;
            this.m_uri = string2 == null ? NamespaceMappings.EMPTYSTRING : string2;
            this.m_declarationDepth = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_prefix.length() == 0) {
                stringBuffer.append("xmlns");
            } else {
                stringBuffer.append("xmlns:").append(this.m_prefix);
            }
            stringBuffer.append("='").append(this.m_uri).append('\'');
            stringBuffer.append("    at depth " + this.m_declarationDepth);
            return stringBuffer.toString();
        }
    }

    private class MappingsAtDepth
    implements Enumeration {
        Stack prefixURIPairs;

        MappingsAtDepth(int n) {
            this.prefixURIPairs = new Stack();
            Set set = NamespaceMappings.this.m_namespaces.keySet();
            for (String string : set) {
                int n2;
                Stack stack = NamespaceMappings.this.getPrefixStack(string);
                if (stack.empty()) continue;
                MappingRecord mappingRecord = null;
                for (n2 = stack.top; 0 <= n2; --n2) {
                    mappingRecord = (MappingRecord)stack.getElement(n2);
                    if (mappingRecord.m_declarationDepth <= n) break;
                }
                if (0 > n2 || mappingRecord.m_declarationDepth != n || mappingRecord.m_prefix.equals("xmlns") || mappingRecord.m_prefix.equals(NamespaceMappings.XML_PREFIX)) continue;
                this.prefixURIPairs.push(mappingRecord.m_uri);
                this.prefixURIPairs.push(mappingRecord.m_prefix);
            }
        }

        public boolean hasMoreElements() {
            return !this.prefixURIPairs.empty();
        }

        public Object nextElement() {
            return this.prefixURIPairs.pop();
        }
    }

    private class Stack {
        private int top = -1;
        private int max = 20;
        Object[] m_stack = new Object[this.max];

        public Object clone() throws CloneNotSupportedException {
            Stack stack = new Stack();
            stack.max = this.max;
            stack.top = this.top;
            stack.m_stack = new Object[stack.max];
            for (int i = 0; i <= this.top; ++i) {
                stack.m_stack[i] = this.m_stack[i];
            }
            return stack;
        }

        public Object push(Object object) {
            ++this.top;
            if (this.max <= this.top) {
                int n = 2 * this.max + 1;
                Object[] objectArray = new Object[n];
                System.arraycopy(this.m_stack, 0, objectArray, 0, this.max);
                this.max = n;
                this.m_stack = objectArray;
            }
            this.m_stack[this.top] = object;
            return object;
        }

        public Object pop() {
            Object object;
            if (0 <= this.top) {
                object = this.m_stack[this.top];
                --this.top;
            } else {
                object = null;
            }
            return object;
        }

        public Object peek() {
            Object object = 0 <= this.top ? this.m_stack[this.top] : null;
            return object;
        }

        public Object peek(int n) {
            return this.m_stack[n];
        }

        public boolean isEmpty() {
            return this.top < 0;
        }

        public boolean empty() {
            return this.top < 0;
        }

        public void clear() {
            for (int i = 0; i <= this.top; ++i) {
                this.m_stack[i] = null;
            }
            this.top = -1;
        }

        public Object getElement(int n) {
            return this.m_stack[n];
        }
    }
}

