/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.utils.Utils;
import org.xml.sax.SAXException;

public class ToXMLStream
extends ToStream {
    private static final CharInfo m_xmlcharInfo = CharInfo.getCharInfo(null, "xml");
    private static boolean INCLUDE_NEWLINE_AFTER_DECL;

    public ToXMLStream() {
        EncodingInfo encodingInfo;
        this.m_charInfo = m_xmlcharInfo;
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
        this.m_OutputPropsDefault = new HashMap();
        this.m_OutputPropsDefault.put("method", "xml");
        this.m_OutputPropsDefault.put("version", "1.0");
        this.m_version = "1.0";
        this.m_OutputPropsDefault.put("mime-name", "UTF-8");
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.m_OutputPropsDefault.put("encoding", "UTF-8");
        this.m_doIndent = false;
        this.m_OutputPropsDefault.put("indent", "no");
        this.m_OutputPropsDefault.put("omit-xml-declaration", "no");
        this.m_standalone = "no";
        this.m_OutputPropsDefault.put("standalone", "no");
        this.m_mediatype = "text/xml";
        this.m_OutputPropsDefault.put("media-type", "text/xml");
        this.m_wasJustReset = true;
    }

    public void CopyFrom(ToXMLStream toXMLStream) {
        this.setWriter(toXMLStream.m_writer);
        String string = toXMLStream.getEncoding();
        this.setEncoding(string);
        this.setOmitXMLDeclaration(toXMLStream.getOmitXMLDeclaration());
        this.m_ispreserve = toXMLStream.m_ispreserve;
        this.m_isprevtext = toXMLStream.m_isprevtext;
        this.m_doIndent = toXMLStream.m_doIndent;
        this.setIndentAmount(toXMLStream.getIndentAmount());
        this.m_startNewLine = toXMLStream.m_startNewLine;
        this.m_needToOutputDocTypeDecl = toXMLStream.m_needToOutputDocTypeDecl;
        this.setDoctypeSystem(toXMLStream.getDoctypeSystem());
        this.setDoctypePublic(toXMLStream.getDoctypePublic());
        this.setStandalone(toXMLStream.getStandalone());
        this.setMediaType(toXMLStream.getMediaType());
        this.m_encodingInfo = toXMLStream.m_encodingInfo;
        this.m_spaceBeforeClose = toXMLStream.m_spaceBeforeClose;
        this.m_cdataStartCalled = toXMLStream.m_cdataStartCalled;
    }

    public void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            if (this.m_inEntityRef) {
                return;
            }
            this.m_needToOutputDocTypeDecl = true;
            this.m_startNewLine = false;
            String string = this.getXMLVersion();
            if (!this.getOmitXMLDeclaration()) {
                String string2 = Encodings.getMimeEncoding(this.getEncoding());
                String string3 = this.m_standaloneWasSpecified ? " standalone=\"" + this.getStandalone() + "\"" : "";
                try {
                    Writer writer = this.m_writer;
                    writer.write("<?xml version=\"");
                    writer.write(string);
                    writer.write("\" encoding=\"");
                    writer.write(string2);
                    writer.write(34);
                    writer.write(string3);
                    writer.write("?>");
                    if (this.m_doIndent) {
                        if (this.m_standaloneWasSpecified || this.getDoctypePublic() != null || this.getDoctypeSystem() != null) {
                            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        } else if (INCLUDE_NEWLINE_AFTER_DECL) {
                            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        }
                    } else if (INCLUDE_NEWLINE_AFTER_DECL) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    }
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
            if (this.m_undeclareNamespaces && "1.0".equals(string)) {
                this.m_undeclareNamespaces = false;
            }
        }
    }

    public void endDocument() throws SAXException {
        this.flushInternal();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void flushPending() throws SAXException {
        this.flushInternal();
        this.flushWriter();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.flushInternal();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int n;
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.m_docIsEmpty = false;
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                if ((n = string2.indexOf("?>")) >= 0) {
                    if (n > 0) {
                        writer.write(string2.substring(0, n));
                    }
                    writer.write("? >");
                    if (n + 2 < string2.length()) {
                        writer.write(string2.substring(n + 2));
                    }
                } else {
                    writer.write(string2);
                }
                writer.write(63);
                writer.write(62);
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            String string6;
            boolean bl2 = this.addAttributeAlways(string, string2, string3, string4, string5, bl);
            if (bl2 && !bl && !string3.startsWith("xmlns") && (string6 = this.ensureAttributesNamespaceIsDeclared(string, string2, string3)) != null && string3 != null && !string3.startsWith(string6)) {
                string3 = string6 + ":" + string2;
            }
            this.addAttributeAlways(string, string2, string3, string4, string5, bl);
        } else {
            this.reportWarning("ER_ILLEGAL_ATTRIBUTE_POSITION", new Object[]{string2});
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToXMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    protected boolean pushNamespace(String string, String string2) {
        try {
            if (this.m_prefixMap.pushNamespace(string, string2, this.m_elemContext.m_currentElemDepth)) {
                this.startPrefixMapping(string, string2);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    public boolean reset() {
        super.reset();
        return true;
    }

    private String getXMLVersion() {
        String string = this.getVersion();
        if (string == null || string.equals("1.0")) {
            string = "1.0";
        } else if (string.equals("1.1")) {
            string = "1.1";
        } else {
            String string2 = Utils.messages.createMessage("ER_XML_VERSION_NOT_SUPPORTED", new Object[]{string});
            try {
                Transformer transformer = super.getTransformer();
                ErrorListener errorListener = null;
                if (transformer != null) {
                    errorListener = transformer.getErrorListener();
                }
                if (null != errorListener && this.m_sourceLocator != null) {
                    errorListener.warning(new TransformerException(string2, this.m_sourceLocator));
                } else {
                    System.out.println(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = "1.0";
        }
        return string;
    }

    final void processAttributes(Writer writer, int n) throws IOException, SAXException {
        WriterOptimized writerOptimized = writer == this.m_writerOptimized ? this.m_writerOptimized : null;
        for (int i = 0; i < n; ++i) {
            this.processAttribute(writer, writerOptimized, this.m_attributes.getAttribute(i), this.m_optLevel);
        }
    }

    void processAttribute(Writer writer, WriterOptimized writerOptimized, AttributesImplSerializer.AttributeImpl attributeImpl, int n) throws IOException {
        writer.write(32);
        String string = attributeImpl.m_qName;
        String string2 = attributeImpl.m_value;
        writer.write(string);
        writer.write("=\"");
        switch (n) {
            case 0: {
                if ((attributeImpl.m_flags & 1) != 0) {
                    if (writer == writerOptimized) {
                        writerOptimized.writeASCII(string2);
                        break;
                    }
                    writer.write(string2);
                    break;
                }
                this.writeXMLAttrOpt(writer, writerOptimized, string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeXMLAttr(writer, writerOptimized, string2);
            }
        }
        writer.write(34);
    }

    public void undeclareAllPrefixMappings() {
        int n = this.m_elemContext.m_currentElemDepth;
        this.m_prefixMap.undeclareAllPrefixMappings(n);
    }

    public void characters(char[] cArray, int n, int n2, int n3) throws SAXException {
        if ((n3 & 1) > 0 && this.m_optLevel == 0) {
            Writer writer;
            if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
                return;
            }
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            } else if (this.m_needToCallStartDocument) {
                this.m_docIsEmpty = false;
                this.startDocumentInternal();
            }
            if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
                this.cdata(cArray, n, n2);
                return;
            }
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
                this.charactersRaw(cArray, n, n2);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n, n2);
                }
                return;
            }
            if ((n3 & 8) == 0) {
                this.m_ispreserve = true;
            }
            WriterOptimized writerOptimized = (writer = this.m_writer) == this.m_writerOptimized ? this.m_writerOptimized : null;
            try {
                if (writerOptimized != null) {
                    writerOptimized.writeASCII(cArray, n, n2);
                } else {
                    writer.write(cArray, n, n2);
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.m_isprevtext = true;
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
        } else {
            this.characters(cArray, n, n2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.m_optLevel) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                super.characters(cArray, n, n2);
                return;
            }
        }
        if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.m_docIsEmpty = false;
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(cArray, n, n2);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            int n3;
            char c;
            Writer writer = this.m_writer;
            WriterOptimized writerOptimized = writer == this.m_writerOptimized ? this.m_writerOptimized : null;
            int n4 = n + n2;
            int n5 = n;
            char c2 = '\u0000';
            boolean bl = true;
            int n6 = n;
            block27: while (n6 < n4) {
                c = cArray[n6];
                switch (c) {
                    case '\t': 
                    case ' ': {
                        ++n6;
                        continue block27;
                    }
                    case '\n': {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            ++n6;
                            continue block27;
                        }
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            writer.write(cArray, n5, n3);
                            n3 = 0;
                        }
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n5 = ++n6;
                        continue block27;
                    }
                    case '\r': {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, c, cArray, n3, n5);
                        n5 = ++n6;
                        continue block27;
                    }
                }
                bl = false;
                if (bl) continue;
            }
            if (n6 < n4 || !bl) {
                this.m_ispreserve = true;
            }
            block28: while (n6 < n4) {
                byte[] byArray;
                int n7;
                char c3;
                c = cArray[n6];
                switch (c) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, c, cArray, n3, n5);
                        n5 = ++n6;
                        continue block28;
                    }
                    case '\t': {
                        ++n6;
                        continue block28;
                    }
                    case '\n': {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            ++n6;
                            continue block28;
                        }
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n5 = ++n6;
                        continue block28;
                    }
                    case '\u000b': 
                    case '\f': {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, c, cArray, n3, n5);
                        n5 = ++n6;
                        continue block28;
                    }
                    case '\r': {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&#13;");
                        n5 = ++n6;
                        continue block28;
                    }
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, c, cArray, n3, n5);
                        n5 = ++n6;
                        continue block28;
                    }
                    case ' ': 
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '$': 
                    case '%': {
                        ++n6;
                        continue block28;
                    }
                    case '&': {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&amp;");
                        n5 = ++n6;
                        continue block28;
                    }
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case ':': 
                    case ';': {
                        ++n6;
                        continue block28;
                    }
                    case '<': {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&lt;");
                        n5 = ++n6;
                        continue block28;
                    }
                    case '=': {
                        ++n6;
                        continue block28;
                    }
                    case '>': {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&gt;");
                        n5 = ++n6;
                        continue block28;
                    }
                    case '?': 
                    case '@': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '_': 
                    case '`': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        ++n6;
                        continue block28;
                    }
                    case '\u007f': {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, c, cArray, n3, n5);
                        n5 = ++n6;
                        continue block28;
                    }
                }
                if (Encodings.isHighUTF16Surrogate(c) && n6 + 1 < n4) {
                    c2 = cArray[n6 + 1];
                    c3 = Encodings.toCodePoint(c, c2);
                    n7 = 2;
                } else {
                    c3 = c;
                    n7 = 1;
                }
                if (c3 <= '\u009f') {
                    n3 = n6 - n5;
                    this.writeNumericEntity(writer, writerOptimized, c, cArray, n3, n5);
                    n5 = n6 += n7;
                    continue;
                }
                if (c3 == '\u2028') {
                    n3 = n6 - n5;
                    if (n3 > 0) {
                        if (writerOptimized == writer) {
                            writerOptimized.writeASCII(cArray, n5, n3);
                        } else {
                            writer.write(cArray, n5, n3);
                        }
                    }
                    writer.write("&#8232;");
                    n5 = n6 += n7;
                    continue;
                }
                byte[] byArray2 = byArray = n7 == 1 ? this.m_encodingInfo.getEncodedBytesForChar(c) : this.m_encodingInfo.getEncodedBytesForCodepoint(c3, c, c2);
                if (byArray != null) {
                    if (writerOptimized == writer) {
                        n3 = n6 - n5;
                        writerOptimized.writeASCII(cArray, n5, n3);
                        writerOptimized.writeBytes(byArray, 0, byArray.length);
                        n5 = n6 += n7;
                        continue;
                    }
                    n6 += n7;
                    continue;
                }
                n3 = n6 - n5;
                if (n3 > 0) {
                    if (writerOptimized == writer) {
                        writerOptimized.writeASCII(cArray, n5, n3);
                    } else {
                        writer.write(cArray, n5, n3);
                    }
                }
                String string = this.m_charInfo.getOutputStringForChar(c3, this.m_charKey);
                if (this.shouldMapTextChar(c3) && string != null) {
                    writer.write(string);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(c3));
                    writer.write(59);
                }
                n5 = n6 += n7;
            }
            n3 = n6 - n5;
            if (n3 > 0) {
                if (writerOptimized == writer) {
                    writerOptimized.writeASCII(cArray, n5, n3);
                } else {
                    writer.write(cArray, n5, n3);
                }
            }
            this.m_isprevtext = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(cArray, n, n2);
        }
    }

    static {
        try {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("org.apache.xml.serializer.NewLineAfterXMLDecl", "false");
                }
            });
            INCLUDE_NEWLINE_AFTER_DECL = string.equals("true");
        }
        catch (Exception exception) {
            INCLUDE_NEWLINE_AFTER_DECL = false;
        }
    }
}

