/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.WriterOptimized;

public class WriterStateless
extends WriterOptimized {
    final EncodingInfo m_ei;
    final EncodingInfo.EncodingImpl m_enc_info;

    public WriterStateless(OutputStream outputStream, EncodingInfo encodingInfo) {
        super(outputStream);
        this.m_ei = encodingInfo;
        this.m_enc_info = new EncodingInfo.EncodingImpl(encodingInfo);
        encodingInfo.m_encoding = this.m_enc_info;
    }

    public void write(int n) throws IOException {
        int n2;
        Object object;
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n < 128) {
            object = this.m_enc_info.getEncodedBytes127(n);
        } else {
            try {
                if (Encodings.codePointHasSurrogatePair(n)) {
                    n2 = Encodings.getLowSurrogate(n);
                    int n3 = Encodings.getHighSurrogate(n);
                    object = n2 != -1 && n3 != -1 ? this.m_ei.getEncodedBytesForCodepoint(n, (char)n3, (char)n2) : null;
                } else {
                    object = this.m_ei.getEncodedBytesForChar((char)n);
                }
            }
            catch (Exception exception) {
                object = null;
            }
        }
        if (object != null) {
            for (n2 = 0; n2 < ((byte[])object).length; ++n2) {
                this.m_outputBytes[this.count++] = object[n2];
            }
        }
    }

    void writeCharsNoChunking(char[] cArray, int n, int n2) {
        int n3;
        char c;
        int n4;
        EncodingInfo.EncodingImpl encodingImpl = this.m_enc_info;
        int n5 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n6 = this.count;
        for (n4 = n; n4 < n5 && (c = cArray[n4]) < '\u0080'; ++n4) {
            byte[] byArray2 = encodingImpl.getEncodedBytes127(c);
            if (byArray2 == null) continue;
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[n6++] = byArray2[n3];
            }
        }
        while (n4 < n5) {
            c = cArray[n4];
            if (c < '\u0080') {
                byte[] byArray3 = encodingImpl.getEncodedBytes127(c);
                if (byArray3 != null) {
                    for (n3 = 0; n3 < byArray3.length; ++n3) {
                        byArray[n6++] = byArray3[n3];
                    }
                }
            } else if (Encodings.isHighUTF16Surrogate(c) && n4 < n5 - 1) {
                char c2 = cArray[n4 + 1];
                ++n4;
                n3 = Encodings.toCodePoint(c, c2);
                byte[] byArray4 = this.m_ei.getEncodedBytesForCodepoint(n3, c, c2);
                if (byArray4 != null) {
                    for (int i = 0; i < byArray4.length; ++i) {
                        byArray[n6++] = byArray4[i];
                    }
                }
            } else {
                byte[] byArray5 = this.m_ei.getEncodedBytesForChar(c);
                if (byArray5 != null) {
                    for (n3 = 0; n3 < byArray5.length; ++n3) {
                        byArray[n6++] = byArray5[n3];
                    }
                }
            }
            ++n4;
        }
        this.count = n6;
    }

    void writeASCIINoChunking(char[] cArray, int n, int n2) {
        int n3 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n4 = this.count;
        EncodingInfo.EncodingImpl encodingImpl = this.m_enc_info;
        for (int i = n; i < n3; ++i) {
            byte[] byArray2 = encodingImpl.getEncodedBytes127(cArray[i]);
            if (byArray2 == null) continue;
            for (int j = 0; j < byArray2.length; ++j) {
                byArray[n4++] = byArray2[j];
            }
        }
        this.count = n4;
    }
}

