/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DOMHelper;
import org.apache.xml.utils.DOMOrder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOM2Helper
extends DOMHelper {
    private Document m_doc;

    public void checkNode(Node node) throws TransformerException {
    }

    public boolean supportsSAX() {
        return true;
    }

    public void setDocument(Document document) {
        this.m_doc = document;
    }

    public Document getDocument() {
        return this.m_doc;
    }

    public void parse(InputSource inputSource) throws TransformerException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new DefaultErrorHandler());
            this.setDocument(documentBuilder.parse(inputSource));
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformerException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public Element getElementByID(String string, Document document) {
        return document.getElementById(string);
    }

    public static boolean isNodeAfter(Node node, Node node2) {
        if (node instanceof DOMOrder && node2 instanceof DOMOrder) {
            int n;
            int n2 = ((DOMOrder)((Object)node)).getUid();
            return n2 <= (n = ((DOMOrder)((Object)node2)).getUid());
        }
        return DOMHelper.isNodeAfter(node, node2);
    }

    public static Node getParentOfNode(Node node) {
        Node node2 = node.getParentNode();
        if (node2 == null && 2 == node.getNodeType()) {
            node2 = ((Attr)node).getOwnerElement();
        }
        return node2;
    }

    public String getLocalNameOfNode(Node node) {
        String string = node.getLocalName();
        return null == string ? super.getLocalNameOfNode(node) : string;
    }

    public String getNamespaceOfNode(Node node) {
        return node.getNamespaceURI();
    }
}

