/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;
    private int m_blocksize;
    Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeSet() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeSet(int n) {
        this.m_blocksize = n;
        this.m_mapSize = 0;
    }

    public NodeSet(NodeList nodeList) {
        this(32);
        this.addNodes(nodeList);
    }

    public NodeSet(NodeSet nodeSet) {
        this(32);
        this.addNodes((NodeIterator)nodeSet);
    }

    public NodeSet(NodeIterator nodeIterator) {
        this(32);
        this.addNodes(nodeIterator);
    }

    public NodeSet(Node node) {
        this(32);
        this.addNode(node);
    }

    public Node getRoot() {
        return null;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)this.clone();
        nodeSet.reset();
        return nodeSet;
    }

    public void reset() {
        this.m_next = 0;
    }

    public int getWhatToShow() {
        return -17;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node node = this.elementAt(this.m_next);
            ++this.m_next;
            return node;
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_ITERATE", null));
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public void detach() {
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public void runTo(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        this.m_next = n >= 0 && this.m_next < this.m_firstFree ? n : this.m_firstFree - 1;
    }

    public Node item(int n) {
        this.runTo(n);
        return this.elementAt(n);
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.addElement(node);
    }

    public void insertNode(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.insertElementAt(node, n);
    }

    public void removeNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.removeElement(node);
    }

    public void addNodes(NodeList nodeList) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null != nodeList) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (null == node) continue;
                this.addElement(node);
            }
        }
    }

    public void addNodes(NodeSet nodeSet) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.addNodes((NodeIterator)nodeSet);
    }

    public void addNodes(NodeIterator nodeIterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null != nodeIterator) {
            Node node;
            while (null != (node = nodeIterator.nextNode())) {
                this.addElement(node);
            }
        }
    }

    public void addNodesInDocOrder(NodeList nodeList, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (null == node) continue;
            this.addNodeInDocOrder(node, xPathContext);
        }
    }

    public void addNodesInDocOrder(NodeIterator nodeIterator, XPathContext xPathContext) {
        Node node;
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        while (null != (node = nodeIterator.nextNode())) {
            this.addNodeInDocOrder(node, xPathContext);
        }
    }

    private boolean addNodesInDocOrder(int n, int n2, int n3, NodeList nodeList, XPathContext xPathContext) {
        int n4;
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        boolean bl = false;
        Node node = nodeList.item(n3);
        for (n4 = n2; n4 >= n; --n4) {
            boolean bl2;
            Node node2 = this.elementAt(n4);
            if (node2 == node) {
                n4 = -2;
                break;
            }
            if (DOM2Helper.isNodeAfter(node, node2)) continue;
            this.insertElementAt(node, n4 + 1);
            if (--n3 <= 0 || (bl2 = this.addNodesInDocOrder(0, n4, n3, nodeList, xPathContext))) break;
            this.addNodesInDocOrder(n4, this.size() - 1, n3, nodeList, xPathContext);
            break;
        }
        if (n4 == -1) {
            this.insertElementAt(node, 0);
        }
        return bl;
    }

    public int addNodeInDocOrder(Node node, boolean bl, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        int n = -1;
        if (bl) {
            int n2;
            int n3 = this.size();
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                Node node2 = this.elementAt(n2);
                if (node2 == node) {
                    n2 = -2;
                    break;
                }
                if (!DOM2Helper.isNodeAfter(node, node2)) break;
            }
            if (n2 != -2) {
                n = n2 + 1;
                this.insertElementAt(node, n);
            }
        } else {
            n = this.size();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                if (!this.item(i).equals(node)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.addElement(node);
            }
        }
        return n;
    }

    public int addNodeInDocOrder(Node node, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        return this.addNodeInDocOrder(node, true, xPathContext);
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public void setCurrentPos(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        this.m_next = n;
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        int n = this.m_next;
        Node node = this.m_next < this.m_firstFree ? this.elementAt(this.m_next) : null;
        this.m_next = n;
        return node;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public void setShouldCacheNodes(boolean bl) {
        if (!this.isFresh()) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_CALL_SETSHOULDCACHENODE", null));
        }
        this.m_cacheNodes = bl;
        this.m_mutable = true;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)super.clone();
        if (null != this.m_map && this.m_map == nodeSet.m_map) {
            nodeSet.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeSet.m_map, 0, this.m_map.length);
        }
        return nodeSet;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void addElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[this.m_firstFree] = node;
        ++this.m_firstFree;
    }

    public final void push(Node node) {
        int n = this.m_firstFree;
        if (n + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, n + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[n] = node;
        this.m_firstFree = ++n;
    }

    public final Node pop() {
        --this.m_firstFree;
        Node node = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return node;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public final Node peepOrNull() {
        return null != this.m_map && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final void pushPair(Node node, Node node2) {
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree);
            this.m_map = nodeArray;
        }
        this.m_map[this.m_firstFree] = node;
        this.m_map[this.m_firstFree + 1] = node2;
        this.m_firstFree += 2;
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void setTail(Node node) {
        this.m_map[this.m_firstFree - 1] = node;
    }

    public final void setTailSub1(Node node) {
        this.m_map[this.m_firstFree - 2] = node;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public void insertElementAt(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (n <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n, this.m_map, n + 1, this.m_firstFree - n);
        }
        this.m_map[n] = node;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeSet nodeSet) {
        int n = nodeSet.size();
        if (null == this.m_map) {
            this.m_mapSize = n + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + n);
            this.m_map = nodeArray;
        }
        System.arraycopy(nodeSet.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public void removeAllElements() {
        if (null == this.m_map) {
            return;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            this.m_map[i] = null;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            return false;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            Node node2 = this.m_map[i];
            if (null == node2 || !node2.equals(node)) continue;
            if (i < this.m_firstFree - 1) {
                System.arraycopy(this.m_map, i + 1, this.m_map, i, this.m_firstFree - i - 1);
            }
            --this.m_firstFree;
            this.m_map[this.m_firstFree] = null;
            return true;
        }
        return false;
    }

    public void removeElementAt(int n) {
        if (null == this.m_map) {
            return;
        }
        if (n >= this.m_firstFree) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.m_firstFree);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n, this.m_firstFree - n - 1);
        }
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public void setElementAt(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[n] = node;
    }

    public Node elementAt(int n) {
        if (null == this.m_map) {
            return null;
        }
        return this.m_map[n];
    }

    public boolean contains(Node node) {
        this.runTo(-1);
        if (null == this.m_map) {
            return false;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            Node node2 = this.m_map[i];
            if (null == node2 || !node2.equals(node)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Node node, int n) {
        this.runTo(-1);
        if (null == this.m_map) {
            return -1;
        }
        for (int i = n; i < this.m_firstFree; ++i) {
            Node node2 = this.m_map[i];
            if (null == node2 || !node2.equals(node)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Node node) {
        this.runTo(-1);
        if (null == this.m_map) {
            return -1;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            Node node2 = this.m_map[i];
            if (null == node2 || !node2.equals(node)) continue;
            return i;
        }
        return -1;
    }
}

