/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.domapi;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPath;
import org.apache.xpath.domapi.XPathNamespaceImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathResult;

class XPathResultImpl
implements XPathResult,
EventListener {
    private final XObject m_resultObj;
    private final XPath m_xpath;
    private final short m_resultType;
    private boolean m_isInvalidIteratorState = false;
    private final Node m_contextNode;
    private NodeIterator m_iterator = null;
    private NodeList m_list = null;

    XPathResultImpl(short s, XObject xObject, Node node, XPath xPath) {
        if (!XPathResultImpl.isValidType(s)) {
            String string = XPATHMessages.createXPATHMessage("ER_INVALID_XPATH_TYPE", new Object[]{new Integer(s)});
            throw new XPathException(52, string);
        }
        if (null == xObject) {
            String string = XPATHMessages.createXPATHMessage("ER_EMPTY_XPATH_RESULT", null);
            throw new XPathException(51, string);
        }
        this.m_resultObj = xObject;
        this.m_contextNode = node;
        this.m_xpath = xPath;
        this.m_resultType = s == 0 ? this.getTypeFromXObject(xObject) : s;
        if (this.m_resultType == 5 || this.m_resultType == 4) {
            this.addEventListener();
        }
        if (this.m_resultType == 5 || this.m_resultType == 4 || this.m_resultType == 8 || this.m_resultType == 9) {
            try {
                this.m_iterator = this.m_resultObj.nodeset();
            }
            catch (TransformerException transformerException) {
                String string = XPATHMessages.createXPATHMessage("ER_INCOMPATIBLE_TYPES", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.getTypeFromXObject(this.m_resultObj)), this.getTypeString(this.m_resultType)});
                throw new XPathException(52, string);
            }
        }
        if (this.m_resultType == 6 || this.m_resultType == 7) {
            try {
                this.m_list = this.m_resultObj.nodelist();
            }
            catch (TransformerException transformerException) {
                String string = XPATHMessages.createXPATHMessage("ER_INCOMPATIBLE_TYPES", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.getTypeFromXObject(this.m_resultObj)), this.getTypeString(this.m_resultType)});
                throw new XPathException(52, string);
            }
        }
    }

    public short getResultType() {
        return this.m_resultType;
    }

    public double getNumberValue() throws XPathException {
        if (this.getResultType() != 1) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_XPATHRESULTTYPE_TO_NUMBER", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.m_resultType)});
            throw new XPathException(52, string);
        }
        try {
            return this.m_resultObj.num();
        }
        catch (Exception exception) {
            throw new XPathException(52, exception.getMessage());
        }
    }

    public String getStringValue() throws XPathException {
        if (this.getResultType() != 2) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_STRING", new Object[]{this.m_xpath.getPatternString(), this.m_resultObj.getTypeString()});
            throw new XPathException(52, string);
        }
        try {
            return this.m_resultObj.str();
        }
        catch (Exception exception) {
            throw new XPathException(52, exception.getMessage());
        }
    }

    public boolean getBooleanValue() throws XPathException {
        if (this.getResultType() != 3) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_BOOLEAN", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.m_resultType)});
            throw new XPathException(52, string);
        }
        try {
            return this.m_resultObj.bool();
        }
        catch (TransformerException transformerException) {
            throw new XPathException(52, transformerException.getMessage());
        }
    }

    public Node getSingleNodeValue() throws XPathException {
        if (this.m_resultType != 8 && this.m_resultType != 9) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_SINGLENODE", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.m_resultType)});
            throw new XPathException(52, string);
        }
        NodeIterator nodeIterator = null;
        try {
            nodeIterator = this.m_resultObj.nodeset();
        }
        catch (TransformerException transformerException) {
            throw new XPathException(52, transformerException.getMessage());
        }
        if (null == nodeIterator) {
            return null;
        }
        Node node = nodeIterator.nextNode();
        if (this.isNamespaceNode(node)) {
            return new XPathNamespaceImpl(node);
        }
        return node;
    }

    public boolean getInvalidIteratorState() {
        return this.m_isInvalidIteratorState;
    }

    public int getSnapshotLength() throws XPathException {
        if (this.m_resultType != 6 && this.m_resultType != 7) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_GET_SNAPSHOT_LENGTH", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.m_resultType)});
            throw new XPathException(52, string);
        }
        return this.m_list.getLength();
    }

    public Node iterateNext() throws XPathException, DOMException {
        if (this.m_resultType != 4 && this.m_resultType != 5) {
            String string = XPATHMessages.createXPATHMessage("ER_NON_ITERATOR_TYPE", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.m_resultType)});
            throw new XPathException(52, string);
        }
        if (this.getInvalidIteratorState()) {
            String string = XPATHMessages.createXPATHMessage("ER_DOC_MUTATED", null);
            throw new DOMException(11, string);
        }
        Node node = this.m_iterator.nextNode();
        if (null == node) {
            this.removeEventListener();
        }
        if (this.isNamespaceNode(node)) {
            return new XPathNamespaceImpl(node);
        }
        return node;
    }

    public Node snapshotItem(int n) throws XPathException {
        if (this.m_resultType != 6 && this.m_resultType != 7) {
            String string = XPATHMessages.createXPATHMessage("ER_NON_SNAPSHOT_TYPE", new Object[]{this.m_xpath.getPatternString(), this.getTypeString(this.m_resultType)});
            throw new XPathException(52, string);
        }
        Node node = this.m_list.item(n);
        if (this.isNamespaceNode(node)) {
            return new XPathNamespaceImpl(node);
        }
        return node;
    }

    static boolean isValidType(short s) {
        switch (s) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void handleEvent(Event event) {
        if (event.getType().equals("DOMSubtreeModified")) {
            this.m_isInvalidIteratorState = true;
            this.removeEventListener();
        }
    }

    private String getTypeString(int n) {
        switch (n) {
            case 0: {
                return "ANY_TYPE";
            }
            case 8: {
                return "ANY_UNORDERED_NODE_TYPE";
            }
            case 3: {
                return "BOOLEAN";
            }
            case 9: {
                return "FIRST_ORDERED_NODE_TYPE";
            }
            case 1: {
                return "NUMBER_TYPE";
            }
            case 5: {
                return "ORDERED_NODE_ITERATOR_TYPE";
            }
            case 7: {
                return "ORDERED_NODE_SNAPSHOT_TYPE";
            }
            case 2: {
                return "STRING_TYPE";
            }
            case 4: {
                return "UNORDERED_NODE_ITERATOR_TYPE";
            }
            case 6: {
                return "UNORDERED_NODE_SNAPSHOT_TYPE";
            }
        }
        return "#UNKNOWN";
    }

    private short getTypeFromXObject(XObject xObject) {
        switch (xObject.getType()) {
            case 1: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case -1: {
                return 0;
            }
        }
        return 0;
    }

    private boolean isNamespaceNode(Node node) {
        return null != node && node.getNodeType() == 2 && (node.getNodeName().startsWith("xmlns:") || node.getNodeName().equals("xmlns"));
    }

    private void addEventListener() {
        if (this.m_contextNode instanceof EventTarget) {
            ((EventTarget)((Object)this.m_contextNode)).addEventListener("DOMSubtreeModified", this, true);
        }
    }

    private void removeEventListener() {
        if (this.m_contextNode instanceof EventTarget) {
            ((EventTarget)((Object)this.m_contextNode)).removeEventListener("DOMSubtreeModified", this, true);
        }
    }
}

