/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import com.ibm.xtq.common.utils.PerSessionHash;
import java.util.Locale;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XString
extends XObject
implements XMLString {
    static final long serialVersionUID = 2020470518395094525L;
    public static final XString EMPTYSTRING = new XString("");

    protected XString(Object object) {
        super(object);
    }

    public XString(String string) {
        super(string);
    }

    public int getType() {
        return 3;
    }

    public String getTypeString() {
        return "#STRING";
    }

    public boolean hasString() {
        return true;
    }

    public double num() {
        return this.toDouble();
    }

    public double toDouble() {
        XMLString xMLString = this.trim();
        double d = Double.NaN;
        for (int i = 0; i < xMLString.length(); ++i) {
            char c = xMLString.charAt(i);
            if (c == '-' || c == '.' || c >= '0' && c <= '9') continue;
            return d;
        }
        try {
            d = Double.parseDouble(((Object)xMLString).toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public XMLString xstr() {
        return this;
    }

    public String str() {
        return null != this.m_obj ? (String)this.m_obj : "";
    }

    public int rtf(XPathContext xPathContext) {
        DTM dTM = xPathContext.createDocumentFragment();
        dTM.appendTextChild(this.str());
        return dTM.getDocument();
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.str();
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public void dispatchAsComment(LexicalHandler lexicalHandler) throws SAXException {
        String string = this.str();
        lexicalHandler.comment(string.toCharArray(), 0, string.length());
    }

    public int length() {
        return this.str().length();
    }

    public char charAt(int n) {
        return this.str().charAt(n);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        this.str().getChars(n, n2, cArray, n3);
    }

    public boolean equals(XObject xObject) {
        int n = xObject.getType();
        try {
            if (4 == n) {
                return xObject.equals(this);
            }
            if (1 == n) {
                return xObject.bool() == this.bool();
            }
            if (2 == n) {
                return xObject.num() == this.num();
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        return this.xstr().equals(xObject.xstr());
    }

    public boolean equals(String string) {
        return this.str().equals(string);
    }

    public boolean equals(XMLString xMLString) {
        if (xMLString != null) {
            if (!xMLString.hasString()) {
                return xMLString.equals(this.str());
            }
            return this.str().equals(((Object)xMLString).toString());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        if (object instanceof XNumber) {
            return object.equals(this);
        }
        return this.str().equals(object.toString());
    }

    public boolean equalsIgnoreCase(String string) {
        return this.str().equalsIgnoreCase(string);
    }

    public int compareTo(XMLString xMLString) {
        int n = this.length();
        int n2 = xMLString.length();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = this.charAt(n4);
            if (c2 != (c = xMLString.charAt(n5))) {
                return c2 - c;
            }
            ++n4;
            ++n5;
        }
        return n - n2;
    }

    public int compareToIgnoreCase(XMLString xMLString) {
        throw new WrappedRuntimeException(new NoSuchMethodException("Java 1.2 method, not yet implemented"));
    }

    public boolean startsWith(String string, int n) {
        return this.str().startsWith(string, n);
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean startsWith(XMLString xMLString, int n) {
        int n2 = n;
        int n3 = this.length();
        int n4 = 0;
        int n5 = xMLString.length();
        if (n < 0 || n > n3 - n5) {
            return false;
        }
        while (--n5 >= 0) {
            if (this.charAt(n2) != xMLString.charAt(n4)) {
                return false;
            }
            ++n2;
            ++n4;
        }
        return true;
    }

    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    public boolean endsWith(String string) {
        return this.str().endsWith(string);
    }

    public int hashCode() {
        return PerSessionHash.hash(this.str());
    }

    public int indexOf(int n) {
        return this.str().indexOf(n);
    }

    public int indexOf(int n, int n2) {
        return this.str().indexOf(n, n2);
    }

    public int lastIndexOf(int n) {
        return this.str().lastIndexOf(n);
    }

    public int lastIndexOf(int n, int n2) {
        return this.str().lastIndexOf(n, n2);
    }

    public int indexOf(String string) {
        return this.str().indexOf(string);
    }

    public int indexOf(XMLString xMLString) {
        return this.str().indexOf(((Object)xMLString).toString());
    }

    public int indexOf(String string, int n) {
        return this.str().indexOf(string, n);
    }

    public int lastIndexOf(String string) {
        return this.str().lastIndexOf(string);
    }

    public int lastIndexOf(String string, int n) {
        return this.str().lastIndexOf(string, n);
    }

    public XMLString substring(int n) {
        return new XString(this.str().substring(n));
    }

    public XMLString substring(int n, int n2) {
        return new XString(this.str().substring(n, n2));
    }

    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    public XMLString toLowerCase(Locale locale) {
        return new XString(this.str().toLowerCase(locale));
    }

    public XMLString toLowerCase() {
        return new XString(this.str().toLowerCase());
    }

    public XMLString toUpperCase(Locale locale) {
        return new XString(this.str().toUpperCase(locale));
    }

    public XMLString toUpperCase() {
        return new XString(this.str().toUpperCase());
    }

    public XMLString trim() {
        return new XString(this.str().trim());
    }

    private static boolean isSpace(char c) {
        return XMLCharacterRecognizer.isWhiteSpace(c);
    }

    public XMLString fixWhiteSpace(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        int n3 = this.length();
        char[] cArray = new char[n3];
        this.getChars(0, n3, cArray, 0);
        boolean bl4 = false;
        for (n2 = 0; n2 < n3 && !XString.isSpace(cArray[n2]); ++n2) {
        }
        int n4 = n2;
        boolean bl5 = false;
        while (n2 < n3) {
            n = cArray[n2];
            if (XString.isSpace((char)n)) {
                if (!bl5) {
                    if (32 != n) {
                        bl4 = true;
                    }
                    cArray[n4++] = 32;
                    if (bl3 && n2 != 0) {
                        char c = cArray[n2 - 1];
                        if (c != '.' && c != '!' && c != '?') {
                            bl5 = true;
                        }
                    } else {
                        bl5 = true;
                    }
                } else {
                    bl4 = true;
                    bl5 = true;
                }
            } else {
                cArray[n4++] = n;
                bl5 = false;
            }
            ++n2;
        }
        if (bl2 && 1 <= n4 && ' ' == cArray[n4 - 1]) {
            bl4 = true;
            --n4;
        }
        n = 0;
        if (bl && 0 < n4 && ' ' == cArray[0]) {
            bl4 = true;
            ++n;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl4 ? xMLStringFactory.newstr(new String(cArray, n, n4 - n)) : this;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitStringLiteral(expressionOwner, this);
    }
}

