/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList,
ExpressionOwner {
    static final long serialVersionUID = 9071668960168152644L;
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n, String string, String string2, int n2, int n3) {
        super(n, string, string2);
        this.m_axis = n2;
    }

    public StepPattern(int n, int n2, int n3) {
        super(n);
        this.m_axis = n2;
    }

    public void calcTargetString() {
        int n = this.getWhatToShow();
        switch (n) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (null != this.m_predicates) {
            for (int i = 0; i < this.m_predicates.length; ++i) {
                this.m_predicates[i].fixupVariables(vector, n);
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.fixupVariables(vector, n);
        }
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.m_relativePathPattern = stepPattern;
        stepPattern.exprSetParent(this);
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getPredicate(i).canTraverseOutsideSubtree()) continue;
            return true;
        }
        return false;
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.m_predicates = expressionArray;
        if (null != expressionArray) {
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i].exprSetParent(this);
            }
        }
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xPathContext, int n) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        if (dTM != null) {
            int n2 = dTM.getExpandedTypeID(n);
            return this.execute(xPathContext, n, dTM, n2);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getCurrentNode());
    }

    public XObject execute(XPathContext xPathContext, int n, DTM dTM, int n2) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.m_relativePathPattern) {
                return this.m_relativePathPattern.execute(xPathContext);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject xObject = super.execute(xPathContext, n, dTM, n2);
        if (xObject == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xPathContext, dTM, n)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.m_relativePathPattern) {
            return this.m_relativePathPattern.executeRelativePathPattern(xPathContext, dTM, n);
        }
        return xObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkProximityPosition(XPathContext xPathContext, int n, DTM dTM, int n2, int n3) {
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(12);
            int n4 = dTMAxisTraverser.first(n2);
            while (-1 != n4) {
                block20: {
                    try {
                        int n5;
                        xPathContext.pushCurrentNode(n4);
                        if (NodeTest.SCORE_NONE == super.execute(xPathContext, n4)) break block20;
                        boolean bl = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            for (n5 = 0; n5 < n; ++n5) {
                                xPathContext.pushPredicatePos(n5);
                                try {
                                    XObject xObject = this.m_predicates[n5].execute(xPathContext);
                                    try {
                                        if (2 == xObject.getType()) {
                                            throw new Error("Why: Should never have been called");
                                        }
                                        if (xObject.boolWithSideEffects()) continue;
                                        bl = false;
                                        break;
                                    }
                                    finally {
                                        xObject.detach();
                                    }
                                }
                                finally {
                                    xPathContext.popPredicatePos();
                                }
                            }
                        }
                        finally {
                            xPathContext.popSubContextList();
                        }
                        if (bl) {
                            --n3;
                        }
                        if (n3 < 1) {
                            n5 = 0;
                            return n5 != 0;
                        }
                    }
                    finally {
                        xPathContext.popCurrentNode();
                    }
                }
                n4 = dTMAxisTraverser.next(n2, n4);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        if (n3 != 1) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xPathContext, int n, boolean bl) {
        int n2 = 0;
        int n3 = xPathContext.getCurrentNode();
        DTM dTM = xPathContext.getDTM(n3);
        int n4 = dTM.getParent(n3);
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(3);
            int n5 = dTMAxisTraverser.first(n4);
            while (-1 != n5) {
                block23: {
                    try {
                        int n6;
                        xPathContext.pushCurrentNode(n5);
                        if (NodeTest.SCORE_NONE == super.execute(xPathContext, n5)) break block23;
                        boolean bl2 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            for (n6 = 0; n6 < n; ++n6) {
                                xPathContext.pushPredicatePos(n6);
                                try {
                                    XObject xObject = this.m_predicates[n6].execute(xPathContext);
                                    try {
                                        if (2 == xObject.getType()) {
                                            if (n2 + 1 == (int)xObject.numWithSideEffects()) continue;
                                            bl2 = false;
                                        } else {
                                            if (xObject.boolWithSideEffects()) continue;
                                            bl2 = false;
                                        }
                                        break;
                                    }
                                    finally {
                                        xObject.detach();
                                    }
                                }
                                finally {
                                    xPathContext.popPredicatePos();
                                }
                            }
                        }
                        finally {
                            xPathContext.popSubContextList();
                        }
                        if (bl2) {
                            ++n2;
                        }
                        if (!bl && n5 == n3) {
                            n6 = n2;
                            return n6;
                        }
                    }
                    finally {
                        xPathContext.popCurrentNode();
                    }
                }
                n5 = dTMAxisTraverser.next(n4, n5);
            }
            return n2;
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final XObject executeRelativePathPattern(XPathContext xPathContext, DTM dTM, int n) throws TransformerException {
        XObject xObject = NodeTest.SCORE_NONE;
        int n2 = n;
        DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(this.m_axis);
        int n3 = dTMAxisTraverser.first(n2);
        while (-1 != n3) {
            try {
                xPathContext.pushCurrentNode(n3);
                xObject = this.execute(xPathContext);
                if (xObject != NodeTest.SCORE_NONE) {
                    break;
                }
            }
            finally {
                xPathContext.popCurrentNode();
            }
            n3 = dTMAxisTraverser.next(n2, n3);
        }
        return xObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean executePredicates(XPathContext xPathContext, DTM dTM, int n) throws TransformerException {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = this.getPredicateCount();
        try {
            xPathContext.pushSubContextList(this);
            for (int i = 0; i < n2; ++i) {
                xPathContext.pushPredicatePos(i);
                try {
                    XObject xObject = this.m_predicates[i].execute(xPathContext);
                    try {
                        if (2 == xObject.getType()) {
                            int n3 = (int)xObject.num();
                            if (bl2) {
                                bl = n3 == 1;
                                break;
                            }
                            bl2 = true;
                            if (this.checkProximityPosition(xPathContext, i, dTM, n, n3)) continue;
                            bl = false;
                            break;
                        }
                        if (xObject.boolWithSideEffects()) continue;
                        bl = false;
                        break;
                    }
                    finally {
                        xObject.detach();
                    }
                }
                finally {
                    xPathContext.popPredicatePos();
                }
            }
        }
        finally {
            xPathContext.popSubContextList();
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StepPattern stepPattern = this;
        while (stepPattern != null) {
            if (stepPattern != this) {
                stringBuffer.append("/");
            }
            stringBuffer.append(Axis.getNames(stepPattern.m_axis));
            stringBuffer.append("::");
            if (20480 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc()");
            } else if (65536 == stepPattern.m_whatToShow) {
                stringBuffer.append("function()");
            } else if (-1 == stepPattern.m_whatToShow) {
                stringBuffer.append("node()");
            } else if (4 == stepPattern.m_whatToShow) {
                stringBuffer.append("text()");
            } else if (64 == stepPattern.m_whatToShow) {
                stringBuffer.append("processing-instruction(");
                if (null != stepPattern.m_name) {
                    stringBuffer.append(stepPattern.m_name);
                }
                stringBuffer.append(")");
            } else if (128 == stepPattern.m_whatToShow) {
                stringBuffer.append("comment()");
            } else if (null != stepPattern.m_name) {
                if (2 == stepPattern.m_whatToShow) {
                    stringBuffer.append("@");
                }
                if (null != stepPattern.m_namespace) {
                    stringBuffer.append("{");
                    stringBuffer.append(stepPattern.m_namespace);
                    stringBuffer.append("}");
                }
                stringBuffer.append(stepPattern.m_name);
            } else if (2 == stepPattern.m_whatToShow) {
                stringBuffer.append("@");
            } else if (1280 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc-root()");
            } else {
                stringBuffer.append("?" + Integer.toHexString(stepPattern.m_whatToShow));
            }
            if (null != stepPattern.m_predicates) {
                for (int i = 0; i < stepPattern.m_predicates.length; ++i) {
                    stringBuffer.append("[");
                    stringBuffer.append(stepPattern.m_predicates[i]);
                    stringBuffer.append("]");
                }
            }
            stepPattern = stepPattern.m_relativePathPattern;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xPathContext, int n) throws TransformerException {
        xPathContext.pushCurrentNode(n);
        xPathContext.pushCurrentExpressionNode(n);
        try {
            XObject xObject = this.execute(xPathContext);
            double d = xObject.num();
            return d;
        }
        finally {
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
        }
    }

    public void setAxis(int n) {
        this.m_axis = n;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitMatchPattern(expressionOwner, this)) {
            this.callSubtreeVisitors(xPathVisitor);
        }
    }

    protected void callSubtreeVisitors(XPathVisitor xPathVisitor) {
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            for (int i = 0; i < n; ++i) {
                PredOwner predOwner = new PredOwner(i);
                if (!xPathVisitor.visitPredicate(predOwner, this.m_predicates[i])) continue;
                this.m_predicates[i].callVisitors(predOwner, xPathVisitor);
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.callVisitors(this, xPathVisitor);
        }
    }

    public Expression getExpression() {
        return this.m_relativePathPattern;
    }

    public void setExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_relativePathPattern = (StepPattern)expression;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        StepPattern stepPattern = (StepPattern)expression;
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            if (null == stepPattern.m_predicates || stepPattern.m_predicates.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_predicates[i].deepEquals(stepPattern.m_predicates[i])) continue;
                return false;
            }
        } else if (null != stepPattern.m_predicates) {
            return false;
        }
        return !(null != this.m_relativePathPattern ? !this.m_relativePathPattern.deepEquals(stepPattern.m_relativePathPattern) : stepPattern.m_relativePathPattern != null);
    }

    class PredOwner
    implements ExpressionOwner {
        int m_index;

        PredOwner(int n) {
            this.m_index = n;
        }

        public Expression getExpression() {
            return StepPattern.this.m_predicates[this.m_index];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(StepPattern.this);
            StepPattern.this.m_predicates[this.m_index] = expression;
        }
    }
}

