/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.Breakpoint;
import com.ibm.db2.psmd.mgr.ByteArrayBuffer;
import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrNode;
import com.ibm.db2.psmd.mgr.SessionRoutine;
import com.ibm.db2.psmd.mgr.SessionUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClientRoutine {
    protected String routineId;
    protected String routineType;
    protected int routineLanguage;
    protected String routineSchema;
    protected String routineName;
    protected String moduleName;
    protected String specificSchema;
    protected String specificName;
    protected String version;
    protected String timestamp;
    protected boolean isInit;
    protected Hashtable breakpoints;
    protected int breakpointsSQN;

    public ClientRoutine(String string) {
        this.routineId = string;
        this.breakpoints = new Hashtable();
        this.breakpointsSQN = 0;
        this.isInit = false;
    }

    protected void finalize() {
    }

    public boolean isInitialized() {
        return this.isInit;
    }

    public void initialize(PSMDMgrNode pSMDMgrNode) {
        this.routineType = "" + pSMDMgrNode.getType();
        this.routineLanguage = pSMDMgrNode.getLanguage();
        this.routineSchema = pSMDMgrNode.getRoutineSchema();
        this.routineName = pSMDMgrNode.getRoutineName();
        this.moduleName = pSMDMgrNode.getModuleName();
        this.specificSchema = pSMDMgrNode.getSpecificSchema();
        this.specificName = pSMDMgrNode.getSpecificName();
        this.version = pSMDMgrNode.getVersion();
        this.timestamp = pSMDMgrNode.getTimestamp();
        this.isInit = true;
    }

    public String getRoutineId() {
        return this.routineId;
    }

    public String getRoutineType() {
        return this.routineType;
    }

    public int getRoutineLanguage() {
        return this.routineLanguage;
    }

    public String getRoutineSchema() {
        return this.routineSchema;
    }

    public String getRoutineName() {
        return this.routineName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getSpecificSchema() {
        return this.specificSchema;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    private byte[] composeAddBreakPts() {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        Enumeration enumeration = this.breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            Breakpoint breakpoint = (Breakpoint)enumeration.nextElement();
            if (breakpoint.mState == null || !breakpoint.mState.equals("1")) continue;
            byteArrayBuffer.append(breakpoint.composeAddBreakPt());
        }
        return byteArrayBuffer.getData();
    }

    public void processSendBreakpoints(ByteArrayBuffer byteArrayBuffer, SessionRoutine sessionRoutine) {
        if (this.breakpointsSQN != sessionRoutine.getBreakpointsSQN()) {
            byteArrayBuffer.append(PSMDMgrComposer.composeRemoveAllBreakPts());
            byteArrayBuffer.append(this.composeAddBreakPts());
            sessionRoutine.setBreakpointsSQN(this.breakpointsSQN);
        }
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        Breakpoint breakpoint2 = (Breakpoint)this.breakpoints.get(breakpoint.getBId());
        if (breakpoint2 == null) {
            this.breakpoints.put(breakpoint.getBId(), breakpoint);
            this.breakpointsSQN = SessionUtil.getNewSQN(this.breakpointsSQN);
        }
    }

    public void removeBreakpoint(String string) {
        this.breakpoints.remove(string);
        this.breakpointsSQN = SessionUtil.getNewSQN(this.breakpointsSQN);
    }

    public void removeAllBreakpoints() {
        this.breakpoints.clear();
        this.breakpointsSQN = SessionUtil.getNewSQN(this.breakpointsSQN);
    }

    public void enableBreakpoint(String string) {
        Breakpoint breakpoint = (Breakpoint)this.breakpoints.get(string);
        if (breakpoint != null) {
            breakpoint.setState("1");
            this.breakpointsSQN = SessionUtil.getNewSQN(this.breakpointsSQN);
        }
    }

    public void disableBreakpoint(String string) {
        Breakpoint breakpoint = (Breakpoint)this.breakpoints.get(string);
        if (breakpoint != null) {
            breakpoint.setState("0");
            this.breakpointsSQN = SessionUtil.getNewSQN(this.breakpointsSQN);
        }
    }

    public String toString() {
        return "ClientRoutine " + this.routineId;
    }
}

