/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionManager;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class Daemon {
    private static final String CMD_HELP = "-help";
    private static final String OPT_PORT = "-port";
    private static final String OPT_TIMEOUT = "-timeout";
    private static final String OPT_LOG = "-log";
    private static final int HELP = 1;
    protected static int mPort;
    protected static int mTimeout;
    protected static String mLog;
    protected static int cmd;

    public static void startDaemon(int n, int n2) throws SQLException, Exception {
        SessionManager sessionManager = new SessionManager();
        n2 = n2 > 0 ? n2 * 1000 * 60 : -1;
        sessionManager.setPort(n);
        sessionManager.setIdleTimeout(n2);
        sessionManager.startService();
        System.exit(0);
    }

    public static void startDaemon(int n, int n2, String string) throws SQLException, Exception {
        SessionManager sessionManager = new SessionManager(string);
        n2 = n2 > 0 ? n2 * 1000 * 60 : -1;
        sessionManager.setPort(n);
        sessionManager.setIdleTimeout(n2);
        sessionManager.startService();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                SessionManager.log("args[" + n + "]: " + stringArray[n]);
                System.out.println("args[" + n + "]: " + stringArray[n]);
            }
            cmd = 0;
            mPort = 4554;
            mTimeout = -1;
            if (stringArray.length == 1) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0]);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (CMD_HELP.equalsIgnoreCase(string) || "?".equals(string)) {
                        cmd = 1;
                        continue;
                    }
                    if (OPT_PORT.equalsIgnoreCase(string)) {
                        string = stringTokenizer.nextToken();
                        mPort = Integer.parseInt(string);
                        continue;
                    }
                    if (OPT_TIMEOUT.equalsIgnoreCase(string)) {
                        string = stringTokenizer.nextToken();
                        mTimeout = Integer.parseInt(string);
                        continue;
                    }
                    if (!OPT_LOG.equalsIgnoreCase(string)) continue;
                    mLog = stringTokenizer.nextToken();
                }
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    if (CMD_HELP.equalsIgnoreCase(stringArray[n]) || "?".equals(stringArray[n])) {
                        cmd = 1;
                        continue;
                    }
                    if (OPT_PORT.equalsIgnoreCase(stringArray[n])) {
                        mPort = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (OPT_TIMEOUT.equalsIgnoreCase(stringArray[n])) {
                        mTimeout = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (!OPT_LOG.equalsIgnoreCase(stringArray[n])) continue;
                    mLog = stringArray[++n];
                }
            }
            if (cmd == 1) {
                Daemon.printHelp();
                return;
            }
            if (mLog != null) {
                Daemon.startDaemon(mPort, mTimeout, mLog);
            } else {
                Daemon.startDaemon(mPort, mTimeout);
            }
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
        }
    }

    protected static void printHelp() {
        System.out.println("Usage: java Daemon [-options]\n");
        System.out.println("where options include:");
        System.out.println("\t-help");
        System.out.println("\t-port\t<port number that session mgr will listen>");
        System.out.println("\t-timeout\t<idle timeout in second>");
        System.out.println("\t-log\t<location of log file>");
    }
}

