/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.SPDUtils;

public class PSMDMgrMessage {
    public static final int OK = 0;
    public static final int ERR_USER_PRIVILEGE = -10;
    public static final int ERR_MGR_COMMUNICATION = -20;
    public static final int ERR_JVM_NO_FREE_PORT = -30;
    public static final int ERR_JVM_NOT_LINKED = -31;
    public static final int ERR_JVM_LINKED_TIMEOUT = -32;
    public static final int ERR_RTN_NOT_FOUND = -100;
    public static final int ERR_RID_NOT_FOUND = -101;
    public static final int ERR_CON_NOT_FOUND = -120;
    public static final int ERR_CON_TIMEDOUT = -121;
    public static final int ERR_CLI_NOT_FOUND = -140;
    public static final int ERR_CLI_NOT_SUPPORTED = -141;
    public static final int ERR_CLI_ALREADY_EXIST = -142;
    public static final int ERR_CLI_SHUTDOWN = -143;
    public static final int ERR_READ_HEADER = -150;
    public static final int ERR_READ_REPLY = -151;
    public static final int ERR_READ_REQUEST = -152;
    public static final int ERR_READ_XMLDATA = -153;
    public static final int ERR_READ_BINDATA = -154;
    public static final int ERR_PARSER_FAILED = -200;
    public static final int ERR_DEBUGINFO_INVALID = -300;
    public static final int ERR_XML_INVALID = -400;
    public static final int ERR_UNKNOWN = -500;
    public static final int ERR_CON_CONNECT_FAILED = -1110;
    public static final int ERR_CON_DISCONNECT_FAILED = -1111;
    public static final int ERR_CON_SEND_FAILED = -1112;
    public static final int ERR_CON_RECV_FAILED = -1113;
    public static final int ERR_CON_INVALID_HEADER = -1114;
    public static final int ERR_CON_NOT_CONNECTED = -1115;
    protected final byte[] DUMMY_CONST = new byte[]{0, 0, 0, 0};
    protected byte[] xmlReply;
    protected byte[] xmlData;
    protected byte[] binData;
    protected String connectionId;
    protected String routineId;
    protected int stackFrame;

    public PSMDMgrMessage() {
    }

    public PSMDMgrMessage(int n, int n2) {
        this.xmlData = new byte[n];
        this.binData = new byte[n2];
    }

    public PSMDMgrMessage(byte[] byArray, byte[] byArray2) {
        this.xmlData = byArray;
        this.binData = byArray2 != null ? byArray2 : this.DUMMY_CONST;
    }

    public void setDataBuffer(byte[] byArray, byte[] byArray2) {
        this.xmlData = byArray;
        this.binData = byArray2 != null ? byArray2 : this.DUMMY_CONST;
    }

    public void createDataBuffer(int n, int n2) {
        this.xmlData = new byte[n];
        this.binData = new byte[n2];
    }

    public void saveReplyInfo(String string, String string2, int n) {
        this.connectionId = string;
        this.routineId = string2;
        this.stackFrame = n;
    }

    public void saveReplyInfo(String string) {
        this.connectionId = string;
    }

    public void genReply(boolean bl) {
        this.xmlReply = this.connectionId != null && this.routineId != null && this.stackFrame >= 0 ? PSMDMgrComposer.composePSMDReply(0, this.connectionId, this.routineId, this.stackFrame, bl) : (this.connectionId != null ? PSMDMgrComposer.composePSMDReply(0, this.connectionId, bl) : PSMDMgrComposer.composePSMDReply(0, bl));
    }

    public byte[] getReply() {
        return this.xmlReply;
    }

    public byte[] getXmlData() {
        return this.xmlData;
    }

    public byte[] getBinData() {
        return this.binData;
    }

    public int getReplySize() {
        if (this.xmlReply != null) {
            return this.xmlReply.length;
        }
        return 0;
    }

    public int getXmlDataSize() {
        if (this.xmlData != null) {
            return this.xmlData.length;
        }
        return 0;
    }

    public int getBinDataSize() {
        if (this.binData != null) {
            return this.binData.length;
        }
        return 0;
    }

    public String getBitString(int n, int n2) {
        int n3 = n + n2;
        if (n2 == 0 || n3 > this.binData.length) {
            return "";
        }
        byte[] byArray = new byte[n2];
        for (int i = n; i < n3; ++i) {
            byArray[i - n] = this.binData[i];
        }
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
            return null;
        }
        return string;
    }

    public byte[] getBitArray(int n, int n2) {
        int n3 = n + n2;
        if (n2 == 0 || n3 > this.binData.length) {
            return new byte[0];
        }
        byte[] byArray = new byte[n2];
        for (int i = n; i < n3; ++i) {
            byArray[i - n] = this.binData[i];
        }
        return byArray;
    }

    public String toString() {
        try {
            String string = new String(this.xmlData, "UTF-8");
            return string;
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
            return null;
        }
    }
}

