/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.SessionManager;

public class PSMDMgrMessageHeader {
    public static final short END_MANAGER = 0;
    public static final short CLI_PING_MANAGER = 2;
    public static final short CLI_INITIALIZE_CLIENT = 10;
    public static final short CLI_TERMINATE_CLIENT = 40;
    public static final short CLI_SEND_ROUTINE_COMMAND = 20;
    public static final short CLI_SEND_MANAGER_COMMAND = 25;
    public static final short CLI_RECV_DEBUG_REPORTS = 30;
    public static final short CLIENT_REQUESTS_MARKER = 999;
    public static final short SVR_PRE_ENTER_ROUTINE = 1000;
    public static final short SVR_ENTER_ROUTINE = 1010;
    public static final short SVR_EXIT_ROUTINE = 1020;
    public static final short SVR_INITIALIZE_ROUTINE = 1030;
    public static final short SVR_PUT_DEBUG_REPORTS_GET_DEBUG_COMMANDS = 1040;
    public static final short SVR_PUT_DEBUG_REPORTS = 1041;
    public static final short SVR_GET_DEBUG_COMMANDS = 1050;
    public static final short SVR_TERMINATE_ROUTINE = 1060;
    public static final short SVR_SET_MGR_INFO = 1070;
    public static final short SVR_GET_MGR_INFO = 1080;
    public static final short SVR_REQ_SEND_EXE_MODE = 1085;
    public static final short SVR_PING_MGR = 1090;
    public static final short SVR_SET_PORT_RANGE = 1100;
    public static final short SVR_RESERVE_PORT = 1110;
    public static final short SVR_RESERVE_ALTERNATE_PORT = 1120;
    public static final short SVR_RELEASE_PORT = 1130;
    protected byte[] data;
    protected short byteOrder = (short)-9427;
    protected short messageType;
    protected int xmlMsgSize;
    protected int xmlDataSize;
    protected int binDataSize;
    protected int F0;
    protected final int DATA_SIZE = 20;
    protected boolean isProcessed;
    protected boolean mProcessHighByte = false;

    public PSMDMgrMessageHeader() {
        this.data = new byte[20];
        this.isProcessed = false;
    }

    public PSMDMgrMessageHeader(int n, int n2, int n3, int n4) {
        this.data = new byte[20];
        this.isProcessed = false;
        this.copyShortToData(this.byteOrder, 0);
        this.copyIntToData(n, 4);
        this.copyIntToData(n2, 8);
        this.copyIntToData(n3, 12);
        this.copyIntToData(n4, 16);
    }

    private void copyShortToData(short s, int n) {
        this.data[n] = (byte)(s >> 8);
        this.data[n + 1] = (byte)s;
    }

    private void copyIntToData(int n, int n2) {
        this.data[n2] = (byte)(n >> 24);
        this.data[n2 + 1] = (byte)(n >> 16);
        this.data[n2 + 2] = (byte)(n >> 8);
        this.data[n2 + 3] = (byte)n;
    }

    public byte[] getData() {
        return this.data;
    }

    public short getMessageType() {
        if (!this.isProcessed) {
            this.processData();
        }
        return this.messageType;
    }

    public int getXmlMsgSize() {
        if (!this.isProcessed) {
            this.processData();
        }
        return this.xmlMsgSize;
    }

    public int getXmlDataSize() {
        if (!this.isProcessed) {
            this.processData();
        }
        return this.xmlDataSize;
    }

    public int getBinDataSize() {
        if (!this.isProcessed) {
            this.processData();
        }
        return this.binDataSize;
    }

    public int getF0() {
        if (!this.isProcessed) {
            this.processData();
        }
        return this.F0;
    }

    public boolean isClientRequest() {
        return this.getMessageType() < 999;
    }

    private void processData() {
        if (this.data[0] == -37) {
            this.mProcessHighByte = true;
            this.processHighByte();
        } else if (this.data[0] == 45) {
            this.processLowByte();
        } else {
            SessionManager.log("ERROR: logic error -- cannot parse the header");
            SessionManager.log("data[0]: " + this.data[0]);
            SessionManager.log("data[1]: " + this.data[1]);
            this.messageType = (short)-1;
        }
        this.isProcessed = true;
    }

    private void processHighByte() {
        this.messageType = this.processHighByteForShort(2);
        this.xmlMsgSize = this.processHighByteForInt(4);
        this.xmlDataSize = this.processHighByteForInt(8);
        this.binDataSize = this.processHighByteForInt(12);
        this.F0 = this.processHighByteForInt(16);
    }

    private short processHighByteForShort(int n) {
        byte by = this.data[n];
        int n2 = by << 8 & 0xFF00;
        by = this.data[++n];
        return (short)(n2 |= by & 0xFF);
    }

    private int processHighByteForInt(int n) {
        byte by = this.data[n];
        int n2 = by << 24;
        by = this.data[++n];
        n2 |= by << 16 & 0xFF0000;
        by = this.data[++n];
        n2 |= by << 8 & 0xFF00;
        by = this.data[++n];
        return n2 |= by & 0xFF;
    }

    private void processLowByte() {
        this.messageType = this.processLowByteForShort(3);
        this.xmlMsgSize = this.processLowByteForInt(7);
        this.xmlDataSize = this.processLowByteForInt(11);
        this.binDataSize = this.processLowByteForInt(15);
        this.F0 = this.processLowByteForInt(19);
    }

    private short processLowByteForShort(int n) {
        byte by = this.data[n];
        int n2 = by << 8 & 0xFF00;
        by = this.data[--n];
        return (short)(n2 |= by & 0xFF);
    }

    private int processLowByteForInt(int n) {
        byte by = this.data[n];
        int n2 = by << 24;
        by = this.data[--n];
        n2 |= by << 16 & 0xFF0000;
        by = this.data[--n];
        n2 |= by << 8 & 0xFF00;
        by = this.data[--n];
        return n2 |= by & 0xFF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.messageType);
        stringBuffer.append(" - msg: ");
        stringBuffer.append(this.xmlMsgSize);
        stringBuffer.append(" - xml: ");
        stringBuffer.append(this.xmlDataSize);
        stringBuffer.append(" - bin: ");
        stringBuffer.append(this.binDataSize);
        stringBuffer.append(" - F0: ");
        stringBuffer.append(this.F0);
        return stringBuffer.toString();
    }

    public PSMDMgrMessageHeader(short s, int n, int n2, int n3) {
        this.data = new byte[20];
        this.copyShortToData(this.byteOrder, 0);
        this.copyShortToData(s, 2);
        this.copyIntToData(n, 4);
        this.copyIntToData(n2, 8);
        this.copyIntToData(n3, 12);
        this.copyIntToData(0, 16);
        this.isProcessed = false;
    }

    public boolean getProcessHighByte() {
        return this.mProcessHighByte;
    }
}

