/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.Breakpoint;
import com.ibm.db2.psmd.mgr.ByteArrayBuffer;
import com.ibm.db2.psmd.mgr.ClientRoutine;
import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessage;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageQueue;
import com.ibm.db2.psmd.mgr.PSMDMgrNode;
import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionClientThread;
import com.ibm.db2.psmd.mgr.SessionConnection;
import com.ibm.db2.psmd.mgr.SessionManager;
import com.ibm.db2.psmd.mgr.SessionRoutine;
import java.util.Enumeration;
import java.util.Vector;

public class SessionClient {
    public static final String SYS_INIT = "SYS_INIT";
    public static final short EXEMODE_UNKNOWN = 1000;
    public static final short EXEMODE_PAUSE = 1004;
    public static final short EXEMODE_STEPINTO = 1008;
    public static final short EXEMODE_STEPOVER = 1012;
    public static final short EXEMODE_STEPRETURN = 1016;
    public static final short EXEMODE_RUNTOLINE = 1020;
    public static final short EXEMODE_RUN = 1024;
    public static final short EXEMODE_END = 1028;
    public static final short EXEMODE_TERMINATE = 1032;
    public static final short EXEMODE_TIMEDOUT = 1036;
    public static final short CLI_STATE_ACTIVE = 20;
    public static final short CLI_STATE_SHUTDOWN = 40;
    public static final int MIN_SESSIONTIMEOUT = 30;
    public static final int MAX_SESSIONTIMEOUT = 1800;
    public static final int MIN_VARREPORTSIZE = 64;
    public static final int MAX_VARREPORTSIZE = 8192;
    protected String clientId;
    protected Vector<String> supportTypes;
    protected Vector<SessionConnection> mConnections;
    protected PSMDMgrMessageQueue reportQueue;
    protected boolean isTimedOut;
    protected int mCliExeMode;
    private Vector<ClientRoutine> cliRoutines;
    protected int optionsSQN;
    protected int mSessionTimeout;
    protected int mMaxVarReportSize;
    protected short mProcState;
    protected String mClientRequestVersion = "1.0";
    private int mServerRequestVersion_major = 1;
    private int mServerRequestVersion_minor = 0;

    public SessionClient(String string) {
        this.clientId = string;
        this.supportTypes = new Vector();
        this.mConnections = new Vector();
        this.reportQueue = new PSMDMgrMessageQueue("Report Queue(cli:" + string + ")");
        this.isTimedOut = false;
        this.cliRoutines = new Vector();
        this.optionsSQN = 0;
        this.mSessionTimeout = 60;
        this.mMaxVarReportSize = 80;
        this.mCliExeMode = 1000;
        this.mProcState = (short)20;
    }

    protected void finalize() {
    }

    public short getProcessState() {
        return this.mProcState;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean getIsTimeout() {
        return this.isTimedOut;
    }

    private boolean isFastPerMode() {
        return this.mServerRequestVersion_major >= 4 || this.mServerRequestVersion_major == 3 && this.mServerRequestVersion_minor >= 3 || this.mServerRequestVersion_major == 1 && this.mServerRequestVersion_minor >= 3;
    }

    public void setIsTimeout(String string, boolean bl) {
        this.reportTimeout(string);
        this.mCliExeMode = 1036;
        this.isTimedOut = bl;
    }

    public int getSessionTimeout() {
        return this.mSessionTimeout;
    }

    public int getCliExeMode() {
        return this.mCliExeMode;
    }

    public void resetExeModeIfNoConnection() {
        if (this.mConnections.size() == 0) {
            this.mCliExeMode = 1000;
            this.isTimedOut = false;
        }
    }

    public void setClientRequestVersion(String string) {
        if (string != null) {
            this.mClientRequestVersion = string;
        }
    }

    public void setServerRequestVersion(String string) {
        int n;
        if (string != null && (n = string.indexOf(46)) > 0) {
            this.mServerRequestVersion_major = Integer.parseInt(string.substring(0, n));
            this.mServerRequestVersion_minor = Integer.parseInt(string.substring(n + 1));
        }
    }

    public double getClientRequestVersion() {
        try {
            return Double.parseDouble(this.mClientRequestVersion);
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
            return 1.0;
        }
    }

    public void addSupportType(int n, int n2) {
        this.supportTypes.add("" + n + "-" + n2);
    }

    public SessionConnection addConnection(String string) {
        SessionConnection sessionConnection = new SessionConnection(string);
        this.mConnections.add(sessionConnection);
        return sessionConnection;
    }

    public SessionConnection getConnection(String string) {
        SessionConnection sessionConnection = null;
        for (int i = 0; i < this.mConnections.size(); ++i) {
            sessionConnection = this.mConnections.get(i);
            if (!sessionConnection.getId().equalsIgnoreCase(string)) continue;
            return sessionConnection;
        }
        return null;
    }

    public SessionConnection getConnection() {
        Enumeration<SessionConnection> enumeration = this.mConnections.elements();
        if (enumeration.hasMoreElements()) {
            return enumeration.nextElement();
        }
        return null;
    }

    public SessionRoutine getTopRoutine(String string) {
        SessionConnection sessionConnection = this.getConnection(string);
        if (sessionConnection != null) {
            return sessionConnection.getTopRoutine();
        }
        return null;
    }

    public SessionRoutine getRoutine(String string, String string2) {
        SessionConnection sessionConnection = this.getConnection(string);
        if (sessionConnection != null) {
            return sessionConnection.getRoutine(string2);
        }
        return null;
    }

    public SessionRoutine getRoutine(String string, int n) {
        SessionConnection sessionConnection = this.getConnection(string);
        if (sessionConnection != null) {
            return sessionConnection.getRoutine(n);
        }
        return null;
    }

    public SessionConnection remConnection(String string) {
        SessionConnection sessionConnection;
        int n;
        for (n = 0; n < this.mConnections.size() && !(sessionConnection = this.mConnections.get(n)).getId().equalsIgnoreCase(string); ++n) {
        }
        if (n < this.mConnections.size()) {
            return this.mConnections.remove(n);
        }
        return null;
    }

    public void removeConIfEmpty(String string) {
        SessionConnection sessionConnection = this.getConnection(string);
        if (sessionConnection.getCallStackSize() == 0) {
            this.mConnections.remove(string);
            this.mCliExeMode = 1000;
        }
    }

    public boolean isSupported(int n, int n2) {
        String string = n + "-" + n2;
        Enumeration<String> enumeration = this.supportTypes.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean ser_putReport(String string, PSMDMgrMessage pSMDMgrMessage) {
        SessionRoutine sessionRoutine;
        if (string == null || pSMDMgrMessage == null) {
            return false;
        }
        SessionConnection sessionConnection = this.getConnection(string);
        if (sessionConnection != null && (sessionRoutine = sessionConnection.getTopRoutine()) != null) {
            pSMDMgrMessage.saveReplyInfo(string, sessionRoutine.getRoutineId(), sessionRoutine.getStackFrame());
            this.reportQueue.enqueue(pSMDMgrMessage, this.interruptSleepingThread());
            return true;
        }
        return false;
    }

    public PSMDMgrMessage cli_getReport() {
        if (this.reportQueue.size() > 0) {
            return (PSMDMgrMessage)this.reportQueue.dequeue();
        }
        return null;
    }

    public void shutdown() {
        this.mProcState = (short)40;
        Enumeration<SessionConnection> enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            SessionConnection sessionConnection = enumeration.nextElement();
            sessionConnection.shutdown();
        }
    }

    public void setWaitingThread(SessionClientThread sessionClientThread) {
        this.reportQueue.setWaitingThread(sessionClientThread);
    }

    public boolean isReportQueueEmpty() {
        return this.reportQueue.isEmpty();
    }

    protected ClientRoutine lookupCliRoutine(String string) {
        ClientRoutine clientRoutine = null;
        for (int i = 0; i < this.cliRoutines.size(); ++i) {
            clientRoutine = this.cliRoutines.get(i);
            if (!clientRoutine.getRoutineId().equalsIgnoreCase(string)) continue;
            return clientRoutine;
        }
        clientRoutine = new ClientRoutine(string);
        this.cliRoutines.add(clientRoutine);
        return clientRoutine;
    }

    public SessionRoutine ser_procEnterRoutine(PSMDMgrNode pSMDMgrNode, String string) {
        ClientRoutine clientRoutine;
        SessionConnection sessionConnection = this.getConnection(pSMDMgrNode.getConnectionId());
        if (sessionConnection == null) {
            sessionConnection = this.addConnection(pSMDMgrNode.getConnectionId());
        }
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        String string2 = pSMDMgrNode2.getJVMDebugIP();
        if (pSMDMgrNode2.getLanguage() == 1 && (string2 == null || string2 == "")) {
            string2 = string;
        }
        if (!(clientRoutine = this.lookupCliRoutine(pSMDMgrNode2.getRoutineId())).isInitialized()) {
            clientRoutine.initialize(pSMDMgrNode2);
        }
        SessionRoutine sessionRoutine = new SessionRoutine(clientRoutine, string2, pSMDMgrNode2.getJVMDebugPort());
        this.reportAddRoutine(sessionRoutine);
        sessionConnection.enterRoutine(sessionRoutine, this.mCliExeMode);
        if (!SYS_INIT.equalsIgnoreCase(sessionRoutine.getRoutineName())) {
            this.reportCallStack(sessionConnection, "enter");
        }
        return sessionRoutine;
    }

    public void ser_procExitRoutine(PSMDMgrNode pSMDMgrNode, SessionConnection sessionConnection) {
        int n = sessionConnection.exitRoutine(pSMDMgrNode.getRoutineId());
        this.reportCallStack(sessionConnection, "exit");
        if (n == 0) {
            this.remConnection(pSMDMgrNode.getConnectionId());
        }
        if (n == 0) {
            this.remConnection(pSMDMgrNode.getConnectionId());
        } else {
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            sessionRoutine.sendExeMode();
        }
        this.resetExeModeIfNoConnection();
    }

    public void cli_procCommandForMgr(SessionConnection sessionConnection, PSMDMgrNode pSMDMgrNode) {
        if (sessionConnection == null) {
            sessionConnection = this.getConnection();
        }
        if (sessionConnection != null) {
            sessionConnection.setPSMDCommandExit(pSMDMgrNode.getExit());
        }
        SessionRoutine sessionRoutine = null;
        if (sessionConnection != null) {
            sessionRoutine = sessionConnection.getTopRoutine();
        }
        if (pSMDMgrNode.getNodeName().equals("End")) {
            this.mCliExeMode = 1028;
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(10);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionConnection.updateExeModeForParentRoutines(10);
            }
        } else if (pSMDMgrNode.getNodeName().equals("Terminate")) {
            this.mCliExeMode = 1032;
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(12);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionConnection.updateExeModeForParentRoutines(12);
            }
        } else if (pSMDMgrNode.getNodeName().equals("Options")) {
            if (pSMDMgrNode.getSessionTimeout() >= 30 && pSMDMgrNode.getSessionTimeout() <= 1800) {
                this.mSessionTimeout = pSMDMgrNode.getSessionTimeout();
                ++this.optionsSQN;
            }
            if (pSMDMgrNode.getMaxVarReportSize() >= 64 && pSMDMgrNode.getMaxVarReportSize() <= 8192) {
                this.mMaxVarReportSize = pSMDMgrNode.getMaxVarReportSize();
                ++this.optionsSQN;
            }
            if (sessionRoutine != null && this.optionsSQN != sessionRoutine.getOptionsSQN() && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdOptions(this.mSessionTimeout, this.mMaxVarReportSize);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionRoutine.setOptionsSQN(this.optionsSQN);
            }
        }
    }

    public void cli_procCommandForCon(SessionConnection sessionConnection, PSMDMgrNode pSMDMgrNode) {
        if (sessionConnection != null) {
            sessionConnection.setPSMDCommandExit(pSMDMgrNode.getExit());
        }
        if (pSMDMgrNode.getNodeName().equals("Pause")) {
            this.mCliExeMode = 1004;
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(4);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionConnection.updateExeModeForParentRoutines(4);
            }
        } else if (pSMDMgrNode.getNodeName().equals("StepInto")) {
            this.mCliExeMode = 1008;
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(2);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionConnection.updateExeModeForParentRoutines(2);
            }
        } else if (pSMDMgrNode.getNodeName().equals("StepOver")) {
            this.mCliExeMode = 1012;
            sessionConnection.setStepOverIndex();
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(2);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionConnection.updateExeModeForParentRoutines(2);
            }
        } else if (pSMDMgrNode.getNodeName().equals("StepReturn")) {
            this.mCliExeMode = 1016;
            sessionConnection.setStepReturnIndex();
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(10);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
                sessionConnection.updateExeModeForParentRoutines(2);
            }
        } else if (pSMDMgrNode.getNodeName().equals("Run")) {
            this.mCliExeMode = 1024;
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                byte[] byArray = PSMDMgrComposer.composeCmdExeMode(6);
                PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                sessionRoutine.putCommand(pSMDMgrMessage);
            }
            sessionConnection.updateExeModeForParentRoutines(6);
        } else if (pSMDMgrNode.getNodeName().equals("RunToLine")) {
            this.mCliExeMode = 1020;
            String string = pSMDMgrNode.getRoutineId();
            SessionRoutine sessionRoutine = null;
            SessionRoutine sessionRoutine2 = null;
            if (string != null) {
                sessionRoutine = sessionConnection.getRoutine(string);
            }
            if ((sessionRoutine2 = sessionConnection.getTopRoutine()) == null) {
                System.out.println("061031 - PSMDTokens.RUNTOLINE RETURN - TopRoutine is NULL");
                return;
            }
            if (this.isFastPerMode()) {
                if (sessionRoutine == null) {
                    SessionManager.log("090619 procMgrCommandForCon -- RUN_TOLINE case 1");
                } else if (sessionRoutine == sessionRoutine2) {
                    SessionManager.log("090619 procMgrCommandForCon -- RUN_TOLINE case 2");
                    byte[] byArray = PSMDMgrComposer.composeCmdExeMode(8, pSMDMgrNode.getLine());
                    PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                    sessionRoutine2.putCommand(pSMDMgrMessage);
                    sessionConnection.updateExeModeForParentRoutines(8);
                } else {
                    SessionManager.log("090619 procMgrCommandForCon -- RUN_TOLINE case 3");
                    byte[] byArray = PSMDMgrComposer.composeCmdExeMode(8, pSMDMgrNode.getLine());
                    PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                    sessionRoutine.putCommand(pSMDMgrMessage);
                    byte[] byArray2 = PSMDMgrComposer.composeCmdExeMode(6);
                    PSMDMgrMessage pSMDMgrMessage2 = new PSMDMgrMessage(byArray2, null);
                    sessionRoutine2.putCommand(pSMDMgrMessage2);
                    sessionConnection.updateExeModeForParentRoutines(8);
                }
            } else {
                if (sessionRoutine != null && 1 != sessionRoutine.getRoutineLanguage()) {
                    sessionRoutine.setStopLine(pSMDMgrNode.getLine());
                } else {
                    sessionConnection.addToCmdBuffer(string, new Integer(pSMDMgrNode.getLine()));
                }
                if (1 != sessionRoutine2.getRoutineLanguage()) {
                    byte[] byArray = PSMDMgrComposer.composeCmdExeMode(8);
                    PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
                    sessionRoutine2.putCommand(pSMDMgrMessage);
                    sessionConnection.updateExeModeForParentRoutines(8);
                }
            }
        }
    }

    public int cli_procCommandForRtn(ClientRoutine clientRoutine, PSMDMgrNode pSMDMgrNode) {
        Object object;
        int n = 0;
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        while (pSMDMgrNode2 != null) {
            if (pSMDMgrNode2.getNodeName().equals("AddLineBreakPt")) {
                object = new Breakpoint(pSMDMgrNode2.getBId(), pSMDMgrNode2.getLine(), pSMDMgrNode2.getState(), pSMDMgrNode2.getHitMode(), pSMDMgrNode2.getHitCount());
                clientRoutine.addBreakpoint((Breakpoint)object);
            } else if (pSMDMgrNode2.getNodeName().equals("AddVarBreakPt")) {
                object = new Breakpoint(pSMDMgrNode2.getBId(), pSMDMgrNode2.getName(), pSMDMgrNode2.getVId(), pSMDMgrNode2.getState(), pSMDMgrNode2.getHitMode(), pSMDMgrNode2.getHitCount());
                clientRoutine.addBreakpoint((Breakpoint)object);
            } else if (pSMDMgrNode2.getNodeName().equals("RemoveBreakPt")) {
                clientRoutine.removeBreakpoint(pSMDMgrNode2.getBId());
            } else if (pSMDMgrNode2.getNodeName().equals("RemoveAllBreakPts")) {
                clientRoutine.removeAllBreakpoints();
            } else if (pSMDMgrNode2.getNodeName().equals("EnableBreakPt")) {
                clientRoutine.enableBreakpoint(pSMDMgrNode2.getBId());
            } else if (pSMDMgrNode2.getNodeName().equals("DisableBreakPt")) {
                clientRoutine.disableBreakpoint(pSMDMgrNode2.getBId());
            } else if (pSMDMgrNode2.getNodeName().equals("LinkedToDebugJVM") && (object = this.getTopRoutine(pSMDMgrNode.getConnectionId())) != null) {
                ((SessionRoutine)object).interruptJVMServerThread(pSMDMgrNode2.getRc());
            }
            pSMDMgrNode2 = pSMDMgrNode.getNextNode();
        }
        object = this.mConnections.elements();
        while (object.hasMoreElements()) {
            SessionConnection sessionConnection = object.nextElement();
            SessionRoutine sessionRoutine = sessionConnection.getTopRoutine();
            sessionRoutine.interruptInitBkptServerThread();
        }
        return n;
    }

    public PSMDMgrMessage ser_getBkptAndOption(String string, SessionRoutine sessionRoutine) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byte[] byArray = PSMDMgrComposer.composeCmdOpenNode();
        byteArrayBuffer.append(byArray);
        sessionRoutine.processSendOptions(byteArrayBuffer, this.optionsSQN, this.mSessionTimeout, this.mMaxVarReportSize);
        ClientRoutine clientRoutine = sessionRoutine.getCliRoutine();
        if (clientRoutine != null) {
            clientRoutine.processSendBreakpoints(byteArrayBuffer, sessionRoutine);
        }
        if (byteArrayBuffer.getSize() > byArray.length) {
            byteArrayBuffer.append(PSMDMgrComposer.composeCmdCloseNode());
            byte[] byArray2 = byteArrayBuffer.getData();
            return new PSMDMgrMessage(byArray2, null);
        }
        return null;
    }

    public void reportAddRoutine(SessionRoutine sessionRoutine) {
        Object object;
        boolean bl = false;
        Enumeration<SessionConnection> enumeration = this.mConnections.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (((SessionConnection)object).contains(sessionRoutine.getRoutineId())) continue;
            bl = true;
            break;
        }
        if (bl && !SYS_INIT.equalsIgnoreCase(sessionRoutine.getRoutineName())) {
            object = PSMDMgrComposer.composeRptAddRoutine(sessionRoutine.getRoutineId(), sessionRoutine.getRoutineSchema(), sessionRoutine.getRoutineName(), sessionRoutine.getModuleName(), sessionRoutine.getSpecificSchema(), sessionRoutine.getSpecificName(), sessionRoutine.getRoutineType(), "" + sessionRoutine.getRoutineLanguage(), sessionRoutine.getVersion(), sessionRoutine.getTimestamp());
            PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage((byte[])object, null);
            this.reportQueue.enqueue(pSMDMgrMessage, this.interruptSleepingThread());
        }
    }

    public void reportCallStack(SessionConnection sessionConnection, String string) {
        PSMDMgrMessage pSMDMgrMessage = sessionConnection.genReportCallStack(string);
        this.reportQueue.enqueue(pSMDMgrMessage, this.interruptSleepingThread());
    }

    public void reportTimeout(String string) {
        byte[] byArray = PSMDMgrComposer.composeRptTimedOut(string);
        PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
        pSMDMgrMessage.saveReplyInfo(string);
        this.reportQueue.enqueue(pSMDMgrMessage, this.interruptSleepingThread());
    }

    public String toString() {
        return this.clientId;
    }

    public boolean interruptSleepingThread() {
        double d = this.getClientRequestVersion();
        return d > 1.8 && d < 2.99;
    }
}

