/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.ClientRoutine;
import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessage;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageHeader;
import com.ibm.db2.psmd.mgr.PSMDMgrNode;
import com.ibm.db2.psmd.mgr.PSMDMgrParser;
import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionClient;
import com.ibm.db2.psmd.mgr.SessionConnection;
import com.ibm.db2.psmd.mgr.SessionManager;
import com.ibm.db2.psmd.mgr.SessionRoutine;
import com.ibm.db2.psmd.mgr.SessionThread;
import com.ibm.db2.psmd.mgr.SessionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class SessionClientThread
extends SessionThread {
    protected SessionClient mSessionClient;
    protected boolean mIsFirstMessage = true;

    public SessionClientThread(SessionManager sessionManager, Socket socket, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, PSMDMgrMessageHeader pSMDMgrMessageHeader, String string) {
        super(sessionManager, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader);
        this.setName("Client - " + SessionUtil.getCmdString(pSMDMgrMessageHeader.getMessageType()));
        SessionManager.log(string);
    }

    public void run() {
        boolean bl = false;
        try {
            int n = 0;
            PSMDMgrParser pSMDMgrParser = new PSMDMgrParser();
            short s = 0;
            byte[] byArray = null;
            while (!bl) {
                if (!this.mIsFirstMessage) {
                    this.messageHeader = new PSMDMgrMessageHeader();
                    if (!SessionUtil.readBytes(this.inStream, this.messageHeader.getData())) {
                        this.sendReply(PSMDMgrComposer.composePSMDReply(-150, "Error: cannot read header"));
                        SessionManager.log("ClientThread.run -- ERROR: cannot read the header");
                        bl = true;
                    }
                }
                s = this.messageHeader.getMessageType();
                byArray = new byte[this.messageHeader.getXmlMsgSize()];
                if (!SessionUtil.readBytes(this.inStream, byArray)) {
                    this.sendReply(PSMDMgrComposer.composePSMDReply(-152, "Error: cannot read request"));
                    SessionManager.log("ERROR: cli thread cannot read the request");
                    SessionManager.logX("cliThread - header: ", this.messageHeader.getData());
                    SessionManager.logX("cliThread - ERROR: ", byArray);
                    return;
                }
                if (this.messageHeader.getMessageType() != 30) {
                    String string = SessionUtil.getCmdString(this.messageHeader.getMessageType());
                    String string2 = new String(byArray, "UTF-8");
                    SessionManager.log("cliThread - " + string + ": entry");
                    SessionManager.log("cliThread - XML1: " + string2);
                    SessionManager.logX("cliThread - XML2: ", byArray);
                } else {
                    SessionManager.logDot();
                }
                pSMDMgrParser = new PSMDMgrParser();
                if (s == 25) {
                    pSMDMgrParser.parse(new String(byArray, "UTF-8"));
                    n = this.putManagerCommand(pSMDMgrParser.getNode());
                    SessionManager.log("cliThread - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
                    this.mSessionMgr.getStopTimer().resetTimer();
                } else if (s == 20) {
                    pSMDMgrParser.parse(new String(byArray, "UTF-8"));
                    n = this.putRoutineCommand(pSMDMgrParser.getNode());
                    SessionManager.log("cliThread - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
                    this.mSessionMgr.getStopTimer().resetTimer();
                } else if (s == 30) {
                    pSMDMgrParser.parse(new String(byArray, "UTF-8"));
                    n = this.getReport(pSMDMgrParser.getNode());
                    if (0 != n && n != -121) {
                        SessionManager.log("cliThread - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - ERROR - rc: " + n);
                    }
                    this.mSessionMgr.getStopTimer().resetTimer();
                } else {
                    SessionManager.log("ERROR: UNKNOWN request type - request: " + s);
                }
                SessionManager.logTime("------------------------ end: " + s);
                if (this.messageHeader.getMessageType() == 30) continue;
                SessionManager.log("00" + this.messageHeader.getMessageType() + ": 'done'");
            }
        }
        catch (SocketException socketException) {
            if (!socketException.getMessage().equalsIgnoreCase("Connection reset")) {
                SPDUtils.logError(socketException);
            }
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
        }
        this.waitForSocketToBeClosed();
        try {
            this.inStream.close();
            this.outStream.close();
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
        }
    }

    protected int putManagerCommand(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            this.mSessionClient = sessionClient;
            if (this.mIsFirstMessage && sessionClient.getClientRequestVersion() > 1.99) {
                this.mIsFirstMessage = false;
            }
            if (sessionClient.getProcessState() == 40) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-143, "Error: session client object will be shutdown."));
                return -143;
            }
            if (pSMDMgrNode2.getNodeName().equals("ClientRequest")) {
                SessionConnection sessionConnection = null;
                if (pSMDMgrNode2.getConnectionId() != null) {
                    sessionConnection = this.getConnection(pSMDMgrNode2.getClientId(), pSMDMgrNode2.getConnectionId());
                }
                PSMDMgrNode pSMDMgrNode3 = pSMDMgrNode2.getFirstNode();
                sessionClient.cli_procCommandForMgr(sessionConnection, pSMDMgrNode3);
                this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
                return 0;
            }
            if (pSMDMgrNode2.getNodeName().equals("ConnectionRequest")) {
                SessionConnection sessionConnection = this.getConnection(pSMDMgrNode2.getClientId(), pSMDMgrNode2.getConnectionId());
                if (sessionConnection != null) {
                    PSMDMgrNode pSMDMgrNode4 = pSMDMgrNode2.getFirstNode();
                    sessionClient.cli_procCommandForCon(sessionConnection, pSMDMgrNode4);
                    this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
                    return 0;
                }
                this.sendReply(PSMDMgrComposer.composePSMDReply(-120, "Error: connection not found"));
                SessionManager.log("ClientThread.run -- ERROR: connection not found -- clientID: '" + pSMDMgrNode2.getClientId() + "' -- connectionID: '" + pSMDMgrNode2.getConnectionId() + "'");
                return -120;
            }
            if (pSMDMgrNode2.getNodeName().equals("RoutineRequests")) {
                ClientRoutine clientRoutine = sessionClient.lookupCliRoutine(pSMDMgrNode2.getRoutineId());
                if (clientRoutine != null) {
                    sessionClient.cli_procCommandForRtn(clientRoutine, pSMDMgrNode2);
                    this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
                    return 0;
                }
                System.out.println("ERROR RTN_NOT_FOUND!!!!");
                this.sendReply(PSMDMgrComposer.composePSMDReply(-100, "Error: routine not found"));
                return -100;
            }
            return -500;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-140, "Error: client not found"));
        return -140;
    }

    protected int putRoutineCommand(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            PSMDMgrMessage pSMDMgrMessage;
            sessionClient.setClientRequestVersion(pSMDMgrNode.getVersion());
            this.mSessionClient = sessionClient;
            if (this.mIsFirstMessage && sessionClient.getClientRequestVersion() > 1.99) {
                this.mIsFirstMessage = false;
            }
            if (!SessionUtil.readBytes(this.inStream, (pSMDMgrMessage = new PSMDMgrMessage(this.messageHeader.getXmlDataSize(), this.messageHeader.getBinDataSize())).getXmlData())) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-153, "Error: cannot read xmldata"));
                return -153;
            }
            if (!SessionUtil.readBytes(this.inStream, pSMDMgrMessage.getBinData())) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-154, "Error: cannot read bindata"));
                return -154;
            }
            SessionManager.logTime("------------------------ done xml & bin");
            if (sessionClient.getProcessState() == 40) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-143, "Error: session client object will be shutdown."));
                return -143;
            }
            SessionRoutine sessionRoutine = sessionClient.getRoutine(pSMDMgrNode2.getConnectionId(), pSMDMgrNode2.getStackFrame());
            if (sessionRoutine != null) {
                sessionRoutine.putCommand(pSMDMgrMessage);
                this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
                return 0;
            }
            this.sendReply(PSMDMgrComposer.composePSMDReply(-100, "Error: routine not found"));
            return -100;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-140, "Error: client not found"));
        return -140;
    }

    protected int getReport(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            this.mSessionClient = sessionClient;
            if (this.mIsFirstMessage && sessionClient.getClientRequestVersion() > 1.99) {
                this.mIsFirstMessage = false;
            }
            if (sessionClient.getProcessState() == 40) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-143, "Error: session client object will be shutdown."));
                return -143;
            }
            PSMDMgrMessage pSMDMgrMessage = sessionClient.cli_getReport();
            if (pSMDMgrMessage == null && pSMDMgrNode2.getTimeout() > 5) {
                sessionClient.setWaitingThread(this);
                try {
                    Thread.sleep(pSMDMgrNode2.getTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pSMDMgrMessage = sessionClient.cli_getReport();
            }
            if (pSMDMgrMessage != null) {
                boolean bl = sessionClient.isReportQueueEmpty();
                this.sendMessage(pSMDMgrMessage, !bl);
                return 0;
            }
            this.sendReply(PSMDMgrComposer.composePSMDReply(-121, "Error: time out"));
            return -121;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-140, "Error: client not found"));
        return -140;
    }
}

