/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageHeader;
import com.ibm.db2.psmd.mgr.PSMDMgrNode;
import com.ibm.db2.psmd.mgr.PSMDMgrParser;
import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionClient;
import com.ibm.db2.psmd.mgr.SessionManager;
import com.ibm.db2.psmd.mgr.SessionThread;
import com.ibm.db2.psmd.mgr.SessionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;

public class SessionClientThread1Req
extends SessionThread {
    public SessionClientThread1Req(SessionManager sessionManager, Socket socket, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, PSMDMgrMessageHeader pSMDMgrMessageHeader, String string) {
        super(sessionManager, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader);
        this.setName("Client1Req - " + SessionUtil.getCmdString(pSMDMgrMessageHeader.getMessageType()));
        SessionManager.log(string);
    }

    public void run() {
        try {
            int n = 0;
            short s = this.messageHeader.getMessageType();
            byte[] byArray = new byte[this.messageHeader.getXmlMsgSize()];
            if (!SessionUtil.readBytes(this.inStream, byArray)) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-152, "Error: cannot read request"));
                SessionManager.log("ERROR: cli thread cannot read the request");
                SessionManager.logX("cliThread1 - header: ", this.messageHeader.getData());
                SessionManager.logX("cliThread1 - ERROR: ", byArray);
                return;
            }
            String string = SessionUtil.getCmdString(this.messageHeader.getMessageType());
            String string2 = new String(byArray, "UTF-8");
            SessionManager.log("cliThread1 - " + string + ": entry");
            SessionManager.log("cliThread1 - XML1: " + string2);
            SessionManager.logX("cliThread1 - XML2: ", byArray);
            PSMDMgrParser pSMDMgrParser = new PSMDMgrParser();
            if (s == 2) {
                n = this.pingManager(null);
                SessionManager.log(SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
                this.mSessionMgr.getStopTimer().resetTimer();
            } else if (s == 10) {
                pSMDMgrParser.parse(new String(byArray, "UTF-8"));
                n = this.intializeClient(pSMDMgrParser.getNode());
                SessionManager.log("cliThread1 - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
                this.mSessionMgr.getStopTimer().resetTimer();
            } else if (s == 40) {
                pSMDMgrParser.parse(new String(byArray, "UTF-8"));
                n = this.terminateClient(pSMDMgrParser.getNode());
                SessionManager.log("cliThread1 - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
                this.mSessionMgr.getStopTimer().resetTimer();
            } else {
                SessionManager.log("ERROR: UNKNOWN request type - request: " + s);
            }
            SessionManager.logTime("------------------------ end: " + s);
            this.waitForSocketToBeClosed();
            this.inStream.close();
            this.outStream.close();
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
        }
    }

    protected int intializeClient(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        if (pSMDMgrNode2 == null || pSMDMgrNode2.getClientId() == null) {
            this.sendReply(PSMDMgrComposer.composePSMDReply(-200, "Error: clientId is null or the parser failed to parse"));
            return -200;
        }
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            this.mSessionMgr.remClient(pSMDMgrNode2.getClientId());
        }
        sessionClient = this.mSessionMgr.addClient(pSMDMgrNode);
        sessionClient.setClientRequestVersion(pSMDMgrNode.getVersion());
        this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
        return 0;
    }

    protected int terminateClient(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            sessionClient.shutdown();
            this.mSessionMgr.remClient(pSMDMgrNode2.getClientId());
            this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
            return 0;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-140, "Error: client not found"));
        return -140;
    }

    protected int pingManager(PSMDMgrNode pSMDMgrNode) throws IOException {
        this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok"));
        return 0;
    }
}

