/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessage;
import com.ibm.db2.psmd.mgr.SessionRoutine;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class SessionConnection {
    public static final short CON_STATE_INIT = 10;
    public static final short CON_STATE_ACTIVE = 20;
    public static final short CON_STATE_END = 30;
    protected String mConnectionId;
    protected Stack mCallStack;
    protected Hashtable mCmdBuffer;
    protected int mStepOverIndex;
    protected int mStepReturnIndex;
    protected short mProcState;
    protected int mPSMDCommand_exit = 0;

    public SessionConnection(String string) {
        this.mConnectionId = string;
        this.mCallStack = new Stack();
        this.mCmdBuffer = new Hashtable();
        this.mStepOverIndex = 0;
        this.mStepReturnIndex = 0;
        this.mProcState = (short)20;
    }

    public String getId() {
        return this.mConnectionId;
    }

    public void setStepOverIndex() {
        this.mStepOverIndex = this.mCallStack.size() - 1;
    }

    public int getStepOverIndex() {
        return this.mStepOverIndex;
    }

    public void setStepReturnIndex() {
        this.mStepReturnIndex = this.mCallStack.size() - 1;
    }

    public int getStepReturnIndex() {
        return this.mStepReturnIndex;
    }

    public int getCallStackSize() {
        return this.mCallStack.size();
    }

    public void setPSMDCommandExit(int n) {
        this.mPSMDCommand_exit = n;
    }

    public void enterRoutine(SessionRoutine sessionRoutine, int n) {
        Object object;
        int n2 = this.mCallStack.size();
        if (n2 >= 1) {
            object = (SessionRoutine)this.mCallStack.get(n2 - 1);
            int n3 = ((SessionRoutine)object).getSerExeMode();
            if (n3 == 2 && n == 1012) {
                n3 = 6;
            }
            sessionRoutine.setSerExeMode(n3);
        }
        sessionRoutine.setStackFrame(n2);
        this.mCallStack.push(sessionRoutine);
        this.mPSMDCommand_exit = 0;
        object = this.getFromCmdBuffer(sessionRoutine.getRoutineId());
        if (object != null) {
            sessionRoutine.setStopLine((Integer)object);
        }
    }

    public int getExeExitRoutine(double d) {
        SessionRoutine sessionRoutine = (SessionRoutine)this.mCallStack.peek();
        if (sessionRoutine != null && 1 == sessionRoutine.getRoutineLanguage() && d > 1.01 && this.mPSMDCommand_exit == 0) {
            return 0;
        }
        return 1;
    }

    public int exitRoutine(String string) {
        this.mCallStack.pop();
        if (this.mCallStack.size() == 0) {
            this.mCmdBuffer.clear();
        }
        return this.mCallStack.size();
    }

    public void popUntilHit(String string) {
        if (!this.mCallStack.empty()) {
            SessionRoutine sessionRoutine = (SessionRoutine)this.mCallStack.pop();
            sessionRoutine.shutdown();
            while (sessionRoutine != null && !sessionRoutine.getRoutineId().equals(string)) {
                sessionRoutine = (SessionRoutine)this.mCallStack.pop();
                sessionRoutine.shutdown();
            }
        }
    }

    public SessionRoutine getTopRoutine() {
        if (this.mCallStack.size() > 0) {
            return (SessionRoutine)this.mCallStack.peek();
        }
        return null;
    }

    public SessionRoutine getRoutine(String string) {
        SessionRoutine sessionRoutine = null;
        for (int i = this.mCallStack.size() - 1; i >= 0; --i) {
            sessionRoutine = (SessionRoutine)this.mCallStack.get(i);
            if (!sessionRoutine.getRoutineId().equals(string)) continue;
            return sessionRoutine;
        }
        return null;
    }

    public void updateExeModeForParentRoutines(int n) {
        for (int i = this.mCallStack.size() - 1; i >= 0; --i) {
            SessionRoutine sessionRoutine = (SessionRoutine)this.mCallStack.get(i);
            sessionRoutine.setSerExeMode(n);
        }
    }

    public SessionRoutine getRoutine(int n) {
        SessionRoutine sessionRoutine = null;
        if (this.mCallStack.size() >= n + 1) {
            sessionRoutine = (SessionRoutine)this.mCallStack.get(n);
        }
        return sessionRoutine;
    }

    public void shutdown() {
        this.mProcState = (short)30;
        Enumeration enumeration = this.mCallStack.elements();
        while (enumeration.hasMoreElements()) {
            SessionRoutine sessionRoutine = (SessionRoutine)enumeration.nextElement();
            sessionRoutine.shutdown();
        }
    }

    public boolean contains(String string) {
        Enumeration enumeration = this.mCallStack.elements();
        while (enumeration.hasMoreElements()) {
            if (!((SessionRoutine)enumeration.nextElement()).getRoutineId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public PSMDMgrMessage genReportCallStack(String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.mCallStack.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (SessionRoutine)enumeration.nextElement();
            object = ((SessionRoutine)object2).getJvmDebugIP();
            if (object == null || ((String)object).length() == 0) {
                object = "-";
            }
            arrayList.add(((SessionRoutine)object2).getRoutineId() + "*" + ((SessionRoutine)object2).getStackFrame() + "*" + ((SessionRoutine)object2).getCurLine() + "*" + (String)object + "*" + ((SessionRoutine)object2).getJvmDebugPort());
        }
        object2 = PSMDMgrComposer.composeRptCallStack(this.mConnectionId, string, arrayList);
        object = new PSMDMgrMessage((byte[])object2, null);
        ((PSMDMgrMessage)object).saveReplyInfo(this.mConnectionId);
        return object;
    }

    public void addToCmdBuffer(String string, Integer n) {
        this.mCmdBuffer.put(string, n);
    }

    public Integer getFromCmdBuffer(String string) {
        if (this.mCmdBuffer.containsKey(string)) {
            return (Integer)this.mCmdBuffer.remove(string);
        }
        return null;
    }

    public String toString() {
        return this.mConnectionId;
    }
}

