/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.JvmInfo;
import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageHeader;
import com.ibm.db2.psmd.mgr.PSMDMgrNode;
import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionClient;
import com.ibm.db2.psmd.mgr.SessionClientThread;
import com.ibm.db2.psmd.mgr.SessionClientThread1Req;
import com.ibm.db2.psmd.mgr.SessionServerThread;
import com.ibm.db2.psmd.mgr.SessionServerThread1Req;
import com.ibm.db2.psmd.mgr.SessionUtil;
import com.ibm.db2.psmd.mgr.StopTimerThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class SessionManager
implements Runnable {
    public static final int PORT_FROM = 8000;
    public static final int PORT_TO = 8050;
    public static final int LOG_LEVEL_1 = 1;
    public static final int LOG_LEVEL_2 = 2;
    public static final String CODE_LEVEL = "100721";
    protected Hashtable mClients = new Hashtable();
    protected int mMgrPort;
    protected boolean mMustExit;
    protected long mIdleTimeOut;
    protected static String mLogFile;
    protected Hashtable mJvms = new Hashtable();
    protected int mLogLevel = 1;
    protected StopTimerThread mStopTimer = new StopTimerThread();
    private boolean mStartedOK;

    public SessionManager() {
    }

    public SessionManager(String string) {
        this();
        mLogFile = string;
    }

    public void setPort(int n) {
        this.mMgrPort = n;
    }

    public long getPort() {
        return this.mMgrPort;
    }

    public void setIdleTimeout(int n) {
        this.mIdleTimeOut = n > 0 ? (long)(n * 1000 * 60) : -1L;
    }

    public void setLogFile(String string) {
        mLogFile = string;
    }

    public void startService() throws IOException, Exception {
        this.mStartedOK = true;
        this.mMustExit = false;
        InetAddress inetAddress = InetAddress.getLocalHost();
        ServerSocket serverSocket = new ServerSocket(this.mMgrPort);
        System.out.println("Debug Session Manager started on IP: " + inetAddress.getHostAddress() + " - port: " + this.mMgrPort);
        System.out.println("Host address: " + inetAddress.getHostAddress().toString());
        System.out.println("mIdleTimeOut: " + this.mIdleTimeOut + "(milliseconds)");
        SessionManager.log("Debug Session Manager started on IP: " + inetAddress.getHostAddress() + " - port: " + this.mMgrPort);
        SessionManager.log("mIdleTimeOut: " + this.mIdleTimeOut + "(milliseconds)");
        String string = "Code Level: 100721";
        System.out.println(string);
        SessionManager.log(string);
        String string2 = "Version: 3.3";
        System.out.println(string2);
        SessionManager.log(string2);
        if (this.mIdleTimeOut > 0L && this.mStopTimer != null) {
            this.mStopTimer.setMgrPort(this.mMgrPort);
            this.mStopTimer.setTimeout(this.mIdleTimeOut);
            this.mStopTimer.start();
        }
        while (!this.mMustExit) {
            try {
                Object object;
                Socket socket = serverSocket.accept();
                InetAddress inetAddress2 = socket.getInetAddress();
                String string3 = "Host address: " + inetAddress2.getHostAddress() + "; Host name: " + inetAddress2.getHostName() + "; port: " + socket.getPort() + "; local port: " + socket.getLocalPort();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                PSMDMgrMessageHeader pSMDMgrMessageHeader = new PSMDMgrMessageHeader();
                SessionUtil.readBytes(bufferedInputStream, pSMDMgrMessageHeader.getData());
                if (pSMDMgrMessageHeader.getMessageType() == 0) {
                    this.mMustExit = true;
                    SessionManager.log("SessionManager.serviceRequests - END_MANAGER begin...");
                    this.shutdown();
                    SessionManager.log("SessionManager.serviceRequests - END_MANAGER shutdown");
                    object = PSMDMgrComposer.composePSMDReply(0, "ok");
                    pSMDMgrMessageHeader = new PSMDMgrMessageHeader(((byte[])object).length, 0, 0, 0);
                    bufferedOutputStream.write(pSMDMgrMessageHeader.getData());
                    bufferedOutputStream.write((byte[])object);
                    bufferedOutputStream.flush();
                    SessionManager.log("SessionManager.serviceRequests - END_MANAGER send reply");
                    bufferedInputStream.close();
                    bufferedOutputStream.close();
                    socket.close();
                    SessionManager.log("SessionManager.serviceRequests - END_MANAGER close streams");
                    continue;
                }
                if (pSMDMgrMessageHeader.getMessageType() < 999) {
                    if (pSMDMgrMessageHeader.getMessageType() <= 10 || pSMDMgrMessageHeader.getMessageType() == 40) {
                        object = new SessionClientThread1Req(this, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader, string3);
                        ((Thread)object).start();
                        continue;
                    }
                    object = new SessionClientThread(this, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader, string3);
                    ((Thread)object).start();
                    continue;
                }
                if (pSMDMgrMessageHeader.getMessageType() == 1030) {
                    object = new SessionServerThread(this, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader, socket.getInetAddress(), string3);
                    ((Thread)object).start();
                    continue;
                }
                object = new SessionServerThread1Req(this, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader, socket.getInetAddress(), string3);
                ((Thread)object).start();
            }
            catch (SocketException socketException) {
                SPDUtils.logError(socketException);
            }
        }
        SessionManager.log("SessionManager.serviceRequests - MAIN Thread exits");
        System.out.println("SessionManager.serviceRequests - MAIN Thread exits");
    }

    protected void shutdown() throws IOException, Exception {
        Enumeration enumeration = this.mClients.elements();
        while (enumeration.hasMoreElements()) {
            SessionClient sessionClient = (SessionClient)enumeration.nextElement();
            sessionClient.shutdown();
        }
    }

    public SessionClient addClient(PSMDMgrNode pSMDMgrNode) {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = new SessionClient(pSMDMgrNode2.getClientId());
        PSMDMgrNode pSMDMgrNode3 = pSMDMgrNode2.getFirstNode();
        while (pSMDMgrNode3 != null) {
            if ("SupportedRoutines".equals(pSMDMgrNode3.getNodeName())) {
                PSMDMgrNode pSMDMgrNode4 = pSMDMgrNode3.getFirstNode();
                while (pSMDMgrNode4 != null) {
                    sessionClient.addSupportType(pSMDMgrNode4.getType(), pSMDMgrNode4.getLanguage());
                    pSMDMgrNode4 = pSMDMgrNode3.getNextNode();
                }
            }
            pSMDMgrNode3 = pSMDMgrNode2.getNextNode();
        }
        this.mClients.put(pSMDMgrNode2.getClientId(), sessionClient);
        return sessionClient;
    }

    public SessionClient remClient(String string) {
        SessionClient sessionClient = (SessionClient)this.mClients.remove(string);
        if (sessionClient != null) {
            sessionClient.shutdown();
        }
        return sessionClient;
    }

    public SessionClient getClient(String string) {
        if (string != null) {
            return (SessionClient)this.mClients.get(string);
        }
        return null;
    }

    public StopTimerThread getStopTimer() {
        return this.mStopTimer;
    }

    public long getIdleTimeOut() {
        return this.mIdleTimeOut;
    }

    public int getMgrPort() {
        return this.mMgrPort;
    }

    public void setJVMPortRange(PSMDMgrNode pSMDMgrNode, String string) {
        JvmInfo jvmInfo;
        String string2 = pSMDMgrNode.getJVMDebugIP();
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if ((jvmInfo = (JvmInfo)this.mJvms.get(string2)) != null) {
            jvmInfo.setPortRange(pSMDMgrNode.getFrom(), pSMDMgrNode.getTo());
        } else {
            int n = 8000;
            int n2 = 8050;
            if (pSMDMgrNode.getFrom() > 0 && pSMDMgrNode.getTo() > pSMDMgrNode.getFrom()) {
                n = pSMDMgrNode.getFrom();
                n2 = pSMDMgrNode.getTo();
            }
            jvmInfo = new JvmInfo(string2, n, n2);
            this.mJvms.put(string2, jvmInfo);
        }
    }

    public int reserveJVMPort(PSMDMgrNode pSMDMgrNode, String string) {
        JvmInfo jvmInfo;
        String string2 = pSMDMgrNode.getJVMDebugIP();
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if ((jvmInfo = (JvmInfo)this.mJvms.get(string2)) != null) {
            return jvmInfo.reservePort();
        }
        return -1;
    }

    public int reserveAlternateJVMPort(PSMDMgrNode pSMDMgrNode, String string) {
        JvmInfo jvmInfo;
        String string2 = pSMDMgrNode.getJVMDebugIP();
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if ((jvmInfo = (JvmInfo)this.mJvms.get(string2)) != null) {
            return jvmInfo.reserveAlternatePort(pSMDMgrNode.getPort());
        }
        return -1;
    }

    public void releaseJVMPort(PSMDMgrNode pSMDMgrNode, String string) {
        JvmInfo jvmInfo;
        String string2 = pSMDMgrNode.getJVMDebugIP();
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if ((jvmInfo = (JvmInfo)this.mJvms.get(string2)) != null) {
            jvmInfo.releasePort(pSMDMgrNode.getPort());
        }
    }

    public static String getTimeStr() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static boolean doLog() {
        return mLogFile != null;
    }

    public static void log(String string) {
        if (mLogFile != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(mLogFile, true)));
                if (printWriter != null) {
                    printWriter.println(SessionManager.getTimeStr() + " " + string);
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void logX(String string, byte[] byArray) {
        if (mLogFile != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(mLogFile, true)));
                if (printWriter != null) {
                    printWriter.println(SessionManager.getTimeStr() + " " + string);
                    for (int i = 0; i < byArray.length; i += 10) {
                        int n = 10;
                        if (byArray.length - i < 10) {
                            n = byArray.length - i;
                        }
                        String string2 = new String(byArray, i, n, "UTF-8");
                        printWriter.print("                        " + SessionUtil.byteToHexString(byArray, i, n));
                        for (int j = 0; j < 10 - n; ++j) {
                            printWriter.print("  ");
                        }
                        printWriter.println("| " + string2);
                    }
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void logDot() {
        if (mLogFile != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(mLogFile, true)));
                if (printWriter != null) {
                    printWriter.println(".");
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void logTime(String string) {
    }

    public void run() {
        try {
            this.startService();
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
            this.mStartedOK = false;
            System.out.println("Session Manager cannot start service");
        }
    }

    public void terminateManager() {
        SessionUtil.terminateManager(this.mMgrPort);
    }

    public boolean isStartedOK() {
        return this.mStartedOK;
    }
}

