/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.ByteArrayBuffer;
import com.ibm.db2.psmd.mgr.ClientRoutine;
import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessage;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageQueue;
import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionThread;
import java.util.Vector;

public class SessionRoutine {
    public static final short RTN_STATE_INIT = 10;
    public static final short RTN_STATE_DEBUG = 20;
    public static final short RTN_STATE_END = 30;
    public static final short RLANG_SQL = 0;
    public static final short RLANG_JAVA = 1;
    public static final short SERVER_MORE = 1;
    public static final short SERVER_REPORT = 2;
    public static final short SERVER_PAUSE = 4;
    public static final short SERVER_RUN = 6;
    public static final short SERVER_RUN2LINE = 8;
    public static final short SERVER_END = 10;
    public static final short SERVER_TERMINATE = 12;
    public static final int SERVER_HAS_ENDED = -10;
    protected ClientRoutine cliRoutine;
    protected int stackFrame;
    protected String jvmDebugIP;
    protected int jvmDebugPort;
    protected Vector mExeModeQueue;
    protected PSMDMgrMessageQueue commandQueue;
    protected int breakpointsSQN;
    protected int optionsSQN;
    protected SessionThread jvmServerThread;
    protected int jvmLinkedToDebugRc;
    protected int mCurLine;
    protected int mStopLine;
    protected short mProcState;
    private int mSerExeMode;
    protected SessionThread fInitBkptServerThread;

    public SessionRoutine(ClientRoutine clientRoutine, String string, int n) {
        this.cliRoutine = clientRoutine;
        this.jvmDebugIP = string;
        this.jvmDebugPort = n;
        this.mProcState = (short)10;
        this.mCurLine = 0;
        this.mStopLine = -1;
        this.mExeModeQueue = new Vector();
        this.commandQueue = new PSMDMgrMessageQueue("Command Queue(rid:" + clientRoutine.routineId + ")");
        this.breakpointsSQN = -1;
        this.optionsSQN = -1;
        this.jvmServerThread = null;
        this.jvmLinkedToDebugRc = -32;
        this.mSerExeMode = 2;
    }

    public short getRoutineState() {
        return this.mProcState;
    }

    public void setRoutineState(short s) {
        this.mProcState = s;
    }

    public void setCurLine(int n) {
        this.mCurLine = n;
    }

    public int getCurLine() {
        return this.mCurLine;
    }

    public void setStopLine(int n) {
        this.mStopLine = n;
    }

    public int getStopLine() {
        return this.mStopLine;
    }

    public int getBreakpointsSQN() {
        return this.breakpointsSQN;
    }

    public void setBreakpointsSQN(int n) {
        this.breakpointsSQN = n;
    }

    public int getOptionsSQN() {
        return this.optionsSQN;
    }

    public void setOptionsSQN(int n) {
        this.optionsSQN = n;
    }

    public synchronized PSMDMgrMessage getCommand(long l) {
        if (this.commandQueue.size() == 0) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                SPDUtils.logError(interruptedException);
            }
        }
        PSMDMgrMessage pSMDMgrMessage = (PSMDMgrMessage)this.commandQueue.dequeue();
        this.notify();
        return pSMDMgrMessage;
    }

    public PSMDMgrMessage getCommandNoWait() {
        PSMDMgrMessage pSMDMgrMessage = (PSMDMgrMessage)this.commandQueue.dequeue();
        return pSMDMgrMessage;
    }

    public void sendExeMode() {
        String string = Integer.toHexString(this.mSerExeMode);
        this.mExeModeQueue.add(string);
    }

    public String getExeMode() {
        String string = null;
        if (this.mExeModeQueue.size() > 0) {
            string = (String)this.mExeModeQueue.remove(0);
        }
        return string;
    }

    public synchronized void putCommand(PSMDMgrMessage pSMDMgrMessage) {
        if (this.commandQueue.size() > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                SPDUtils.logError(interruptedException);
            }
        }
        this.commandQueue.enqueue(pSMDMgrMessage, false);
        this.notify();
    }

    public void setStackFrame(int n) {
        this.stackFrame = n;
    }

    public int getStackFrame() {
        return this.stackFrame;
    }

    public String getJvmDebugIP() {
        return this.jvmDebugIP;
    }

    public int getJvmDebugPort() {
        return this.jvmDebugPort;
    }

    public ClientRoutine getCliRoutine() {
        return this.cliRoutine;
    }

    public String getRoutineId() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getRoutineId();
        }
        return null;
    }

    public String getRoutineType() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getRoutineType();
        }
        return null;
    }

    public int getRoutineLanguage() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getRoutineLanguage();
        }
        return -1;
    }

    public String getRoutineSchema() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getRoutineSchema();
        }
        return null;
    }

    public String getRoutineName() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getRoutineName();
        }
        return null;
    }

    public String getModuleName() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getModuleName();
        }
        return null;
    }

    public String getSpecificSchema() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getSpecificSchema();
        }
        return null;
    }

    public String getSpecificName() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getSpecificName();
        }
        return null;
    }

    public String getVersion() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getVersion();
        }
        return null;
    }

    public String getTimestamp() {
        if (this.cliRoutine != null) {
            return this.cliRoutine.getTimestamp();
        }
        return null;
    }

    public void setWaitingThread(SessionThread sessionThread) {
        this.commandQueue.setWaitingThread(sessionThread);
    }

    public boolean isCommandQueueEmpty() {
        return this.commandQueue.isEmpty();
    }

    public synchronized void shutdown() {
        this.mProcState = (short)30;
        byte[] byArray = PSMDMgrComposer.composeCmdExeMode(10);
        PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(byArray, null);
        this.commandQueue.enqueue(pSMDMgrMessage, false);
        this.notify();
    }

    public void setDebugJVMWaitingThread(SessionThread sessionThread) {
        this.jvmServerThread = sessionThread;
    }

    public void interruptJVMServerThread(int n) {
        this.jvmLinkedToDebugRc = n;
        if (this.jvmServerThread != null) {
            this.jvmServerThread.interrupt();
            this.jvmServerThread = null;
        }
    }

    public int getLinkedToDebugJVMRc() {
        return this.jvmLinkedToDebugRc;
    }

    public void setInitialBkptWaitingThread(SessionThread sessionThread) {
        this.fInitBkptServerThread = sessionThread;
    }

    public void interruptInitBkptServerThread() {
        if (this.fInitBkptServerThread != null) {
            this.fInitBkptServerThread.interrupt();
            this.fInitBkptServerThread = null;
        }
    }

    public void processSendOptions(ByteArrayBuffer byteArrayBuffer, int n, int n2, int n3) {
        if (this.optionsSQN != n) {
            byteArrayBuffer.append(PSMDMgrComposer.composeOptions(n2, n3));
            this.optionsSQN = n;
        }
    }

    public String toString() {
        return "SessionRoutine " + this.cliRoutine.getRoutineId();
    }

    public void setSerExeMode(int n) {
        if (n > 0) {
            this.mSerExeMode = n;
        }
    }

    public int getSerExeMode() {
        if (this.mCurLine == this.mStopLine) {
            this.mSerExeMode = 2;
        }
        return this.mSerExeMode;
    }
}

