/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessage;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageHeader;
import com.ibm.db2.psmd.mgr.PSMDMgrNode;
import com.ibm.db2.psmd.mgr.PSMDMgrParser;
import com.ibm.db2.psmd.mgr.SPDUtils;
import com.ibm.db2.psmd.mgr.SessionClient;
import com.ibm.db2.psmd.mgr.SessionConnection;
import com.ibm.db2.psmd.mgr.SessionManager;
import com.ibm.db2.psmd.mgr.SessionRoutine;
import com.ibm.db2.psmd.mgr.SessionThread;
import com.ibm.db2.psmd.mgr.SessionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class SessionServerThread1Req
extends SessionThread {
    public static final int DEFAULT_SLEEP_TIME = 120000;
    protected boolean mIsSeverRoutineThread;
    protected SessionClient mSessionClient;
    protected SessionConnection mSessionCon;
    protected SessionRoutine mSessionRoutine;
    protected String mDbgServerIP;
    private short request = 0;
    private String mRId;
    private boolean mProcessHighByte = false;

    public SessionServerThread1Req(SessionManager sessionManager, Socket socket, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, PSMDMgrMessageHeader pSMDMgrMessageHeader, InetAddress inetAddress, String string) {
        super(sessionManager, socket, bufferedInputStream, bufferedOutputStream, pSMDMgrMessageHeader);
        this.mDbgServerIP = inetAddress.getHostAddress();
        this.setName("Server1Req - " + SessionUtil.getCmdString(pSMDMgrMessageHeader.getMessageType()));
        this.mIsSeverRoutineThread = false;
        this.mSessionClient = null;
        this.mSessionCon = null;
        this.mSessionRoutine = null;
        SessionManager.log(string);
    }

    protected void finalize() {
    }

    public void run() {
        try {
            PSMDMgrParser pSMDMgrParser = new PSMDMgrParser();
            byte[] byArray = null;
            this.request = this.messageHeader.getMessageType();
            byArray = new byte[this.messageHeader.getXmlMsgSize()];
            if (!SessionUtil.readBytes(this.inStream, byArray)) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(-152, "Error: cannot read request"));
                SessionManager.log("srvThread1Req - ERROR: cannot read the request");
                return;
            }
            String string = SessionUtil.getCmdString(this.messageHeader.getMessageType());
            String string2 = new String(byArray, "UTF-8");
            SessionManager.log("svrThread1Req - " + string + " - entry");
            SessionManager.log("svrThread1Req - XML1: " + string2);
            SessionManager.logX("svrThread1Req - XML2: ", byArray);
            if (this.messageHeader.getXmlMsgSize() > 3) {
                pSMDMgrParser = new PSMDMgrParser();
                pSMDMgrParser.parse(new String(byArray, "UTF-8"));
            }
            int n = 0;
            String string3 = SessionUtil.getCmdString(this.request);
            if (this.request == 1085) {
                this.mProcessHighByte = this.messageHeader.getProcessHighByte();
                n = this.sendExeMode(pSMDMgrParser.getNode());
                if (0 != n && -10 != n) {
                    SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - ERROR: - rc: " + n);
                }
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
                try {
                    if (this.mSessionRoutine != null) {
                        this.mSessionRoutine.setRoutineState((short)30);
                    }
                    this.inStream.close();
                    this.outStream.close();
                }
                catch (Exception exception) {
                    SPDUtils.logError(exception);
                }
                return;
            }
            if (this.request == 1090) {
                n = this.pingManager();
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1000) {
                n = this.processPreEnterRoutine(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1010) {
                n = this.processEnterRoutine(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1020) {
                n = this.processExitRoutine(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1100) {
                n = this.setPortRange(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1110) {
                n = this.reservePort(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1120) {
                n = this.reserveAlternatePort(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            } else if (this.request == 1130) {
                n = this.releasePort(pSMDMgrParser.getNode());
                SessionManager.log("svrThread1Req - " + SessionUtil.getCmdString(this.messageHeader.getMessageType()) + " - exit - rc: " + n);
            }
        }
        catch (IOException iOException) {
            SPDUtils.logError(iOException);
        }
        this.waitForSocketToBeClosed();
        try {
            if (this.mSessionRoutine != null) {
                this.mSessionRoutine.setRoutineState((short)30);
            }
            this.inStream.close();
            this.outStream.close();
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
        }
    }

    protected int pingManager() throws IOException {
        this.sendReply(0);
        return 0;
    }

    protected int processPreEnterRoutine(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            if (sessionClient.getProcessState() == 40) {
                this.sendReply(-143);
                return -143;
            }
            if (sessionClient.isSupported(pSMDMgrNode2.getType(), pSMDMgrNode2.getLanguage())) {
                this.sendReply(0);
                return 0;
            }
            this.sendReply(-141);
            return -141;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int processEnterRoutine(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        sessionClient.setServerRequestVersion(pSMDMgrNode.getVersion());
        if (sessionClient != null) {
            if (sessionClient.getProcessState() == 40) {
                this.sendReply(-143);
                return -143;
            }
            if (pSMDMgrNode2.getConnectionId() == null) {
                this.sendReply(-101);
                return -101;
            }
            SessionRoutine sessionRoutine = sessionClient.ser_procEnterRoutine(pSMDMgrNode2, this.mDbgServerIP);
            this.mRId = sessionRoutine.getRoutineId();
            int n = 0;
            if (sessionRoutine.getJvmDebugIP().length() > 1) {
                sessionRoutine.setDebugJVMWaitingThread(this);
                try {
                    Thread.sleep(sessionClient.mSessionTimeout * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = sessionRoutine.getLinkedToDebugJVMRc();
            } else if (sessionClient.getClientRequestVersion() > 3.28) {
                sessionRoutine.setInitialBkptWaitingThread(this);
                try {
                    Thread.sleep(sessionClient.mSessionTimeout * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.sendReply(n);
            return n;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int processExitRoutine(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            if (sessionClient.getProcessState() == 40) {
                this.sendReply(-143);
                return -143;
            }
            SessionConnection sessionConnection = sessionClient.getConnection(pSMDMgrNode2.getConnectionId());
            if (sessionConnection != null) {
                int n = sessionConnection.getExeExitRoutine(sessionClient.getClientRequestVersion());
                int n2 = 0;
                while (n == 0 && n2 < sessionClient.mSessionTimeout * 2) {
                    try {
                        Thread.sleep(500L);
                        ++n2;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n = sessionConnection.getExeExitRoutine(sessionClient.getClientRequestVersion());
                }
                sessionClient.ser_procExitRoutine(pSMDMgrNode2, sessionConnection);
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendReply(0);
                return 0;
            }
            this.sendReply(-120);
            return -120;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int initializeRoutine(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            SessionConnection sessionConnection = sessionClient.getConnection(pSMDMgrNode2.getConnectionId());
            SessionRoutine sessionRoutine = sessionClient.getTopRoutine(pSMDMgrNode2.getConnectionId());
            if (sessionConnection != null && sessionRoutine != null && sessionRoutine.getRoutineState() == 10) {
                sessionRoutine.setRoutineState((short)20);
                this.mIsSeverRoutineThread = true;
                this.mSessionClient = sessionClient;
                this.mSessionCon = sessionConnection;
                this.mSessionRoutine = sessionRoutine;
                this.sendReply(PSMDMgrComposer.composePSMDReply(0, "ok", sessionRoutine.getRoutineId()));
                this.mRId = sessionRoutine.getRoutineId();
                SessionManager.log("SessionServerThread -- mRid: " + this.mRId);
                return 0;
            }
            this.sendReply(PSMDMgrComposer.composePSMDReply(-100, "Error: routine not found"));
            return -100;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-140, "Error: client not found"));
        return -140;
    }

    protected int terminateRoutine(PSMDMgrNode pSMDMgrNode) throws IOException {
        this.mSessionRoutine.setRoutineState((short)30);
        this.sendReply(0);
        return 0;
    }

    protected int putReports(int n) throws IOException {
        if (this.mSessionClient != null) {
            PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(this.messageHeader.getXmlDataSize(), this.messageHeader.getBinDataSize());
            if (!SessionUtil.readBytes(this.inStream, pSMDMgrMessage.getXmlData())) {
                this.sendReply(-153);
                return -153;
            }
            if (!SessionUtil.readBytes(this.inStream, pSMDMgrMessage.getBinData())) {
                this.sendReply(-154);
                return -154;
            }
            if (this.mSessionClient.getProcessState() == 40) {
                this.sendReply(-143);
                return -143;
            }
            SessionManager.logTime("done xml & bin");
            this.mSessionClient.ser_putReport(this.mSessionCon.getId(), pSMDMgrMessage);
            this.sendReply(0);
            return 0;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int putReportsGetCommands(int n) throws IOException {
        if (this.mSessionClient != null) {
            PSMDMgrMessage pSMDMgrMessage = new PSMDMgrMessage(this.messageHeader.getXmlDataSize(), this.messageHeader.getBinDataSize());
            if (!SessionUtil.readBytes(this.inStream, pSMDMgrMessage.getXmlData())) {
                this.sendReply(-153);
                return -153;
            }
            if (!SessionUtil.readBytes(this.inStream, pSMDMgrMessage.getBinData())) {
                this.sendReply(-154);
                return -154;
            }
            if (this.mSessionClient.getProcessState() == 40) {
                this.sendReply(-143);
                return -143;
            }
            SessionManager.logTime("done xml & bin");
            this.mSessionClient.ser_putReport(this.mSessionCon.getId(), pSMDMgrMessage);
            SessionRoutine sessionRoutine = this.mSessionRoutine;
            if (sessionRoutine != null) {
                sessionRoutine.setSerExeMode(n);
                if (sessionRoutine.getSerExeMode() == 2) {
                    long l = this.mSessionClient.getSessionTimeout() * 1000;
                    PSMDMgrMessage pSMDMgrMessage2 = sessionRoutine.getCommand(l);
                    if (pSMDMgrMessage2 != null) {
                        int n2 = sessionRoutine.isCommandQueueEmpty() ? 0 : 1;
                        this.sendMessageToServer(pSMDMgrMessage2, n2);
                        return 0;
                    }
                    System.out.println("090624 - WARNING timeout occurs - timeout: " + l);
                    this.sendReply(-121);
                    this.mSessionClient.setIsTimeout(this.mSessionCon.getId(), true);
                    sessionRoutine.setSerExeMode(10);
                    return 0;
                }
                PSMDMgrMessage pSMDMgrMessage3 = sessionRoutine.getCommandNoWait();
                if (pSMDMgrMessage3 == null) {
                    this.sendReply(0);
                    return 0;
                }
                int n3 = sessionRoutine.isCommandQueueEmpty() ? 0 : 1;
                this.sendMessageToServer(pSMDMgrMessage3, n3);
                return 0;
            }
            this.sendReply(-100);
            return -100;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int getCommands(int n) throws IOException {
        if (this.mSessionClient != null) {
            if (this.mSessionClient.getProcessState() == 40) {
                this.sendReply(-143);
                return -143;
            }
            SessionRoutine sessionRoutine = this.mSessionRoutine;
            if (sessionRoutine != null) {
                sessionRoutine.setSerExeMode(n);
                if (sessionRoutine.getSerExeMode() == 2) {
                    long l = this.mSessionClient.getSessionTimeout() * 1000;
                    PSMDMgrMessage pSMDMgrMessage = sessionRoutine.getCommand(l);
                    if (pSMDMgrMessage != null) {
                        int n2 = sessionRoutine.isCommandQueueEmpty() ? 0 : 1;
                        this.sendMessageToServer(pSMDMgrMessage, n2);
                        return 0;
                    }
                    this.sendReply(-121);
                    this.mSessionClient.setIsTimeout(this.mSessionCon.getId(), true);
                    sessionRoutine.setSerExeMode(10);
                    return 0;
                }
                PSMDMgrMessage pSMDMgrMessage = sessionRoutine.getCommandNoWait();
                if (pSMDMgrMessage == null) {
                    this.sendReply(0);
                    return 0;
                }
                int n3 = sessionRoutine.isCommandQueueEmpty() ? 0 : 1;
                this.sendMessageToServer(pSMDMgrMessage, n3);
                return 0;
            }
            this.sendReply(-100);
            return -100;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int sendExeMode(PSMDMgrNode pSMDMgrNode) throws IOException {
        Object object;
        Object object2;
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        SessionClient sessionClient = this.getClient(pSMDMgrNode2.getClientId());
        if (sessionClient != null) {
            object2 = sessionClient.getConnection(pSMDMgrNode2.getConnectionId());
            object = sessionClient.getTopRoutine(pSMDMgrNode2.getConnectionId());
            this.mIsSeverRoutineThread = true;
            this.mSessionClient = sessionClient;
            this.mSessionCon = object2;
            this.mSessionRoutine = object;
            this.mRId = ((SessionRoutine)object).getRoutineId();
        }
        if (this.mSessionRoutine != null) {
            while (this.mSessionRoutine.getRoutineState() != 30) {
                object2 = this.mSessionRoutine.getExeMode();
                if (object2 != null) {
                    this.outStream.write(((String)object2).getBytes());
                    this.outStream.flush();
                    continue;
                }
                object = new byte[4];
                boolean bl = false;
                while (this.inStream.available() >= 4) {
                    bl = true;
                    this.inStream.read((byte[])object);
                }
                if (bl) {
                    int n = 0;
                    n = this.mProcessHighByte ? this.processHighByteForInt((byte[])object) : this.processLowByteForInt((byte[])object);
                    this.mSessionRoutine.setCurLine(n);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    protected int getExeMode(int n) throws IOException {
        if (this.mSessionClient != null) {
            if (this.mSessionClient.getProcessState() == 40) {
                int n2 = 10;
                this.sendReply(n2);
                return 0;
            }
            SessionRoutine sessionRoutine = this.mSessionRoutine;
            if ("SYS_INIT".equalsIgnoreCase(sessionRoutine.getRoutineName())) {
                int n3 = 10;
                this.sendReply(n3);
                return 0;
            }
            if (sessionRoutine != null) {
                sessionRoutine.setCurLine(n);
                PSMDMgrMessage pSMDMgrMessage = this.mSessionClient.ser_getBkptAndOption(this.mSessionCon.getId(), sessionRoutine);
                int n4 = sessionRoutine.getSerExeMode();
                if (pSMDMgrMessage != null) {
                    this.sendMessageToServer(pSMDMgrMessage, n4);
                    return 0;
                }
                this.sendReply(n4);
                return 0;
            }
            this.sendReply(-100);
            return -100;
        }
        this.sendReply(-140);
        return -140;
    }

    protected int setPortRange(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        if (pSMDMgrNode2 != null) {
            this.mSessionMgr.setJVMPortRange(pSMDMgrNode2, this.mDbgServerIP);
            this.sendReply(0);
            return 0;
        }
        this.sendReply(-400);
        return -400;
    }

    protected int reservePort(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        if (pSMDMgrNode2 != null) {
            int n = this.mSessionMgr.reserveJVMPort(pSMDMgrNode2, this.mDbgServerIP);
            if (n > 0) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(0, n));
                return 0;
            }
            this.sendReply(PSMDMgrComposer.composePSMDReply(-30, "Error: no free port available."));
            return -30;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-400, "Error: xml: invalid node"));
        return -400;
    }

    protected int reserveAlternatePort(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        if (pSMDMgrNode2 != null) {
            int n = this.mSessionMgr.reserveAlternateJVMPort(pSMDMgrNode2, this.mDbgServerIP);
            if (n > 0) {
                this.sendReply(PSMDMgrComposer.composePSMDReply(0, n));
                return 0;
            }
            this.sendReply(PSMDMgrComposer.composePSMDReply(-30, "Error: no free port available."));
            return -30;
        }
        this.sendReply(PSMDMgrComposer.composePSMDReply(-400, "Error: xml: invalid node"));
        return -400;
    }

    protected int releasePort(PSMDMgrNode pSMDMgrNode) throws IOException {
        PSMDMgrNode pSMDMgrNode2 = pSMDMgrNode.getFirstNode();
        if (pSMDMgrNode2 != null) {
            this.mSessionMgr.releaseJVMPort(pSMDMgrNode2, this.mDbgServerIP);
            this.sendReply(0);
            return 0;
        }
        this.sendReply(-400);
        return -400;
    }

    private int processHighByteForInt(byte[] byArray) {
        int n = 0;
        byte by = byArray[n];
        int n2 = by << 24;
        by = byArray[++n];
        n2 |= by << 16 & 0xFF0000;
        by = byArray[++n];
        n2 |= by << 8 & 0xFF00;
        by = byArray[++n];
        return n2 |= by & 0xFF;
    }

    private int processLowByteForInt(byte[] byArray) {
        int n = 3;
        byte by = byArray[n];
        int n2 = by << 24;
        by = byArray[--n];
        n2 |= by << 16 & 0xFF0000;
        by = byArray[--n];
        n2 |= by << 8 & 0xFF00;
        by = byArray[--n];
        return n2 |= by & 0xFF;
    }
}

