/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.psmd.mgr;

import com.ibm.db2.psmd.mgr.PSMDMgrComposer;
import com.ibm.db2.psmd.mgr.PSMDMgrMessageHeader;
import com.ibm.db2.psmd.mgr.SPDUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class SessionUtil {
    public static int getNewSQN(int n) {
        return n + 1;
    }

    public static boolean readBytes(BufferedInputStream bufferedInputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        for (n = byArray.length; n > 0 && (n2 = bufferedInputStream.read(byArray, n3, n)) != -1; n -= n2) {
            n3 += n2;
        }
        return n == 0;
    }

    public static void terminateManager(int n) {
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), n);
            socket.setSoLinger(false, 2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            byte[] byArray = PSMDMgrComposer.composeReqExitManager();
            PSMDMgrMessageHeader pSMDMgrMessageHeader = new PSMDMgrMessageHeader(0, byArray.length, 0, 0);
            bufferedOutputStream.write(pSMDMgrMessageHeader.getData());
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            SPDUtils.logError(exception);
        }
    }

    public static String byteToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        if (byArray.length == 0) {
            return "";
        }
        stringBuffer.setLength(0);
        for (int i = 0; i < n; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() < 2) {
                stringBuffer.append("0");
                stringBuffer.append(string);
                continue;
            }
            if (string.length() == 2) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string.substring(string.length() - 2));
        }
        return stringBuffer.toString();
    }

    public static String byteToHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length == 0) {
            return "";
        }
        stringBuffer.setLength(0);
        for (int i = n; i < n + n2; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() < 2) {
                stringBuffer.append("0");
                stringBuffer.append(string);
                continue;
            }
            if (string.length() == 2) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string.substring(string.length() - 2));
        }
        return stringBuffer.toString();
    }

    public static String getCmdString(short s) {
        switch (s) {
            case 10: {
                return "CLI_INITIALIZE_CLIENT";
            }
            case 2: {
                return "CLI_PING_MANAGER";
            }
            case 30: {
                return "CLI_RECV_DEBUG_REPORTS";
            }
            case 25: {
                return "CLI_SEND_MANAGER_COMMAND";
            }
            case 20: {
                return "CLI_SEND_ROUTINE_COMMAND";
            }
            case 40: {
                return "CLI_TERMINATE_CLIENT";
            }
            case 1010: {
                return "SVR_ENTER_ROUTINE";
            }
            case 1020: {
                return "SVR_EXIT_ROUTINE";
            }
            case 1050: {
                return "SVR_GET_DEBUG_COMMANDS";
            }
            case 1080: {
                return "SVR_GET_MGR_INFO";
            }
            case 1030: {
                return "SVR_INITIALIZE_ROUTINE";
            }
            case 1090: {
                return "SVR_PING_MGR";
            }
            case 1000: {
                return "SVR_PRE_ENTER_ROUTINE";
            }
            case 1041: {
                return "SVR_PUT_DEBUG_REPORTS";
            }
            case 1040: {
                return "SVR_PUT_DEBUG_REPORTS_GET_DEBUG_COMMANDS";
            }
            case 1130: {
                return "SVR_RELEASE_PORT";
            }
            case 1120: {
                return "SVR_RESERVE_ALTERNATE_PORT";
            }
            case 1110: {
                return "SVR_RESERVE_PORT";
            }
            case 1070: {
                return "SVR_SET_MGR_INFO";
            }
            case 1100: {
                return "SVR_SET_PORT_RANGE";
            }
            case 1060: {
                return "SVR_TERMINATE_ROUTINE";
            }
            case 1085: {
                return "SVR_REQ_SEND_EXE_MODE";
            }
        }
        return "" + s;
    }
}

