/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class FileUtils {
    private static final int DEFAULT_OFFSET = 0;
    private static final int LENGTH_ALLBYTES = -1;

    public static String getTmpDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return string;
    }

    public static byte[] readDataFromFile(File file) throws IOException {
        return FileUtils.readDataFromFile_internal(file, 0L, -1L);
    }

    public static byte[] readDataFromFile(File file, long l) throws IOException {
        return FileUtils.readDataFromFile_internal(file, l, -1L);
    }

    public static byte[] readDataFromFile(File file, long l, long l2) throws IOException {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("length must be greater than zero");
        }
        return FileUtils.readDataFromFile_internal(file, l, l2);
    }

    private static final byte[] readDataFromFile_internal(File file, long l, long l2) throws IOException {
        byte[] byArray = null;
        long l3 = file.length();
        if (l3 > Integer.MAX_VALUE) {
            throw new RuntimeException("File is too large to load");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("offset must be a non-negative integer");
        }
        if (l > l3) {
            throw new IllegalArgumentException("offset must be less than the file size");
        }
        if (l2 < -1L) {
            throw new IllegalArgumentException();
        }
        if (l2 == -1L) {
            l2 = l3 - l;
        } else if (l + l2 > l3) {
            l2 = l3 - l;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                byArray = new byte[(int)l2];
                fileInputStream = new FileInputStream(file);
                int n = 0;
                while ((long)n < l) {
                    n = (int)((long)n + fileInputStream.skip(l - (long)n));
                }
                fileInputStream.read(byArray, 0, (int)l2);
            }
            catch (IOException iOException) {
                byArray = null;
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static final void writeDataToFile(byte[] byArray, File file) throws IOException {
        FileUtils.writeDataToFile_internal(byArray, file, 0L, -1L);
    }

    public static final void writeDataToFile(byte[] byArray, File file, long l) throws IOException {
        FileUtils.writeDataToFile_internal(byArray, file, l, -1L);
    }

    public static final void writeDataToFile(byte[] byArray, File file, long l, long l2) throws IOException {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("length must be greater than zero");
        }
        FileUtils.writeDataToFile_internal(byArray, file, l, l2);
    }

    private static final void writeDataToFile_internal(byte[] byArray, File file, long l, long l2) throws IOException {
        long l3;
        if (l2 < -1L) {
            throw new IllegalArgumentException("length cannot be less than -1");
        }
        if (l2 == -1L) {
            l2 = byArray.length;
        }
        if ((l3 = l + l2) > Integer.MAX_VALUE) {
            throw new RuntimeException("File is too large to write");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("offset must be a non-negative integer");
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray, (int)l, (int)l2);
            }
            catch (IOException iOException) {
                byArray = null;
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }
}

