/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.file;

public class Mode {
    private static final String INVALID_MODE = "Invalid file mode specified: ";
    private final int mode;
    public static final int OX = 1;
    public static final int OW = 2;
    public static final int OR = 4;
    public static final int GX = 8;
    public static final int GW = 16;
    public static final int GR = 32;
    public static final int UX = 64;
    public static final int UW = 128;
    public static final int UR = 256;
    public static final int ST = 512;
    public static final int SG = 1024;
    public static final int SU = 2048;

    public Mode(int n) {
        if (n > 4095 || n < 0) {
            throw new IllegalArgumentException(INVALID_MODE + Integer.toOctalString(n));
        }
        this.mode = n;
    }

    public Mode(String string) {
        this(Mode.getMode(string));
    }

    public int getMode() {
        return this.mode;
    }

    private static int getMode(String string) {
        int n = 0;
        if (string.length() != 9) {
            throw new IllegalArgumentException(INVALID_MODE + string);
        }
        int n2 = 0;
        while (n2 < 9) {
            int n3 = 8 - n2;
            switch (string.charAt(n2)) {
                case 's': 
                case 't': {
                    n = (int)((double)n + Math.pow(2.0, n3 / 3 + 9));
                }
                case 'r': 
                case 'w': 
                case 'x': {
                    n = (int)((double)n + Math.pow(2.0, n3));
                    break;
                }
                case 'S': {
                    n = (int)((double)n + Math.pow(2.0, n3 / 3 + 9));
                    break;
                }
                case 'T': {
                    n += 512;
                    break;
                }
                case '-': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(INVALID_MODE + string.charAt(n2));
                }
            }
            ++n2;
        }
        return n;
    }

    public boolean hasStickyBit() {
        return (this.mode & 0x200) > 0;
    }

    public boolean hasSetGID() {
        return (this.mode & 0x400) > 0;
    }

    public boolean hasSetUID() {
        return (this.mode & 0x800) > 0;
    }

    public boolean isUserReadable() {
        return (this.mode & 0x100) > 0;
    }

    public boolean isUserWritable() {
        return (this.mode & 0x80) > 0;
    }

    public boolean isUserExecutable() {
        return (this.mode & 0x40) > 0;
    }

    public boolean isGroupReadable() {
        return (this.mode & 0x20) > 0;
    }

    public boolean isGroupWritable() {
        return (this.mode & 0x10) > 0;
    }

    public boolean isGroupExecutable() {
        return (this.mode & 8) > 0;
    }

    public boolean isOtherReadable() {
        return (this.mode & 4) > 0;
    }

    public boolean isOtherWritable() {
        return (this.mode & 2) > 0;
    }

    public boolean isOtherExecutable() {
        return (this.mode & 1) > 0;
    }

    public boolean isAllReadable() {
        return this.isUserReadable() && this.isGroupReadable() && this.isOtherReadable();
    }

    public boolean isAllWritable() {
        return this.isUserWritable() && this.isGroupWritable() && this.isOtherWritable();
    }

    public boolean isAllExecutable() {
        return this.isUserExecutable() && this.isGroupExecutable() && this.isOtherExecutable();
    }
}

