/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.file;

import com.ibm.arcs.basic.file.Mode;
import com.ibm.arcs.basic.file.Type;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class UnixFile
extends File {
    private static final String COMMAND = "ls -l";
    private static final long serialVersionUID = -208814245391198367L;
    public final String userName;
    public final String groupName;
    public final Mode mode;
    public final Type type;
    public final int links;

    public UnixFile(File file) throws IOException, SecurityException {
        this(file.getAbsolutePath());
    }

    public UnixFile(String string) throws IOException, SecurityException {
        super(string);
        Process process = Runtime.getRuntime().exec(COMMAND + (this.isDirectory() ? (char)'d' : ' ') + ' ' + string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        String[] stringArray = string2.toString().split("\\s+", 4);
        this.type = Type.getType(stringArray[0].charAt(0));
        this.mode = new Mode(stringArray[0].substring(1));
        this.links = Integer.parseInt(stringArray[1]);
        this.userName = stringArray[2];
        this.groupName = stringArray[3];
    }
}

