/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.map.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HashMapArrayList<K, V> {
    private final HashMap<K, ArrayList<V>> map = new HashMap();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public void add(K k, V v) {
        this.writeLock.lock();
        if (this.map.containsKey(k)) {
            ArrayList<V> arrayList = this.map.get(k);
            arrayList.add(v);
        } else {
            ArrayList<V> arrayList = new ArrayList<V>();
            arrayList.add(v);
            this.map.put(k, arrayList);
        }
        this.writeLock.unlock();
    }

    public void addAll(K k, List<V> list) {
        this.writeLock.lock();
        for (V v : list) {
            this.add(k, v);
        }
        this.writeLock.unlock();
    }

    public void removeKey(K k) {
        this.writeLock.lock();
        if (this.map.containsKey(k)) {
            ArrayList<V> arrayList = this.map.get(k);
            arrayList.clear();
            arrayList = null;
            this.map.remove(k);
        }
        this.writeLock.unlock();
    }

    public void removeValue(K k, V v) {
        this.writeLock.lock();
        if (this.map.containsKey(k)) {
            ArrayList<V> arrayList = this.map.get(k);
            arrayList.remove(v);
            if (arrayList.size() == 0) {
                arrayList = null;
                this.map.remove(k);
            }
        }
        this.writeLock.unlock();
    }

    public List<V> get(K k) {
        this.readLock.lock();
        List list = this.map.get(k);
        this.readLock.unlock();
        return list;
    }

    public List<K> getKeys(V v) {
        this.readLock.lock();
        ArrayList<K> arrayList = new ArrayList<K>();
        for (K k : this.map.keySet()) {
            ArrayList<V> arrayList2 = this.map.get(k);
            if (!arrayList2.contains(v)) continue;
            arrayList.add(k);
        }
        this.readLock.unlock();
        return arrayList;
    }
}

