/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.map.multi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HashMapHashSet<K, V> {
    private final HashMap<K, HashSet<V>> multiMap = new HashMap();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public void add(K k, V v) {
        this.writeLock.lock();
        if (this.multiMap.containsKey(k)) {
            HashSet<V> hashSet = this.multiMap.get(k);
            hashSet.add(v);
        } else {
            HashSet<V> hashSet = new HashSet<V>();
            hashSet.add(v);
            this.multiMap.put(k, hashSet);
        }
        this.writeLock.unlock();
    }

    public void addAll(K k, Set<V> set) {
        this.writeLock.lock();
        for (V v : set) {
            this.add(k, v);
        }
        this.writeLock.unlock();
    }

    public void removeKey(K k) {
        this.writeLock.lock();
        if (this.multiMap.containsKey(k)) {
            HashSet<V> hashSet = this.multiMap.get(k);
            hashSet.clear();
            hashSet = null;
            this.multiMap.remove(k);
        }
        this.writeLock.unlock();
    }

    public void removeValue(K k, V v) {
        this.writeLock.lock();
        if (this.multiMap.containsKey(k)) {
            HashSet<V> hashSet = this.multiMap.get(k);
            hashSet.remove(v);
            if (hashSet.size() == 0) {
                hashSet = null;
                this.multiMap.remove(k);
            }
        }
        this.writeLock.unlock();
    }

    public Set<V> get(K k) {
        this.readLock.lock();
        Set set = this.multiMap.get(k);
        if (set == null) {
            set = Collections.emptySet();
        }
        this.readLock.unlock();
        return set;
    }

    public Set<K> getKeys(V v) {
        this.readLock.lock();
        HashSet<K> hashSet = new HashSet<K>();
        for (K k : this.multiMap.keySet()) {
            HashSet<V> hashSet2 = this.multiMap.get(k);
            if (!hashSet2.contains(v)) continue;
            hashSet.add(k);
        }
        this.readLock.unlock();
        return hashSet;
    }

    public Set<K> getAllKeys() {
        return this.multiMap.keySet();
    }
}

