/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node;

import com.ibm.arcs.basic.node.Node;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLocation<T extends Node<T>>
implements Comparable<NodeLocation<T>> {
    protected final int defaultLocationIndicesIndex = -1;
    protected final ArrayList<Integer> locationIndices = new ArrayList();
    protected int locationIndicesIndex = -1;
    protected Logger logger = LoggerFactory.getLogger(NodeLocation.class);

    public void reset() {
        this.locationIndices.clear();
        this.locationIndicesIndex = -1;
    }

    public void navigateToParent() {
        if (this.locationIndicesIndex > -1) {
            this.locationIndices.remove(this.locationIndicesIndex);
            --this.locationIndicesIndex;
        } else {
            throw new RuntimeException("Attempt to go to parent of root location");
        }
    }

    public void navigateToChild() {
        this.locationIndices.add(0);
        ++this.locationIndicesIndex;
    }

    public void navigateToSibling() {
        this.locationIndices.set(this.locationIndicesIndex, this.locationIndices.get(this.locationIndicesIndex) + 1);
    }

    public void set(NodeLocation<T> nodeLocation) {
        this.locationIndices.clear();
        this.locationIndices.addAll(nodeLocation.locationIndices);
        this.locationIndicesIndex = nodeLocation.locationIndicesIndex;
    }

    public int getDepth() {
        return this.locationIndicesIndex + 1;
    }

    public int getLocationIndex(int n) {
        return this.locationIndices.get(n - 1);
    }

    public T get(T t) {
        return this.get(t, this.locationIndicesIndex);
    }

    public T get(T t, int n) {
        Object object = t;
        int n2 = 0;
        while (n2 <= n) {
            object = (Node)object.getChild(this.locationIndices.get(n2));
            ++n2;
        }
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.locationIndices == null ? 0 : this.locationIndices.hashCode());
        n = 31 * n + this.locationIndicesIndex;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!(object instanceof NodeLocation)) {
            return false;
        }
        NodeLocation nodeLocation = (NodeLocation)object;
        if (this.locationIndices == null ? nodeLocation.locationIndices != null : !this.locationIndices.equals(nodeLocation.locationIndices)) {
            return false;
        }
        return this.locationIndicesIndex == nodeLocation.locationIndicesIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("locationIndicesIndex: " + this.locationIndicesIndex);
        stringBuilder.append('\n');
        stringBuilder.append("locationIndices: " + this.locationIndices.toString());
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(NodeLocation<T> nodeLocation) {
        int n = this.getSmallestDepth(nodeLocation);
        int n2 = this.compareToLimitDepth(nodeLocation, n);
        if (n2 != 0) {
            return n2;
        }
        return this.compareDepth(nodeLocation);
    }

    private int compareToLimitDepth(NodeLocation<T> nodeLocation, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this.locationIndices.get(n2);
            if (n4 < (n3 = nodeLocation.locationIndices.get(n2).intValue())) {
                return n4 - n3;
            }
            if (n4 > n3) {
                return n4 - n3;
            }
            ++n2;
        }
        return 0;
    }

    private int compareDepth(NodeLocation<T> nodeLocation) {
        return this.locationIndicesIndex - nodeLocation.locationIndicesIndex;
    }

    private int getSmallestDepth(NodeLocation<T> nodeLocation) {
        if (this.locationIndicesIndex < nodeLocation.locationIndicesIndex) {
            return this.locationIndicesIndex;
        }
        return this.locationIndicesIndex;
    }
}

