/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeLocation;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeNavigator<T extends Node<T>> {
    protected final T root;
    protected final NodeLocation<T> location = new NodeLocation();
    protected final BitSet levels = new BitSet();
    protected T currentNode;
    protected Logger logger;

    public NodeNavigator(T t) {
        this.root = t;
        this.logger = LoggerFactory.getLogger(NodeNavigator.class);
        this.currentNode = t;
        this.levels.set(0);
        this.checkAndSetNextLevelExists();
    }

    public T getCurrentNode() {
        return this.currentNode;
    }

    public int getDepth() {
        return this.location.getDepth();
    }

    public boolean isAtRoot() {
        return !this.hasParent();
    }

    public void navigateToRoot() {
        this.logger.debug("navigating to root");
        this.logger.debug("forcibly setting currentNode = root");
        this.currentNode = this.root;
        this.location.reset();
    }

    public void navigateToParent() {
        this.logger.debug("navigating to parent");
        this.location.navigateToParent();
        this.currentNode = (Node)this.currentNode.getParent();
    }

    public void navigateToChild() {
        this.logger.debug("navigating to child");
        this.location.navigateToChild();
        this.currentNode = (Node)this.currentNode.getChild(0);
        this.checkAndSetNextLevelExists();
    }

    public void navigateToSibling() {
        this.logger.debug("navigating to sibling");
        this.location.navigateToSibling();
        this.currentNode = this.location.get(this.root);
        this.checkAndSetNextLevelExists();
    }

    public void navigateToParentNextSibling() {
        this.logger.debug("navigating to parent's next sibling");
        while (this.hasParent()) {
            this.logger.debug("has parent");
            this.navigateToParent();
            if (!this.hasSiblingsToRight()) continue;
            this.navigateToSibling();
            break;
        }
    }

    public void navigateToTargetDepth(int n) {
        this.logger.debug("navigate to target depth of " + n);
        while (this.location.getDepth() < n) {
            if (this.hasChildren()) {
                this.navigateToChild();
                continue;
            }
            if (this.hasSiblingsToRight()) {
                this.navigateToSibling();
                continue;
            }
            if (this.hasParent()) {
                this.navigateToParentNextSibling();
                if (!this.isAtRoot()) continue;
                throw new IllegalArgumentException("Unable to navigate to requested target depth. Requested depth does not exist.");
            }
            throw new IllegalArgumentException("Unable to navigate to requested target depth. No parent, children, or siblings exist.");
        }
    }

    public boolean hasParent() {
        if (this.currentNode != this.root) {
            return this.currentNode.hasParent();
        }
        return false;
    }

    public boolean hasChildren() {
        return this.currentNode.hasChildren();
    }

    public boolean hasSiblingsToRight() {
        if (this.hasParent()) {
            int n = this.location.getLocationIndex(this.location.getDepth());
            return n < this.getNumberOfSiblings();
        }
        return false;
    }

    public boolean hasSiblingsToLeft() {
        if (this.hasParent()) {
            int n = this.location.getLocationIndex(this.location.getDepth());
            return n == 0;
        }
        return false;
    }

    public int getNumberOfSiblings() {
        if (this.hasParent()) {
            return ((Node)this.currentNode.getParent()).getNumberOfChildren() - 1;
        }
        return 0;
    }

    public boolean hasLevel(int n) {
        return this.levels.get(n);
    }

    public boolean hasNextLevel() {
        return this.hasLevel(this.location.getDepth() + 1);
    }

    private void checkAndSetNextLevelExists() {
        boolean bl = this.hasNextLevel();
        boolean bl2 = this.currentNode.hasChildren();
        this.logger.debug("checking for existence of a next level");
        this.logger.debug("hasNextLevel() = " + bl);
        this.logger.debug("hasChildren() = " + bl2);
        if (!bl && bl2) {
            int n = this.location.getDepth() + 1;
            this.logger.debug("a next level exists, setting level " + n + " to true");
            this.levels.set(n);
        }
    }
}

