/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeSearch;
import com.ibm.arcs.basic.node.iterator.NodeIterator;
import com.ibm.arcs.basic.node.iterator.NodeIteratorFactory;
import com.ibm.arcs.basic.node.matcher.NodeMatcher;
import java.util.ArrayList;
import java.util.List;

public class NodeSearcher<T extends Node<T>>
implements NodeSearch<T> {
    private int maxResults = -1;
    private int maxDepth = -1;
    private final NodeIteratorFactory<T> iteratorFactory;
    private final NodeMatcher<T> matcher;

    public NodeSearcher(NodeIteratorFactory<T> nodeIteratorFactory, NodeMatcher<T> nodeMatcher) {
        this.iteratorFactory = nodeIteratorFactory;
        this.configureIteratorFactoryMaxDepth();
        this.matcher = nodeMatcher;
    }

    @Override
    public void setMaxDepth(int n) {
        this.maxDepth = n;
        this.configureIteratorFactoryMaxDepth();
    }

    @Override
    public void setMaxDepthUnlimited() {
        this.maxDepth = -1;
        this.configureIteratorFactoryMaxDepth();
    }

    @Override
    public void setMaxResults(int n) {
        this.maxResults = n;
    }

    @Override
    public void setMaxResultsUnlimited() {
        this.maxResults = -1;
    }

    @Override
    public List<T> search(T t) {
        NodeIterator<T> nodeIterator = this.iteratorFactory.create(t);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (nodeIterator.hasNext() && (this.maxResults == -1 || n < this.maxResults)) {
            Node node = (Node)nodeIterator.next();
            if (!this.matcher.matches(node)) continue;
            arrayList.add(node);
            ++n;
        }
        return arrayList;
    }

    private final void configureIteratorFactoryMaxDepth() {
        if (this.maxDepth == -1) {
            this.iteratorFactory.setMaxDepthUnlimited();
        } else {
            this.iteratorFactory.setMaxDepth(this.maxDepth);
        }
    }
}

