/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.arcs.basic.node;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeSearch;
import com.ibm.arcs.basic.node.NodeSearcher;
import com.ibm.arcs.basic.node.iterator.compact.NodeLevelOrderIteratorFactory;
import com.ibm.arcs.basic.node.matcher.NodeMatcher;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NodeSearches {
    public static <T extends Node<T>> NodeSearch<T> getAllMatchingSearch(NodeMatcher<T> nodeMatcher) {
        NodeSearcher nodeSearcher = new NodeSearcher(new NodeLevelOrderIteratorFactory(), nodeMatcher);
        nodeSearcher.setMaxDepthUnlimited();
        nodeSearcher.setMaxResultsUnlimited();
        return nodeSearcher;
    }

    public static <T extends Node<T>> List<T> getAllMatching(T t, NodeMatcher<T> nodeMatcher) {
        return NodeSearches.getAllMatchingSearch(nodeMatcher).search(t);
    }

    public static <T extends Node<T>> NodeSearch<T> getAllMatchingSearch(NodeMatcher<T> nodeMatcher, int n) {
        NodeSearcher nodeSearcher = new NodeSearcher(new NodeLevelOrderIteratorFactory(), nodeMatcher);
        nodeSearcher.setMaxDepth(n);
        nodeSearcher.setMaxResultsUnlimited();
        return nodeSearcher;
    }

    public static <T extends Node<T>> List<T> getAllMatching(T t, NodeMatcher<T> nodeMatcher, int n) {
        return NodeSearches.getAllMatchingSearch(nodeMatcher, n).search(t);
    }

    public static <T extends Node<T>> T getFirstMatching(T t, NodeMatcher<T> nodeMatcher) throws CoreException {
        NodeSearcher nodeSearcher = new NodeSearcher(new NodeLevelOrderIteratorFactory(), nodeMatcher);
        nodeSearcher.setMaxResults(1);
        List<T> list = nodeSearcher.search(t);
        if (list.size() > 0) {
            return list.get(0);
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.arcs.basic", "search found zero matching nodes"));
    }
}

